"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.VERSION_LOCKED=exports.trimFromStart=exports.calculateFunctionHash=void 0;const crypto=require("crypto"),core_1=require("../../core"),cx_api_1=require("../../cx-api"),function_1=require("./function");function calculateFunctionHash(fn){const stack=core_1.Stack.of(fn),functionResource=fn.node.defaultChild,config=stack.resolve(functionResource._toCloudFormation()),resources=config.Resources,resourceKeys=Object.keys(resources);if(resourceKeys.length!==1)throw new Error(`Expected one rendered CloudFormation resource but found ${resourceKeys.length}`);const logicalId=resourceKeys[0],properties=resources[logicalId].Properties;let stringifiedConfig;if(core_1.FeatureFlags.of(fn).isEnabled(cx_api_1.LAMBDA_RECOGNIZE_VERSION_PROPS)){const updatedProps=sortProperties(filterUsefulKeys(properties));stringifiedConfig=JSON.stringify(updatedProps)}else{const sorted=sortProperties(properties);config.Resources[logicalId].Properties=sorted,stringifiedConfig=JSON.stringify(config)}core_1.FeatureFlags.of(fn).isEnabled(cx_api_1.LAMBDA_RECOGNIZE_LAYER_VERSION)&&(stringifiedConfig=stringifiedConfig+calculateLayersHash(fn._layers));const hash=crypto.createHash("md5");return hash.update(stringifiedConfig),hash.digest("hex")}exports.calculateFunctionHash=calculateFunctionHash;function trimFromStart(s,maxLength){const desiredLength=Math.min(maxLength,s.length),newStart=s.length-desiredLength;return s.substring(newStart)}exports.trimFromStart=trimFromStart,exports.VERSION_LOCKED={Architectures:!0,Code:!0,DeadLetterConfig:!0,Description:!0,Environment:!0,EphemeralStorage:!0,FileSystemConfigs:!0,FunctionName:!0,Handler:!0,ImageConfig:!0,KmsKeyArn:!0,Layers:!0,MemorySize:!0,PackageType:!0,Role:!0,Runtime:!0,Timeout:!0,TracingConfig:!0,VpcConfig:!0,CodeSigningConfigArn:!1,ReservedConcurrentExecutions:!1,Tags:!1};function filterUsefulKeys(properties){const versionProps={...exports.VERSION_LOCKED,...function_1.Function._VER_PROPS},unclassified=Object.entries(properties).filter(([k,v])=>v!=null&&!Object.keys(versionProps).includes(k)).map(([k,_])=>k);if(unclassified.length>0)throw new Error(`The following properties are not recognized as version properties: [${unclassified}]. See the README of the aws-lambda module to learn more about this and to fix it.`);Object.entries(versionProps).filter(([_,v])=>!v).map(([k,_])=>k).forEach(p=>delete properties[p]);const ret={};return Object.entries(properties).filter(([k,_])=>versionProps[k]).forEach(([k,v])=>ret[k]=v),ret}function sortProperties(properties){const ret={},requiredProperties=["Code","Handler","Role","Runtime"];for(const requiredProperty of requiredProperties)ret[requiredProperty]=properties[requiredProperty];for(const property of Object.keys(properties))requiredProperties.indexOf(property)===-1&&(ret[property]=properties[property]);return ret}function calculateLayersHash(layers){const layerConfig={};for(const layer of layers){const stack=core_1.Stack.of(layer),layerResource=layer.node.defaultChild;if(layerResource===void 0){layerConfig[layer.layerVersionArn]=layer.compatibleRuntimes;continue}const resources=stack.resolve(layerResource._toCloudFormation()).Resources,resourceKeys=Object.keys(resources);if(resourceKeys.length!==1)throw new Error(`Expected one rendered CloudFormation resource but found ${resourceKeys.length}`);const logicalId=resourceKeys[0],properties=resources[logicalId].Properties;layerConfig[layer.node.id]=properties}const hash=crypto.createHash("md5");return hash.update(JSON.stringify(layerConfig)),hash.digest("hex")}
//# sourceMappingURL=function-hash.js.map
