"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.FunctionVersionUpgrade=exports.verifyCodeConfig=exports.Function=exports.Tracing=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cloudwatch=require("../../aws-cloudwatch"),aws_codeguruprofiler_1=require("../../aws-codeguruprofiler"),ec2=require("../../aws-ec2"),iam=require("../../aws-iam"),logs=require("../../aws-logs"),sqs=require("../../aws-sqs"),core_1=require("../../core"),cx_api_1=require("../../cx-api"),architecture_1=require("./architecture"),function_base_1=require("./function-base"),function_hash_1=require("./function-hash"),handler_1=require("./handler"),lambda_version_1=require("./lambda-version"),lambda_generated_1=require("./lambda.generated"),layers_1=require("./layers"),runtime_1=require("./runtime"),util_1=require("./util");var Tracing;(function(Tracing2){Tracing2.ACTIVE="Active",Tracing2.PASS_THROUGH="PassThrough",Tracing2.DISABLED="Disabled"})(Tracing=exports.Tracing||(exports.Tracing={}));class Function extends function_base_1.FunctionBase{constructor(scope,id,props){super(scope,id,{physicalName:props.functionName}),this.permissionsNode=this.node,this.canCreatePermissions=!0,this._layers=[],this.environment={};try{jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_FunctionProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Function),error}if(props.functionName&&!core_1.Token.isUnresolved(props.functionName)){if(props.functionName.length>64)throw new Error(`Function name can not be longer than 64 characters but has ${props.functionName.length} characters.`);if(!/^[a-zA-Z0-9-_]+$/.test(props.functionName))throw new Error(`Function name ${props.functionName} can contain only letters, numbers, hyphens, or underscores with no spaces.`)}if(props.description&&!core_1.Token.isUnresolved(props.description)&&props.description.length>256)throw new Error(`Function description can not be longer than 256 characters but has ${props.description.length} characters.`);const managedPolicies=new Array;if(managedPolicies.push(iam.ManagedPolicy.fromAwsManagedPolicyName("service-role/AWSLambdaBasicExecutionRole")),props.vpc&&managedPolicies.push(iam.ManagedPolicy.fromAwsManagedPolicyName("service-role/AWSLambdaVPCAccessExecutionRole")),this.role=props.role||new iam.Role(this,"ServiceRole",{assumedBy:new iam.ServicePrincipal("lambda.amazonaws.com"),managedPolicies}),this.grantPrincipal=this.role,props.filesystem){const config=props.filesystem.config;config.policies&&config.policies.forEach(p=>{this.role?.addToPrincipalPolicy(p)})}for(const statement of props.initialPolicy||[])this.role.addToPrincipalPolicy(statement);const code=props.code.bind(this);verifyCodeConfig(code,props);let profilingGroupEnvironmentVariables={};if(props.profilingGroup&&props.profiling!==!1)this.validateProfiling(props),props.profilingGroup.grantPublish(this.role),profilingGroupEnvironmentVariables={AWS_CODEGURU_PROFILER_GROUP_ARN:core_1.Stack.of(scope).formatArn({service:"codeguru-profiler",resource:"profilingGroup",resourceName:props.profilingGroup.profilingGroupName}),AWS_CODEGURU_PROFILER_ENABLED:"TRUE"};else if(props.profiling){this.validateProfiling(props);const profilingGroup=new aws_codeguruprofiler_1.ProfilingGroup(this,"ProfilingGroup",{computePlatform:aws_codeguruprofiler_1.ComputePlatform.AWS_LAMBDA});profilingGroup.grantPublish(this.role),profilingGroupEnvironmentVariables={AWS_CODEGURU_PROFILER_GROUP_ARN:profilingGroup.profilingGroupArn,AWS_CODEGURU_PROFILER_ENABLED:"TRUE"}}const env={...profilingGroupEnvironmentVariables,...props.environment};for(const[key,value]of Object.entries(env))this.addEnvironment(key,value);const dlqTopicOrQueue=this.buildDeadLetterQueue(props);dlqTopicOrQueue!==void 0&&(this.isQueue(dlqTopicOrQueue)?this.deadLetterQueue=dlqTopicOrQueue:this.deadLetterTopic=dlqTopicOrQueue);let fileSystemConfigs;if(props.filesystem&&(fileSystemConfigs=[{arn:props.filesystem.config.arn,localMountPath:props.filesystem.config.localMountPath}]),props.architecture&&props.architectures!==void 0)throw new Error("Either architecture or architectures must be specified but not both.");if(props.architectures&&props.architectures.length>1)throw new Error("Only one architecture must be specified.");if(this._architecture=props.architecture??(props.architectures&&props.architectures[0]),props.ephemeralStorageSize&&!props.ephemeralStorageSize.isUnresolved()&&(props.ephemeralStorageSize.toMebibytes()<512||props.ephemeralStorageSize.toMebibytes()>10240))throw new Error(`Ephemeral storage size must be between 512 and 10240 MB, received ${props.ephemeralStorageSize}.`);const resource=new lambda_generated_1.CfnFunction(this,"Resource",{functionName:this.physicalName,description:props.description,code:{s3Bucket:code.s3Location&&code.s3Location.bucketName,s3Key:code.s3Location&&code.s3Location.objectKey,s3ObjectVersion:code.s3Location&&code.s3Location.objectVersion,zipFile:code.inlineCode,imageUri:code.image?.imageUri},layers:core_1.Lazy.list({produce:()=>this.renderLayers()}),handler:props.handler===handler_1.Handler.FROM_IMAGE?void 0:props.handler,timeout:props.timeout&&props.timeout.toSeconds(),packageType:props.runtime===runtime_1.Runtime.FROM_IMAGE?"Image":void 0,runtime:props.runtime===runtime_1.Runtime.FROM_IMAGE?void 0:props.runtime.name,role:this.role.roleArn,environment:core_1.Lazy.uncachedAny({produce:()=>this.renderEnvironment()}),memorySize:props.memorySize,ephemeralStorage:props.ephemeralStorageSize?{size:props.ephemeralStorageSize.toMebibytes()}:void 0,vpcConfig:this.configureVpc(props),deadLetterConfig:this.buildDeadLetterConfig(dlqTopicOrQueue),tracingConfig:this.buildTracingConfig(props),reservedConcurrentExecutions:props.reservedConcurrentExecutions,imageConfig:undefinedIfNoKeys({command:code.image?.cmd,entryPoint:code.image?.entrypoint,workingDirectory:code.image?.workingDirectory}),kmsKeyArn:props.environmentEncryption?.keyArn,fileSystemConfigs,codeSigningConfigArn:props.codeSigningConfig?.codeSigningConfigArn,architectures:this._architecture?[this._architecture.name]:void 0});if(resource.node.addDependency(this.role),this.functionName=this.getResourceNameAttribute(resource.ref),this.functionArn=this.getResourceArnAttribute(resource.attrArn,{service:"lambda",resource:"function",resourceName:this.physicalName,arnFormat:core_1.ArnFormat.COLON_RESOURCE_NAME}),this.runtime=props.runtime,this.timeout=props.timeout,this.architecture=props.architecture??architecture_1.Architecture.X86_64,props.layers){if(props.runtime===runtime_1.Runtime.FROM_IMAGE)throw new Error("Layers are not supported for container image functions");this.addLayers(...props.layers)}for(const event of props.events||[])this.addEventSource(event);if(props.logRetention){const logRetention=new logs.LogRetention(this,"LogRetention",{logGroupName:`/aws/lambda/${this.functionName}`,retention:props.logRetention,role:props.logRetentionRole,logRetentionRetryOptions:props.logRetentionRetryOptions});this._logGroup=logs.LogGroup.fromLogGroupArn(this,"LogGroup",logRetention.logGroupArn)}if(props.code.bindToResource(resource),(props.onFailure||props.onSuccess||props.maxEventAge||props.retryAttempts!==void 0)&&this.configureAsyncInvoke({onFailure:props.onFailure,onSuccess:props.onSuccess,maxEventAge:props.maxEventAge,retryAttempts:props.retryAttempts}),this.currentVersionOptions=props.currentVersionOptions,props.filesystem){if(!props.vpc)throw new Error("Cannot configure 'filesystem' without configuring a VPC.");const config=props.filesystem.config;config.dependency&&this.node.addDependency(...config.dependency),this.connections.securityGroups.forEach(sg=>{sg.node.findAll().forEach(child=>{child instanceof core_1.CfnResource&&child.cfnResourceType==="AWS::EC2::SecurityGroupEgress"&&resource.node.addDependency(child)})}),config.connections?.securityGroups.forEach(sg=>{sg.node.findAll().forEach(child=>{child instanceof core_1.CfnResource&&child.cfnResourceType==="AWS::EC2::SecurityGroupIngress"&&resource.node.addDependency(child)})})}this.configureLambdaInsights(props)}get currentVersion(){if(this._currentVersion)return this._currentVersion;this._warnIfCurrentVersionCalled&&this.warnInvokeFunctionPermissions(this),this._currentVersion=new lambda_version_1.Version(this,"CurrentVersion",{lambda:this,...this.currentVersionOptions});const cfn=this._currentVersion.node.defaultChild,originalLogicalId=this.stack.resolve(cfn.logicalId);return cfn.overrideLogicalId(core_1.Lazy.uncachedString({produce:()=>{const hash=function_hash_1.calculateFunctionHash(this);return`${function_hash_1.trimFromStart(originalLogicalId,255-32)}${hash}`}})),this._currentVersion}get resourceArnsForGrantInvoke(){return[this.functionArn,`${this.functionArn}:*`]}static classifyVersionProperty(propertyName,locked){this._VER_PROPS[propertyName]=locked}static fromFunctionName(scope,id,functionName){return Function.fromFunctionAttributes(scope,id,{functionArn:core_1.Stack.of(scope).formatArn({service:"lambda",resource:"function",resourceName:functionName,arnFormat:core_1.ArnFormat.COLON_RESOURCE_NAME})})}static fromFunctionArn(scope,id,functionArn){return Function.fromFunctionAttributes(scope,id,{functionArn})}static fromFunctionAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_FunctionAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromFunctionAttributes),error}const functionArn=attrs.functionArn,functionName=extractNameFromArn(attrs.functionArn),role=attrs.role;class Import extends function_base_1.FunctionBase{constructor(s,i){super(s,i,{environmentFromArn:functionArn}),this.functionName=functionName,this.functionArn=functionArn,this.role=role,this.permissionsNode=this.node,this.architecture=attrs.architecture??architecture_1.Architecture.X86_64,this.resourceArnsForGrantInvoke=[this.functionArn,`${this.functionArn}:*`],this.canCreatePermissions=attrs.sameEnvironment??this._isStackAccount(),this._skipPermissions=attrs.skipPermissions??!1,this.grantPrincipal=role||new iam.UnknownPrincipal({resource:this}),attrs.securityGroup?this._connections=new ec2.Connections({securityGroups:[attrs.securityGroup]}):attrs.securityGroupId&&(this._connections=new ec2.Connections({securityGroups:[ec2.SecurityGroup.fromSecurityGroupId(scope,"SecurityGroup",attrs.securityGroupId)]}))}}return new Import(scope,id)}static metricAll(metricName,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricAll),error}return new cloudwatch.Metric({namespace:"AWS/Lambda",metricName,...props})}static metricAllErrors(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricAllErrors),error}return this.metricAll("Errors",{statistic:"sum",...props})}static metricAllDuration(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricAllDuration),error}return this.metricAll("Duration",props)}static metricAllInvocations(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricAllInvocations),error}return this.metricAll("Invocations",{statistic:"sum",...props})}static metricAllThrottles(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricAllThrottles),error}return this.metricAll("Throttles",{statistic:"sum",...props})}static metricAllConcurrentExecutions(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricAllConcurrentExecutions),error}return this.metricAll("ConcurrentExecutions",{statistic:"max",...props})}static metricAllUnreservedConcurrentExecutions(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricAllUnreservedConcurrentExecutions),error}return this.metricAll("UnreservedConcurrentExecutions",{statistic:"max",...props})}addEnvironment(key,value,options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_EnvironmentOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addEnvironment),error}if(["_HANDLER","_X_AMZN_TRACE_ID","AWS_REGION","AWS_EXECUTION_ENV","AWS_LAMBDA_FUNCTION_NAME","AWS_LAMBDA_FUNCTION_MEMORY_SIZE","AWS_LAMBDA_FUNCTION_VERSION","AWS_LAMBDA_INITIALIZATION_TYPE","AWS_LAMBDA_LOG_GROUP_NAME","AWS_LAMBDA_LOG_STREAM_NAME","AWS_ACCESS_KEY","AWS_ACCESS_KEY_ID","AWS_SECRET_ACCESS_KEY","AWS_SESSION_TOKEN","AWS_LAMBDA_RUNTIME_API","LAMBDA_TASK_ROOT","LAMBDA_RUNTIME_DIR"].includes(key))throw new Error(`${key} environment variable is reserved by the lambda runtime and can not be set manually. See https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html`);return this.environment[key]={value,...options},this}addLayers(...layers){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_ILayerVersion(layers)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addLayers),error}for(const layer of layers){if(this._layers.length===5)throw new Error("Unable to add layer: this lambda function already uses 5 layers.");if(layer.compatibleRuntimes&&!layer.compatibleRuntimes.find(runtime=>runtime.runtimeEquals(this.runtime))){const runtimes=layer.compatibleRuntimes.map(runtime=>runtime.name).join(", ");throw new Error(`This lambda function uses a runtime that is incompatible with this layer (${this.runtime.name} is not in [${runtimes}])`)}this._layers.push(layer)}}addVersion(name,codeSha256,description,provisionedExecutions,asyncInvokeConfig={}){return new lambda_version_1.Version(this,"Version"+name,{lambda:this,codeSha256,description,provisionedConcurrentExecutions:provisionedExecutions,...asyncInvokeConfig})}addAlias(aliasName,options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_AliasOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addAlias),error}return util_1.addAlias(this,this.currentVersion,aliasName,options)}get logGroup(){if(!this._logGroup){const logRetention=new logs.LogRetention(this,"LogRetention",{logGroupName:`/aws/lambda/${this.functionName}`,retention:logs.RetentionDays.INFINITE});this._logGroup=logs.LogGroup.fromLogGroupArn(this,`${this.node.id}-LogGroup`,logRetention.logGroupArn)}return this._logGroup}_checkEdgeCompatibility(){const envEntries=Object.entries(this.environment);for(const[key,config]of envEntries)config.removeInEdge&&(delete this.environment[key],core_1.Annotations.of(this).addInfo(`Removed ${key} environment variable for Lambda@Edge compatibility`));const envKeys=Object.keys(this.environment);if(envKeys.length!==0)throw new Error(`The function ${this.node.path} contains environment variables [${envKeys}] and is not compatible with Lambda@Edge. Environment variables can be marked for removal when used in Lambda@Edge by setting the 'removeInEdge' property in the 'addEnvironment()' API.`)}configureLambdaInsights(props){props.insightsVersion!==void 0&&(props.runtime!==runtime_1.Runtime.FROM_IMAGE&&this.addLayers(layers_1.LayerVersion.fromLayerVersionArn(this,"LambdaInsightsLayer",props.insightsVersion._bind(this,this).arn)),this.role?.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName("CloudWatchLambdaInsightsExecutionRolePolicy")))}renderLayers(){if(!(!this._layers||this._layers.length===0))return core_1.FeatureFlags.of(this).isEnabled(cx_api_1.LAMBDA_RECOGNIZE_LAYER_VERSION)&&this._layers.sort(),this._layers.map(layer=>layer.layerVersionArn)}renderEnvironment(){if(!this.environment||Object.keys(this.environment).length===0)return;const variables={},keys=this._currentVersion?Object.keys(this.environment).sort():Object.keys(this.environment);for(const key of keys)variables[key]=this.environment[key].value;return{variables}}configureVpc(props){if((props.securityGroup||props.allowAllOutbound!==void 0)&&!props.vpc)throw new Error("Cannot configure 'securityGroup' or 'allowAllOutbound' without configuring a VPC");if(!props.vpc){if(props.vpcSubnets)throw new Error("Cannot configure 'vpcSubnets' without configuring a VPC");return}if(props.securityGroup&&props.allowAllOutbound!==void 0)throw new Error("Configure 'allowAllOutbound' directly on the supplied SecurityGroup.");let securityGroups;if(props.securityGroup&&props.securityGroups)throw new Error("Only one of the function props, securityGroup or securityGroups, is allowed");props.securityGroups?securityGroups=props.securityGroups:securityGroups=[props.securityGroup||new ec2.SecurityGroup(this,"SecurityGroup",{vpc:props.vpc,description:"Automatic security group for Lambda Function "+core_1.Names.uniqueId(this),allowAllOutbound:props.allowAllOutbound})],this._connections=new ec2.Connections({securityGroups}),props.filesystem&&props.filesystem.config.connections&&props.filesystem.config.connections.allowDefaultPortFrom(this);const allowPublicSubnet=props.allowPublicSubnet??!1,selectedSubnets=props.vpc.selectSubnets(props.vpcSubnets),publicSubnetIds=new Set(props.vpc.publicSubnets.map(s=>s.subnetId));for(const subnetId of selectedSubnets.subnetIds)if(publicSubnetIds.has(subnetId)&&!allowPublicSubnet)throw new Error("Lambda Functions in a public subnet can NOT access the internet. If you are aware of this limitation and would still like to place the function in a public subnet, set `allowPublicSubnet` to true");return this.node.addDependency(selectedSubnets.internetConnectivityEstablished),{subnetIds:selectedSubnets.subnetIds,securityGroupIds:securityGroups.map(sg=>sg.securityGroupId)}}isQueue(deadLetterQueue){return deadLetterQueue.queueArn!==void 0}buildDeadLetterQueue(props){if(!props.deadLetterQueue&&!props.deadLetterQueueEnabled&&!props.deadLetterTopic)return;if(props.deadLetterQueue&&props.deadLetterQueueEnabled===!1)throw Error("deadLetterQueue defined but deadLetterQueueEnabled explicitly set to false");if(props.deadLetterTopic&&(props.deadLetterQueue||props.deadLetterQueueEnabled!==void 0))throw new Error("deadLetterQueue and deadLetterTopic cannot be specified together at the same time");let deadLetterQueue;return props.deadLetterTopic?(deadLetterQueue=props.deadLetterTopic,this.addToRolePolicy(new iam.PolicyStatement({actions:["sns:Publish"],resources:[deadLetterQueue.topicArn]}))):(deadLetterQueue=props.deadLetterQueue||new sqs.Queue(this,"DeadLetterQueue",{retentionPeriod:core_1.Duration.days(14)}),this.addToRolePolicy(new iam.PolicyStatement({actions:["sqs:SendMessage"],resources:[deadLetterQueue.queueArn]}))),deadLetterQueue}buildDeadLetterConfig(deadLetterQueue){if(deadLetterQueue)return{targetArn:this.isQueue(deadLetterQueue)?deadLetterQueue.queueArn:deadLetterQueue.topicArn}}buildTracingConfig(props){if(!(props.tracing===void 0||props.tracing===Tracing.DISABLED))return this.addToRolePolicy(new iam.PolicyStatement({actions:["xray:PutTraceSegments","xray:PutTelemetryRecords"],resources:["*"]})),{mode:props.tracing}}validateProfiling(props){if(!props.runtime.supportsCodeGuruProfiling)throw new Error(`CodeGuru profiling is not supported by runtime ${props.runtime.name}`);if(props.environment&&(props.environment.AWS_CODEGURU_PROFILER_GROUP_ARN||props.environment.AWS_CODEGURU_PROFILER_ENABLED))throw new Error("AWS_CODEGURU_PROFILER_GROUP_ARN and AWS_CODEGURU_PROFILER_ENABLED must not be set when profiling options enabled")}}exports.Function=Function,_a=JSII_RTTI_SYMBOL_1,Function[_a]={fqn:"aws-cdk-lib.aws_lambda.Function",version:"2.42.0"},Function._VER_PROPS={};function extractNameFromArn(arn){return core_1.Fn.select(6,core_1.Fn.split(":",arn))}function verifyCodeConfig(code,props){if([code.inlineCode,code.s3Location,code.image].filter(x=>!!x).length!==1)throw new Error('lambda.Code must specify exactly one of: "inlineCode", "s3Location", or "image"');if(!!code.image==(props.handler!==handler_1.Handler.FROM_IMAGE))throw new Error("handler must be `Handler.FROM_IMAGE` when using image asset for Lambda function");if(!!code.image==(props.runtime!==runtime_1.Runtime.FROM_IMAGE))throw new Error("runtime must be `Runtime.FROM_IMAGE` when using image asset for Lambda function");if(code.inlineCode&&!props.runtime.supportsInlineCode)throw new Error(`Inline source not allowed for ${props.runtime.name}`)}exports.verifyCodeConfig=verifyCodeConfig;function undefinedIfNoKeys(struct){return Object.values(struct).every(val=>val===void 0)?void 0:struct}class FunctionVersionUpgrade{constructor(featureFlag,enabled=!0){this.featureFlag=featureFlag,this.enabled=enabled}visit(node){if(node instanceof Function&&this.enabled===core_1.FeatureFlags.of(node).isEnabled(this.featureFlag)){const cfnFunction=node.node.defaultChild,desc=cfnFunction.description?`${cfnFunction.description} `:"";cfnFunction.addPropertyOverride("Description",`${desc}version-hash:${function_hash_1.calculateFunctionHash(node)}`)}}}exports.FunctionVersionUpgrade=FunctionVersionUpgrade,_b=JSII_RTTI_SYMBOL_1,FunctionVersionUpgrade[_b]={fqn:"aws-cdk-lib.aws_lambda.FunctionVersionUpgrade",version:"2.42.0"};
//# sourceMappingURL=function.js.map
