"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.HttpsRedirect=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),crypto=require("crypto"),aws_certificatemanager_1=require("../../aws-certificatemanager"),aws_cloudfront_1=require("../../aws-cloudfront"),aws_route53_1=require("../../aws-route53"),aws_route53_targets_1=require("../../aws-route53-targets"),aws_s3_1=require("../../aws-s3"),core_1=require("../../core"),constructs_1=require("constructs");class HttpsRedirect extends constructs_1.Construct{constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_patterns_HttpsRedirectProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,HttpsRedirect),error}const domainNames=props.recordNames??[props.zone.zoneName];if(props.certificate){const certificateRegion=core_1.Stack.of(this).splitArn(props.certificate.certificateArn,core_1.ArnFormat.SLASH_RESOURCE_NAME).region;if(!core_1.Token.isUnresolved(certificateRegion)&&certificateRegion!=="us-east-1")throw new Error(`The certificate must be in the us-east-1 region and the certificate you provided is in ${certificateRegion}.`)}const redirectCert=props.certificate??new aws_certificatemanager_1.DnsValidatedCertificate(this,"RedirectCertificate",{domainName:domainNames[0],subjectAlternativeNames:domainNames,hostedZone:props.zone,region:"us-east-1"}),redirectBucket=new aws_s3_1.Bucket(this,"RedirectBucket",{websiteRedirect:{hostName:props.targetDomain,protocol:aws_s3_1.RedirectProtocol.HTTPS},removalPolicy:core_1.RemovalPolicy.DESTROY,blockPublicAccess:aws_s3_1.BlockPublicAccess.BLOCK_ALL}),redirectDist=new aws_cloudfront_1.CloudFrontWebDistribution(this,"RedirectDistribution",{defaultRootObject:"",originConfigs:[{behaviors:[{isDefaultBehavior:!0}],customOriginSource:{domainName:redirectBucket.bucketWebsiteDomainName,originProtocolPolicy:aws_cloudfront_1.OriginProtocolPolicy.HTTP_ONLY}}],viewerCertificate:aws_cloudfront_1.ViewerCertificate.fromAcmCertificate(redirectCert,{aliases:domainNames}),comment:`Redirect to ${props.targetDomain} from ${domainNames.join(", ")}`,priceClass:aws_cloudfront_1.PriceClass.PRICE_CLASS_ALL,viewerProtocolPolicy:aws_cloudfront_1.ViewerProtocolPolicy.REDIRECT_TO_HTTPS});domainNames.forEach(domainName=>{const hash=crypto.createHash("md5").update(domainName).digest("hex").slice(0,6),aliasProps={recordName:domainName,zone:props.zone,target:aws_route53_1.RecordTarget.fromAlias(new aws_route53_targets_1.CloudFrontTarget(redirectDist))};new aws_route53_1.ARecord(this,`RedirectAliasRecord${hash}`,aliasProps),new aws_route53_1.AaaaRecord(this,`RedirectAliasRecordSix${hash}`,aliasProps)})}}exports.HttpsRedirect=HttpsRedirect,_a=JSII_RTTI_SYMBOL_1,HttpsRedirect[_a]={fqn:"aws-cdk-lib.aws_route53_patterns.HttpsRedirect",version:"2.42.0"};
//# sourceMappingURL=website-redirect.js.map
