"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.makeHostedZoneArn=exports.determineFullyQualifiedDomainName=exports.validateZoneName=void 0;const core_1=require("../../core");function validateZoneName(zoneName){if(zoneName.endsWith("."))throw new ValidationError("zone name must not end with a trailing dot");if(zoneName.length>255)throw new ValidationError("zone name cannot be more than 255 bytes long");if(zoneName.split(".").find(label=>label.length>63))throw new ValidationError("zone name labels cannot be more than 63 bytes long");if(!zoneName.match(/^[a-z0-9!"#$%&'()*+,/:;<=>?@[\\\]^_`{|}~.-]+$/i))throw new ValidationError("zone names can only contain a-z, 0-9, -, ! \" # $ % & ' ( ) * + , - / : ; < = > ? @ [  ] ^ _ ` { | } ~ .")}exports.validateZoneName=validateZoneName;class ValidationError extends Error{constructor(message){super(message)}}function determineFullyQualifiedDomainName(providedName,hostedZone){if(providedName.endsWith("."))return providedName;const hostedZoneName=hostedZone.zoneName.endsWith(".")?hostedZone.zoneName.substring(0,hostedZone.zoneName.length-1):hostedZone.zoneName,suffix=`.${hostedZoneName}`;return providedName.endsWith(suffix)||providedName===hostedZoneName?`${providedName}.`:`${providedName}${suffix}.`}exports.determineFullyQualifiedDomainName=determineFullyQualifiedDomainName;function makeHostedZoneArn(construct,hostedZoneId){return core_1.Stack.of(construct).formatArn({account:"",region:"",service:"route53",resource:"hostedzone",resourceName:hostedZoneId})}exports.makeHostedZoneArn=makeHostedZoneArn;
//# sourceMappingURL=util.js.map
