"use strict";var _a,_b,_c;Object.defineProperty(exports,"__esModule",{value:!0}),exports.Expires=exports.StorageClass=exports.ServerSideEncryption=exports.CacheControl=exports.BucketDeployment=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),path=require("path"),efs=require("../../aws-efs"),iam=require("../../aws-iam"),lambda=require("../../aws-lambda"),s3=require("../../aws-s3"),cdk=require("../../core"),lambda_layer_awscli_1=require("../../lambda-layer-awscli"),case_1=require("case"),constructs_1=require("constructs"),CUSTOM_RESOURCE_OWNER_TAG="aws-cdk:cr-owned";class BucketDeployment extends constructs_1.Construct{constructor(scope,id,props){super(scope,id),this.requestDestinationArn=!1;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_s3_deployment_BucketDeploymentProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,BucketDeployment),error}if(props.distributionPaths){if(!props.distribution)throw new Error("Distribution must be specified if distribution paths are specified");if(!cdk.Token.isUnresolved(props.distributionPaths)&&!props.distributionPaths.every(distributionPath=>cdk.Token.isUnresolved(distributionPath)||distributionPath.startsWith("/")))throw new Error('Distribution paths must start with "/"')}if(props.useEfs&&!props.vpc)throw new Error("Vpc must be specified if useEfs is set");const accessPointPath="/lambda";let accessPoint;if(props.useEfs&&props.vpc){const accessMode="0777",fileSystem=this.getOrCreateEfsFileSystem(scope,{vpc:props.vpc,removalPolicy:cdk.RemovalPolicy.DESTROY});accessPoint=fileSystem.addAccessPoint("AccessPoint",{path:accessPointPath,createAcl:{ownerUid:"1001",ownerGid:"1001",permissions:accessMode},posixUser:{uid:"1001",gid:"1001"}}),accessPoint.node.addDependency(fileSystem.mountTargetsAvailable)}props.vpc&&this.node.addDependency(props.vpc);const mountPath=`/mnt${accessPointPath}`,handler=new lambda.SingletonFunction(this,"CustomResourceHandler",{uuid:this.renderSingletonUuid(props.memoryLimit,props.ephemeralStorageSize,props.vpc),code:lambda.Code.fromAsset(path.join(__dirname,"lambda")),layers:[new lambda_layer_awscli_1.AwsCliLayer(this,"AwsCliLayer")],runtime:lambda.Runtime.PYTHON_3_9,environment:props.useEfs?{MOUNT_PATH:mountPath}:void 0,handler:"index.handler",lambdaPurpose:"Custom::CDKBucketDeployment",timeout:cdk.Duration.minutes(15),role:props.role,memorySize:props.memoryLimit,ephemeralStorageSize:props.ephemeralStorageSize,vpc:props.vpc,vpcSubnets:props.vpcSubnets,filesystem:accessPoint?lambda.FileSystem.fromEfsAccessPoint(accessPoint,mountPath):void 0,logRetention:props.logRetention}),handlerRole=handler.role;if(!handlerRole)throw new Error("lambda.SingletonFunction should have created a Role");const sources=props.sources.map(source=>source.bind(this,{handlerRole}));props.destinationBucket.grantReadWrite(handler),props.accessControl&&props.destinationBucket.grantPutAcl(handler),props.distribution&&handler.addToRolePolicy(new iam.PolicyStatement({effect:iam.Effect.ALLOW,actions:["cloudfront:GetInvalidation","cloudfront:CreateInvalidation"],resources:["*"]}));const hasMarkers=sources.some(source=>source.markers),crUniqueId=`CustomResource${this.renderUniqueId(props.memoryLimit,props.ephemeralStorageSize,props.vpc)}`;this.cr=new cdk.CustomResource(this,crUniqueId,{serviceToken:handler.functionArn,resourceType:"Custom::CDKBucketDeployment",properties:{SourceBucketNames:sources.map(source=>source.bucket.bucketName),SourceObjectKeys:sources.map(source=>source.zipObjectKey),SourceMarkers:hasMarkers?sources.map(source=>source.markers??{}):void 0,DestinationBucketName:props.destinationBucket.bucketName,DestinationBucketKeyPrefix:props.destinationKeyPrefix,RetainOnDelete:props.retainOnDelete,Prune:props.prune??!0,Exclude:props.exclude,Include:props.include,UserMetadata:props.metadata?mapUserMetadata(props.metadata):void 0,SystemMetadata:mapSystemMetadata(props),DistributionId:props.distribution?.distributionId,DistributionPaths:props.distributionPaths,DestinationBucketArn:cdk.Lazy.string({produce:()=>this.requestDestinationArn?props.destinationBucket.bucketArn:void 0})}});let prefix=props.destinationKeyPrefix?`:${props.destinationKeyPrefix}`:"";prefix+=`:${this.cr.node.addr.slice(-8)}`;const tagKey=CUSTOM_RESOURCE_OWNER_TAG+prefix;if(tagKey.length>128)throw new Error('The BucketDeployment construct requires that the "destinationKeyPrefix" be <=104 characters');cdk.Tags.of(props.destinationBucket).add(tagKey,"true")}get deployedBucket(){return this.requestDestinationArn=!0,this._deployedBucket=this._deployedBucket??s3.Bucket.fromBucketArn(this,"DestinationBucket",cdk.Token.asString(this.cr.getAtt("DestinationBucketArn"))),this._deployedBucket}renderUniqueId(memoryLimit,ephemeralStorageSize,vpc){let uuid="";if(memoryLimit){if(cdk.Token.isUnresolved(memoryLimit))throw new Error("Can't use tokens when specifying 'memoryLimit' since we use it to identify the singleton custom resource handler.");uuid+=`-${memoryLimit.toString()}MiB`}if(ephemeralStorageSize){if(ephemeralStorageSize.isUnresolved())throw new Error("Can't use tokens when specifying 'ephemeralStorageSize' since we use it to identify the singleton custom resource handler.");uuid+=`-${ephemeralStorageSize.toMebibytes().toString()}MiB`}return vpc&&(uuid+=`-${vpc.node.addr}`),uuid}renderSingletonUuid(memoryLimit,ephemeralStorageSize,vpc){let uuid="8693BB64-9689-44B6-9AAF-B0CC9EB8756C";return uuid+=this.renderUniqueId(memoryLimit,ephemeralStorageSize,vpc),uuid}getOrCreateEfsFileSystem(scope,fileSystemProps){const stack=cdk.Stack.of(scope),uuid=`BucketDeploymentEFS-VPC-${fileSystemProps.vpc.node.addr}`;return stack.node.tryFindChild(uuid)??new efs.FileSystem(scope,uuid,fileSystemProps)}}exports.BucketDeployment=BucketDeployment,_a=JSII_RTTI_SYMBOL_1,BucketDeployment[_a]={fqn:"aws-cdk-lib.aws_s3_deployment.BucketDeployment",version:"2.42.0"};function mapUserMetadata(metadata){const mapKey=key=>key.toLowerCase();return Object.keys(metadata).reduce((o,key)=>({...o,[mapKey(key)]:metadata[key]}),{})}function mapSystemMetadata(metadata){const res={};return metadata.cacheControl&&(res["cache-control"]=metadata.cacheControl.map(c=>c.value).join(", ")),metadata.expires&&(res.expires=metadata.expires.date.toUTCString()),metadata.contentDisposition&&(res["content-disposition"]=metadata.contentDisposition),metadata.contentEncoding&&(res["content-encoding"]=metadata.contentEncoding),metadata.contentLanguage&&(res["content-language"]=metadata.contentLanguage),metadata.contentType&&(res["content-type"]=metadata.contentType),metadata.serverSideEncryption&&(res.sse=metadata.serverSideEncryption),metadata.storageClass&&(res["storage-class"]=metadata.storageClass),metadata.websiteRedirectLocation&&(res["website-redirect"]=metadata.websiteRedirectLocation),metadata.serverSideEncryptionAwsKmsKeyId&&(res["sse-kms-key-id"]=metadata.serverSideEncryptionAwsKmsKeyId),metadata.serverSideEncryptionCustomerAlgorithm&&(res["sse-c-copy-source"]=metadata.serverSideEncryptionCustomerAlgorithm),metadata.accessControl&&(res.acl=case_1.kebab(metadata.accessControl.toString())),Object.keys(res).length===0?void 0:res}class CacheControl{constructor(value){this.value=value}static mustRevalidate(){return new CacheControl("must-revalidate")}static noCache(){return new CacheControl("no-cache")}static noTransform(){return new CacheControl("no-transform")}static setPublic(){return new CacheControl("public")}static setPrivate(){return new CacheControl("private")}static proxyRevalidate(){return new CacheControl("proxy-revalidate")}static maxAge(t){try{jsiiDeprecationWarnings.aws_cdk_lib_Duration(t)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.maxAge),error}return new CacheControl(`max-age=${t.toSeconds()}`)}static sMaxAge(t){try{jsiiDeprecationWarnings.aws_cdk_lib_Duration(t)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.sMaxAge),error}return new CacheControl(`s-maxage=${t.toSeconds()}`)}static fromString(s){return new CacheControl(s)}}exports.CacheControl=CacheControl,_b=JSII_RTTI_SYMBOL_1,CacheControl[_b]={fqn:"aws-cdk-lib.aws_s3_deployment.CacheControl",version:"2.42.0"};var ServerSideEncryption;(function(ServerSideEncryption2){ServerSideEncryption2.AES_256="AES256",ServerSideEncryption2.AWS_KMS="aws:kms"})(ServerSideEncryption=exports.ServerSideEncryption||(exports.ServerSideEncryption={}));var StorageClass;(function(StorageClass2){StorageClass2.STANDARD="STANDARD",StorageClass2.REDUCED_REDUNDANCY="REDUCED_REDUNDANCY",StorageClass2.STANDARD_IA="STANDARD_IA",StorageClass2.ONEZONE_IA="ONEZONE_IA",StorageClass2.INTELLIGENT_TIERING="INTELLIGENT_TIERING",StorageClass2.GLACIER="GLACIER",StorageClass2.DEEP_ARCHIVE="DEEP_ARCHIVE"})(StorageClass=exports.StorageClass||(exports.StorageClass={}));class Expires{constructor(value){this.value=value}static atDate(d){return new Expires(d.toUTCString())}static atTimestamp(t){return Expires.atDate(new Date(t))}static after(t){return Expires.atDate(new Date(Date.now()+t.toMilliseconds()))}static fromString(s){return new Expires(s)}}exports.Expires=Expires,_c=JSII_RTTI_SYMBOL_1,Expires[_c]={fqn:"aws-cdk-lib.aws_s3_deployment.Expires",version:"2.42.0"};
//# sourceMappingURL=bucket-deployment.js.map
