"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.handler=void 0;const aws_sdk_1=require("aws-sdk"),AUTO_DELETE_OBJECTS_TAG="aws-cdk:auto-delete-objects",s3=new aws_sdk_1.S3;async function handler(event){switch(event.RequestType){case"Create":return;case"Update":return onUpdate(event);case"Delete":return onDelete(event.ResourceProperties?.BucketName)}}exports.handler=handler;async function onUpdate(event){const updateEvent=event,oldBucketName=updateEvent.OldResourceProperties?.BucketName,newBucketName=updateEvent.ResourceProperties?.BucketName;if(newBucketName!=null&&oldBucketName!=null&&newBucketName!==oldBucketName)return onDelete(oldBucketName)}async function emptyBucket(bucketName){const listedObjects=await s3.listObjectVersions({Bucket:bucketName}).promise(),contents=[...listedObjects.Versions??[],...listedObjects.DeleteMarkers??[]];if(contents.length===0)return;const records=contents.map(record=>({Key:record.Key,VersionId:record.VersionId}));await s3.deleteObjects({Bucket:bucketName,Delete:{Objects:records}}).promise(),listedObjects?.IsTruncated&&await emptyBucket(bucketName)}async function onDelete(bucketName){if(!bucketName)throw new Error("No BucketName was provided.");if(!await isBucketTaggedForDeletion(bucketName)){process.stdout.write(`Bucket does not have '${AUTO_DELETE_OBJECTS_TAG}' tag, skipping cleaning.
`);return}try{await emptyBucket(bucketName)}catch(e){if(e.code!=="NoSuchBucket")throw e}}async function isBucketTaggedForDeletion(bucketName){return(await s3.getBucketTagging({Bucket:bucketName}).promise()).TagSet.some(tag=>tag.Key===AUTO_DELETE_OBJECTS_TAG&&tag.Value==="true")}
//# sourceMappingURL=index.js.map
