"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.SubscriptionProtocol=exports.Subscription=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),aws_iam_1=require("../../aws-iam"),core_1=require("../../core"),sns_generated_1=require("./sns.generated");class Subscription extends core_1.Resource{constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_sns_SubscriptionProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Subscription),error}if(props.rawMessageDelivery&&[SubscriptionProtocol.HTTP,SubscriptionProtocol.HTTPS,SubscriptionProtocol.SQS,SubscriptionProtocol.FIREHOSE].indexOf(props.protocol)<0)throw new Error("Raw message delivery can only be enabled for HTTP, HTTPS, SQS, and Firehose subscriptions.");if(props.filterPolicy){if(Object.keys(props.filterPolicy).length>5)throw new Error("A filter policy can have a maximum of 5 attribute names.");this.filterPolicy=Object.entries(props.filterPolicy).reduce((acc,[k,v])=>({...acc,[k]:v.conditions}),{});let total=1;if(Object.values(this.filterPolicy).forEach(filter=>{total*=filter.length}),total>100)throw new Error(`The total combination of values (${total}) must not exceed 100.`)}if(props.protocol===SubscriptionProtocol.FIREHOSE&&!props.subscriptionRoleArn)throw new Error("Subscription role arn is required field for subscriptions with a firehose protocol.");this.deadLetterQueue=this.buildDeadLetterQueue(props),new sns_generated_1.CfnSubscription(this,"Resource",{endpoint:props.endpoint,protocol:props.protocol,topicArn:props.topic.topicArn,rawMessageDelivery:props.rawMessageDelivery,filterPolicy:this.filterPolicy,region:props.region,redrivePolicy:this.buildDeadLetterConfig(this.deadLetterQueue),subscriptionRoleArn:props.subscriptionRoleArn})}buildDeadLetterQueue(props){if(!props.deadLetterQueue)return;const deadLetterQueue=props.deadLetterQueue;return deadLetterQueue.addToResourcePolicy(new aws_iam_1.PolicyStatement({resources:[deadLetterQueue.queueArn],actions:["sqs:SendMessage"],principals:[new aws_iam_1.ServicePrincipal("sns.amazonaws.com")],conditions:{ArnEquals:{"aws:SourceArn":props.topic.topicArn}}})),deadLetterQueue}buildDeadLetterConfig(deadLetterQueue){if(deadLetterQueue)return{deadLetterTargetArn:deadLetterQueue.queueArn}}}exports.Subscription=Subscription,_a=JSII_RTTI_SYMBOL_1,Subscription[_a]={fqn:"aws-cdk-lib.aws_sns.Subscription",version:"2.42.0"};var SubscriptionProtocol;(function(SubscriptionProtocol2){SubscriptionProtocol2.HTTP="http",SubscriptionProtocol2.HTTPS="https",SubscriptionProtocol2.EMAIL="email",SubscriptionProtocol2.EMAIL_JSON="email-json",SubscriptionProtocol2.SMS="sms",SubscriptionProtocol2.SQS="sqs",SubscriptionProtocol2.APPLICATION="application",SubscriptionProtocol2.LAMBDA="lambda",SubscriptionProtocol2.FIREHOSE="firehose"})(SubscriptionProtocol=exports.SubscriptionProtocol||(exports.SubscriptionProtocol={}));
//# sourceMappingURL=subscription.js.map
