"use strict";var _a,_b,_c,_d;Object.defineProperty(exports,"__esModule",{value:!0}),exports.VirtualClusterInput=exports.ReleaseLabel=exports.Classification=exports.EmrContainersStartJobRun=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),path=require("path"),iam=require("../../../aws-iam"),lambda=require("../../../aws-lambda"),logs=require("../../../aws-logs"),s3=require("../../../aws-s3"),sfn=require("../../../aws-stepfunctions"),cdk=require("../../../core"),cr=require("../../../custom-resources"),awscli=require("../../../lambda-layer-awscli"),task_utils_1=require("../private/task-utils");class EmrContainersStartJobRun extends sfn.TaskStateBase{constructor(scope,id,props){super(scope,id,props),this.props=props,this.applicationConfigPropertyToJson=property=>({Classification:cdk.stringToCloudFormation(property.classification.classificationStatement),Properties:property.properties?cdk.objectToCloudFormation(property.properties):void 0,Configurations:property.nestedConfig?cdk.listMapper(this.applicationConfigPropertyToJson)(property.nestedConfig):void 0}),this.assignLogGroup=()=>this.props.monitoring?.logGroup?this.props.monitoring?.logGroup:this.props.monitoring?.logging?new logs.LogGroup(this,"Monitoring Log Group"):void 0,this.assignLogBucket=()=>this.props.monitoring?.logBucket?this.props.monitoring?.logBucket:this.props.monitoring?.logging?new s3.Bucket(this,"Monitoring Bucket"):void 0;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_stepfunctions_tasks_EmrContainersStartJobRunProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,EmrContainersStartJobRun),error}if(this.integrationPattern=props.integrationPattern??sfn.IntegrationPattern.RUN_JOB,task_utils_1.validatePatternSupported(this.integrationPattern,EmrContainersStartJobRun.SUPPORTED_INTEGRATION_PATTERNS),this.props.applicationConfig&&this.validateAppConfig(this.props.applicationConfig),this.props.jobDriver.sparkSubmitJobDriver&&this.validateSparkSubmitJobDriver(props.jobDriver.sparkSubmitJobDriver),this.props.executionRole===void 0&&sfn.JsonPath.isEncodedJsonPath(props.virtualCluster.id))throw new Error("Execution role cannot be undefined when the virtual cluster ID is not a concrete value. Provide an execution role with the correct trust policy");this.logGroup=this.assignLogGroup(),this.logBucket=this.assignLogBucket(),this.role=this.props.executionRole??this.createJobExecutionRole(),this.grantPrincipal=this.role,this.grantMonitoringPolicies(),this.taskPolicies=this.createPolicyStatements()}_renderTask(){return{Resource:task_utils_1.integrationResourceArn("emr-containers","startJobRun",this.integrationPattern),Parameters:sfn.FieldUtils.renderObject({VirtualClusterId:this.props.virtualCluster.id,Name:this.props.jobName,ExecutionRoleArn:this.role.roleArn,ReleaseLabel:this.props.releaseLabel.label,JobDriver:{SparkSubmitJobDriver:{EntryPoint:this.props.jobDriver.sparkSubmitJobDriver?.entryPoint.value,EntryPointArguments:this.props.jobDriver.sparkSubmitJobDriver?.entryPointArguments?.value,SparkSubmitParameters:this.props.jobDriver.sparkSubmitJobDriver?.sparkSubmitParameters}},ConfigurationOverrides:{ApplicationConfiguration:cdk.listMapper(this.applicationConfigPropertyToJson)(this.props.applicationConfig),MonitoringConfiguration:{CloudWatchMonitoringConfiguration:this.logGroup?{LogGroupName:this.logGroup.logGroupName,LogStreamNamePrefix:this.props.monitoring.logStreamNamePrefix}:void 0,PersistentAppUI:this.props.monitoring?.persistentAppUI===!1?"DISABLED":"ENABLED",S3MonitoringConfiguration:this.logBucket?{LogUri:this.logBucket.s3UrlForObject()}:void 0}},Tags:this.props.tags})}}validateAppConfigPropertiesLength(appConfig){if(appConfig?.properties!==void 0&&Object.keys(appConfig.properties).length>100)throw new Error(`Application configuration properties must have 100 or fewer entries. Received ${Object.keys(appConfig.properties).length}`)}validatePropertiesNestedAppConfigBothNotUndefined(appConfig){if(appConfig?.properties===void 0&&appConfig?.nestedConfig===void 0)throw new Error("Application configuration must have either properties or nested app configurations defined.")}validateAppConfig(config){if(config!==void 0){if(config.length>100)throw new Error(`Application configuration array must have 100 or fewer entries. Received ${config.length}`);config.forEach(element=>this.validateAppConfig(element.nestedConfig)),config.forEach(element=>this.validateAppConfigPropertiesLength(element)),config.forEach(element=>this.validatePropertiesNestedAppConfigBothNotUndefined(element))}}isArrayOfStrings(value){return Array.isArray(value)&&value.every(item=>typeof item=="string")}validateEntryPointArguments(entryPointArguments){if(typeof entryPointArguments.value=="string"&&!sfn.JsonPath.isEncodedJsonPath(entryPointArguments.value))throw new Error(`Entry point arguments must be a string array or encoded JSON path, but received a non JSON path string');
      .`);if(!this.isArrayOfStrings(entryPointArguments.value))throw new Error(`Entry point arguments must be a string array or encoded JSON path but received ${typeof entryPointArguments.value}.`)}validateEntryPointArgumentsLength(entryPointArguments){if(this.isArrayOfStrings(entryPointArguments.value)&&(entryPointArguments.value.length>10280||entryPointArguments.value.length<1))throw new Error(`Entry point arguments must be a string array between 1 and 10280 in length. Received ${entryPointArguments.value.length}.`)}validateSparkSubmitParametersLength(sparkSubmitParameters){if(sparkSubmitParameters.length>102400||sparkSubmitParameters.length<1)throw new Error(`Spark submit parameters must be between 1 and 102400 characters in length. Received ${sparkSubmitParameters.length}.`)}validateEntryPoint(entryPoint){if(!sfn.JsonPath.isEncodedJsonPath(entryPoint.value)&&(entryPoint.value.length>256||entryPoint.value.length<1))throw new Error(`Entry point must be between 1 and 256 characters in length. Received ${entryPoint.value.length}.`)}validateSparkSubmitJobDriver(driver){this.validateEntryPoint(driver.entryPoint),driver.entryPointArguments&&(this.validateEntryPointArguments(driver.entryPointArguments),this.validateEntryPointArgumentsLength(driver.entryPointArguments)),driver.sparkSubmitParameters&&this.validateSparkSubmitParametersLength(driver.sparkSubmitParameters)}createJobExecutionRole(){const jobExecutionRole=new iam.Role(this,"Job-Execution-Role",{assumedBy:new iam.CompositePrincipal(new iam.ServicePrincipal("emr-containers.amazonaws.com"),new iam.ServicePrincipal("states.amazonaws.com"))});return this.logBucket?.grantReadWrite(jobExecutionRole),this.logGroup?.grantWrite(jobExecutionRole),this.logGroup?.grant(jobExecutionRole,"logs:DescribeLogStreams"),jobExecutionRole.addToPrincipalPolicy(new iam.PolicyStatement({resources:["arn:aws:logs:*:*:*"],actions:["logs:DescribeLogGroups"]})),this.updateRoleTrustPolicy(jobExecutionRole),jobExecutionRole}grantMonitoringPolicies(){this.logBucket?.grantReadWrite(this.role),this.logGroup?.grantWrite(this.role),this.logGroup?.grant(this.role,"logs:DescribeLogStreams"),this.role.addToPrincipalPolicy(new iam.PolicyStatement({resources:["arn:aws:logs:*:*:*"],actions:["logs:DescribeLogGroups"]}))}updateRoleTrustPolicy(role){const eksClusterInfo=new cr.AwsCustomResource(this,"GetEksClusterInfo",{onCreate:{service:"EMRcontainers",action:"describeVirtualCluster",parameters:{id:this.props.virtualCluster.id},outputPaths:["virtualCluster.containerProvider.info.eksInfo.namespace","virtualCluster.containerProvider.id"],physicalResourceId:cr.PhysicalResourceId.of("id")},policy:cr.AwsCustomResourcePolicy.fromSdkCalls({resources:cr.AwsCustomResourcePolicy.ANY_RESOURCE})}),cliLayer=new awscli.AwsCliLayer(this,"awsclilayer"),shellCliLambda=new lambda.SingletonFunction(this,"Call Update-Role-Trust-Policy",{uuid:"8693BB64-9689-44B6-9AAF-B0CC9EB8757C",runtime:lambda.Runtime.PYTHON_3_9,handler:"index.handler",code:lambda.Code.fromAsset(path.join(__dirname,"utils/role-policy")),timeout:cdk.Duration.seconds(30),memorySize:256,layers:[cliLayer]});shellCliLambda.addToRolePolicy(new iam.PolicyStatement({resources:[cdk.Stack.of(this).formatArn({service:"eks",resource:"cluster",resourceName:eksClusterInfo.getResponseField("virtualCluster.containerProvider.id")})],actions:["eks:DescribeCluster"]})),shellCliLambda.addToRolePolicy(new iam.PolicyStatement({resources:[role.roleArn],actions:["iam:GetRole","iam:UpdateAssumeRolePolicy"]}));const provider=new cr.Provider(this,"CustomResourceProvider",{onEventHandler:shellCliLambda});new cdk.CustomResource(this,"Custom Resource",{properties:{eksNamespace:eksClusterInfo.getResponseField("virtualCluster.containerProvider.info.eksInfo.namespace"),eksClusterId:eksClusterInfo.getResponseField("virtualCluster.containerProvider.id"),roleName:role.roleName},serviceToken:provider.serviceToken})}createPolicyStatements(){const policyStatements=[new iam.PolicyStatement({resources:[cdk.Stack.of(this).formatArn({arnFormat:cdk.ArnFormat.SLASH_RESOURCE_SLASH_RESOURCE_NAME,service:"emr-containers",resource:"virtualclusters",resourceName:sfn.JsonPath.isEncodedJsonPath(this.props.virtualCluster.id)?"*":this.props.virtualCluster.id})],actions:["emr-containers:StartJobRun"],conditions:{StringEquals:{"emr-containers:ExecutionRoleArn":this.role.roleArn}}})];return this.integrationPattern===sfn.IntegrationPattern.RUN_JOB&&policyStatements.push(new iam.PolicyStatement({resources:[cdk.Stack.of(this).formatArn({arnFormat:cdk.ArnFormat.SLASH_RESOURCE_SLASH_RESOURCE_NAME,service:"emr-containers",resource:"virtualclusters",resourceName:sfn.JsonPath.isEncodedJsonPath(this.props.virtualCluster.id)?"*":`${this.props.virtualCluster.id}/jobruns/*`})],actions:["emr-containers:DescribeJobRun","emr-containers:CancelJobRun"]})),policyStatements}}exports.EmrContainersStartJobRun=EmrContainersStartJobRun,_a=JSII_RTTI_SYMBOL_1,EmrContainersStartJobRun[_a]={fqn:"aws-cdk-lib.aws_stepfunctions_tasks.EmrContainersStartJobRun",version:"2.42.0"},EmrContainersStartJobRun.SUPPORTED_INTEGRATION_PATTERNS=[sfn.IntegrationPattern.REQUEST_RESPONSE,sfn.IntegrationPattern.RUN_JOB];class Classification{constructor(classificationStatement){this.classificationStatement=classificationStatement}}exports.Classification=Classification,_b=JSII_RTTI_SYMBOL_1,Classification[_b]={fqn:"aws-cdk-lib.aws_stepfunctions_tasks.Classification",version:"2.42.0"},Classification.SPARK=new Classification("spark"),Classification.SPARK_DEFAULTS=new Classification("spark-defaults"),Classification.SPARK_ENV=new Classification("spark-env"),Classification.SPARK_HIVE_SITE=new Classification("spark-hive-site"),Classification.SPARK_LOG4J=new Classification("spark-log4j"),Classification.SPARK_METRICS=new Classification("spark-metrics");class ReleaseLabel{constructor(label){this.label=label}}exports.ReleaseLabel=ReleaseLabel,_c=JSII_RTTI_SYMBOL_1,ReleaseLabel[_c]={fqn:"aws-cdk-lib.aws_stepfunctions_tasks.ReleaseLabel",version:"2.42.0"},ReleaseLabel.EMR_5_32_0=new ReleaseLabel("emr-5.32.0-latest"),ReleaseLabel.EMR_5_33_0=new ReleaseLabel("emr-5.33.0-latest"),ReleaseLabel.EMR_6_2_0=new ReleaseLabel("emr-6.2.0-latest"),ReleaseLabel.EMR_6_3_0=new ReleaseLabel("emr-6.3.0-latest");class VirtualClusterInput{constructor(id){this.id=id}static fromTaskInput(taskInput){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_stepfunctions_TaskInput(taskInput)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromTaskInput),error}return new VirtualClusterInput(taskInput.value)}static fromVirtualClusterId(virtualClusterId){return new VirtualClusterInput(virtualClusterId)}}exports.VirtualClusterInput=VirtualClusterInput,_d=JSII_RTTI_SYMBOL_1,VirtualClusterInput[_d]={fqn:"aws-cdk-lib.aws_stepfunctions_tasks.VirtualClusterInput",version:"2.42.0"};
//# sourceMappingURL=start-job-run.js.map
