import * as iam from '../../../aws-iam';
import * as sfn from '../../../aws-stepfunctions';
import { Duration } from '../../../core';
import { Construct } from 'constructs';
/**
 * Properties for starting an AWS Glue job as a task
 */
export interface GlueStartJobRunProps extends sfn.TaskStateBaseProps {
    /**
     * Glue job name
     */
    readonly glueJobName: string;
    /**
     * The job arguments specifically for this run.
     *
     * For this job run, they replace the default arguments set in the job
     * definition itself.
     *
     * @default - Default arguments set in the job definition
     */
    readonly arguments?: sfn.TaskInput;
    /**
     * The name of the SecurityConfiguration structure to be used with this job run.
     *
     * This must match the Glue API
     * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html#aws-glue-api-regex-oneLine
     *
     * @default - Default configuration set in the job definition
     */
    readonly securityConfiguration?: string;
    /**
     * After a job run starts, the number of minutes to wait before sending a job run delay notification.
     *
     * Must be at least 1 minute.
     *
     * @default - Default delay set in the job definition
     */
    readonly notifyDelayAfter?: Duration;
}
/**
 * Starts an AWS Glue job in a Task state
 *
 * OUTPUT: the output of this task is a JobRun structure, for details consult
 * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-runs.html#aws-glue-api-jobs-runs-JobRun
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-glue.html
 */
export declare class GlueStartJobRun extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    constructor(scope: Construct, id: string, props: GlueStartJobRunProps);
    /**
     * @internal
     */
    protected _renderTask(): any;
    private getPolicies;
}
