"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.SageMakerCreateEndpointConfig=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),iam=require("../../../aws-iam"),sfn=require("../../../aws-stepfunctions"),cdk=require("../../../core"),task_utils_1=require("../private/task-utils");class SageMakerCreateEndpointConfig extends sfn.TaskStateBase{constructor(scope,id,props){super(scope,id,props),this.props=props;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_stepfunctions_tasks_SageMakerCreateEndpointConfigProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,SageMakerCreateEndpointConfig),error}this.integrationPattern=props.integrationPattern||sfn.IntegrationPattern.REQUEST_RESPONSE,task_utils_1.validatePatternSupported(this.integrationPattern,SageMakerCreateEndpointConfig.SUPPORTED_INTEGRATION_PATTERNS),this.validateProductionVariants(),this.taskPolicies=this.makePolicyStatements()}_renderTask(){return{Resource:task_utils_1.integrationResourceArn("sagemaker","createEndpointConfig",this.integrationPattern),Parameters:sfn.FieldUtils.renderObject(this.renderParameters())}}renderParameters(){return{EndpointConfigName:this.props.endpointConfigName,Tags:this.props.tags?.value,KmsKeyId:this.props.kmsKey?.keyId,ProductionVariants:this.props.productionVariants.map(variant=>({InitialInstanceCount:variant.initialInstanceCount?variant.initialInstanceCount:1,InstanceType:sfn.JsonPath.isEncodedJsonPath(variant.instanceType.toString())?variant.instanceType.toString():`ml.${variant.instanceType}`,ModelName:variant.modelName,VariantName:variant.variantName,AcceleratorType:variant.acceleratorType,InitialVariantWeight:variant.initialVariantWeight}))}}makePolicyStatements(){const stack=cdk.Stack.of(this);return[new iam.PolicyStatement({actions:["sagemaker:CreateEndpointConfig"],resources:[stack.formatArn({service:"sagemaker",resource:"endpoint-config",resourceName:sfn.JsonPath.isEncodedJsonPath(this.props.endpointConfigName)?"*":`${this.props.endpointConfigName.toLowerCase()}`})]}),new iam.PolicyStatement({actions:["sagemaker:ListTags"],resources:["*"]})]}validateProductionVariants(){if(this.props.productionVariants.length<1||this.props.productionVariants.length>10)throw new Error("Must specify from 1 to 10 production variants per endpoint configuration");this.props.productionVariants.forEach(variant=>{if(variant.initialInstanceCount&&variant.initialInstanceCount<1)throw new Error("Must define at least one instance");if(variant.initialVariantWeight&&variant.initialVariantWeight<=0)throw new Error("InitialVariantWeight has minimum value of 0")})}}exports.SageMakerCreateEndpointConfig=SageMakerCreateEndpointConfig,_a=JSII_RTTI_SYMBOL_1,SageMakerCreateEndpointConfig[_a]={fqn:"aws-cdk-lib.aws_stepfunctions_tasks.SageMakerCreateEndpointConfig",version:"2.42.0"},SageMakerCreateEndpointConfig.SUPPORTED_INTEGRATION_PATTERNS=[sfn.IntegrationPattern.REQUEST_RESPONSE];
//# sourceMappingURL=create-endpoint-config.js.map
