"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.SnsPublish=exports.MessageAttributeDataType=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),iam=require("../../../aws-iam"),sfn=require("../../../aws-stepfunctions"),core_1=require("../../../core"),task_utils_1=require("../private/task-utils");var MessageAttributeDataType;(function(MessageAttributeDataType2){MessageAttributeDataType2.STRING="String",MessageAttributeDataType2.STRING_ARRAY="String.Array",MessageAttributeDataType2.NUMBER="Number",MessageAttributeDataType2.BINARY="Binary"})(MessageAttributeDataType=exports.MessageAttributeDataType||(exports.MessageAttributeDataType={}));class SnsPublish extends sfn.TaskStateBase{constructor(scope,id,props){super(scope,id,props),this.props=props;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_stepfunctions_tasks_SnsPublishProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,SnsPublish),error}if(this.integrationPattern=props.integrationPattern??sfn.IntegrationPattern.REQUEST_RESPONSE,task_utils_1.validatePatternSupported(this.integrationPattern,SnsPublish.SUPPORTED_INTEGRATION_PATTERNS),this.integrationPattern===sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN&&!sfn.FieldUtils.containsTaskToken(props.message))throw new Error("Task Token is required in `message` Use JsonPath.taskToken to set the token.");this.taskPolicies=[new iam.PolicyStatement({actions:["sns:Publish"],resources:[this.props.topic.topicArn]})]}_renderTask(){return{Resource:task_utils_1.integrationResourceArn("sns","publish",this.integrationPattern),Parameters:sfn.FieldUtils.renderObject({TopicArn:this.props.topic.topicArn,Message:this.props.message.value,MessageStructure:this.props.messagePerSubscriptionType?"json":void 0,MessageAttributes:renderMessageAttributes(this.props.messageAttributes),Subject:this.props.subject})}}}exports.SnsPublish=SnsPublish,_a=JSII_RTTI_SYMBOL_1,SnsPublish[_a]={fqn:"aws-cdk-lib.aws_stepfunctions_tasks.SnsPublish",version:"2.42.0"},SnsPublish.SUPPORTED_INTEGRATION_PATTERNS=[sfn.IntegrationPattern.REQUEST_RESPONSE,sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN];function renderMessageAttributes(attributes){if(attributes===void 0)return;const renderedAttributes={};return Object.entries(attributes).map(([key,val])=>{renderedAttributes[key]=renderMessageAttributeValue(val)}),sfn.TaskInput.fromObject(renderedAttributes).value}function renderMessageAttributeValue(attribute){const dataType=attribute.dataType;if(attribute.value instanceof sfn.TaskInput)return{DataType:dataType??MessageAttributeDataType.STRING,StringValue:dataType!==MessageAttributeDataType.BINARY?attribute.value.value:void 0,BinaryValue:dataType===MessageAttributeDataType.BINARY?attribute.value.value:void 0};if(dataType===MessageAttributeDataType.BINARY)return{DataType:dataType,BinaryValue:`${attribute.value}`};if(core_1.Token.isUnresolved(attribute.value))return{DataType:dataType??MessageAttributeDataType.STRING,StringValue:attribute.value};if(validateMessageAttribute(attribute),Array.isArray(attribute.value))return{DataType:MessageAttributeDataType.STRING_ARRAY,StringValue:JSON.stringify(attribute.value)};const value=attribute.value;return typeof value=="number"?{DataType:MessageAttributeDataType.NUMBER,StringValue:`${value}`}:{DataType:MessageAttributeDataType.STRING,StringValue:`${value}`}}function validateMessageAttribute(attribute){const dataType=attribute.dataType,value=attribute.value;if(dataType===void 0)return;if(Array.isArray(value)){if(dataType!==MessageAttributeDataType.STRING_ARRAY)throw new Error(`Requested SNS message attribute type was ${dataType} but ${value} was of type Array`);const validArrayTypes=["string","boolean","number"];value.forEach(v=>{if(v!==null||!validArrayTypes.includes(typeof v))throw new Error(`Requested SNS message attribute type was ${typeof value} but Array values must be one of ${validArrayTypes}`)});return}const error=new Error(`Requested SNS message attribute type was ${dataType} but ${value} was of type ${typeof value}`);switch(typeof value){case"string":if(sfn.JsonPath.isEncodedJsonPath(attribute.value)||dataType===MessageAttributeDataType.STRING||dataType===MessageAttributeDataType.BINARY)return;throw error;case"number":if(dataType===MessageAttributeDataType.NUMBER)return;throw error;case"boolean":if(dataType===MessageAttributeDataType.STRING)return;throw error;default:throw error}}
//# sourceMappingURL=publish.js.map
