"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.StartExecution=void 0;const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),iam=require("../../aws-iam"),sfn=require("../../aws-stepfunctions"),core_1=require("../../core"),resource_arn_suffix_1=require("./resource-arn-suffix");class StartExecution{constructor(stateMachine,props={}){if(this.stateMachine=stateMachine,this.props=props,this.integrationPattern=props.integrationPattern||sfn.ServiceIntegrationPattern.FIRE_AND_FORGET,![sfn.ServiceIntegrationPattern.FIRE_AND_FORGET,sfn.ServiceIntegrationPattern.SYNC,sfn.ServiceIntegrationPattern.WAIT_FOR_TASK_TOKEN].includes(this.integrationPattern))throw new Error(`Invalid Service Integration Pattern: ${this.integrationPattern} is not supported to call Step Functions.`);if(this.integrationPattern===sfn.ServiceIntegrationPattern.WAIT_FOR_TASK_TOKEN&&!sfn.FieldUtils.containsTaskToken(props.input))throw new Error("Task Token is missing in input (pass JsonPath.taskToken somewhere in input)")}bind(task){return{resourceArn:resource_arn_suffix_1.getResourceArn("states","startExecution",this.integrationPattern),policyStatements:this.createScopedAccessPolicy(task),parameters:{Input:this.props.input,StateMachineArn:this.stateMachine.stateMachineArn,Name:this.props.name}}}createScopedAccessPolicy(task){const stack=core_1.Stack.of(task),policyStatements=[new iam.PolicyStatement({actions:["states:StartExecution"],resources:[this.stateMachine.stateMachineArn]})];return this.integrationPattern===sfn.ServiceIntegrationPattern.SYNC&&(policyStatements.push(new iam.PolicyStatement({actions:["states:DescribeExecution","states:StopExecution"],resources:[stack.formatArn({service:"states",resource:"execution",arnFormat:core_1.ArnFormat.COLON_RESOURCE_NAME,resourceName:`${stack.splitArn(this.stateMachine.stateMachineArn,core_1.ArnFormat.COLON_RESOURCE_NAME).resourceName}*`})]})),policyStatements.push(new iam.PolicyStatement({actions:["events:PutTargets","events:PutRule","events:DescribeRule"],resources:[stack.formatArn({service:"events",resource:"rule",resourceName:"StepFunctionsGetEventsForStepFunctionsExecutionRule"})]}))),policyStatements}}exports.StartExecution=StartExecution,_a=JSII_RTTI_SYMBOL_1,StartExecution[_a]={fqn:"aws-cdk-lib.aws_stepfunctions_tasks.StartExecution",version:"2.42.0"};
//# sourceMappingURL=start-execution.js.map
