import * as constructs from 'constructs';
import * as cdk from '../../core';
import * as cfn_parse from '../../core/lib/helpers-internal';
/**
 * Properties for defining a `CfnAccountAlias`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-accountalias.html
 */
export interface CfnAccountAliasProps {
    /**
     * `AWS::SupportApp::AccountAlias.AccountAlias`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-accountalias.html#cfn-supportapp-accountalias-accountalias
     */
    readonly accountAlias: string;
}
/**
 * A CloudFormation `AWS::SupportApp::AccountAlias`
 *
 *
 *
 * @cloudformationResource AWS::SupportApp::AccountAlias
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-accountalias.html
 */
export declare class CfnAccountAlias extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SupportApp::AccountAlias";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: constructs.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAccountAlias;
    /**
     *
     * @cloudformationAttribute AccountAliasResourceId
     */
    readonly attrAccountAliasResourceId: string;
    /**
     * `AWS::SupportApp::AccountAlias.AccountAlias`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-accountalias.html#cfn-supportapp-accountalias-accountalias
     */
    accountAlias: string;
    /**
     * Create a new `AWS::SupportApp::AccountAlias`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnAccountAliasProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `CfnSlackChannelConfiguration`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html
 */
export interface CfnSlackChannelConfigurationProps {
    /**
     * `AWS::SupportApp::SlackChannelConfiguration.ChannelId`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-channelid
     */
    readonly channelId: string;
    /**
     * `AWS::SupportApp::SlackChannelConfiguration.ChannelRoleArn`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-channelrolearn
     */
    readonly channelRoleArn: string;
    /**
     * `AWS::SupportApp::SlackChannelConfiguration.NotifyOnCaseSeverity`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyoncaseseverity
     */
    readonly notifyOnCaseSeverity: string;
    /**
     * `AWS::SupportApp::SlackChannelConfiguration.TeamId`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-teamid
     */
    readonly teamId: string;
    /**
     * `AWS::SupportApp::SlackChannelConfiguration.ChannelName`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-channelname
     */
    readonly channelName?: string;
    /**
     * `AWS::SupportApp::SlackChannelConfiguration.NotifyOnAddCorrespondenceToCase`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyonaddcorrespondencetocase
     */
    readonly notifyOnAddCorrespondenceToCase?: boolean | cdk.IResolvable;
    /**
     * `AWS::SupportApp::SlackChannelConfiguration.NotifyOnCreateOrReopenCase`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyoncreateorreopencase
     */
    readonly notifyOnCreateOrReopenCase?: boolean | cdk.IResolvable;
    /**
     * `AWS::SupportApp::SlackChannelConfiguration.NotifyOnResolveCase`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyonresolvecase
     */
    readonly notifyOnResolveCase?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::SupportApp::SlackChannelConfiguration`
 *
 *
 *
 * @cloudformationResource AWS::SupportApp::SlackChannelConfiguration
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html
 */
export declare class CfnSlackChannelConfiguration extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SupportApp::SlackChannelConfiguration";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: constructs.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSlackChannelConfiguration;
    /**
     * `AWS::SupportApp::SlackChannelConfiguration.ChannelId`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-channelid
     */
    channelId: string;
    /**
     * `AWS::SupportApp::SlackChannelConfiguration.ChannelRoleArn`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-channelrolearn
     */
    channelRoleArn: string;
    /**
     * `AWS::SupportApp::SlackChannelConfiguration.NotifyOnCaseSeverity`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyoncaseseverity
     */
    notifyOnCaseSeverity: string;
    /**
     * `AWS::SupportApp::SlackChannelConfiguration.TeamId`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-teamid
     */
    teamId: string;
    /**
     * `AWS::SupportApp::SlackChannelConfiguration.ChannelName`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-channelname
     */
    channelName: string | undefined;
    /**
     * `AWS::SupportApp::SlackChannelConfiguration.NotifyOnAddCorrespondenceToCase`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyonaddcorrespondencetocase
     */
    notifyOnAddCorrespondenceToCase: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::SupportApp::SlackChannelConfiguration.NotifyOnCreateOrReopenCase`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyoncreateorreopencase
     */
    notifyOnCreateOrReopenCase: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::SupportApp::SlackChannelConfiguration.NotifyOnResolveCase`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyonresolvecase
     */
    notifyOnResolveCase: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::SupportApp::SlackChannelConfiguration`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnSlackChannelConfigurationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
