"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.generateSchema=exports.bump=exports.update=exports.SCHEMAS=void 0;const fs=require("fs"),path=require("path"),semver=require("semver"),tjs=require("typescript-json-schema");function log(message){console.log(message)}const SCHEMA_DIR=path.resolve(__dirname,"../schema"),SCHEMA_DEFINITIONS={assets:{rootTypeName:"AssetManifest"},"cloud-assembly":{rootTypeName:"AssemblyManifest"},integ:{rootTypeName:"IntegManifest"}};exports.SCHEMAS=Object.keys(SCHEMA_DEFINITIONS);function update(){for(const s of exports.SCHEMAS)generateSchema(s);bump()}exports.update=update;function bump(){const versionFile=path.join(SCHEMA_DIR,"cloud-assembly.version.json"),oldVersion=require(versionFile).version,newVersion=semver.inc(oldVersion,"major");log(`Updating schema version: ${oldVersion} -> ${newVersion}`),fs.writeFileSync(versionFile,JSON.stringify({version:newVersion}))}exports.bump=bump;function generateSchema(schemaName,saveToFile=!0){const spec=SCHEMA_DEFINITIONS[schemaName],out=saveToFile?path.join(SCHEMA_DIR,`${schemaName}.schema.json`):"",settings={required:!0,ref:!0,topRef:!0,noExtraProps:!1,out},compilerOptions={strictNullChecks:!0},program=tjs.getProgramFromFiles([path.join(__dirname,"../lib/index.d.ts")],compilerOptions),schema=tjs.generateSchema(program,spec.rootTypeName,settings);return augmentDescription(schema),addAnyMetadataEntry(schema),out&&(log(`Generating schema to ${out}`),fs.writeFileSync(out,JSON.stringify(schema,null,4))),schema}exports.generateSchema=generateSchema;function augmentDescription(schema){function _recurse(o){for(const prop in o)if(prop==="description"&&typeof o[prop]=="string"){const description=o[prop],defaultValue=o.default;if(!defaultValue)continue;const descriptionWithDefault=`${description} (Default ${defaultValue})`;delete o.default,o[prop]=descriptionWithDefault}else typeof o[prop]=="object"&&_recurse(o[prop])}_recurse(schema)}function addAnyMetadataEntry(schema){schema.definitions.MetadataEntry?.properties.data.anyOf.push({description:"Free form data."})}
//# sourceMappingURL=update-schema.js.map
