"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.DockerVolumeConsistency=exports.DockerImage=exports.BundlingDockerImage=exports.BundlingOutput=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),child_process_1=require("child_process"),crypto=require("crypto"),path_1=require("path"),fs_1=require("./fs"),jsii_deprecated_1=require("./private/jsii-deprecated");var BundlingOutput;(function(BundlingOutput2){BundlingOutput2.ARCHIVED="archived",BundlingOutput2.NOT_ARCHIVED="not-archived",BundlingOutput2.AUTO_DISCOVER="auto-discover"})(BundlingOutput=exports.BundlingOutput||(exports.BundlingOutput={}));class BundlingDockerImage{constructor(image,_imageHash){this.image=image,this._imageHash=_imageHash}static fromRegistry(image){return new DockerImage(image)}static fromAsset(path,options={}){return DockerImage.fromBuild(path,options)}toJSON(){return this._imageHash??this.image}run(options={}){const volumes=options.volumes||[],environment=options.environment||{},entrypoint=options.entrypoint?.[0]||null,command=[...options.entrypoint?.[1]?[...options.entrypoint.slice(1)]:[],...options.command?[...options.command]:[]],dockerArgs=["run","--rm",...options.securityOpt?["--security-opt",options.securityOpt]:[],...options.network?["--network",options.network]:[],...options.user?["-u",options.user]:[],...flatten(volumes.map(v=>["-v",`${v.hostPath}:${v.containerPath}:${isSeLinux()?"z,":""}${v.consistency??DockerVolumeConsistency.DELEGATED}`])),...flatten(Object.entries(environment).map(([k,v])=>["--env",`${k}=${v}`])),...options.workingDirectory?["-w",options.workingDirectory]:[],...entrypoint?["--entrypoint",entrypoint]:[],this.image,...command];dockerExec(dockerArgs)}cp(imagePath,outputPath){const{stdout}=dockerExec(["create",this.image],{}),match=stdout.toString().match(/([0-9a-f]{16,})/);if(!match)throw new Error("Failed to extract container ID from Docker create output");const containerId=match[1],containerPath=`${containerId}:${imagePath}`,destPath=outputPath??fs_1.FileSystem.mkdtemp("cdk-docker-cp-");try{return dockerExec(["cp",containerPath,destPath]),destPath}catch(err){throw new Error(`Failed to copy files from ${containerPath} to ${destPath}: ${err}`)}finally{dockerExec(["rm","-v",containerId])}}}exports.BundlingDockerImage=BundlingDockerImage,_a=JSII_RTTI_SYMBOL_1,BundlingDockerImage[_a]={fqn:"aws-cdk-lib.BundlingDockerImage",version:"2.42.0"};class DockerImage extends BundlingDockerImage{constructor(image,_imageHash){const deprecated=jsii_deprecated_1.quiet();super(image,_imageHash),jsii_deprecated_1.reset(deprecated),this.image=image}static fromBuild(path,options={}){try{jsiiDeprecationWarnings.aws_cdk_lib_DockerBuildOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromBuild),error}const buildArgs=options.buildArgs||{};if(options.file&&path_1.isAbsolute(options.file))throw new Error(`"file" must be relative to the docker build directory. Got ${options.file}`);const input=JSON.stringify({path,...options}),tag=`cdk-${crypto.createHash("sha256").update(input).digest("hex")}`,dockerArgs=["build","-t",tag,...options.file?["-f",path_1.join(path,options.file)]:[],...options.platform?["--platform",options.platform]:[],...options.targetStage?["--target",options.targetStage]:[],...flatten(Object.entries(buildArgs).map(([k,v])=>["--build-arg",`${k}=${v}`])),path];dockerExec(dockerArgs);const hash=fs_1.FileSystem.fingerprint(path,{extraHash:JSON.stringify(options)});return new DockerImage(tag,hash)}static fromRegistry(image){return new DockerImage(image)}toJSON(){const deprecated=jsii_deprecated_1.quiet(),json=super.toJSON();return jsii_deprecated_1.reset(deprecated),json}run(options={}){try{jsiiDeprecationWarnings.aws_cdk_lib_DockerRunOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.run),error}const deprecated=jsii_deprecated_1.quiet(),result=super.run(options);return jsii_deprecated_1.reset(deprecated),result}cp(imagePath,outputPath){const deprecated=jsii_deprecated_1.quiet(),result=super.cp(imagePath,outputPath);return jsii_deprecated_1.reset(deprecated),result}}exports.DockerImage=DockerImage,_b=JSII_RTTI_SYMBOL_1,DockerImage[_b]={fqn:"aws-cdk-lib.DockerImage",version:"2.42.0"};var DockerVolumeConsistency;(function(DockerVolumeConsistency2){DockerVolumeConsistency2.CONSISTENT="consistent",DockerVolumeConsistency2.DELEGATED="delegated",DockerVolumeConsistency2.CACHED="cached"})(DockerVolumeConsistency=exports.DockerVolumeConsistency||(exports.DockerVolumeConsistency={}));function flatten(x){return Array.prototype.concat([],...x)}function dockerExec(args,options){const prog=process.env.CDK_DOCKER??"docker",proc=child_process_1.spawnSync(prog,args,options??{stdio:["ignore",process.stderr,"inherit"]});if(proc.error)throw proc.error;if(proc.status!==0)throw proc.stdout||proc.stderr?new Error(`[Status ${proc.status}] stdout: ${proc.stdout?.toString().trim()}


stderr: ${proc.stderr?.toString().trim()}`):new Error(`${prog} exited with status ${proc.status}`);return proc}function isSeLinux(){if(process.platform!="linux")return!1;const prog="selinuxenabled",proc=child_process_1.spawnSync(prog,[],{stdio:["pipe",process.stderr,"inherit"]});return proc.error?!1:proc.status==0}
//# sourceMappingURL=bundling.js.map
