"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.Fn=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cloudformation_lang_1=require("./private/cloudformation-lang"),intrinsic_1=require("./private/intrinsic"),reference_1=require("./reference"),stack_1=require("./stack"),stack_trace_1=require("./stack-trace"),token_1=require("./token");class Fn{constructor(){}static ref(logicalName){return new FnRef(logicalName).toString()}static getAtt(logicalNameOfResource,attributeName){return new FnGetAtt(logicalNameOfResource,attributeName)}static join(delimiter,listOfValues){if(listOfValues.length===0)throw new Error("FnJoin requires at least one value to be provided");return new FnJoin(delimiter,listOfValues).toString()}static split(delimiter,source,assumedLength){if(!token_1.Token.isUnresolved(source))return source.split(delimiter);if(token_1.Token.isUnresolved(delimiter))throw new Error("Fn.split: 'delimiter' may not be a token value");const split=token_1.Token.asList(new FnSplit(delimiter,source));if(assumedLength===void 0)return split;if(token_1.Token.isUnresolved(assumedLength))throw new Error("Fn.split: 'assumedLength' may not be a token value");return range(assumedLength).map(i=>Fn.select(i,split))}static select(index,array){return!token_1.Token.isUnresolved(index)&&!token_1.Token.isUnresolved(array)&&!array.some(token_1.Token.isUnresolved)?array[index]:new FnSelect(index,array).toString()}static sub(body,variables){return new FnSub(body,variables).toString()}static base64(data){return new FnBase64(data).toString()}static cidr(ipBlock,count,sizeMask){return token_1.Token.asList(new FnCidr(ipBlock,count,sizeMask))}static parseDomainName(url){const noHttps=Fn.select(1,Fn.split("//",url));return Fn.select(0,Fn.split("/",noHttps))}static getAzs(region){return token_1.Token.asList(new FnGetAZs(region))}static importValue(sharedValueToImport){return new FnImportValue(sharedValueToImport).toString()}static importListValue(sharedValueToImport,assumedLength,delimiter=","){return Fn.split(delimiter,Fn.importValue(sharedValueToImport),assumedLength)}static findInMap(mapName,topLevelKey,secondLevelKey){return Fn._findInMap(mapName,topLevelKey,secondLevelKey).toString()}static _findInMap(mapName,topLevelKey,secondLevelKey){return new FnFindInMap(mapName,topLevelKey,secondLevelKey)}static transform(macroName,parameters){return new FnTransform(macroName,parameters)}static conditionAnd(...conditions){try{jsiiDeprecationWarnings.aws_cdk_lib_ICfnConditionExpression(conditions)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.conditionAnd),error}if(conditions.length===0)throw new Error("Fn.conditionAnd() needs at least one argument");return conditions.length===1?conditions[0]:Fn.conditionAnd(..._inGroupsOf(conditions,10).map(group=>new FnAnd(...group)))}static conditionEquals(lhs,rhs){return new FnEquals(lhs,rhs)}static conditionIf(conditionId,valueIfTrue,valueIfFalse){return new FnIf(conditionId,valueIfTrue,valueIfFalse)}static conditionNot(condition){try{jsiiDeprecationWarnings.aws_cdk_lib_ICfnConditionExpression(condition)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.conditionNot),error}return new FnNot(condition)}static conditionOr(...conditions){try{jsiiDeprecationWarnings.aws_cdk_lib_ICfnConditionExpression(conditions)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.conditionOr),error}if(conditions.length===0)throw new Error("Fn.conditionOr() needs at least one argument");return conditions.length===1?conditions[0]:Fn.conditionOr(..._inGroupsOf(conditions,10).map(group=>new FnOr(...group)))}static conditionContains(listOfStrings,value){return new FnContains(listOfStrings,value)}static conditionEachMemberEquals(listOfStrings,value){return new FnEachMemberEquals(listOfStrings,value)}static conditionEachMemberIn(stringsToCheck,stringsToMatch){return new FnEachMemberIn(stringsToCheck,stringsToMatch)}static refAll(parameterType){return token_1.Token.asList(new FnRefAll(parameterType))}static valueOf(parameterOrLogicalId,attribute){return new FnValueOf(parameterOrLogicalId,attribute).toString()}static valueOfAll(parameterType,attribute){return token_1.Token.asList(new FnValueOfAll(parameterType,attribute))}static toJsonString(object){return token_1.Token.isUnresolved(object)?new FnToJsonString(object).toString():JSON.stringify(object)}static len(array){if(!token_1.Token.isUnresolved(array)){if(!Array.isArray(array))throw new Error("Fn.length() needs an array");return array.length}return token_1.Token.asNumber(new FnLength(array))}}exports.Fn=Fn,_a=JSII_RTTI_SYMBOL_1,Fn[_a]={fqn:"aws-cdk-lib.Fn",version:"2.42.0"};class FnBase extends intrinsic_1.Intrinsic{constructor(name,value){super({[name]:value})}}class FnRef extends FnBase{constructor(logicalName){super("Ref",logicalName)}}class FnFindInMap extends FnBase{constructor(mapName,topLevelKey,secondLevelKey){super("Fn::FindInMap",[mapName,topLevelKey,secondLevelKey])}}class FnTransform extends FnBase{constructor(macroName,parameters){super("Fn::Transform",{Name:macroName,Parameters:parameters})}}class FnGetAtt extends FnBase{constructor(logicalNameOfResource,attributeName){super("Fn::GetAtt",[logicalNameOfResource,attributeName])}}class FnGetAZs extends FnBase{constructor(region){super("Fn::GetAZs",region||"")}}class FnImportValue extends FnBase{constructor(sharedValueToImport){super("Fn::ImportValue",sharedValueToImport)}}class FnSelect extends FnBase{constructor(index,array){super("Fn::Select",[index,array])}}class FnSplit extends FnBase{constructor(delimiter,source){super("Fn::Split",[delimiter,source])}}class FnSub extends FnBase{constructor(body,variables){super("Fn::Sub",variables?[body,variables]:body)}}class FnBase64 extends FnBase{constructor(data){super("Fn::Base64",data)}}class FnCidr extends FnBase{constructor(ipBlock,count,sizeMask){if(count<1||count>256)throw new Error(`Fn::Cidr's count attribute must be betwen 1 and 256, ${count} was provided.`);super("Fn::Cidr",[ipBlock,count,sizeMask])}}class FnConditionBase extends intrinsic_1.Intrinsic{constructor(type,value){super({[type]:value}),this.disambiguator=!0}}class FnAnd extends FnConditionBase{constructor(...condition){super("Fn::And",condition)}}class FnEquals extends FnConditionBase{constructor(lhs,rhs){super("Fn::Equals",[lhs,rhs])}}class FnIf extends FnConditionBase{constructor(condition,valueIfTrue,valueIfFalse){super("Fn::If",[condition,valueIfTrue,valueIfFalse])}}class FnNot extends FnConditionBase{constructor(condition){super("Fn::Not",[condition])}}class FnOr extends FnConditionBase{constructor(...condition){super("Fn::Or",condition)}}class FnContains extends FnConditionBase{constructor(listOfStrings,value){super("Fn::Contains",[listOfStrings,value])}}class FnEachMemberEquals extends FnConditionBase{constructor(listOfStrings,value){super("Fn::EachMemberEquals",[listOfStrings,value])}}class FnEachMemberIn extends FnConditionBase{constructor(stringsToCheck,stringsToMatch){super("Fn::EachMemberIn",[stringsToCheck,stringsToMatch])}}class FnRefAll extends FnBase{constructor(parameterType){super("Fn::RefAll",parameterType)}}class FnValueOf extends FnBase{constructor(parameterOrLogicalId,attribute){super("Fn::ValueOf",[parameterOrLogicalId,attribute])}}class FnValueOfAll extends FnBase{constructor(parameterType,attribute){super("Fn::ValueOfAll",[parameterType,attribute])}}class FnJoin{constructor(delimiter,listOfValues){if(listOfValues.length===0)throw new Error("FnJoin requires at least one value to be provided");this.delimiter=delimiter,this.listOfValues=listOfValues,this.creationStack=stack_trace_1.captureStackTrace()}resolve(context){if(token_1.Token.isUnresolved(this.listOfValues))return{"Fn::Join":[this.delimiter,this.listOfValues]};const resolved=this.resolveValues(context);return resolved.length===1?resolved[0]:{"Fn::Join":[this.delimiter,resolved]}}toString(){return token_1.Token.asString(this,{displayHint:"Fn::Join"})}toJSON(){return"<Fn::Join>"}resolveValues(context){const resolvedValues=this.listOfValues.map(x=>reference_1.Reference.isReference(x)?x:context.resolve(x));return cloudformation_lang_1.minimalCloudFormationJoin(this.delimiter,resolvedValues)}}class FnToJsonString{constructor(object){this.object=object,this.creationStack=stack_trace_1.captureStackTrace()}resolve(context){return stack_1.Stack.of(context.scope).addTransform("AWS::LanguageExtensions"),{"Fn::ToJsonString":this.object}}toString(){return token_1.Token.asString(this,{displayHint:"Fn::ToJsonString"})}toJSON(){return"<Fn::ToJsonString>"}}class FnLength{constructor(array){this.array=array,this.creationStack=stack_trace_1.captureStackTrace()}resolve(context){return stack_1.Stack.of(context.scope).addTransform("AWS::LanguageExtensions"),{"Fn::Length":this.array}}toString(){return token_1.Token.asString(this,{displayHint:"Fn::Length"})}toJSON(){return"<Fn::Length>"}}function _inGroupsOf(array,maxGroup){const result=new Array;for(let i=0;i<array.length;i+=maxGroup)result.push(array.slice(i,i+maxGroup));return result}function range(n){const ret=[];for(let i=0;i<n;i++)ret.push(i);return ret}
//# sourceMappingURL=cfn-fn.js.map
