"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.CustomResourceProvider=exports.CustomResourceProviderRuntime=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),fs=require("fs"),path=require("path"),cxapi=require("../../../cx-api"),constructs_1=require("constructs"),fse=require("fs-extra"),asset_staging_1=require("../asset-staging"),assets_1=require("../assets"),cfn_resource_1=require("../cfn-resource"),duration_1=require("../duration"),fs_1=require("../fs"),lazy_1=require("../lazy"),size_1=require("../size"),stack_1=require("../stack"),token_1=require("../token"),ENTRYPOINT_FILENAME="__entrypoint__",ENTRYPOINT_NODEJS_SOURCE=path.join(__dirname,"nodejs-entrypoint.js");var CustomResourceProviderRuntime;(function(CustomResourceProviderRuntime2){CustomResourceProviderRuntime2.NODEJS_12_X="nodejs12.x",CustomResourceProviderRuntime2.NODEJS_12="deprecated_nodejs12.x",CustomResourceProviderRuntime2.NODEJS_14_X="nodejs14.x",CustomResourceProviderRuntime2.NODEJS_16_X="nodejs16.x"})(CustomResourceProviderRuntime=exports.CustomResourceProviderRuntime||(exports.CustomResourceProviderRuntime={}));class CustomResourceProvider extends constructs_1.Construct{constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_CustomResourceProviderProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CustomResourceProvider),error}const stack=stack_1.Stack.of(scope);if(!fs.existsSync(path.join(props.codeDirectory,"index.js")))throw new Error(`cannot find ${props.codeDirectory}/index.js`);const stagingDirectory=fs_1.FileSystem.mkdtemp("cdk-custom-resource");fse.copySync(props.codeDirectory,stagingDirectory),fs.copyFileSync(ENTRYPOINT_NODEJS_SOURCE,path.join(stagingDirectory,`${ENTRYPOINT_FILENAME}.js`));const staging=new asset_staging_1.AssetStaging(this,"Staging",{sourcePath:stagingDirectory}),assetFileName=staging.relativeStagedPath(stack),asset=stack.synthesizer.addFileAsset({fileName:assetFileName,sourceHash:staging.assetHash,packaging:assets_1.FileAssetPackaging.ZIP_DIRECTORY});if(props.policyStatements)for(const statement of props.policyStatements)this.addToRolePolicy(statement);const role=new cfn_resource_1.CfnResource(this,"Role",{type:"AWS::IAM::Role",properties:{AssumeRolePolicyDocument:{Version:"2012-10-17",Statement:[{Action:"sts:AssumeRole",Effect:"Allow",Principal:{Service:"lambda.amazonaws.com"}}]},ManagedPolicyArns:[{"Fn::Sub":"arn:${AWS::Partition}:iam::aws:policy/service-role/AWSLambdaBasicExecutionRole"}],Policies:lazy_1.Lazy.any({produce:()=>this.renderPolicies()})}});this.roleArn=token_1.Token.asString(role.getAtt("Arn"));const timeout=props.timeout??duration_1.Duration.minutes(15),memory=props.memorySize??size_1.Size.mebibytes(128),handler=new cfn_resource_1.CfnResource(this,"Handler",{type:"AWS::Lambda::Function",properties:{Code:{S3Bucket:asset.bucketName,S3Key:asset.objectKey},Timeout:timeout.toSeconds(),MemorySize:memory.toMebibytes(),Handler:`${ENTRYPOINT_FILENAME}.handler`,Role:role.getAtt("Arn"),Runtime:customResourceProviderRuntimeToString(props.runtime),Environment:this.renderEnvironmentVariables(props.environment),Description:props.description??void 0}});handler.addDependsOn(role),this.node.tryGetContext(cxapi.ASSET_RESOURCE_METADATA_ENABLED_CONTEXT)&&(handler.addMetadata(cxapi.ASSET_RESOURCE_METADATA_PATH_KEY,assetFileName),handler.addMetadata(cxapi.ASSET_RESOURCE_METADATA_PROPERTY_KEY,"Code")),this.serviceToken=token_1.Token.asString(handler.getAtt("Arn"))}static getOrCreate(scope,uniqueid,props){try{jsiiDeprecationWarnings.aws_cdk_lib_CustomResourceProviderProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.getOrCreate),error}return this.getOrCreateProvider(scope,uniqueid,props).serviceToken}static getOrCreateProvider(scope,uniqueid,props){try{jsiiDeprecationWarnings.aws_cdk_lib_CustomResourceProviderProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.getOrCreateProvider),error}const id=`${uniqueid}CustomResourceProvider`,stack=stack_1.Stack.of(scope);return stack.node.tryFindChild(id)??new CustomResourceProvider(stack,id,props)}addToRolePolicy(statement){this.policyStatements||(this.policyStatements=[]),this.policyStatements.push(statement)}renderPolicies(){return this.policyStatements?[{PolicyName:"Inline",PolicyDocument:{Version:"2012-10-17",Statement:this.policyStatements}}]:void 0}renderEnvironmentVariables(env){if(!env||Object.keys(env).length===0)return;const variables={},keys=Object.keys(env).sort();for(const key of keys)variables[key]=env[key];return{Variables:variables}}}exports.CustomResourceProvider=CustomResourceProvider,_a=JSII_RTTI_SYMBOL_1,CustomResourceProvider[_a]={fqn:"aws-cdk-lib.CustomResourceProvider",version:"2.42.0"};function customResourceProviderRuntimeToString(x){switch(x){case CustomResourceProviderRuntime.NODEJS_12:case CustomResourceProviderRuntime.NODEJS_12_X:return"nodejs12.x";case CustomResourceProviderRuntime.NODEJS_14_X:return"nodejs14.x";case CustomResourceProviderRuntime.NODEJS_16_X:return"nodejs16.x"}}
//# sourceMappingURL=custom-resource-provider.js.map
