"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.addDependency=void 0;const stack_1=require("./stack"),stage_1=require("./stage"),util_1=require("./util");function addDependency(source,target,reason){if(source===target)return;const sourceStack=stack_1.Stack.of(source),targetStack=stack_1.Stack.of(target),sourceStage=stage_1.Stage.of(sourceStack),targetStage=stage_1.Stage.of(targetStack);if(sourceStage!==targetStage)throw new Error(`You cannot add a dependency from '${source.node.path}' (in ${describeStage(sourceStage)}) to '${target.node.path}' (in ${describeStage(targetStage)}): dependency cannot cross stage boundaries`);const sourcePath=util_1.pathToTopLevelStack(sourceStack),targetPath=util_1.pathToTopLevelStack(targetStack),commonStack=util_1.findLastCommonElement(sourcePath,targetPath);if(!commonStack){const topLevelSource=sourcePath[0],topLevelTarget=targetPath[0];topLevelSource._addAssemblyDependency(topLevelTarget,reason);return}if(commonStack===source)return;if(commonStack===target)throw new Error(`Nested stack '${sourceStack.node.path}' cannot depend on a parent stack '${targetStack.node.path}': ${reason}`);const sourceResource=resourceInCommonStackFor(source),targetResource=resourceInCommonStackFor(target);sourceResource._addResourceDependency(targetResource);function resourceInCommonStackFor(element){const resource=stack_1.Stack.isStack(element)?element.nestedStackResource:element;if(!resource)throw new Error("assertion failure");const resourceStack=stack_1.Stack.of(resource);return commonStack===resourceStack?resource:resourceInCommonStackFor(resourceStack)}}exports.addDependency=addDependency;function describeStage(assembly){return assembly?assembly.parentStage?`Stage '${assembly.node.path}'`:"the App":"an unrooted construct tree"}
//# sourceMappingURL=deps.js.map
