"use strict";var _a,_b,_c,_d;Object.defineProperty(exports,"__esModule",{value:!0}),exports.DockerIgnoreStrategy=exports.GitIgnoreStrategy=exports.GlobIgnoreStrategy=exports.IgnoreStrategy=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),path=require("path"),dockerignore_1=require("@balena/dockerignore"),ignore_1=require("ignore"),minimatch=require("minimatch"),options_1=require("./options");class IgnoreStrategy{static glob(absoluteRootPath,patterns){return new GlobIgnoreStrategy(absoluteRootPath,patterns)}static git(absoluteRootPath,patterns){return new GitIgnoreStrategy(absoluteRootPath,patterns)}static docker(absoluteRootPath,patterns){return new DockerIgnoreStrategy(absoluteRootPath,patterns)}static fromCopyOptions(options,absoluteRootPath){try{jsiiDeprecationWarnings.aws_cdk_lib_CopyOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromCopyOptions),error}const ignoreMode=options.ignoreMode||options_1.IgnoreMode.GLOB,exclude=options.exclude||[];switch(ignoreMode){case options_1.IgnoreMode.GLOB:return this.glob(absoluteRootPath,exclude);case options_1.IgnoreMode.GIT:return this.git(absoluteRootPath,exclude);case options_1.IgnoreMode.DOCKER:return this.docker(absoluteRootPath,exclude)}}}exports.IgnoreStrategy=IgnoreStrategy,_a=JSII_RTTI_SYMBOL_1,IgnoreStrategy[_a]={fqn:"aws-cdk-lib.IgnoreStrategy",version:"2.42.0"};class GlobIgnoreStrategy extends IgnoreStrategy{constructor(absoluteRootPath,patterns){if(super(),!path.isAbsolute(absoluteRootPath))throw new Error("GlobIgnoreStrategy expects an absolute file path");this.absoluteRootPath=absoluteRootPath,this.patterns=patterns}add(pattern){this.patterns.push(pattern)}ignores(absoluteFilePath){if(!path.isAbsolute(absoluteFilePath))throw new Error("GlobIgnoreStrategy.ignores() expects an absolute path");let relativePath=path.relative(this.absoluteRootPath,absoluteFilePath),excludeOutput=!1;for(const pattern of this.patterns){const negate=pattern.startsWith("!"),match=minimatch(relativePath,pattern,{matchBase:!0,flipNegate:!0});!negate&&match&&(excludeOutput=!0),negate&&match&&(excludeOutput=!1)}return excludeOutput}}exports.GlobIgnoreStrategy=GlobIgnoreStrategy,_b=JSII_RTTI_SYMBOL_1,GlobIgnoreStrategy[_b]={fqn:"aws-cdk-lib.GlobIgnoreStrategy",version:"2.42.0"};class GitIgnoreStrategy extends IgnoreStrategy{constructor(absoluteRootPath,patterns){if(super(),!path.isAbsolute(absoluteRootPath))throw new Error("GitIgnoreStrategy expects an absolute file path");this.absoluteRootPath=absoluteRootPath,this.ignore=ignore_1.default().add(patterns)}add(pattern){this.ignore.add(pattern)}ignores(absoluteFilePath){if(!path.isAbsolute(absoluteFilePath))throw new Error("GitIgnoreStrategy.ignores() expects an absolute path");let relativePath=path.relative(this.absoluteRootPath,absoluteFilePath);return this.ignore.ignores(relativePath)}}exports.GitIgnoreStrategy=GitIgnoreStrategy,_c=JSII_RTTI_SYMBOL_1,GitIgnoreStrategy[_c]={fqn:"aws-cdk-lib.GitIgnoreStrategy",version:"2.42.0"};class DockerIgnoreStrategy extends IgnoreStrategy{constructor(absoluteRootPath,patterns){if(super(),!path.isAbsolute(absoluteRootPath))throw new Error("DockerIgnoreStrategy expects an absolute file path");this.absoluteRootPath=absoluteRootPath,this.ignore=dockerignore_1.default().add(patterns)}add(pattern){this.ignore.add(pattern)}ignores(absoluteFilePath){if(!path.isAbsolute(absoluteFilePath))throw new Error("DockerIgnoreStrategy.ignores() expects an absolute path");let relativePath=path.relative(this.absoluteRootPath,absoluteFilePath);return this.ignore.ignores(relativePath)}}exports.DockerIgnoreStrategy=DockerIgnoreStrategy,_d=JSII_RTTI_SYMBOL_1,DockerIgnoreStrategy[_d]={fqn:"aws-cdk-lib.DockerIgnoreStrategy",version:"2.42.0"};
//# sourceMappingURL=ignore.js.map
