"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.NestedStack=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),crypto=require("crypto"),cxapi=require("../../cx-api"),constructs_1=require("constructs"),assets_1=require("./assets"),cfn_fn_1=require("./cfn-fn"),cfn_pseudo_1=require("./cfn-pseudo"),cloudformation_generated_1=require("./cloudformation.generated"),lazy_1=require("./lazy"),names_1=require("./names"),removal_policy_1=require("./removal-policy"),stack_1=require("./stack"),stack_synthesizers_1=require("./stack-synthesizers"),token_1=require("./token"),NESTED_STACK_SYMBOL=Symbol.for("@aws-cdk/core.NestedStack");class NestedStack extends stack_1.Stack{constructor(scope,id,props={}){try{jsiiDeprecationWarnings.aws_cdk_lib_NestedStackProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,NestedStack),error}const parentStack=findParentStack(scope);super(scope,id,{env:{account:parentStack.account,region:parentStack.region},synthesizer:new stack_synthesizers_1.NestedStackSynthesizer(parentStack.synthesizer),description:props.description}),this._parentStack=parentStack;const parentScope=new constructs_1.Construct(scope,id+".NestedStack");Object.defineProperty(this,NESTED_STACK_SYMBOL,{value:!0}),this.templateFile=`${names_1.Names.uniqueId(this)}.nested.template.json`,this.parameters=props.parameters||{},this.resource=new cloudformation_generated_1.CfnStack(parentScope,`${id}.NestedStackResource`,{templateUrl:lazy_1.Lazy.uncachedString({produce:()=>this._templateUrl||"<unresolved>"}),parameters:lazy_1.Lazy.any({produce:()=>Object.keys(this.parameters).length>0?this.parameters:void 0}),notificationArns:props.notificationArns,timeoutInMinutes:props.timeout?props.timeout.toMinutes():void 0}),this.resource.applyRemovalPolicy(props.removalPolicy??removal_policy_1.RemovalPolicy.DESTROY),this.nestedStackResource=this.resource,this.node.defaultChild=this.resource,this._contextualStackName=this.contextualAttribute(cfn_pseudo_1.Aws.STACK_NAME,cfn_fn_1.Fn.select(1,cfn_fn_1.Fn.split("/",this.resource.ref))),this._contextualStackId=this.contextualAttribute(cfn_pseudo_1.Aws.STACK_ID,this.resource.ref)}static isNestedStack(x){return x!=null&&typeof x=="object"&&NESTED_STACK_SYMBOL in x}get stackName(){return this._contextualStackName}get stackId(){return this._contextualStackId}setParameter(name,value){this.parameters[name]=value}_prepareTemplateAsset(){if(this._templateUrl)return!1;Object.entries(this.tags.tagValues()).forEach(([key,value])=>{this.resource.tags.setTag(key,value)});const cfn=JSON.stringify(this._toCloudFormation()),templateHash=crypto.createHash("sha256").update(cfn).digest("hex"),templateLocation=this._parentStack.synthesizer.addFileAsset({packaging:assets_1.FileAssetPackaging.FILE,sourceHash:templateHash,fileName:this.templateFile});return this.addResourceMetadata(this.resource,"TemplateURL"),this._templateUrl=`https://s3.${this._parentStack.region}.${this._parentStack.urlSuffix}/${templateLocation.bucketName}/${templateLocation.objectKey}`,!0}contextualAttribute(innerValue,outerValue){return token_1.Token.asString({resolve:context=>stack_1.Stack.of(context.scope)===this?innerValue:outerValue})}addResourceMetadata(resource,resourceProperty){!this.node.tryGetContext(cxapi.ASSET_RESOURCE_METADATA_ENABLED_CONTEXT)||(resource.cfnOptions.metadata=resource.cfnOptions.metadata||{},resource.cfnOptions.metadata[cxapi.ASSET_RESOURCE_METADATA_PATH_KEY]=this.templateFile,resource.cfnOptions.metadata[cxapi.ASSET_RESOURCE_METADATA_PROPERTY_KEY]=resourceProperty)}}exports.NestedStack=NestedStack,_a=JSII_RTTI_SYMBOL_1,NestedStack[_a]={fqn:"aws-cdk-lib.NestedStack",version:"2.42.0"};function findParentStack(scope){if(!scope)throw new Error("Nested stacks cannot be defined as a root construct");const parentStack=constructs_1.Node.of(scope).scopes.reverse().find(p=>stack_1.Stack.isStack(p));if(!parentStack)throw new Error("Nested stacks must be defined within scope of another non-nested stack");return parentStack}
//# sourceMappingURL=nested-stack.js.map
