"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.formatAnalytics=exports.MetadataResource=void 0;const zlib=require("zlib"),region_info_1=require("../../../region-info"),constructs_1=require("constructs"),cfn_condition_1=require("../cfn-condition"),cfn_fn_1=require("../cfn-fn"),cfn_pseudo_1=require("../cfn-pseudo"),cfn_resource_1=require("../cfn-resource"),lazy_1=require("../lazy"),token_1=require("../token"),runtime_info_1=require("./runtime-info");class MetadataResource extends constructs_1.Construct{constructor(scope,id){if(super(scope,id),token_1.Token.isUnresolved(scope.region)||region_info_1.RegionInfo.get(scope.region).cdkMetadataResourceAvailable){const resource=new cfn_resource_1.CfnResource(this,"Default",{type:"AWS::CDK::Metadata",properties:{Analytics:lazy_1.Lazy.string({produce:()=>formatAnalytics(runtime_info_1.constructInfoFromStack(scope))})}});if(token_1.Token.isUnresolved(scope.region)){const condition=new cfn_condition_1.CfnCondition(this,"Condition",{expression:makeCdkMetadataAvailableCondition()});condition.overrideLogicalId("CDKMetadataAvailable"),resource.cfnOptions.condition=condition}}}}exports.MetadataResource=MetadataResource;function makeCdkMetadataAvailableCondition(){return cfn_fn_1.Fn.conditionOr(...region_info_1.RegionInfo.regions.filter(ri=>ri.cdkMetadataResourceAvailable).map(ri=>cfn_fn_1.Fn.conditionEquals(cfn_pseudo_1.Aws.REGION,ri.name)))}class Trie extends Map{}function formatAnalytics(infos){const trie=new Trie;infos.forEach(info=>insertFqnInTrie(`${info.version}!${info.fqn}`,trie));const plaintextEncodedConstructs=prefixEncodeTrie(trie),compressedConstructsBuffer=zlib.gzipSync(Buffer.from(plaintextEncodedConstructs));return setGzipOperatingSystemToUnknown(compressedConstructsBuffer),`v2:deflate64:${compressedConstructsBuffer.toString("base64")}`}exports.formatAnalytics=formatAnalytics;function insertFqnInTrie(fqn,trie){for(const fqnPart of fqn.replace(/[^a-z0-9]/gi,"$& ").split(" ")){const nextLevelTreeRef=trie.get(fqnPart)??new Trie;trie.set(fqnPart,nextLevelTreeRef),trie=nextLevelTreeRef}return trie}function prefixEncodeTrie(trie){let prefixEncoded="",isFirstEntryAtLevel=!0;return[...trie.entries()].forEach(([key,value])=>{isFirstEntryAtLevel||(prefixEncoded+=","),isFirstEntryAtLevel=!1,prefixEncoded+=key,value.size>1?(prefixEncoded+="{",prefixEncoded+=prefixEncodeTrie(value),prefixEncoded+="}"):prefixEncoded+=prefixEncodeTrie(value)}),prefixEncoded}function setGzipOperatingSystemToUnknown(gzipBuffer){if(gzipBuffer[0]!==31||gzipBuffer[1]!==139)throw new Error("Expecting a gzip buffer (must start with 0x1f8b)");gzipBuffer[9]=255}
//# sourceMappingURL=metadata-resource.js.map
