"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.referenceNestedStackValueInParent=exports.resolveReferences=void 0;const cfn_element_1=require("../cfn-element"),cfn_output_1=require("../cfn-output"),cfn_parameter_1=require("../cfn-parameter"),names_1=require("../names"),stack_1=require("../stack"),token_1=require("../token"),cfn_reference_1=require("./cfn-reference"),resolve_1=require("./resolve");function resolveReferences(scope){const edges=findAllReferences(scope);for(const{source,value}of edges){const consumer=stack_1.Stack.of(source);if(!value.hasValueForStack(consumer)){const resolved=resolveValue(consumer,value);value.assignValueForStack(consumer,resolved)}}}exports.resolveReferences=resolveReferences;function resolveValue(consumer,reference){const producer=stack_1.Stack.of(reference.target);if(producer===consumer)return reference;if(producer.node.root!==consumer.node.root)throw new Error("Cannot reference across apps. Consuming and producing stacks must be defined within the same CDK app.");if(producer.environment!==consumer.environment)throw new Error(`Stack "${consumer.node.path}" cannot consume a cross reference from stack "${producer.node.path}". Cross stack references are only supported for stacks deployed to the same environment or between nested stacks and their parent stack`);if(consumer.nestedStackParent&&isNested(consumer,producer)){const parameterValue=resolveValue(consumer.nestedStackParent,reference);return createNestedStackParameter(consumer,reference,parameterValue)}if(producer.nested){const outputValue=createNestedStackOutput(producer,reference);return resolveValue(consumer,outputValue)}return consumer.addDependency(producer,`${consumer.node.path} -> ${reference.target.node.path}.${reference.displayName}`),createImportValue(reference)}function findAllReferences(root){const result=new Array;for(const consumer of root.node.findAll())if(!!cfn_element_1.CfnElement.isCfnElement(consumer))try{const tokens=resolve_1.findTokens(consumer,()=>consumer._toCloudFormation());for(const token of tokens)!cfn_reference_1.CfnReference.isCfnReference(token)||result.push({source:consumer,value:token})}catch(e){if(e.type==="CfnSynthesisError")continue;throw e}return result}function createImportValue(reference){const importExpr=stack_1.Stack.of(reference.target).exportValue(reference);return token_1.Tokenization.reverseCompleteString(importExpr)}function createNestedStackParameter(nested,reference,value){const paramId=generateUniqueId(nested,reference,"reference-to-");let param=nested.node.tryFindChild(paramId);if(!param){if(param=new cfn_parameter_1.CfnParameter(nested,paramId,{type:"String"}),!("setParameter"in nested))throw new Error('assertion failed: nested stack should have a "setParameter" method');nested.setParameter(param.logicalId,token_1.Token.asString(value))}return param.value}function createNestedStackOutput(producer,reference){const outputId=generateUniqueId(producer,reference);let output=producer.node.tryFindChild(outputId);if(output||(output=new cfn_output_1.CfnOutput(producer,outputId,{value:token_1.Token.asString(reference)})),!producer.nestedStackResource)throw new Error("assertion failed");return producer.nestedStackResource.getAtt(`Outputs.${output.logicalId}`)}function referenceNestedStackValueInParent(reference,targetStack){let currentStack=stack_1.Stack.of(reference.target);if(currentStack!==targetStack&&!isNested(currentStack,targetStack))throw new Error(`Referenced resource must be in stack '${targetStack.node.path}', got '${reference.target.node.path}'`);for(;currentStack!==targetStack;)reference=createNestedStackOutput(stack_1.Stack.of(reference.target),reference),currentStack=stack_1.Stack.of(reference.target);return reference}exports.referenceNestedStackValueInParent=referenceNestedStackValueInParent;function isNested(nested,parent){return nested.nestedStackParent===parent?!0:nested.nestedStackParent?isNested(nested.nestedStackParent,parent):!1}function generateUniqueId(stack,ref,prefix=""){return stack.resolve(`${prefix}${names_1.Names.nodeUniqueId(ref.target.node)}${ref.displayName}`)}
//# sourceMappingURL=refs.js.map
