"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.AssetManifestBuilder=void 0;const fs=require("fs"),path=require("path"),cxschema=require("../../../cloud-assembly-schema"),assets_1=require("../assets"),cfn_fn_1=require("../cfn-fn"),_shared_1=require("./_shared");class AssetManifestBuilder{constructor(){this.files={},this.dockerImages={}}addFileAssetDefault(asset,stack,bucketName,bucketPrefix,role){validateFileAssetSource(asset);const extension=asset.fileName!=null?path.extname(asset.fileName):"",objectKey=bucketPrefix+asset.sourceHash+(asset.packaging===assets_1.FileAssetPackaging.ZIP_DIRECTORY?".zip":extension);this.files[asset.sourceHash]={source:{path:asset.fileName,executable:asset.executable,packaging:asset.packaging},destinations:{[this.manifestEnvName(stack)]:{bucketName,objectKey,region:_shared_1.resolvedOr(stack.region,void 0),assumeRoleArn:role?.assumeRoleArn,assumeRoleExternalId:role?.assumeRoleExternalId}}};const{region,urlSuffix}=stackLocationOrInstrinsics(stack),httpUrl=cfnify(`https://s3.${region}.${urlSuffix}/${bucketName}/${objectKey}`),s3ObjectUrlWithPlaceholders=`s3://${bucketName}/${objectKey}`;return{bucketName:cfnify(bucketName),objectKey,httpUrl,s3ObjectUrl:cfnify(s3ObjectUrlWithPlaceholders),s3ObjectUrlWithPlaceholders,s3Url:httpUrl}}addDockerImageAssetDefault(asset,stack,repositoryName,dockerTagPrefix,role){validateDockerImageAssetSource(asset);const imageTag=`${dockerTagPrefix}${asset.sourceHash}`;this.dockerImages[asset.sourceHash]={source:{executable:asset.executable,directory:asset.directoryName,dockerBuildArgs:asset.dockerBuildArgs,dockerBuildTarget:asset.dockerBuildTarget,dockerFile:asset.dockerFile,networkMode:asset.networkMode,platform:asset.platform},destinations:{[this.manifestEnvName(stack)]:{repositoryName,imageTag,region:_shared_1.resolvedOr(stack.region,void 0),assumeRoleArn:role?.assumeRoleArn,assumeRoleExternalId:role?.assumeRoleExternalId}}};const{account,region,urlSuffix}=stackLocationOrInstrinsics(stack);return{repositoryName:cfnify(repositoryName),imageUri:cfnify(`${account}.dkr.ecr.${region}.${urlSuffix}/${repositoryName}:${imageTag}`),imageTag:cfnify(imageTag)}}writeManifest(stack,session,additionalProps={}){const artifactId=`${stack.artifactId}.assets`,manifestFile=`${artifactId}.json`,outPath=path.join(session.assembly.outdir,manifestFile),manifest={version:cxschema.Manifest.version(),files:this.files,dockerImages:this.dockerImages};return fs.writeFileSync(outPath,JSON.stringify(manifest,void 0,2)),session.assembly.addArtifact(artifactId,{type:cxschema.ArtifactType.ASSET_MANIFEST,properties:{file:manifestFile,...additionalProps}}),artifactId}manifestEnvName(stack){return[_shared_1.resolvedOr(stack.account,"current_account"),_shared_1.resolvedOr(stack.region,"current_region")].join("-")}}exports.AssetManifestBuilder=AssetManifestBuilder;function validateFileAssetSource(asset){if(!!asset.executable==!!asset.fileName)throw new Error(`Exactly one of 'fileName' or 'executable' is required, got: ${JSON.stringify(asset)}`);if(!!asset.packaging!=!!asset.fileName)throw new Error(`'packaging' is expected in combination with 'fileName', got: ${JSON.stringify(asset)}`)}function validateDockerImageAssetSource(asset){if(!!asset.executable==!!asset.directoryName)throw new Error(`Exactly one of 'directoryName' or 'executable' is required, got: ${JSON.stringify(asset)}`);check("dockerBuildArgs"),check("dockerBuildTarget"),check("dockerFile");function check(key){if(asset[key]&&!asset.directoryName)throw new Error(`'${key}' is only allowed in combination with 'directoryName', got: ${JSON.stringify(asset)}`)}}function stackLocationOrInstrinsics(stack){return{account:_shared_1.resolvedOr(stack.account,"${AWS::AccountId}"),region:_shared_1.resolvedOr(stack.region,"${AWS::Region}"),urlSuffix:_shared_1.resolvedOr(stack.urlSuffix,"${AWS::URLSuffix}")}}function cfnify(s){return s.indexOf("${")>-1?cfn_fn_1.Fn.sub(s):s}
//# sourceMappingURL=_asset-manifest-builder.js.map
