"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.DefaultStackSynthesizer=exports.BOOTSTRAP_QUALIFIER_CONTEXT=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cxapi=require("../../../cx-api"),cfn_fn_1=require("../cfn-fn"),cfn_parameter_1=require("../cfn-parameter"),cfn_rule_1=require("../cfn-rule"),token_1=require("../token"),_asset_manifest_builder_1=require("./_asset-manifest-builder"),_shared_1=require("./_shared"),stack_synthesizer_1=require("./stack-synthesizer");exports.BOOTSTRAP_QUALIFIER_CONTEXT="@aws-cdk/core:bootstrapQualifier";const MIN_BOOTSTRAP_STACK_VERSION=6,MIN_LOOKUP_ROLE_BOOTSTRAP_STACK_VERSION=8;class DefaultStackSynthesizer extends stack_synthesizer_1.StackSynthesizer{constructor(props={}){super(),this.props=props,this.assetManifest=new _asset_manifest_builder_1.AssetManifestBuilder;try{jsiiDeprecationWarnings.aws_cdk_lib_DefaultStackSynthesizerProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,DefaultStackSynthesizer),error}this.useLookupRoleForStackOperations=props.useLookupRoleForStackOperations??!0;for(const key in props)props.hasOwnProperty(key)&&validateNoToken(key);function validateNoToken(key){const prop=props[key];if(typeof prop=="string"&&token_1.Token.isUnresolved(prop))throw new Error(`DefaultSynthesizer property '${key}' cannot contain tokens; only the following placeholder strings are allowed: `+["${Qualifier}",cxapi.EnvironmentPlaceholders.CURRENT_REGION,cxapi.EnvironmentPlaceholders.CURRENT_ACCOUNT,cxapi.EnvironmentPlaceholders.CURRENT_PARTITION].join(", "))}}bind(stack){try{jsiiDeprecationWarnings.aws_cdk_lib_Stack(stack)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.bind),error}if(this._stack!==void 0)throw new Error("A StackSynthesizer can only be used for one Stack: create a new instance to use with a different Stack");this._stack=stack;const qualifier=this.props.qualifier??stack.node.tryGetContext(exports.BOOTSTRAP_QUALIFIER_CONTEXT)??DefaultStackSynthesizer.DEFAULT_QUALIFIER;this.qualifier=qualifier;const spec=new _shared_1.StringSpecializer(stack,qualifier);this.bucketName=spec.specialize(this.props.fileAssetsBucketName??DefaultStackSynthesizer.DEFAULT_FILE_ASSETS_BUCKET_NAME),this.repositoryName=spec.specialize(this.props.imageAssetsRepositoryName??DefaultStackSynthesizer.DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME),this._deployRoleArn=spec.specialize(this.props.deployRoleArn??DefaultStackSynthesizer.DEFAULT_DEPLOY_ROLE_ARN),this._cloudFormationExecutionRoleArn=spec.specialize(this.props.cloudFormationExecutionRole??DefaultStackSynthesizer.DEFAULT_CLOUDFORMATION_ROLE_ARN),this.fileAssetPublishingRoleArn=spec.specialize(this.props.fileAssetPublishingRoleArn??DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PUBLISHING_ROLE_ARN),this.imageAssetPublishingRoleArn=spec.specialize(this.props.imageAssetPublishingRoleArn??DefaultStackSynthesizer.DEFAULT_IMAGE_ASSET_PUBLISHING_ROLE_ARN),this.lookupRoleArn=spec.specialize(this.props.lookupRoleArn??DefaultStackSynthesizer.DEFAULT_LOOKUP_ROLE_ARN),this.bucketPrefix=spec.specialize(this.props.bucketPrefix??DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PREFIX),this.dockerTagPrefix=spec.specialize(this.props.dockerTagPrefix??DefaultStackSynthesizer.DEFAULT_DOCKER_ASSET_PREFIX),this.bootstrapStackVersionSsmParameter=spec.qualifierOnly(this.props.bootstrapStackVersionSsmParameter??DefaultStackSynthesizer.DEFAULT_BOOTSTRAP_STACK_VERSION_SSM_PARAMETER)}addFileAsset(asset){try{jsiiDeprecationWarnings.aws_cdk_lib_FileAssetSource(asset)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addFileAsset),error}return _shared_1.assertBound(this.stack),_shared_1.assertBound(this.bucketName),_shared_1.assertBound(this.bucketPrefix),this.assetManifest.addFileAssetDefault(asset,this.stack,this.bucketName,this.bucketPrefix,{assumeRoleArn:this.fileAssetPublishingRoleArn,assumeRoleExternalId:this.props.fileAssetPublishingExternalId})}addDockerImageAsset(asset){try{jsiiDeprecationWarnings.aws_cdk_lib_DockerImageAssetSource(asset)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addDockerImageAsset),error}return _shared_1.assertBound(this.stack),_shared_1.assertBound(this.repositoryName),_shared_1.assertBound(this.dockerTagPrefix),this.assetManifest.addDockerImageAssetDefault(asset,this.stack,this.repositoryName,this.dockerTagPrefix,{assumeRoleArn:this.imageAssetPublishingRoleArn,assumeRoleExternalId:this.props.imageAssetPublishingExternalId})}synthesizeStackTemplate(stack,session){try{jsiiDeprecationWarnings.aws_cdk_lib_Stack(stack),jsiiDeprecationWarnings.aws_cdk_lib_ISynthesisSession(session)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.synthesizeStackTemplate),error}stack._synthesizeTemplate(session,this.lookupRoleArn)}synthesize(session){try{jsiiDeprecationWarnings.aws_cdk_lib_ISynthesisSession(session)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.synthesize),error}_shared_1.assertBound(this.stack),_shared_1.assertBound(this.qualifier),(this.props.generateBootstrapVersionRule??!0)&&addBootstrapVersionRule(this.stack,MIN_BOOTSTRAP_STACK_VERSION,this.bootstrapStackVersionSsmParameter),this.synthesizeStackTemplate(this.stack,session);const templateAsset=this.addFileAsset(_shared_1.stackTemplateFileAsset(this.stack,session)),assetManifestId=this.assetManifest.writeManifest(this.stack,session,{requiresBootstrapStackVersion:MIN_BOOTSTRAP_STACK_VERSION,bootstrapStackVersionSsmParameter:this.bootstrapStackVersionSsmParameter});this.emitStackArtifact(this.stack,session,{assumeRoleExternalId:this.props.deployRoleExternalId,assumeRoleArn:this._deployRoleArn,cloudFormationExecutionRoleArn:this._cloudFormationExecutionRoleArn,stackTemplateAssetObjectUrl:templateAsset.s3ObjectUrlWithPlaceholders,requiresBootstrapStackVersion:MIN_BOOTSTRAP_STACK_VERSION,bootstrapStackVersionSsmParameter:this.bootstrapStackVersionSsmParameter,additionalDependencies:[assetManifestId],lookupRole:this.useLookupRoleForStackOperations&&this.lookupRoleArn?{arn:this.lookupRoleArn,assumeRoleExternalId:this.props.lookupRoleExternalId,requiresBootstrapStackVersion:MIN_LOOKUP_ROLE_BOOTSTRAP_STACK_VERSION,bootstrapStackVersionSsmParameter:this.bootstrapStackVersionSsmParameter}:void 0})}get deployRoleArn(){if(!this._deployRoleArn)throw new Error("deployRoleArn getter can only be called after the synthesizer has been bound to a Stack");return this._deployRoleArn}get cloudFormationExecutionRoleArn(){if(!this._cloudFormationExecutionRoleArn)throw new Error("cloudFormationExecutionRoleArn getter can only be called after the synthesizer has been bound to a Stack");return this._cloudFormationExecutionRoleArn}get stack(){return this._stack}}exports.DefaultStackSynthesizer=DefaultStackSynthesizer,_a=JSII_RTTI_SYMBOL_1,DefaultStackSynthesizer[_a]={fqn:"aws-cdk-lib.DefaultStackSynthesizer",version:"2.42.0"},DefaultStackSynthesizer.DEFAULT_QUALIFIER="hnb659fds",DefaultStackSynthesizer.DEFAULT_CLOUDFORMATION_ROLE_ARN="arn:${AWS::Partition}:iam::${AWS::AccountId}:role/cdk-${Qualifier}-cfn-exec-role-${AWS::AccountId}-${AWS::Region}",DefaultStackSynthesizer.DEFAULT_DEPLOY_ROLE_ARN="arn:${AWS::Partition}:iam::${AWS::AccountId}:role/cdk-${Qualifier}-deploy-role-${AWS::AccountId}-${AWS::Region}",DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PUBLISHING_ROLE_ARN="arn:${AWS::Partition}:iam::${AWS::AccountId}:role/cdk-${Qualifier}-file-publishing-role-${AWS::AccountId}-${AWS::Region}",DefaultStackSynthesizer.DEFAULT_IMAGE_ASSET_PUBLISHING_ROLE_ARN="arn:${AWS::Partition}:iam::${AWS::AccountId}:role/cdk-${Qualifier}-image-publishing-role-${AWS::AccountId}-${AWS::Region}",DefaultStackSynthesizer.DEFAULT_LOOKUP_ROLE_ARN="arn:${AWS::Partition}:iam::${AWS::AccountId}:role/cdk-${Qualifier}-lookup-role-${AWS::AccountId}-${AWS::Region}",DefaultStackSynthesizer.DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME="cdk-${Qualifier}-container-assets-${AWS::AccountId}-${AWS::Region}",DefaultStackSynthesizer.DEFAULT_FILE_ASSETS_BUCKET_NAME="cdk-${Qualifier}-assets-${AWS::AccountId}-${AWS::Region}",DefaultStackSynthesizer.DEFAULT_FILE_ASSET_KEY_ARN_EXPORT_NAME="CdkBootstrap-${Qualifier}-FileAssetKeyArn",DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PREFIX="",DefaultStackSynthesizer.DEFAULT_DOCKER_ASSET_PREFIX="",DefaultStackSynthesizer.DEFAULT_BOOTSTRAP_STACK_VERSION_SSM_PARAMETER="/cdk-bootstrap/${Qualifier}/version";function addBootstrapVersionRule(stack,requiredVersion,bootstrapStackVersionSsmParameter){if(stack.node.tryFindChild("BootstrapVersion"))return;const param=new cfn_parameter_1.CfnParameter(stack,"BootstrapVersion",{type:"AWS::SSM::Parameter::Value<String>",description:`Version of the CDK Bootstrap resources in this environment, automatically retrieved from SSM Parameter Store. ${cxapi.SSMPARAM_NO_INVALIDATE}`,default:bootstrapStackVersionSsmParameter}),oldVersions=range(1,requiredVersion).map(n=>`${n}`);new cfn_rule_1.CfnRule(stack,"CheckBootstrapVersion",{assertions:[{assert:cfn_fn_1.Fn.conditionNot(cfn_fn_1.Fn.conditionContains(oldVersions,param.valueAsString)),assertDescription:`CDK bootstrap stack version ${requiredVersion} required. Please run 'cdk bootstrap' with a recent version of the CDK CLI.`}]})}function range(startIncl,endExcl){const ret=new Array;for(let i=startIncl;i<endExcl;i++)ret.push(i);return ret}
//# sourceMappingURL=default-synthesizer.js.map
