"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.LegacyStackSynthesizer=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cxschema=require("../../../cloud-assembly-schema"),cxapi=require("../../../cx-api"),constructs_1=require("constructs"),cfn_fn_1=require("../cfn-fn"),asset_parameters_1=require("../private/asset-parameters"),_shared_1=require("./_shared"),stack_synthesizer_1=require("./stack-synthesizer"),ASSETS_ECR_REPOSITORY_NAME="aws-cdk/assets",ASSETS_ECR_REPOSITORY_NAME_OVERRIDE_CONTEXT_KEY="assets-ecr-repository-name";class LegacyStackSynthesizer extends stack_synthesizer_1.StackSynthesizer{constructor(){super(...arguments),this.cycle=!1,this.addedImageAssets=new Set}bind(stack){try{jsiiDeprecationWarnings.aws_cdk_lib_Stack(stack)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.bind),error}if(this.stack!==void 0)throw new Error("A StackSynthesizer can only be used for one Stack: create a new instance to use with a different Stack");this.stack=stack}addFileAsset(asset){try{jsiiDeprecationWarnings.aws_cdk_lib_FileAssetSource(asset)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addFileAsset),error}if(_shared_1.assertBound(this.stack),this.cycle)return this.doAddFileAsset(asset);this.cycle=!0;try{const stack=this.stack;return withoutDeprecationWarnings(()=>stack.addFileAsset(asset))}finally{this.cycle=!1}}addDockerImageAsset(asset){try{jsiiDeprecationWarnings.aws_cdk_lib_DockerImageAssetSource(asset)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addDockerImageAsset),error}if(_shared_1.assertBound(this.stack),this.cycle)return this.doAddDockerImageAsset(asset);this.cycle=!0;try{const stack=this.stack;return withoutDeprecationWarnings(()=>stack.addDockerImageAsset(asset))}finally{this.cycle=!1}}synthesize(session){try{jsiiDeprecationWarnings.aws_cdk_lib_ISynthesisSession(session)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.synthesize),error}_shared_1.assertBound(this.stack),this.synthesizeStackTemplate(this.stack,session),this.emitStackArtifact(this.stack,session)}doAddDockerImageAsset(asset){_shared_1.assertBound(this.stack);const repositoryNameOverride=this.stack.node.tryGetContext(ASSETS_ECR_REPOSITORY_NAME_OVERRIDE_CONTEXT_KEY),repositoryName=asset.repositoryName??repositoryNameOverride??ASSETS_ECR_REPOSITORY_NAME,imageTag=asset.sourceHash,assetId=asset.sourceHash;if(!this.addedImageAssets.has(assetId)){if(!asset.directoryName)throw new Error(`LegacyStackSynthesizer does not support this type of file asset: ${JSON.stringify(asset)}`);const metadata={repositoryName,imageTag,id:assetId,packaging:"container-image",path:asset.directoryName,sourceHash:asset.sourceHash,buildArgs:asset.dockerBuildArgs,target:asset.dockerBuildTarget,file:asset.dockerFile,networkMode:asset.networkMode,platform:asset.platform};this.stack.node.addMetadata(cxschema.ArtifactMetadataEntryType.ASSET,metadata),this.addedImageAssets.add(assetId)}return{imageUri:`${this.stack.account}.dkr.ecr.${this.stack.region}.${this.stack.urlSuffix}/${repositoryName}:${imageTag}`,repositoryName}}doAddFileAsset(asset){_shared_1.assertBound(this.stack);let params=this.assetParameters.node.tryFindChild(asset.sourceHash);if(!params){if(params=new asset_parameters_1.FileAssetParameters(this.assetParameters,asset.sourceHash),!asset.fileName||!asset.packaging)throw new Error(`LegacyStackSynthesizer does not support this type of file asset: ${JSON.stringify(asset)}`);const metadata={path:asset.fileName,id:asset.sourceHash,packaging:asset.packaging,sourceHash:asset.sourceHash,s3BucketParameter:params.bucketNameParameter.logicalId,s3KeyParameter:params.objectKeyParameter.logicalId,artifactHashParameter:params.artifactHashParameter.logicalId};this.stack.node.addMetadata(cxschema.ArtifactMetadataEntryType.ASSET,metadata)}const bucketName=params.bucketNameParameter.valueAsString,encodedKey=params.objectKeyParameter.valueAsString,s3Prefix=cfn_fn_1.Fn.select(0,cfn_fn_1.Fn.split(cxapi.ASSET_PREFIX_SEPARATOR,encodedKey)),s3Filename=cfn_fn_1.Fn.select(1,cfn_fn_1.Fn.split(cxapi.ASSET_PREFIX_SEPARATOR,encodedKey)),objectKey=`${s3Prefix}${s3Filename}`,httpUrl=`https://s3.${this.stack.region}.${this.stack.urlSuffix}/${bucketName}/${objectKey}`,s3ObjectUrl=`s3://${bucketName}/${objectKey}`;return{bucketName,objectKey,httpUrl,s3ObjectUrl,s3Url:httpUrl}}get assetParameters(){return _shared_1.assertBound(this.stack),this._assetParameters||(this._assetParameters=new constructs_1.Construct(this.stack,"AssetParameters")),this._assetParameters}}exports.LegacyStackSynthesizer=LegacyStackSynthesizer,_a=JSII_RTTI_SYMBOL_1,LegacyStackSynthesizer[_a]={fqn:"aws-cdk-lib.LegacyStackSynthesizer",version:"2.42.0"};function withoutDeprecationWarnings(block){const orig=process.env.JSII_DEPRECATED;process.env.JSII_DEPRECATED="quiet";try{return block()}finally{process.env.JSII_DEPRECATED=orig}}
//# sourceMappingURL=legacy.js.map
