"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.rootPathTo=exports.Stack=exports.STACK_RESOURCE_LIMIT_CONTEXT=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),fs=require("fs"),path=require("path"),cxschema=require("../../cloud-assembly-schema"),cxapi=require("../../cx-api"),constructs_1=require("constructs"),minimatch=require("minimatch"),annotations_1=require("./annotations"),app_1=require("./app"),arn_1=require("./arn"),cfn_element_1=require("./cfn-element"),cfn_fn_1=require("./cfn-fn"),cfn_pseudo_1=require("./cfn-pseudo"),cfn_resource_1=require("./cfn-resource"),context_provider_1=require("./context-provider"),feature_flags_1=require("./feature-flags"),cloudformation_lang_1=require("./private/cloudformation-lang"),logical_id_1=require("./private/logical-id"),resolve_1=require("./private/resolve"),uniqueid_1=require("./private/uniqueid"),STACK_SYMBOL=Symbol.for("@aws-cdk/core.Stack"),MY_STACK_CACHE=Symbol.for("@aws-cdk/core.Stack.myStack");exports.STACK_RESOURCE_LIMIT_CONTEXT="@aws-cdk/core:stackResourceLimit";const VALID_STACK_NAME_REGEX=/^[A-Za-z][A-Za-z0-9-]*$/,MAX_RESOURCES=500;class Stack extends constructs_1.Construct{constructor(scope,id,props={}){try{jsiiDeprecationWarnings.aws_cdk_lib_StackProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Stack),error}scope=scope??new app_1.App({autoSynth:!1,outdir:fs_1.FileSystem.mkdtemp("cdk-test-app-")}),id=id??"Default",super(scope,id),this._missingContext=new Array,this._stackDependencies={},this.templateOptions={},Object.defineProperty(this,STACK_SYMBOL,{value:!0}),this._logicalIds=new logical_id_1.LogicalIDs;const{account,region,environment}=this.parseEnvironment(props.env);if(this.account=account,this.region=region,this.environment=environment,this.terminationProtection=props.terminationProtection,props.description!==void 0){if(props.description.length>512)throw new Error(`Stack description must be <= 1024 bytes. Received description: '${props.description}'`);this.templateOptions.description=props.description}if(this._stackName=props.stackName??this.generateStackName(),this._stackName.length>128)throw new Error(`Stack name must be <= 128 characters. Stack name: '${this._stackName}'`);if(this.tags=new tag_manager_1.TagManager(cfn_resource_1.TagType.KEY_VALUE,"aws:cdk:stack",props.tags),!VALID_STACK_NAME_REGEX.test(this.stackName))throw new Error(`Stack name must match the regular expression: ${VALID_STACK_NAME_REGEX.toString()}, got '${this.stackName}'`);const featureFlags=feature_flags_1.FeatureFlags.of(this),stackNameDupeContext=featureFlags.isEnabled(cxapi.ENABLE_STACK_NAME_DUPLICATES_CONTEXT),newStyleSynthesisContext=featureFlags.isEnabled(cxapi.NEW_STYLE_STACK_SYNTHESIS_CONTEXT);this.artifactId=stackNameDupeContext||newStyleSynthesisContext?this.generateStackArtifactId():this.stackName,this.templateFile=`${this.artifactId}.template.json`,this._versionReportingEnabled=(props.analyticsReporting??this.node.tryGetContext(cxapi.ANALYTICS_REPORTING_ENABLED_CONTEXT))&&!this.nestedStackParent,this.synthesizer=props.synthesizer??(newStyleSynthesisContext?new stack_synthesizers_1.DefaultStackSynthesizer:new stack_synthesizers_1.LegacyStackSynthesizer),this.synthesizer.bind(this)}static isStack(x){return x!==null&&typeof x=="object"&&STACK_SYMBOL in x}static of(construct){const cache=construct[MY_STACK_CACHE];if(cache)return cache;{const value=_lookup(construct);return Object.defineProperty(construct,MY_STACK_CACHE,{enumerable:!1,writable:!1,configurable:!1,value}),value}function _lookup(c){if(Stack.isStack(c))return c;const _scope=constructs_1.Node.of(c).scope;if(stage_1.Stage.isStage(c)||!_scope)throw new Error(`${construct.constructor?.name??"Construct"} at '${constructs_1.Node.of(construct).path}' should be created in the scope of a Stack, but no Stack found`);return _lookup(_scope)}}resolve(obj){return resolve_1.resolve(obj,{scope:this,prefix:[],resolver:cloudformation_lang_1.CLOUDFORMATION_TOKEN_RESOLVER,preparing:!1})}toJsonString(obj,space){return cloudformation_lang_1.CloudFormationLang.toJSON(obj,space).toString()}reportMissingContext(report){if(!Object.values(cxschema.ContextProvider).includes(report.provider))throw new Error(`Unknown context provider requested in: ${JSON.stringify(report)}`);this.reportMissingContextKey(report)}reportMissingContextKey(report){try{jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_MissingContext(report)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.reportMissingContextKey),error}this._missingContext.push(report)}renameLogicalId(oldId,newId){this._logicalIds.addRename(oldId,newId)}getLogicalId(element){try{jsiiDeprecationWarnings.aws_cdk_lib_CfnElement(element)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.getLogicalId),error}const logicalId=this.allocateLogicalId(element);return this._logicalIds.applyRename(logicalId)}addDependency(target,reason){try{jsiiDeprecationWarnings.aws_cdk_lib_Stack(target)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addDependency),error}deps_1.addDependency(this,target,reason)}get dependencies(){return Object.values(this._stackDependencies).map(x=>x.stack)}get stackName(){return this._stackName}get partition(){return!feature_flags_1.FeatureFlags.of(this).isEnabled(cxapi.ENABLE_PARTITION_LITERALS)||token_1.Token.isUnresolved(this.region)?cfn_pseudo_1.Aws.PARTITION:region_info_1.RegionInfo.get(this.region).partition??cfn_pseudo_1.Aws.PARTITION}get urlSuffix(){return cfn_pseudo_1.Aws.URL_SUFFIX}get stackId(){return new cfn_pseudo_1.ScopedAws(this).stackId}get notificationArns(){return new cfn_pseudo_1.ScopedAws(this).notificationArns}get nested(){return this.nestedStackResource!==void 0}formatArn(components){try{jsiiDeprecationWarnings.aws_cdk_lib_ArnComponents(components)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.formatArn),error}return arn_1.Arn.format(components,this)}parseArn(arn,sepIfToken="/",hasName=!0){return arn_1.Arn.parse(arn,sepIfToken,hasName)}splitArn(arn,arnFormat){try{jsiiDeprecationWarnings.aws_cdk_lib_ArnFormat(arnFormat)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.splitArn),error}return arn_1.Arn.split(arn,arnFormat)}get availabilityZones(){if(token_1.Token.isUnresolved(this.account)||token_1.Token.isUnresolved(this.region))return this.node.tryGetContext(cxapi.AVAILABILITY_ZONE_FALLBACK_CONTEXT_KEY)||[cfn_fn_1.Fn.select(0,cfn_fn_1.Fn.getAzs()),cfn_fn_1.Fn.select(1,cfn_fn_1.Fn.getAzs())];const value=context_provider_1.ContextProvider.getValue(this,{provider:cxschema.ContextProvider.AVAILABILITY_ZONE_PROVIDER,dummyValue:["dummy1a","dummy1b","dummy1c"]}).value;if(!Array.isArray(value))throw new Error(`Provider ${cxschema.ContextProvider.AVAILABILITY_ZONE_PROVIDER} expects a list`);return value}addFileAsset(asset){return this.synthesizer.addFileAsset(asset)}addDockerImageAsset(asset){return this.synthesizer.addDockerImageAsset(asset)}get nestedStackParent(){return this.nestedStackResource&&Stack.of(this.nestedStackResource)}get parentStack(){return this.nestedStackParent}addTransform(transform){this.templateOptions.transforms||(this.templateOptions.transforms=[]),this.templateOptions.transforms.push(transform)}_addAssemblyDependency(target,reason){if(this.nested||target.nested)throw new Error("Cannot add assembly-level dependencies for nested stacks");reason=reason||"dependency added using stack.addDependency()";const cycle=target.stackDependencyReasons(this);if(cycle!==void 0)throw new Error(`'${target.node.path}' depends on '${this.node.path}' (${cycle.join(", ")}). Adding this dependency (${reason}) would create a cyclic reference.`);let dep=this._stackDependencies[names_1.Names.uniqueId(target)];dep||(dep=this._stackDependencies[names_1.Names.uniqueId(target)]={stack:target,reasons:[]}),dep.reasons.push(reason),process.env.CDK_DEBUG_DEPS&&console.error(`[CDK_DEBUG_DEPS] stack "${this.node.path}" depends on "${target.node.path}" because: ${reason}`)}_synthesizeTemplate(session,lookupRoleArn){const builder=session.assembly,template=this._toCloudFormation(),outPath=path.join(builder.outdir,this.templateFile);if(this.maxResources>0){const resources=template.Resources||{},numberOfResources=Object.keys(resources).length;if(numberOfResources>this.maxResources){const counts=Object.entries(count(Object.values(resources).map(r=>`${r?.Type}`))).map(([type,c])=>`${type} (${c})`).join(", ");throw new Error(`Number of resources in stack '${this.node.path}': ${numberOfResources} is greater than allowed maximum of ${this.maxResources}: ${counts}`)}else numberOfResources>=this.maxResources*.8&&annotations_1.Annotations.of(this).addInfo(`Number of resources: ${numberOfResources} is approaching allowed maximum of ${this.maxResources}`)}fs.writeFileSync(outPath,JSON.stringify(template,void 0,1));for(const ctx of this._missingContext)lookupRoleArn!=null?builder.addMissing({...ctx,props:{...ctx.props,lookupRoleArn}}):builder.addMissing(ctx)}regionalFact(factName,defaultValue){if(!token_1.Token.isUnresolved(this.region)){const ret=region_info_1.Fact.find(this.region,factName)??defaultValue;if(ret===void 0)throw new Error(`region-info: don't know ${factName} for region ${this.region}. Use 'Fact.register' to provide this value.`);return ret}const partitions=constructs_1.Node.of(this).tryGetContext(cxapi.TARGET_PARTITIONS);if(partitions!==void 0&&!Array.isArray(partitions))throw new Error(`Context value '${cxapi.TARGET_PARTITIONS}' should be a list of strings, got: ${JSON.stringify(cxapi.TARGET_PARTITIONS)}`);const lookupMap=partitions?region_info_1.RegionInfo.limitedRegionMap(factName,partitions):region_info_1.RegionInfo.regionMap(factName);return region_lookup_1.deployTimeLookup(this,factName,lookupMap,defaultValue)}exportValue(exportedValue,options={}){try{jsiiDeprecationWarnings.aws_cdk_lib_ExportValueOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.exportValue),error}if(options.name)return new cfn_output_1.CfnOutput(this,`Export${options.name}`,{value:exportedValue,exportName:options.name}),cfn_fn_1.Fn.importValue(options.name);const resolvable=token_1.Tokenization.reverse(exportedValue);if(!resolvable||!reference_1.Reference.isReference(resolvable))throw new Error("exportValue: either supply 'name' or make sure to export a resource attribute (like 'bucket.bucketName')");cfn_element_1.CfnElement.isCfnElement(resolvable.target)&&resolvable.target._lockLogicalId();const exportable=refs_1.referenceNestedStackValueInParent(resolvable,this),exportsScope=getCreateExportsScope(this),resolved=this.resolve(exportable),id="Output"+JSON.stringify(resolved),exportName=generateExportName(exportsScope,id);if(token_1.Token.isUnresolved(exportName))throw new Error(`unresolved token in generated export name: ${JSON.stringify(this.resolve(exportName))}`);return exportsScope.node.tryFindChild(id)||new cfn_output_1.CfnOutput(exportsScope,id,{value:token_1.Token.asString(exportable),exportName}),cfn_fn_1.Fn.importValue(exportName)}allocateLogicalId(cfnElement){try{jsiiDeprecationWarnings.aws_cdk_lib_CfnElement(cfnElement)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.allocateLogicalId),error}const scopes=cfnElement.node.scopes,stackIndex=scopes.indexOf(cfnElement.stack),pathComponents=scopes.slice(stackIndex+1).map(x=>x.node.id);return uniqueid_1.makeUniqueId(pathComponents)}_validateId(name){if(name&&!VALID_STACK_NAME_REGEX.test(name))throw new Error(`Stack name must match the regular expression: ${VALID_STACK_NAME_REGEX.toString()}, got '${name}'`)}_toCloudFormation(){let transform;this.templateOptions.transform&&(annotations_1.Annotations.of(this).addWarning("This stack is using the deprecated `templateOptions.transform` property. Consider switching to `addTransform()`."),this.addTransform(this.templateOptions.transform)),this.templateOptions.transforms&&(this.templateOptions.transforms.length===1?transform=this.templateOptions.transforms[0]:transform=Array.from(new Set(this.templateOptions.transforms)));const template={Description:this.templateOptions.description,Transform:transform,AWSTemplateFormatVersion:this.templateOptions.templateFormatVersion,Metadata:this.templateOptions.metadata},fragments=cfnElements(this).map(e=>this.resolve(e._toCloudFormation()));for(const fragment of fragments)merge(template,fragment);const ret=this.resolve(template)||{};return this._logicalIds.assertAllRenamesApplied(),ret}prepareCrossReference(_sourceStack,reference){return reference}parseEnvironment(env={}){const containingAssembly=stage_1.Stage.of(this),account=env.account??containingAssembly?.account??cfn_pseudo_1.Aws.ACCOUNT_ID,region=env.region??containingAssembly?.region??cfn_pseudo_1.Aws.REGION,envAccount=token_1.Token.isUnresolved(account)?cxapi.UNKNOWN_ACCOUNT:account,envRegion=token_1.Token.isUnresolved(region)?cxapi.UNKNOWN_REGION:region;return{account,region,environment:cxapi.EnvironmentUtils.format(envAccount,envRegion)}}get maxResources(){const contextLimit=this.node.tryGetContext(exports.STACK_RESOURCE_LIMIT_CONTEXT);return contextLimit!==void 0?parseInt(contextLimit,10):MAX_RESOURCES}stackDependencyReasons(other){if(this===other)return[];for(const dep of Object.values(this._stackDependencies)){const ret=dep.stack.stackDependencyReasons(other);if(ret!==void 0)return[...dep.reasons,...ret]}}generateStackName(){const assembly=stage_1.Stage.of(this);return`${assembly&&assembly.stageName?`${assembly.stageName}-`:""}${this.generateStackId(assembly)}`}generateStackArtifactId(){return this.generateStackId(this.node.root)}generateStackId(container){const ids=rootPathTo(this,container).map(c=>constructs_1.Node.of(c).id);if(ids.length===1&&!ids[0])throw new Error("unexpected: stack id must always be defined");return makeStackName(ids)}get bundlingRequired(){return(this.node.tryGetContext(cxapi.BUNDLING_STACKS)??["*"]).some(pattern=>minimatch(this.stackName,pattern.replace("/","-")))}}exports.Stack=Stack,_a=JSII_RTTI_SYMBOL_1,Stack[_a]={fqn:"aws-cdk-lib.Stack",version:"2.42.0"};function merge(template,fragment){for(const section of Object.keys(fragment)){const src=fragment[section],dest=template[section];dest?template[section]=mergeSection(section,dest,src):template[section]=src}}function mergeSection(section,val1,val2){switch(section){case"Description":return`${val1}
${val2}`;case"AWSTemplateFormatVersion":if(val1!=null&&val2!=null&&val1!==val2)throw new Error(`Conflicting CloudFormation template versions provided: '${val1}' and '${val2}`);return val1??val2;case"Transform":return mergeSets(val1,val2);default:return mergeObjectsWithoutDuplicates(section,val1,val2)}}function mergeSets(val1,val2){const array1=val1==null?[]:Array.isArray(val1)?val1:[val1],array2=val2==null?[]:Array.isArray(val2)?val2:[val2];for(const value of array2)array1.includes(value)||array1.push(value);return array1.length===1?array1[0]:array1}function mergeObjectsWithoutDuplicates(section,dest,src){if(typeof dest!="object")throw new Error(`Expecting ${JSON.stringify(dest)} to be an object`);if(typeof src!="object")throw new Error(`Expecting ${JSON.stringify(src)} to be an object`);for(const id of Object.keys(src)){if(id in dest)throw new Error(`section '${section}' already contains '${id}'`);dest[id]=src[id]}return dest}function cfnElements(node,into=[]){cfn_element_1.CfnElement.isCfnElement(node)&&into.push(node);for(const child of constructs_1.Node.of(node).children)Stack.isStack(child)||cfnElements(child,into);return into}function rootPathTo(construct,ancestor){const scopes=constructs_1.Node.of(construct).scopes;for(let i=scopes.length-2;i>=0;i--)if(scopes[i]===ancestor)return scopes.slice(i+1);return scopes}exports.rootPathTo=rootPathTo;function makeStackName(components){return components.length===1?components[0]:unique_resource_name_1.makeUniqueResourceName(components,{maxLength:128})}function getCreateExportsScope(stack){const exportsName="Exports";let stackExports=stack.node.tryFindChild(exportsName);return stackExports===void 0&&(stackExports=new constructs_1.Construct(stack,exportsName)),stackExports}function generateExportName(stackExports,id){const stackRelativeExports=feature_flags_1.FeatureFlags.of(stackExports).isEnabled(cxapi.STACK_RELATIVE_EXPORTS_CONTEXT),stack=Stack.of(stackExports),components=[...stackExports.node.scopes.slice(stackRelativeExports?stack.node.scopes.length:2).map(c=>c.node.id),id],prefix=stack.stackName?stack.stackName+":":"",localPart=uniqueid_1.makeUniqueId(components),maxLength=255;return prefix+localPart.slice(Math.max(0,localPart.length-maxLength+prefix.length))}function count(xs){const ret={};for(const x of xs)x in ret?ret[x]+=1:ret[x]=1;return ret}const cfn_output_1=require("./cfn-output"),deps_1=require("./deps"),fs_1=require("./fs"),names_1=require("./names"),reference_1=require("./reference"),stack_synthesizers_1=require("./stack-synthesizers"),stage_1=require("./stage"),tag_manager_1=require("./tag-manager"),token_1=require("./token"),refs_1=require("./private/refs"),region_info_1=require("../../region-info"),region_lookup_1=require("./private/region-lookup"),unique_resource_name_1=require("./private/unique-resource-name");
//# sourceMappingURL=stack.js.map
