"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.CloudFormationStackArtifact=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),fs=require("fs"),path=require("path"),cxschema=require("../../../cloud-assembly-schema"),cloud_artifact_1=require("../cloud-artifact"),environment_1=require("../environment");class CloudFormationStackArtifact extends cloud_artifact_1.CloudArtifact{constructor(assembly,artifactId,artifact){super(assembly,artifactId,artifact);try{jsiiDeprecationWarnings.aws_cdk_lib_cx_api_CloudAssembly(assembly),jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_ArtifactManifest(artifact)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CloudFormationStackArtifact),error}const properties=this.manifest.properties||{};if(!properties.templateFile)throw new Error('Invalid CloudFormation stack artifact. Missing "templateFile" property in cloud assembly manifest');if(!artifact.environment)throw new Error("Invalid CloudFormation stack artifact. Missing environment");this.environment=environment_1.EnvironmentUtils.parse(artifact.environment),this.templateFile=properties.templateFile,this.parameters=properties.parameters??{},this.tags=properties.tags??this.tagsFromMetadata(),this.assumeRoleArn=properties.assumeRoleArn,this.assumeRoleExternalId=properties.assumeRoleExternalId,this.cloudFormationExecutionRoleArn=properties.cloudFormationExecutionRoleArn,this.stackTemplateAssetObjectUrl=properties.stackTemplateAssetObjectUrl,this.requiresBootstrapStackVersion=properties.requiresBootstrapStackVersion,this.bootstrapStackVersionSsmParameter=properties.bootstrapStackVersionSsmParameter,this.terminationProtection=properties.terminationProtection,this.validateOnSynth=properties.validateOnSynth,this.lookupRole=properties.lookupRole,this.stackName=properties.stackName||artifactId,this.assets=this.findMetadataByType(cxschema.ArtifactMetadataEntryType.ASSET).map(e=>e.data),this.displayName=this.stackName===artifactId?this.hierarchicalId:`${this.hierarchicalId} (${this.stackName})`,this.name=this.stackName,this.originalName=this.stackName}get templateFullPath(){return path.join(this.assembly.directory,this.templateFile)}get template(){return this._template===void 0&&(this._template=JSON.parse(fs.readFileSync(this.templateFullPath,"utf-8"))),this._template}tagsFromMetadata(){const ret={};for(const metadataEntry of this.findMetadataByType(cxschema.ArtifactMetadataEntryType.STACK_TAGS))for(const tag of metadataEntry.data??[])ret[tag.key]=tag.value;return ret}}exports.CloudFormationStackArtifact=CloudFormationStackArtifact,_a=JSII_RTTI_SYMBOL_1,CloudFormationStackArtifact[_a]={fqn:"aws-cdk-lib.cx_api.CloudFormationStackArtifact",version:"2.42.0"};
//# sourceMappingURL=cloudformation-artifact.js.map
