"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.StackDeployment=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),path=require("path"),url_1=require("url"),cxapi=require("../../../cx-api"),asset_manifest_1=require("../private/asset-manifest"),cloud_assembly_internals_1=require("../private/cloud-assembly-internals"),asset_type_1=require("./asset-type");class StackDeployment{constructor(props){this.stackDependencies=[],this.pre=[],this.changeSet=[],this.post=[],this.stackArtifactId=props.stackArtifactId,this.constructPath=props.constructPath,this.account=props.account,this.region=props.region,this.tags=props.tags??{},this.assumeRoleArn=props.assumeRoleArn,this.executionRoleArn=props.executionRoleArn,this.stackName=props.stackName,this.absoluteTemplatePath=props.absoluteTemplatePath,this.templateUrl=props.templateS3Uri?s3UrlFromUri(props.templateS3Uri,props.region):void 0,this.assets=new Array;for(const asset of props.assets??[])asset.isTemplate?this.templateAsset=asset:this.assets.push(asset)}static fromArtifact(stackArtifact){try{jsiiDeprecationWarnings.aws_cdk_lib_cx_api_CloudFormationStackArtifact(stackArtifact)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromArtifact),error}const artRegion=stackArtifact.environment.region,region=artRegion===cxapi.UNKNOWN_REGION?void 0:artRegion,artAccount=stackArtifact.environment.account,account=artAccount===cxapi.UNKNOWN_ACCOUNT?void 0:artAccount;return new StackDeployment({account,region,tags:stackArtifact.tags,stackArtifactId:stackArtifact.id,constructPath:stackArtifact.hierarchicalId,stackName:stackArtifact.stackName,absoluteTemplatePath:path.join(stackArtifact.assembly.directory,stackArtifact.templateFile),assumeRoleArn:stackArtifact.assumeRoleArn,executionRoleArn:stackArtifact.cloudFormationExecutionRoleArn,assets:extractStackAssets(stackArtifact),templateS3Uri:stackArtifact.stackTemplateAssetObjectUrl})}addStackDependency(stackDeployment){try{jsiiDeprecationWarnings.aws_cdk_lib_pipelines_StackDeployment(stackDeployment)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addStackDependency),error}this.stackDependencies.push(stackDeployment)}addStackSteps(pre,changeSet,post){this.pre.push(...pre),this.changeSet.push(...changeSet),this.post.push(...post)}}exports.StackDeployment=StackDeployment,_a=JSII_RTTI_SYMBOL_1,StackDeployment[_a]={fqn:"aws-cdk-lib.pipelines.StackDeployment",version:"2.42.0"};function extractStackAssets(stackArtifact){const ret=new Array,assetManifests=stackArtifact.dependencies.filter(cloud_assembly_internals_1.isAssetManifest);for(const manifestArtifact of assetManifests){const manifest=asset_manifest_1.AssetManifestReader.fromFile(manifestArtifact.file);for(const entry of manifest.entries){let assetType,isTemplate=!1;if(entry instanceof asset_manifest_1.DockerImageManifestEntry)assetType=asset_type_1.AssetType.DOCKER_IMAGE;else if(entry instanceof asset_manifest_1.FileManifestEntry)isTemplate=entry.source.packaging==="file"&&entry.source.path===stackArtifact.templateFile,assetType=asset_type_1.AssetType.FILE;else throw new Error(`Unrecognized asset type: ${entry.type}`);ret.push({assetManifestPath:manifestArtifact.file,assetId:entry.id.assetId,assetSelector:entry.id.toString(),assetType,assetPublishingRoleArn:entry.destination.assumeRoleArn,isTemplate})}}return ret}function s3UrlFromUri(uri,region){const url=url_1.parse(uri);return`https://${url.hostname}.s3.${region?`${region}.`:""}amazonaws.com${url.path}`}
//# sourceMappingURL=stack-deployment.js.map
