"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.isGraph=exports.GraphNodeCollection=exports.Graph=exports.DependencyBuilders=exports.DependencyBuilder=exports.GraphNode=void 0;const javascript_1=require("../private/javascript"),toposort_1=require("./toposort");class GraphNode{constructor(id,props={}){this.id=id,this.dependencies=[],this.data=props.data}static of(id,data){return new GraphNode(id,{data})}get uniqueId(){return this.ancestorPath(this.root).map(x=>x.id).join("-")}get allDeps(){const fromParent=this.parentGraph?.allDeps??[];return Array.from(new Set([...this.dependencies,...fromParent]))}dependOn(...dependencies){if(dependencies.includes(this))throw new Error(`Cannot add dependency on self: ${this}`);this.dependencies.push(...dependencies.filter(javascript_1.isDefined))}ancestorPath(upTo){let x=this;const ret=[x];for(;x.parentGraph&&x.parentGraph!==upTo;)x=x.parentGraph,ret.unshift(x);return ret}rootPath(){let x=this;const ret=[x];for(;x.parentGraph;)x=x.parentGraph,ret.unshift(x);return ret}get root(){let x=this;for(;x.parentGraph;)x=x.parentGraph;return x}get parentGraph(){return this._parentGraph}_setParentGraph(parentGraph){if(this._parentGraph)throw new Error("Node already has a parent");this._parentGraph=parentGraph}toString(){return`${this.constructor.name}(${this.id})`}}exports.GraphNode=GraphNode;class DependencyBuilder{constructor(){this.targets=[],this.sources=[]}dependOn(...targets){for(const target of targets){for(const source of this.sources)source.dependOn(target);this.targets.push(target)}return this}dependBy(...sources){for(const source of sources){for(const target of this.targets)source.dependOn(target);this.sources.push(source)}return this}}exports.DependencyBuilder=DependencyBuilder;class DependencyBuilders{constructor(){this.builders=new Map}get(key){const b=this.builders.get(key);if(b)return b;const ret=new DependencyBuilder;return this.builders.set(key,ret),ret}}exports.DependencyBuilders=DependencyBuilders;class Graph extends GraphNode{constructor(name,props={}){super(name,props),this.children=new Map,props.nodes&&this.add(...props.nodes)}static of(id,data,nodes){return new Graph(id,{data,nodes})}get nodes(){return new Set(this.children.values())}tryGetChild(name){return this.children.get(name)}contains(node){return this.nodes.has(node)}add(...nodes){for(const node of nodes){if(node._setParentGraph(this),this.children.has(node.id))throw new Error(`Node with duplicate id: ${node.id}`);this.children.set(node.id,node)}}absorb(other){this.add(...other.nodes)}sortedChildren(){const nodes=this.nodes,projectedDependencies=projectDependencies(this.deepDependencies(),node=>{for(;!nodes.has(node)&&node.parentGraph;)node=node.parentGraph;return nodes.has(node)?[node]:[]});return toposort_1.topoSort(nodes,projectedDependencies)}sortedLeaves(){const descendantsMap=new Map;findDescendants(this);function findDescendants(node){const ret=[];if(node instanceof Graph)for(const child of node.nodes)ret.push(...findDescendants(child));else ret.push(node);return descendantsMap.set(node,ret),ret}const projectedDependencies=projectDependencies(this.deepDependencies(),node=>descendantsMap.get(node)??[]);return toposort_1.topoSort(new Set(projectedDependencies.keys()),projectedDependencies)}consoleLog(indent=0){process.stdout.write(" ".repeat(indent)+this+depString(this)+`
`);for(const node of this.nodes)node instanceof Graph?node.consoleLog(indent+2):process.stdout.write(" ".repeat(indent+2)+node+depString(node)+`
`);function depString(node){return node.dependencies.length>0?` -> ${Array.from(node.dependencies).join(", ")}`:""}}deepDependencies(){const ret=new Map;for(const node of this.nodes)recurse(node);return ret;function recurse(node){let deps=ret.get(node);deps||ret.set(node,deps=new Set);for(let dep of node.dependencies)deps.add(dep);if(node instanceof Graph)for(const child of node.nodes)recurse(child)}}allLeaves(){const ret=[];return recurse(this),new GraphNodeCollection(ret);function recurse(node){if(node instanceof Graph)for(const child of node.nodes)recurse(child);else ret.push(node)}}}exports.Graph=Graph;class GraphNodeCollection{constructor(nodes){this.nodes=Array.from(nodes)}dependOn(...dependencies){for(const node of this.nodes)node.dependOn(...dependencies.filter(javascript_1.isDefined))}commonAncestor(){const paths=new Array;for(const x of this.nodes)paths.push(x.rootPath());if(paths.length===0)throw new Error("Cannot find common ancestor between an empty set of nodes");if(paths.length===1){const path=paths[0];if(path.length<2)throw new Error(`Cannot find ancestor of node without ancestor: ${path[0]}`);return path[path.length-2]}const originalPaths=[...paths];for(;paths.every(path=>paths[0].length>=2&&path.length>=2&&path[1]===paths[0][1]);)for(const path of paths)path.shift();if(paths.some(path=>path.length<2))throw new Error(`Could not determine a shared parent between nodes: ${originalPaths.map(nodes=>nodes.map(n=>n.id).join("/"))}`);return paths[0][0]}}exports.GraphNodeCollection=GraphNodeCollection;function projectDependencies(dependencies,project){for(const node of dependencies.keys()){const projectedNodes=project(node);if(projectedNodes.length===1&&projectedNodes[0]===node)continue;const deps=javascript_1.extract(dependencies,node);for(const projectedNode of projectedNodes)javascript_1.addAll(dependencies.get(projectedNode),deps)}for(const[node,deps]of dependencies.entries()){const depset=new Set(javascript_1.flatMap(deps,project));depset.delete(node),dependencies.set(node,depset)}return dependencies}function isGraph(x){return x instanceof Graph}exports.isGraph=isGraph;
//# sourceMappingURL=graph.js.map
