"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.topoSort=exports.printDependencyMap=void 0;function printDependencyMap(dependencies){const lines=["---"];for(const[k,vs]of dependencies.entries())lines.push(`${k} -> ${Array.from(vs)}`);console.log(lines.join(`
`))}exports.printDependencyMap=printDependencyMap;function topoSort(nodes,dependencies){const remaining=new Set(nodes),ret=[];for(;remaining.size>0;){const selectable=Array.from(remaining.values()).filter(e=>{if(!dependencies.has(e))throw new Error(`No key for ${e}`);return dependencies.get(e).size===0});if(selectable.sort((a,b)=>a.id<b.id?-1:b.id<a.id?1:0),selectable.length===0){const cycle=findCycle(dependencies);throw new Error(`Dependency cycle in graph: ${cycle.map(n=>n.id).join(" => ")}`)}ret.push(selectable);for(const selected of selectable){remaining.delete(selected);for(const depSet of dependencies.values())depSet.delete(selected)}}return ret}exports.topoSort=topoSort;function findCycle(deps){for(const node of deps.keys()){const cycle=recurse(node,[node]);if(cycle)return cycle}throw new Error("No cycle found. Assertion failure!");function recurse(node,path){for(const dep of deps.get(node)??[]){if(dep===path[0])return[...path,dep];const cycle=recurse(dep,[...path,dep]);if(cycle)return cycle}}}
//# sourceMappingURL=toposort.js.map
