"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.ShellScriptAction=void 0;const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),codebuild=require("../../../../aws-codebuild"),codepipeline=require("../../../../aws-codepipeline"),codepipeline_actions=require("../../../../aws-codepipeline-actions");class ShellScriptAction{constructor(props){if(this.props=props,this._actionProperties={actionName:props.actionName,category:codepipeline.ActionCategory.BUILD,provider:"CodeBuild",artifactBounds:{minInputs:0,maxInputs:5,minOutputs:0,maxOutputs:5},inputs:[],outputs:[]},Object.keys(props.useOutputs??{}).length+(props.additionalArtifacts??[]).length===0)throw new Error("You must supply either 'useOutputs' or 'additionalArtifacts', since a CodeBuild Action must always have at least one input artifact.")}get grantPrincipal(){return this.project.grantPrincipal}get actionProperties(){return this._actionProperties}bind(scope,stage,options){const inputs=new Array;inputs.push(...this.props.additionalArtifacts??[]);const envVarCommands=new Array,bashOptions=this.props.bashOptions??"-eu";bashOptions&&envVarCommands.push(`set ${bashOptions}`);for(const[varName,output]of Object.entries(this.props.useOutputs??{})){const outputArtifact=output.artifactFile;let artifactIndex=inputs.findIndex(a=>a.artifactName===outputArtifact.artifact.artifactName);artifactIndex===-1&&(artifactIndex=inputs.push(outputArtifact.artifact)-1);const dirEnv=artifactIndex===0?"CODEBUILD_SRC_DIR":`CODEBUILD_SRC_DIR_${outputArtifact.artifact.artifactName}`;envVarCommands.push(`export ${varName}="$(node -pe 'require(process.env.${dirEnv} + "/${outputArtifact.fileName}")["${output.outputName}"]')"`)}this._project=new codebuild.PipelineProject(scope,"Project",{environment:this.props.environment||{buildImage:codebuild.LinuxBuildImage.STANDARD_5_0},vpc:this.props.vpc,securityGroups:this.props.securityGroups,subnetSelection:this.props.subnetSelection,buildSpec:codebuild.BuildSpec.fromObject({version:"0.2",phases:{build:{commands:[...envVarCommands,...this.props.commands]}}})});for(const statement of this.props.rolePolicyStatements??[])this._project.addToRolePolicy(statement);return this._action=new codepipeline_actions.CodeBuildAction({actionName:this.props.actionName,input:inputs[0],extraInputs:inputs.slice(1),runOrder:this.props.runOrder??100,project:this._project,environmentVariables:this.props.environmentVariables}),this._actionProperties=this._action.actionProperties,this._action.bind(scope,stage,options)}get project(){if(!this._project)throw new Error("Project becomes available after ShellScriptAction has been bound to a stage");return this._project}onStateChange(name,target,options){if(!this._action)throw new Error("Need bind() first");return this._action.onStateChange(name,target,options)}}exports.ShellScriptAction=ShellScriptAction,_a=JSII_RTTI_SYMBOL_1,ShellScriptAction[_a]={fqn:"aws-cdk-lib.pipelines.ShellScriptAction",version:"2.42.0"};
//# sourceMappingURL=shell-script-action.js.map
