"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.ApplicationSecurityCheck=void 0;const path=require("path"),codebuild=require("../../../aws-codebuild"),iam=require("../../../aws-iam"),lambda=require("../../../aws-lambda"),core_1=require("../../../core"),constructs_1=require("constructs");class ApplicationSecurityCheck extends constructs_1.Construct{constructor(scope,id,props){super(scope,id),core_1.Tags.of(props.codePipeline).add("SECURITY_CHECK","ALLOW_APPROVE",{includeResourceTypes:["AWS::CodePipeline::Pipeline"]}),this.preApproveLambda=new lambda.Function(this,"CDKPipelinesAutoApprove",{handler:"index.handler",runtime:lambda.Runtime.NODEJS_14_X,code:lambda.Code.fromAsset(path.resolve(__dirname,"approve-lambda")),timeout:core_1.Duration.minutes(5)}),this.preApproveLambda.addToRolePolicy(new iam.PolicyStatement({actions:["codepipeline:GetPipelineState","codepipeline:PutApprovalResult"],conditions:{StringEquals:{"aws:ResourceTag/SECURITY_CHECK":"ALLOW_APPROVE"}},resources:["*"]}));const invokeLambda=`aws lambda invoke --function-name ${this.preApproveLambda.functionName} --invocation-type Event --cli-binary-format raw-in-base64-out --payload "$payload" lambda.out`,publishNotification=`aws sns publish --topic-arn $NOTIFICATION_ARN --subject "$NOTIFICATION_SUBJECT" --message "${["An upcoming change would broaden security changes in $PIPELINE_NAME.","Review and approve the changes in CodePipeline to proceed with the deployment.","","Review the changes in CodeBuild:","","$LINK","","Approve the changes in CodePipeline (stage $STAGE_NAME, action $ACTION_NAME):","","$PIPELINE_LINK"].join(`
`)}"`;this.cdkDiffProject=new codebuild.Project(this,"CDKSecurityCheck",{environment:{buildImage:codebuild.LinuxBuildImage.STANDARD_5_0},buildSpec:codebuild.BuildSpec.fromObject({version:.2,phases:{build:{commands:["npm install -g aws-cdk",'export PIPELINE_NAME="$(node -pe \'`${process.env.CODEBUILD_INITIATOR}`.split("/")[1]\')"',`payload="$(node -pe 'JSON.stringify({ "PipelineName": process.env.PIPELINE_NAME, "StageName": process.env.STAGE_NAME, "ActionName": process.env.ACTION_NAME })' )"`,"ARN=$CODEBUILD_BUILD_ARN",'REGION="$(node -pe \'`${process.env.ARN}`.split(":")[3]\')"','ACCOUNT_ID="$(node -pe \'`${process.env.ARN}`.split(":")[4]\')"','PROJECT_NAME="$(node -pe \'`${process.env.ARN}`.split(":")[5].split("/")[1]\')"','PROJECT_ID="$(node -pe \'`${process.env.ARN}`.split(":")[6]\')"','export LINK="https://$REGION.console.aws.amazon.com/codesuite/codebuild/$ACCOUNT_ID/projects/$PROJECT_NAME/build/$PROJECT_NAME:$PROJECT_ID/?region=$REGION"','export PIPELINE_LINK="https://$REGION.console.aws.amazon.com/codesuite/codepipeline/pipelines/$PIPELINE_NAME/view?region=$REGION"',ifElse({condition:"cdk diff -a . --security-only --fail $STAGE_PATH/\\*",thenStatements:[invokeLambda,'export MESSAGE="No security-impacting changes detected."'],elseStatements:[`[ -z "\${NOTIFICATION_ARN}" ] || ${publishNotification}`,'export MESSAGE="Deployment would make security-impacting changes. Click the link below to inspect them, then click Approve if all changes are expected."']})]}},env:{"exported-variables":["LINK","MESSAGE"]}})}),this.cdkDiffProject.addToRolePolicy(new iam.PolicyStatement({actions:["sts:AssumeRole"],resources:["*"],conditions:{"ForAnyValue:StringEquals":{"iam:ResourceTag/aws-cdk:bootstrap-role":["deploy"]}}})),this.preApproveLambda.grantInvoke(this.cdkDiffProject)}}exports.ApplicationSecurityCheck=ApplicationSecurityCheck;const ifElse=({condition,thenStatements,elseStatements})=>{let statement=thenStatements.reduce((acc,ifTrue)=>`${acc} ${ifTrue};`,`if ${condition}; then`);return elseStatements&&(statement=elseStatements.reduce((acc,ifFalse)=>`${acc} ${ifFalse};`,`${statement} else`)),`${statement} fi`};
//# sourceMappingURL=application-security-check.js.map
