"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.STANDARD_COMPILER_OPTIONS=exports.withTemporaryDirectory=void 0;const os=require("os"),path=require("path"),fs=require("fs-extra"),ts=require("typescript");async function main(){await withTemporaryDirectory(async tmpDir=>{await fs.mkdirp(path.join(tmpDir,"node_modules")),await fs.symlink(path.resolve(__dirname,".."),path.join(tmpDir,"node_modules","aws-cdk-lib"));const import1='import { aws_ec2 } from "aws-cdk-lib";',import2='import * as aws_ec2 from "aws-cdk-lib/aws-ec2";',src1=await compileAndResolve(path.join(tmpDir,"program1.ts"),import1,"aws_ec2"),src2=await compileAndResolve(path.join(tmpDir,"program2.ts"),import2,"aws_ec2");src1!==src2&&(console.error("Import mismatch!"),console.error(`
    `,import1,`
`),console.error("resolves to",src1),console.error(`
    `,import2,`
`),console.error("resolves to",src2),process.exitCode=1)})}async function compileAndResolve(fileName,contents,symbolName){await fs.writeFile(fileName,contents+`

console.log(${symbolName});`,{encoding:"utf-8"});const program=ts.createProgram({rootNames:[fileName],options:exports.STANDARD_COMPILER_OPTIONS}),sourceFile=program.getSourceFile(fileName);if(!sourceFile)throw new Error(`Could not find sourcefile back: ${fileName}`);const diags=[...program.getGlobalDiagnostics(),...program.getDeclarationDiagnostics(sourceFile),...program.getSyntacticDiagnostics(sourceFile),...program.getSemanticDiagnostics(sourceFile)];if(diags.length>0)throw console.error(ts.formatDiagnostics(diags,{getNewLine:()=>`
`,getCurrentDirectory:()=>path.dirname(fileName),getCanonicalFileName:f=>path.resolve(f)})),new Error("Compilation failed");const logStmt=assertNode(sourceFile.statements[1],ts.isExpressionStatement),logCall=assertNode(logStmt.expression,ts.isCallExpression),ident=assertNode(logCall.arguments[0],ts.isIdentifier);let sym=program.getTypeChecker().getSymbolAtLocation(ident);for(;sym&&(sym.flags&ts.SymbolFlags.Alias)!==0;)sym=program.getTypeChecker().getAliasedSymbol(sym);if(!sym)throw new Error(`Could not resolve: ${symbolName} in '${contents}'`);const srcFile=sym.declarations?.[0].getSourceFile().fileName.replace(/[.](ts|js|d\.ts)$/,"");if(!srcFile)throw console.log(sym),new Error(`Symbol ${symbolName} in '${contents}' does not resolve to a source location`);return srcFile}async function withTemporaryDirectory(callback){const tmpdir=await fs.mkdtemp(path.join(os.tmpdir(),path.basename(__filename)));try{return await callback(tmpdir)}finally{await fs.remove(tmpdir)}}exports.withTemporaryDirectory=withTemporaryDirectory;function assertNode(x,assert){if(!assert(x))throw new Error(`Not the right type of node, expecting ${assert.name}, got ${ts.SyntaxKind[x.kind]}`);return x}exports.STANDARD_COMPILER_OPTIONS={alwaysStrict:!0,charset:"utf8",declaration:!0,experimentalDecorators:!0,inlineSourceMap:!0,inlineSources:!0,lib:["lib.es2016.d.ts","lib.es2017.object.d.ts","lib.es2017.string.d.ts"],module:ts.ModuleKind.CommonJS,noEmitOnError:!0,noFallthroughCasesInSwitch:!0,noImplicitAny:!0,noImplicitReturns:!0,noImplicitThis:!0,noUnusedLocals:!1,noUnusedParameters:!1,resolveJsonModule:!0,strict:!0,strictNullChecks:!0,strictPropertyInitialization:!0,stripInternal:!0,target:ts.ScriptTarget.ES2019,incremental:!0,tsBuildInfoFile:".tsbuildinfo"},main().catch(e=>{console.error(e),process.exitCode=1});
//# sourceMappingURL=verify-imports-resolve-same.js.map
