"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const child_process_1=require("child_process"),console=require("console"),os=require("os"),path=require("path"),fs=require("fs-extra");async function main(tempDir2){console.log("\u{1F9D0} Verifying all experimental modules includes only L1s files...");const cwd=process.cwd(),awsCdkModulesRepoPath=path.join(findWorkspacePath(),"packages","@aws-cdk"),version=require("./../package.json").version,tarFullPath=path.join(cwd,"dist","js",`aws-cdk-lib@${version}.jsii.tgz`),invalidCfnModules=new Map,invalidModules=new Array;console.log(`installing aws-cdk-lib from dist/js into ${tempDir2}`),exec("npm",["install","--prefix",tempDir2,tarFullPath]);const installedAwsCdkLibPath=path.join(tempDir2,"node_modules","aws-cdk-lib","lib");for(const module2 of fs.readdirSync(awsCdkModulesRepoPath)){const pkgJson=require(path.join(awsCdkModulesRepoPath,module2,"package.json"));if(pkgJson.stability==="experimental")if(pkgJson["cdk-build"]?.cloudformation){const files=await listAllFiles(path.join(installedAwsCdkLibPath,module2)),invalidFiles=new Array;files.forEach(file=>{isAllowedFile(file)||invalidFiles.push(file)}),invalidFiles.length>0&&invalidCfnModules.set(module2,invalidFiles)}else fs.existsSync(path.join(installedAwsCdkLibPath,module2))&&invalidModules.push(module2)}if(invalidCfnModules.size>0||invalidModules.length>0){if(invalidCfnModules.size>0){console.log("cfn module with invalid files:");for(let[module2,files]of invalidCfnModules.entries())console.log(`${module2}:`),files.forEach(file=>console.log(`	 ${file}`))}throw console.log("---------------------------------------------"),invalidModules.length>0&&(console.log("non-cfn experimental modules:"),invalidModules.forEach(m=>console.log(`	 ${m}`))),new Error("Verification Error")}}const tempDir=fs.mkdtempSync(os.tmpdir());main(tempDir).then(()=>{fs.removeSync(tempDir),console.log("\u2705 All experimental modules includes only L1s files!"),process.exit(0)},err=>{process.stderr.write(`${err}
`),process.stderr.write(`\u274C Verification failed, Some experimental modules includes non L1 files, see details above. Inspect working directory: '${tempDir}'`),process.exit(1)});function exec(cmd,args){const proc=child_process_1.spawnSync(cmd,args);if(proc.error)throw proc.error;if(proc.status!==0)throw proc.stdout||proc.stderr?new Error(`${cmd} exited with status ${proc.status}; stdout: ${proc.stdout?.toString().trim()}


stderr: ${proc.stderr?.toString().trim()}`):new Error(`${cmd} exited with status ${proc.status}`);return proc}const GENERATED_SUFFIX_REGEX=new RegExp(/generated\.(js|d\.ts)$/),ALLOWED_FILES=[".jsiirc.json","index.ts","index.js","index.d.ts"];async function listAllFiles(dir){const ret=new Array;async function recurse(part){const files=await fs.readdir(part);for(const file of files){const fullPath=path.join(part,file);(await fs.stat(fullPath)).isDirectory()?await recurse(fullPath):ret.push(file)}}return await recurse(dir),ret}function findWorkspacePath(){return _findRootPath(process.cwd());function _findRootPath(part){if(part===path.resolve(part,".."))throw new Error("couldn't find a 'lerna.json' file when walking up the directory tree, are you in a aws-cdk project?");return fs.existsSync(path.resolve(part,"lerna.json"))?part:_findRootPath(path.resolve(part,".."))}}function isAllowedFile(file){return GENERATED_SUFFIX_REGEX.test(file)?!0:ALLOWED_FILES.includes(file)}
//# sourceMappingURL=verify-stripped-exp.js.map
