Signald python bindings
=======================


[![pypi](https://badge.fury.io/py/aiosignald.svg)](https://pypi.org/project/aiosignald/)
[![Documentation Status](https://readthedocs.org/projects/aiosignald/badge/?version=latest)](https://aiosignald.readthedocs.io/en/latest/)
[![builds.sr.ht status](https://builds.sr.ht/~nicoco/aiosignald/commits/master/.build.yml.svg)](https://builds.sr.ht/~nicoco/aiosignald/commits/master/.build.yml?)

Interact with the signal messaging network in python with sweet, sweet autocompletion.

Most of the code is generated by the `generate.py` script that
uses the schema available at <https://signald.org/protocol.json>.

No 3rd party dep, just the python standard lib.

Install
-------

`pip install aiosignald`

Have signald running. See [their
docs](https://signald.org/articles/install/) about it.

Issue tracker: https://todo.sr.ht/~nicoco/aiosignald

Part of the [slidge project](https://sr.ht/~nicoco/slidge) (but can be used independently)

Usage
-----

### Example: registration

```py
import asyncio

from aiosignald import SignaldAPI
import aiosignald.generated as api

class SignalClient(SignaldAPI):
    async def handle_IncomingMessage(self, msg: api.IncomingMessagev1, _payload):
        # hook to the incoming event by naming you function handle_EventName
        # most stuff comes through an IncomingMessage anyway
        print("Received: ", msg)

async def main():
    loop = asyncio.get_running_loop()
    _, signald = await loop.create_unix_connection(
        SignaldAPI, path=SIGNALD_SOCKET_PATH)
    await signald.register(account="+XXXXXX")
    # Some async code to get the SMS code
    code = await user_input("Enter your sms code?")
    await signald.verify(account="+XXXXXX", code=code)
    # linking to an existing account is also possible
    # uri = await signald.generate_linking_uri()
    await signald.on_con_lost

# See https://signald.org/articles/protocol/ for more info about this
SIGNALD_SOCKET_PATH = "/var/run/signald/signald.sock"

asyncio.run(main())
```

Docs are available on [readthedocs](https://aiosignald.readthedocs.org).
