# galv
A standard API for accessing battery experiment datasets and metadata

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.1.20
- Package version: 2.1.20
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python &gt;&#x3D;3.7

## Migration from other generators like python and python-legacy

### Changes
1. This generator uses spec case for all (object) property names and parameter names.
    - So if the spec has a property name like camelCase, it will use camelCase rather than camel_case
    - So you will need to update how you input and read properties to use spec case
2. Endpoint parameters are stored in dictionaries to prevent collisions (explanation below)
    - So you will need to update how you pass data in to endpoints
3. Endpoint responses now include the original response, the deserialized response body, and (todo)the deserialized headers
    - So you will need to update your code to use response.body to access deserialized data
4. All validated data is instantiated in an instance that subclasses all validated Schema classes and Decimal/str/list/tuple/frozendict/NoneClass/BoolClass/bytes/io.FileIO
    - This means that you can use isinstance to check if a payload validated against a schema class
    - This means that no data will be of type None/True/False
        - ingested None will subclass NoneClass
        - ingested True will subclass BoolClass
        - ingested False will subclass BoolClass
        - So if you need to check is True/False/None, instead use instance.is_true_oapg()/.is_false_oapg()/.is_none_oapg()
5. All validated class instances are immutable except for ones based on io.File
    - This is because if properties were changed after validation, that validation would no longer apply
    - So no changing values or property values after a class has been instantiated
6. String + Number types with formats
    - String type data is stored as a string and if you need to access types based on its format like date,
    date-time, uuid, number etc then you will need to use accessor functions on the instance
    - type string + format: See .as_date_oapg, .as_datetime_oapg, .as_decimal_oapg, .as_uuid_oapg
    - type number + format: See .as_float_oapg, .as_int_oapg
    - this was done because openapi/json-schema defines constraints. string data may be type string with no format
    keyword in one schema, and include a format constraint in another schema
    - So if you need to access a string format based type, use as_date_oapg/as_datetime_oapg/as_decimal_oapg/as_uuid_oapg
    - So if you need to access a number format based type, use as_int_oapg/as_float_oapg
7. Property access on AnyType(type unset) or object(dict) schemas
    - Only required keys with valid python names are properties like .someProp and have type hints
    - All optional keys may not exist, so properties are not defined for them
    - One can access optional values with dict_instance['optionalProp'] and KeyError will be raised if it does not exist
    - Use get_item_oapg if you need a way to always get a value whether or not the key exists
        - If the key does not exist, schemas.unset is returned from calling dict_instance.get_item_oapg('optionalProp')
        - All required and optional keys have type hints for this method, and @typing.overload is used
        - A type hint is also generated for additionalProperties accessed using this method
    - So you will need to update you code to use some_instance['optionalProp'] to access optional property
    and additionalProperty values
8. The location of the api classes has changed
    - Api classes are located in your_package.apis.tags.some_api
    - This change was made to eliminate redundant code generation
    - Legacy generators generated the same endpoint twice if it had > 1 tag on it
    - This generator defines an endpoint in one class, then inherits that class to generate
      apis by tags and by paths
    - This change reduces code and allows quicker run time if you use the path apis
        - path apis are at your_package.apis.paths.some_path
    - Those apis will only load their needed models, which is less to load than all of the resources needed in a tag api
    - So you will need to update your import paths to the api classes

### Why are Oapg and _oapg used in class and method names?
Classes can have arbitrarily named properties set on them
Endpoints can have arbitrary operationId method names set
For those reasons, I use the prefix Oapg and _oapg to greatly reduce the likelihood of collisions
on protected + public classes/methods.
oapg stands for OpenApi Python Generator.

### Object property spec case
This was done because when payloads are ingested, they can be validated against N number of schemas.
If the input signature used a different property name then that has mutated the payload.
So SchemaA and SchemaB must both see the camelCase spec named variable.
Also it is possible to send in two properties, named camelCase and camel_case in the same payload.
That use case should be support so spec case is used.

### Parameter spec case
Parameters can be included in different locations including:
- query
- path
- header
- cookie

Any of those parameters could use the same parameter names, so if every parameter
was included as an endpoint parameter in a function signature, they would collide.
For that reason, each of those inputs have been separated out into separate typed dictionaries:
- query_params
- path_params
- header_params
- cookie_params

So when updating your code, you will need to pass endpoint parameters in using those
dictionaries.

### Endpoint responses
Endpoint responses have been enriched to now include more information.
Any response reom an endpoint will now include the following properties:
response: urllib3.HTTPResponse
body: typing.Union[Unset, Schema]
headers: typing.Union[Unset, TODO]
Note: response header deserialization has not yet been added


## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import galv
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import galv
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import galv
from pprint import pprint
from galv.apis.tags import access_levels_api
from galv.model.permitted_access_levels import PermittedAccessLevels
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = galv.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: knoxTokenAuth
configuration = galv.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)

# Configure API key authorization: cookieAuth
configuration.api_key['cookieAuth'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['cookieAuth'] = 'Bearer'

# Configure API key authorization: harvesterAuth
configuration.api_key['harvesterAuth'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['harvesterAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with galv.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = access_levels_api.AccessLevelsApi(api_client)
    
    try:
        api_response = api_instance.access_levels_retrieve()
        pprint(api_response)
    except galv.ApiException as e:
        print("Exception when calling AccessLevelsApi->access_levels_retrieve: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccessLevelsApi* | [**access_levels_retrieve**](docs/apis/tags/AccessLevelsApi.md#access_levels_retrieve) | **get** /access_levels/ | 
*ActivateApi* | [**activate_retrieve**](docs/apis/tags/ActivateApi.md#activate_retrieve) | **get** /activate/ | 
*ArbitraryFilesApi* | [**arbitrary_files_create**](docs/apis/tags/ArbitraryFilesApi.md#arbitrary_files_create) | **post** /arbitrary_files/ | Upload a file
*ArbitraryFilesApi* | [**arbitrary_files_destroy**](docs/apis/tags/ArbitraryFilesApi.md#arbitrary_files_destroy) | **delete** /arbitrary_files/{uuid}/ | Delete a file
*ArbitraryFilesApi* | [**arbitrary_files_list**](docs/apis/tags/ArbitraryFilesApi.md#arbitrary_files_list) | **get** /arbitrary_files/ | 
*ArbitraryFilesApi* | [**arbitrary_files_partial_update**](docs/apis/tags/ArbitraryFilesApi.md#arbitrary_files_partial_update) | **patch** /arbitrary_files/{uuid}/ | Update a file&#x27;s metadata
*ArbitraryFilesApi* | [**arbitrary_files_retrieve**](docs/apis/tags/ArbitraryFilesApi.md#arbitrary_files_retrieve) | **get** /arbitrary_files/{uuid}/ | 
*CellChemistriesApi* | [**cell_chemistries_list**](docs/apis/tags/CellChemistriesApi.md#cell_chemistries_list) | **get** /cell_chemistries/ | 
*CellFamiliesApi* | [**cell_families_create**](docs/apis/tags/CellFamiliesApi.md#cell_families_create) | **post** /cell_families/ | Create a Cell Family
*CellFamiliesApi* | [**cell_families_destroy**](docs/apis/tags/CellFamiliesApi.md#cell_families_destroy) | **delete** /cell_families/{uuid}/ | Delete a Cell Family
*CellFamiliesApi* | [**cell_families_list**](docs/apis/tags/CellFamiliesApi.md#cell_families_list) | **get** /cell_families/ | View Cell Families
*CellFamiliesApi* | [**cell_families_partial_update**](docs/apis/tags/CellFamiliesApi.md#cell_families_partial_update) | **patch** /cell_families/{uuid}/ | Update a Cell Family
*CellFamiliesApi* | [**cell_families_retrieve**](docs/apis/tags/CellFamiliesApi.md#cell_families_retrieve) | **get** /cell_families/{uuid}/ | View a Cell Family
*CellFormFactorsApi* | [**cell_form_factors_list**](docs/apis/tags/CellFormFactorsApi.md#cell_form_factors_list) | **get** /cell_form_factors/ | 
*CellManufacturersApi* | [**cell_manufacturers_list**](docs/apis/tags/CellManufacturersApi.md#cell_manufacturers_list) | **get** /cell_manufacturers/ | 
*CellModelsApi* | [**cell_models_list**](docs/apis/tags/CellModelsApi.md#cell_models_list) | **get** /cell_models/ | 
*CellsApi* | [**cells_create**](docs/apis/tags/CellsApi.md#cells_create) | **post** /cells/ | Create a Cell
*CellsApi* | [**cells_destroy**](docs/apis/tags/CellsApi.md#cells_destroy) | **delete** /cells/{uuid}/ | Delete a Cell
*CellsApi* | [**cells_list**](docs/apis/tags/CellsApi.md#cells_list) | **get** /cells/ | View Cells
*CellsApi* | [**cells_partial_update**](docs/apis/tags/CellsApi.md#cells_partial_update) | **patch** /cells/{uuid}/ | Update a Cell
*CellsApi* | [**cells_rdf_retrieve**](docs/apis/tags/CellsApi.md#cells_rdf_retrieve) | **get** /cells/{uuid}/rdf/ | View a Cell in RDF (JSON-LD)
*CellsApi* | [**cells_retrieve**](docs/apis/tags/CellsApi.md#cells_retrieve) | **get** /cells/{uuid}/ | View a Cell
*ColumnTypesApi* | [**column_types_list**](docs/apis/tags/ColumnTypesApi.md#column_types_list) | **get** /column_types/ | View Column Types
*ColumnTypesApi* | [**column_types_retrieve**](docs/apis/tags/ColumnTypesApi.md#column_types_retrieve) | **get** /column_types/{id}/ | View a Column Type
*ColumnsApi* | [**columns_list**](docs/apis/tags/ColumnsApi.md#columns_list) | **get** /columns/ | View Columns to which you have access
*ColumnsApi* | [**columns_retrieve**](docs/apis/tags/ColumnsApi.md#columns_retrieve) | **get** /columns/{id}/ | View a Column
*ColumnsApi* | [**columns_values_retrieve**](docs/apis/tags/ColumnsApi.md#columns_values_retrieve) | **get** /columns/{id}/values/ | View Column data as newline-separated stream of values
*CreateTokenApi* | [**create_token_create**](docs/apis/tags/CreateTokenApi.md#create_token_create) | **post** /create_token/ | Create a new API Token
*CyclerTestsApi* | [**cycler_tests_create**](docs/apis/tags/CyclerTestsApi.md#cycler_tests_create) | **post** /cycler_tests/ | 
*CyclerTestsApi* | [**cycler_tests_destroy**](docs/apis/tags/CyclerTestsApi.md#cycler_tests_destroy) | **delete** /cycler_tests/{uuid}/ | 
*CyclerTestsApi* | [**cycler_tests_list**](docs/apis/tags/CyclerTestsApi.md#cycler_tests_list) | **get** /cycler_tests/ | 
*CyclerTestsApi* | [**cycler_tests_partial_update**](docs/apis/tags/CyclerTestsApi.md#cycler_tests_partial_update) | **patch** /cycler_tests/{uuid}/ | 
*CyclerTestsApi* | [**cycler_tests_retrieve**](docs/apis/tags/CyclerTestsApi.md#cycler_tests_retrieve) | **get** /cycler_tests/{uuid}/ | 
*EquipmentApi* | [**equipment_create**](docs/apis/tags/EquipmentApi.md#equipment_create) | **post** /equipment/ | Create Equipment
*EquipmentApi* | [**equipment_destroy**](docs/apis/tags/EquipmentApi.md#equipment_destroy) | **delete** /equipment/{uuid}/ | Delete Equipment
*EquipmentApi* | [**equipment_list**](docs/apis/tags/EquipmentApi.md#equipment_list) | **get** /equipment/ | View Equipment
*EquipmentApi* | [**equipment_partial_update**](docs/apis/tags/EquipmentApi.md#equipment_partial_update) | **patch** /equipment/{uuid}/ | Update Equipment
*EquipmentApi* | [**equipment_retrieve**](docs/apis/tags/EquipmentApi.md#equipment_retrieve) | **get** /equipment/{uuid}/ | View specific Equipment
*EquipmentFamiliesApi* | [**equipment_families_create**](docs/apis/tags/EquipmentFamiliesApi.md#equipment_families_create) | **post** /equipment_families/ | Create an Equipment Family
*EquipmentFamiliesApi* | [**equipment_families_destroy**](docs/apis/tags/EquipmentFamiliesApi.md#equipment_families_destroy) | **delete** /equipment_families/{uuid}/ | Delete an Equipment Family
*EquipmentFamiliesApi* | [**equipment_families_list**](docs/apis/tags/EquipmentFamiliesApi.md#equipment_families_list) | **get** /equipment_families/ | View Equipment Families
*EquipmentFamiliesApi* | [**equipment_families_partial_update**](docs/apis/tags/EquipmentFamiliesApi.md#equipment_families_partial_update) | **patch** /equipment_families/{uuid}/ | Update an Equipment Family
*EquipmentFamiliesApi* | [**equipment_families_retrieve**](docs/apis/tags/EquipmentFamiliesApi.md#equipment_families_retrieve) | **get** /equipment_families/{uuid}/ | View an Equipment Family
*EquipmentManufacturersApi* | [**equipment_manufacturers_list**](docs/apis/tags/EquipmentManufacturersApi.md#equipment_manufacturers_list) | **get** /equipment_manufacturers/ | 
*EquipmentModelsApi* | [**equipment_models_list**](docs/apis/tags/EquipmentModelsApi.md#equipment_models_list) | **get** /equipment_models/ | 
*EquipmentTypesApi* | [**equipment_types_list**](docs/apis/tags/EquipmentTypesApi.md#equipment_types_list) | **get** /equipment_types/ | 
*ExperimentsApi* | [**experiments_create**](docs/apis/tags/ExperimentsApi.md#experiments_create) | **post** /experiments/ | Create an Experiment
*ExperimentsApi* | [**experiments_destroy**](docs/apis/tags/ExperimentsApi.md#experiments_destroy) | **delete** /experiments/{uuid}/ | 
*ExperimentsApi* | [**experiments_list**](docs/apis/tags/ExperimentsApi.md#experiments_list) | **get** /experiments/ | View Experiments
*ExperimentsApi* | [**experiments_partial_update**](docs/apis/tags/ExperimentsApi.md#experiments_partial_update) | **patch** /experiments/{uuid}/ | 
*ExperimentsApi* | [**experiments_retrieve**](docs/apis/tags/ExperimentsApi.md#experiments_retrieve) | **get** /experiments/{uuid}/ | View an Experiment
*FilesApi* | [**files_list**](docs/apis/tags/FilesApi.md#files_list) | **get** /files/ | View Files on a Path you can access
*FilesApi* | [**files_partial_update**](docs/apis/tags/FilesApi.md#files_partial_update) | **patch** /files/{uuid}/ | 
*FilesApi* | [**files_reimport_retrieve**](docs/apis/tags/FilesApi.md#files_reimport_retrieve) | **get** /files/{uuid}/reimport/ | Force a File to be re-imported
*FilesApi* | [**files_retrieve**](docs/apis/tags/FilesApi.md#files_retrieve) | **get** /files/{uuid}/ | View a File
*HarvestErrorsApi* | [**harvest_errors_list**](docs/apis/tags/HarvestErrorsApi.md#harvest_errors_list) | **get** /harvest_errors/ | View Errors encountered while Harvesting
*HarvestErrorsApi* | [**harvest_errors_retrieve**](docs/apis/tags/HarvestErrorsApi.md#harvest_errors_retrieve) | **get** /harvest_errors/{id}/ | View Error details
*HarvestersApi* | [**harvesters_list**](docs/apis/tags/HarvestersApi.md#harvesters_list) | **get** /harvesters/ | View all Harvesters
*HarvestersApi* | [**harvesters_partial_update**](docs/apis/tags/HarvestersApi.md#harvesters_partial_update) | **patch** /harvesters/{uuid}/ | Update Harvester details
*HarvestersApi* | [**harvesters_retrieve**](docs/apis/tags/HarvestersApi.md#harvesters_retrieve) | **get** /harvesters/{uuid}/ | View a single Harvester
*LabsApi* | [**labs_create**](docs/apis/tags/LabsApi.md#labs_create) | **post** /labs/ | Create a new Lab
*LabsApi* | [**labs_destroy**](docs/apis/tags/LabsApi.md#labs_destroy) | **delete** /labs/{id}/ | 
*LabsApi* | [**labs_list**](docs/apis/tags/LabsApi.md#labs_list) | **get** /labs/ | View all Labs
*LabsApi* | [**labs_partial_update**](docs/apis/tags/LabsApi.md#labs_partial_update) | **patch** /labs/{id}/ | Update a Lab
*LabsApi* | [**labs_retrieve**](docs/apis/tags/LabsApi.md#labs_retrieve) | **get** /labs/{id}/ | View a single Lab
*LoginApi* | [**login_create**](docs/apis/tags/LoginApi.md#login_create) | **post** /login/ | Log in to retrieve an API Token for use elsewhere in the API.
*MonitoredPathsApi* | [**monitored_paths_create**](docs/apis/tags/MonitoredPathsApi.md#monitored_paths_create) | **post** /monitored_paths/ | Create a new Path
*MonitoredPathsApi* | [**monitored_paths_destroy**](docs/apis/tags/MonitoredPathsApi.md#monitored_paths_destroy) | **delete** /monitored_paths/{uuid}/ | Delete a Path
*MonitoredPathsApi* | [**monitored_paths_list**](docs/apis/tags/MonitoredPathsApi.md#monitored_paths_list) | **get** /monitored_paths/ | View Paths to which you have access
*MonitoredPathsApi* | [**monitored_paths_partial_update**](docs/apis/tags/MonitoredPathsApi.md#monitored_paths_partial_update) | **patch** /monitored_paths/{uuid}/ | Update a Path
*MonitoredPathsApi* | [**monitored_paths_retrieve**](docs/apis/tags/MonitoredPathsApi.md#monitored_paths_retrieve) | **get** /monitored_paths/{uuid}/ | View the details of a Path
*ScheduleFamiliesApi* | [**schedule_families_create**](docs/apis/tags/ScheduleFamiliesApi.md#schedule_families_create) | **post** /schedule_families/ | Create a Schedule Family
*ScheduleFamiliesApi* | [**schedule_families_destroy**](docs/apis/tags/ScheduleFamiliesApi.md#schedule_families_destroy) | **delete** /schedule_families/{uuid}/ | Delete a Schedule Family
*ScheduleFamiliesApi* | [**schedule_families_list**](docs/apis/tags/ScheduleFamiliesApi.md#schedule_families_list) | **get** /schedule_families/ | View Equipment Families
*ScheduleFamiliesApi* | [**schedule_families_partial_update**](docs/apis/tags/ScheduleFamiliesApi.md#schedule_families_partial_update) | **patch** /schedule_families/{uuid}/ | Update a Schedule Family
*ScheduleFamiliesApi* | [**schedule_families_retrieve**](docs/apis/tags/ScheduleFamiliesApi.md#schedule_families_retrieve) | **get** /schedule_families/{uuid}/ | View a Schedule Family
*ScheduleIdentifiersApi* | [**schedule_identifiers_list**](docs/apis/tags/ScheduleIdentifiersApi.md#schedule_identifiers_list) | **get** /schedule_identifiers/ | 
*SchedulesApi* | [**schedules_create**](docs/apis/tags/SchedulesApi.md#schedules_create) | **post** /schedules/ | Create Schedule
*SchedulesApi* | [**schedules_destroy**](docs/apis/tags/SchedulesApi.md#schedules_destroy) | **delete** /schedules/{uuid}/ | Delete Schedule
*SchedulesApi* | [**schedules_list**](docs/apis/tags/SchedulesApi.md#schedules_list) | **get** /schedules/ | View Schedule
*SchedulesApi* | [**schedules_partial_update**](docs/apis/tags/SchedulesApi.md#schedules_partial_update) | **patch** /schedules/{uuid}/ | Update Schedule
*SchedulesApi* | [**schedules_retrieve**](docs/apis/tags/SchedulesApi.md#schedules_retrieve) | **get** /schedules/{uuid}/ | View specific Schedule
*SchemaValidationsApi* | [**schema_validations_list**](docs/apis/tags/SchemaValidationsApi.md#schema_validations_list) | **get** /schema_validations/ | 
*SchemaValidationsApi* | [**schema_validations_retrieve**](docs/apis/tags/SchemaValidationsApi.md#schema_validations_retrieve) | **get** /schema_validations/{id}/ | 
*TeamsApi* | [**teams_create**](docs/apis/tags/TeamsApi.md#teams_create) | **post** /teams/ | Create a new Lab
*TeamsApi* | [**teams_destroy**](docs/apis/tags/TeamsApi.md#teams_destroy) | **delete** /teams/{id}/ | 
*TeamsApi* | [**teams_list**](docs/apis/tags/TeamsApi.md#teams_list) | **get** /teams/ | View all Labs
*TeamsApi* | [**teams_partial_update**](docs/apis/tags/TeamsApi.md#teams_partial_update) | **patch** /teams/{id}/ | Update a Lab
*TeamsApi* | [**teams_retrieve**](docs/apis/tags/TeamsApi.md#teams_retrieve) | **get** /teams/{id}/ | View a single Lab
*TokensApi* | [**tokens_destroy**](docs/apis/tags/TokensApi.md#tokens_destroy) | **delete** /tokens/{id}/ | Revoke a token associated with your account.
*TokensApi* | [**tokens_list**](docs/apis/tags/TokensApi.md#tokens_list) | **get** /tokens/ | View tokens associated with your account.
*TokensApi* | [**tokens_partial_update**](docs/apis/tags/TokensApi.md#tokens_partial_update) | **patch** /tokens/{id}/ | Change the name of a token associated with your account.
*TokensApi* | [**tokens_retrieve**](docs/apis/tags/TokensApi.md#tokens_retrieve) | **get** /tokens/{id}/ | View a token associated with your account.
*UnitsApi* | [**units_list**](docs/apis/tags/UnitsApi.md#units_list) | **get** /units/ | View Units
*UnitsApi* | [**units_retrieve**](docs/apis/tags/UnitsApi.md#units_retrieve) | **get** /units/{id}/ | View a Unit
*UsersApi* | [**users_create**](docs/apis/tags/UsersApi.md#users_create) | **post** /users/ | 
*UsersApi* | [**users_list**](docs/apis/tags/UsersApi.md#users_list) | **get** /users/ | 
*UsersApi* | [**users_partial_update**](docs/apis/tags/UsersApi.md#users_partial_update) | **patch** /users/{id}/ | Update User profile
*UsersApi* | [**users_retrieve**](docs/apis/tags/UsersApi.md#users_retrieve) | **get** /users/{id}/ | 
*ValidationSchemasApi* | [**validation_schemas_create**](docs/apis/tags/ValidationSchemasApi.md#validation_schemas_create) | **post** /validation_schemas/ | 
*ValidationSchemasApi* | [**validation_schemas_destroy**](docs/apis/tags/ValidationSchemasApi.md#validation_schemas_destroy) | **delete** /validation_schemas/{uuid}/ | 
*ValidationSchemasApi* | [**validation_schemas_keys_retrieve**](docs/apis/tags/ValidationSchemasApi.md#validation_schemas_keys_retrieve) | **get** /validation_schemas/keys/ | Keys available for validation schemas
*ValidationSchemasApi* | [**validation_schemas_list**](docs/apis/tags/ValidationSchemasApi.md#validation_schemas_list) | **get** /validation_schemas/ | List all Validation Schemas
*ValidationSchemasApi* | [**validation_schemas_partial_update**](docs/apis/tags/ValidationSchemasApi.md#validation_schemas_partial_update) | **patch** /validation_schemas/{uuid}/ | 
*ValidationSchemasApi* | [**validation_schemas_retrieve**](docs/apis/tags/ValidationSchemasApi.md#validation_schemas_retrieve) | **get** /validation_schemas/{uuid}/ | 
*ValidationSchemasApi* | [**validation_schemas_update**](docs/apis/tags/ValidationSchemasApi.md#validation_schemas_update) | **put** /validation_schemas/{uuid}/ | 

## Documentation For Models

 - [ActivationResponse](docs/models/ActivationResponse.md)
 - [ArbitraryFile](docs/models/ArbitraryFile.md)
 - [Cell](docs/models/Cell.md)
 - [CellFamily](docs/models/CellFamily.md)
 - [CellFamilyRequest](docs/models/CellFamilyRequest.md)
 - [CellRequest](docs/models/CellRequest.md)
 - [CreateKnoxTokenRequest](docs/models/CreateKnoxTokenRequest.md)
 - [CyclerTest](docs/models/CyclerTest.md)
 - [CyclerTestRequest](docs/models/CyclerTestRequest.md)
 - [DataColumn](docs/models/DataColumn.md)
 - [DataColumnType](docs/models/DataColumnType.md)
 - [DataUnit](docs/models/DataUnit.md)
 - [Equipment](docs/models/Equipment.md)
 - [EquipmentFamily](docs/models/EquipmentFamily.md)
 - [EquipmentFamilyRequest](docs/models/EquipmentFamilyRequest.md)
 - [EquipmentRequest](docs/models/EquipmentRequest.md)
 - [Error](docs/models/Error.md)
 - [Experiment](docs/models/Experiment.md)
 - [ExperimentRequest](docs/models/ExperimentRequest.md)
 - [HarvestError](docs/models/HarvestError.md)
 - [Harvester](docs/models/Harvester.md)
 - [KnoxToken](docs/models/KnoxToken.md)
 - [KnoxTokenFull](docs/models/KnoxTokenFull.md)
 - [KnoxUser](docs/models/KnoxUser.md)
 - [Lab](docs/models/Lab.md)
 - [LabRequest](docs/models/LabRequest.md)
 - [MonitoredPath](docs/models/MonitoredPath.md)
 - [MonitoredPathRequest](docs/models/MonitoredPathRequest.md)
 - [ObservedFile](docs/models/ObservedFile.md)
 - [PaginatedArbitraryFileList](docs/models/PaginatedArbitraryFileList.md)
 - [PaginatedCellFamilyList](docs/models/PaginatedCellFamilyList.md)
 - [PaginatedCellList](docs/models/PaginatedCellList.md)
 - [PaginatedCyclerTestList](docs/models/PaginatedCyclerTestList.md)
 - [PaginatedDataColumnList](docs/models/PaginatedDataColumnList.md)
 - [PaginatedDataColumnTypeList](docs/models/PaginatedDataColumnTypeList.md)
 - [PaginatedDataUnitList](docs/models/PaginatedDataUnitList.md)
 - [PaginatedEquipmentFamilyList](docs/models/PaginatedEquipmentFamilyList.md)
 - [PaginatedEquipmentList](docs/models/PaginatedEquipmentList.md)
 - [PaginatedExperimentList](docs/models/PaginatedExperimentList.md)
 - [PaginatedHarvestErrorList](docs/models/PaginatedHarvestErrorList.md)
 - [PaginatedHarvesterList](docs/models/PaginatedHarvesterList.md)
 - [PaginatedKnoxTokenList](docs/models/PaginatedKnoxTokenList.md)
 - [PaginatedLabList](docs/models/PaginatedLabList.md)
 - [PaginatedMonitoredPathList](docs/models/PaginatedMonitoredPathList.md)
 - [PaginatedObservedFileList](docs/models/PaginatedObservedFileList.md)
 - [PaginatedScheduleFamilyList](docs/models/PaginatedScheduleFamilyList.md)
 - [PaginatedScheduleList](docs/models/PaginatedScheduleList.md)
 - [PaginatedSchemaValidationList](docs/models/PaginatedSchemaValidationList.md)
 - [PaginatedTeamList](docs/models/PaginatedTeamList.md)
 - [PaginatedUserList](docs/models/PaginatedUserList.md)
 - [PaginatedValidationSchemaList](docs/models/PaginatedValidationSchemaList.md)
 - [PatchedArbitraryFileRequest](docs/models/PatchedArbitraryFileRequest.md)
 - [PatchedCellFamilyRequest](docs/models/PatchedCellFamilyRequest.md)
 - [PatchedCellRequest](docs/models/PatchedCellRequest.md)
 - [PatchedCyclerTestRequest](docs/models/PatchedCyclerTestRequest.md)
 - [PatchedEquipmentFamilyRequest](docs/models/PatchedEquipmentFamilyRequest.md)
 - [PatchedEquipmentRequest](docs/models/PatchedEquipmentRequest.md)
 - [PatchedExperimentRequest](docs/models/PatchedExperimentRequest.md)
 - [PatchedHarvesterRequest](docs/models/PatchedHarvesterRequest.md)
 - [PatchedLabRequest](docs/models/PatchedLabRequest.md)
 - [PatchedMonitoredPathRequest](docs/models/PatchedMonitoredPathRequest.md)
 - [PatchedScheduleFamilyRequest](docs/models/PatchedScheduleFamilyRequest.md)
 - [PatchedScheduleRequest](docs/models/PatchedScheduleRequest.md)
 - [PatchedTeamRequest](docs/models/PatchedTeamRequest.md)
 - [PatchedUserUpdateRequest](docs/models/PatchedUserUpdateRequest.md)
 - [PatchedValidationSchemaRequest](docs/models/PatchedValidationSchemaRequest.md)
 - [PermittedAccessLevels](docs/models/PermittedAccessLevels.md)
 - [Schedule](docs/models/Schedule.md)
 - [ScheduleFamily](docs/models/ScheduleFamily.md)
 - [ScheduleFamilyRequest](docs/models/ScheduleFamilyRequest.md)
 - [ScheduleRequest](docs/models/ScheduleRequest.md)
 - [SchemaValidation](docs/models/SchemaValidation.md)
 - [Team](docs/models/Team.md)
 - [TeamRequest](docs/models/TeamRequest.md)
 - [TransparentGroup](docs/models/TransparentGroup.md)
 - [TransparentGroupRequest](docs/models/TransparentGroupRequest.md)
 - [User](docs/models/User.md)
 - [UserRequest](docs/models/UserRequest.md)
 - [ValidationSchema](docs/models/ValidationSchema.md)
 - [ValidationSchemaRequest](docs/models/ValidationSchemaRequest.md)
 - [ValidationSchemaRootKeys](docs/models/ValidationSchemaRootKeys.md)

## Documentation For Authorization

Authentication schemes defined for the API:
<a id="basicAuth"></a>
### basicAuth

- **Type**: HTTP basic authentication

<a id="cookieAuth"></a>
### cookieAuth

- **Type**: API key
- **API key parameter name**: sessionid
- **Location**: 

<a id="harvesterAuth"></a>
### harvesterAuth

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header

<a id="knoxTokenAuth"></a>
### knoxTokenAuth

- **Type**: Bearer authentication


## Author

martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk
martin.robinson@cs.ox.ac.uk

## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in galv.apis and galv.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from galv.apis.default_api import DefaultApi`
- `from galv.model.pet import Pet`

Solution 1:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import galv
from galv.apis import *
from galv.models import *
```
