# do not import all endpoints into this module because that uses a lot of memory and stack frames
# if you need the ability to import all endpoints from this module, import them with
# from galv.apis.path_to_api import path_to_api

import enum


class PathValues(str, enum.Enum):
    ACCESS_LEVELS_ = "/access_levels/"
    ACTIVATE_ = "/activate/"
    ARBITRARY_FILES_ = "/arbitrary_files/"
    ARBITRARY_FILES_UUID_ = "/arbitrary_files/{uuid}/"
    CELL_CHEMISTRIES_ = "/cell_chemistries/"
    CELL_FAMILIES_ = "/cell_families/"
    CELL_FAMILIES_UUID_ = "/cell_families/{uuid}/"
    CELL_FORM_FACTORS_ = "/cell_form_factors/"
    CELL_MANUFACTURERS_ = "/cell_manufacturers/"
    CELL_MODELS_ = "/cell_models/"
    CELLS_ = "/cells/"
    CELLS_UUID_ = "/cells/{uuid}/"
    CELLS_UUID_RDF_ = "/cells/{uuid}/rdf/"
    COLUMN_TYPES_ = "/column_types/"
    COLUMN_TYPES_ID_ = "/column_types/{id}/"
    COLUMNS_ = "/columns/"
    COLUMNS_ID_ = "/columns/{id}/"
    COLUMNS_ID_VALUES_ = "/columns/{id}/values/"
    CREATE_TOKEN_ = "/create_token/"
    CYCLER_TESTS_ = "/cycler_tests/"
    CYCLER_TESTS_UUID_ = "/cycler_tests/{uuid}/"
    EQUIPMENT_ = "/equipment/"
    EQUIPMENT_UUID_ = "/equipment/{uuid}/"
    EQUIPMENT_FAMILIES_ = "/equipment_families/"
    EQUIPMENT_FAMILIES_UUID_ = "/equipment_families/{uuid}/"
    EQUIPMENT_MANUFACTURERS_ = "/equipment_manufacturers/"
    EQUIPMENT_MODELS_ = "/equipment_models/"
    EQUIPMENT_TYPES_ = "/equipment_types/"
    EXPERIMENTS_ = "/experiments/"
    EXPERIMENTS_UUID_ = "/experiments/{uuid}/"
    FILES_ = "/files/"
    FILES_UUID_ = "/files/{uuid}/"
    FILES_UUID_REIMPORT_ = "/files/{uuid}/reimport/"
    HARVEST_ERRORS_ = "/harvest_errors/"
    HARVEST_ERRORS_ID_ = "/harvest_errors/{id}/"
    HARVESTERS_ = "/harvesters/"
    HARVESTERS_UUID_ = "/harvesters/{uuid}/"
    LABS_ = "/labs/"
    LABS_ID_ = "/labs/{id}/"
    LOGIN_ = "/login/"
    MONITORED_PATHS_ = "/monitored_paths/"
    MONITORED_PATHS_UUID_ = "/monitored_paths/{uuid}/"
    SCHEDULE_FAMILIES_ = "/schedule_families/"
    SCHEDULE_FAMILIES_UUID_ = "/schedule_families/{uuid}/"
    SCHEDULE_IDENTIFIERS_ = "/schedule_identifiers/"
    SCHEDULES_ = "/schedules/"
    SCHEDULES_UUID_ = "/schedules/{uuid}/"
    SCHEMA_VALIDATIONS_ = "/schema_validations/"
    SCHEMA_VALIDATIONS_ID_ = "/schema_validations/{id}/"
    TEAMS_ = "/teams/"
    TEAMS_ID_ = "/teams/{id}/"
    TOKENS_ = "/tokens/"
    TOKENS_ID_ = "/tokens/{id}/"
    UNITS_ = "/units/"
    UNITS_ID_ = "/units/{id}/"
    USERS_ = "/users/"
    USERS_ID_ = "/users/{id}/"
    VALIDATION_SCHEMAS_ = "/validation_schemas/"
    VALIDATION_SCHEMAS_UUID_ = "/validation_schemas/{uuid}/"
    VALIDATION_SCHEMAS_KEYS_ = "/validation_schemas/keys/"
