"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2025 Ant Group Co., Ltd.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _DataType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DataTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DataType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNDEFINED: _DataType.ValueType  # 0
    """Undefined data type"""
    U8: _DataType.ValueType  # 1
    """uint8_t"""
    I8: _DataType.ValueType  # 2
    """int8_t"""
    U16: _DataType.ValueType  # 3
    """uint16_t"""
    I16: _DataType.ValueType  # 4
    """int16_t"""
    U32: _DataType.ValueType  # 5
    """uint32_t"""
    I32: _DataType.ValueType  # 6
    """int32_t"""
    U64: _DataType.ValueType  # 7
    """uint64_t"""
    I64: _DataType.ValueType  # 8
    """int64_t"""
    F16: _DataType.ValueType  # 9
    """float16"""
    F32: _DataType.ValueType  # 10
    """float32"""
    F64: _DataType.ValueType  # 11
    """double"""
    STRING: _DataType.ValueType  # 12
    """string (table only)"""
    BOOL: _DataType.ValueType  # 13
    """bool"""
    COMPLEX64: _DataType.ValueType  # 14
    """complex with float32 real and imaginary components"""
    COMPLEX128: _DataType.ValueType  # 15
    """complex with float64 real and imaginary components"""
    BFLOAT16: _DataType.ValueType  # 16
    """bfloat16"""
    DATE: _DataType.ValueType  # 17
    """date (table only)"""
    TIME: _DataType.ValueType  # 18
    """time (table only)"""
    TIMESTAMP: _DataType.ValueType  # 19
    """timestamp (table only)"""
    JSON: _DataType.ValueType  # 20
    """json (table only)"""

class DataType(_DataType, metaclass=_DataTypeEnumTypeWrapper):
    """Data type enumeration"""

UNDEFINED: DataType.ValueType  # 0
"""Undefined data type"""
U8: DataType.ValueType  # 1
"""uint8_t"""
I8: DataType.ValueType  # 2
"""int8_t"""
U16: DataType.ValueType  # 3
"""uint16_t"""
I16: DataType.ValueType  # 4
"""int16_t"""
U32: DataType.ValueType  # 5
"""uint32_t"""
I32: DataType.ValueType  # 6
"""int32_t"""
U64: DataType.ValueType  # 7
"""uint64_t"""
I64: DataType.ValueType  # 8
"""int64_t"""
F16: DataType.ValueType  # 9
"""float16"""
F32: DataType.ValueType  # 10
"""float32"""
F64: DataType.ValueType  # 11
"""double"""
STRING: DataType.ValueType  # 12
"""string (table only)"""
BOOL: DataType.ValueType  # 13
"""bool"""
COMPLEX64: DataType.ValueType  # 14
"""complex with float32 real and imaginary components"""
COMPLEX128: DataType.ValueType  # 15
"""complex with float64 real and imaginary components"""
BFLOAT16: DataType.ValueType  # 16
"""bfloat16"""
DATE: DataType.ValueType  # 17
"""date (table only)"""
TIME: DataType.ValueType  # 18
"""time (table only)"""
TIMESTAMP: DataType.ValueType  # 19
"""timestamp (table only)"""
JSON: DataType.ValueType  # 20
"""json (table only)"""
global___DataType = DataType

@typing_extensions.final
class AttrProto(google.protobuf.message.Message):
    """Custom attribute message (without name field since it's the map key)"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _AttrType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _AttrTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[AttrProto._AttrType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNDEFINED: AttrProto._AttrType.ValueType  # 0
        """Undefined attribute type"""
        FLOAT: AttrProto._AttrType.ValueType  # 1
        """Single float value"""
        INT: AttrProto._AttrType.ValueType  # 2
        """Single integer value"""
        STRING: AttrProto._AttrType.ValueType  # 3
        """Single string value"""
        BOOL: AttrProto._AttrType.ValueType  # 4
        """Single boolean value"""
        BYTES: AttrProto._AttrType.ValueType  # 5
        """Binary data"""
        FLOATS: AttrProto._AttrType.ValueType  # 6
        """Array of float values"""
        INTS: AttrProto._AttrType.ValueType  # 7
        """Array of integer values"""
        STRINGS: AttrProto._AttrType.ValueType  # 8
        """Array of string values"""
        FUNCTION: AttrProto._AttrType.ValueType  # 10
        """Textual function reference"""
        GRAPH: AttrProto._AttrType.ValueType  # 11
        """Nested function graph"""

    class AttrType(_AttrType, metaclass=_AttrTypeEnumTypeWrapper):
        """Define possible attribute types"""

    UNDEFINED: AttrProto.AttrType.ValueType  # 0
    """Undefined attribute type"""
    FLOAT: AttrProto.AttrType.ValueType  # 1
    """Single float value"""
    INT: AttrProto.AttrType.ValueType  # 2
    """Single integer value"""
    STRING: AttrProto.AttrType.ValueType  # 3
    """Single string value"""
    BOOL: AttrProto.AttrType.ValueType  # 4
    """Single boolean value"""
    BYTES: AttrProto.AttrType.ValueType  # 5
    """Binary data"""
    FLOATS: AttrProto.AttrType.ValueType  # 6
    """Array of float values"""
    INTS: AttrProto.AttrType.ValueType  # 7
    """Array of integer values"""
    STRINGS: AttrProto.AttrType.ValueType  # 8
    """Array of string values"""
    FUNCTION: AttrProto.AttrType.ValueType  # 10
    """Textual function reference"""
    GRAPH: AttrProto.AttrType.ValueType  # 11
    """Nested function graph"""

    TYPE_FIELD_NUMBER: builtins.int
    F_FIELD_NUMBER: builtins.int
    I_FIELD_NUMBER: builtins.int
    S_FIELD_NUMBER: builtins.int
    B_FIELD_NUMBER: builtins.int
    RAW_BYTES_FIELD_NUMBER: builtins.int
    FLOATS_FIELD_NUMBER: builtins.int
    INTS_FIELD_NUMBER: builtins.int
    STRS_FIELD_NUMBER: builtins.int
    FUNC_FIELD_NUMBER: builtins.int
    GRAPH_FIELD_NUMBER: builtins.int
    type: global___AttrProto.AttrType.ValueType
    """Type of the attribute"""
    f: builtins.float
    """FLOAT value"""
    i: builtins.int
    """INT value"""
    s: builtins.str
    """STRING value"""
    b: builtins.bool
    """BOOL value"""
    raw_bytes: builtins.bytes
    """BYTES - for raw binary data"""
    @property
    def floats(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """FLOATS - array of float values"""
    @property
    def ints(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """INTS - array of integer values"""
    @property
    def strs(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """STRINGS - array of string values"""
    @property
    def func(self) -> global___FuncProto:
        """FUNCTION - textual function reference"""
    @property
    def graph(self) -> global___GraphProto:
        """GRAPH - nested function graph"""
    def __init__(
        self,
        *,
        type: global___AttrProto.AttrType.ValueType = ...,
        f: builtins.float = ...,
        i: builtins.int = ...,
        s: builtins.str = ...,
        b: builtins.bool = ...,
        raw_bytes: builtins.bytes = ...,
        floats: collections.abc.Iterable[builtins.float] | None = ...,
        ints: collections.abc.Iterable[builtins.int] | None = ...,
        strs: collections.abc.Iterable[builtins.str] | None = ...,
        func: global___FuncProto | None = ...,
        graph: global___GraphProto | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["func", b"func", "graph", b"graph"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["b", b"b", "f", b"f", "floats", b"floats", "func", b"func", "graph", b"graph", "i", b"i", "ints", b"ints", "raw_bytes", b"raw_bytes", "s", b"s", "strs", b"strs", "type", b"type"]) -> None: ...

global___AttrProto = AttrProto

@typing_extensions.final
class FuncProto(google.protobuf.message.Message):
    """Function prototype message"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class AttrsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___AttrProto: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___AttrProto | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    TYPE_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    BODY_FIELD_NUMBER: builtins.int
    DOC_STRING_FIELD_NUMBER: builtins.int
    ATTRS_FIELD_NUMBER: builtins.int
    type: builtins.str
    """Function type"""
    name: builtins.str
    """Function name"""
    body: builtins.str
    """Function body as a string (e.g., Python code)"""
    doc_string: builtins.str
    """Documentation string"""
    @property
    def attrs(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___AttrProto]:
        """Function attributes"""
    def __init__(
        self,
        *,
        type: builtins.str = ...,
        name: builtins.str = ...,
        body: builtins.str = ...,
        doc_string: builtins.str = ...,
        attrs: collections.abc.Mapping[builtins.str, global___AttrProto] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["attrs", b"attrs", "body", b"body", "doc_string", b"doc_string", "name", b"name", "type", b"type"]) -> None: ...

global___FuncProto = FuncProto

@typing_extensions.final
class TensorTypeProto(google.protobuf.message.Message):
    """Tensor type definition"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DTYPE_FIELD_NUMBER: builtins.int
    SHAPE_DIMS_FIELD_NUMBER: builtins.int
    dtype: global___DataType.ValueType
    """Data type of the tensor elements"""
    @property
    def shape_dims(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Shape dimensions of the tensor"""
    def __init__(
        self,
        *,
        dtype: global___DataType.ValueType = ...,
        shape_dims: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["dtype", b"dtype", "shape_dims", b"shape_dims"]) -> None: ...

global___TensorTypeProto = TensorTypeProto

@typing_extensions.final
class TableTypeProto(google.protobuf.message.Message):
    """Table type definition"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Column(google.protobuf.message.Message):
        """Column definition within a table"""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        DTYPE_FIELD_NUMBER: builtins.int
        name: builtins.str
        """Name of the column"""
        dtype: global___DataType.ValueType
        """Data type of the column"""
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            dtype: global___DataType.ValueType = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["dtype", b"dtype", "name", b"name"]) -> None: ...

    COLUMNS_FIELD_NUMBER: builtins.int
    @property
    def columns(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TableTypeProto.Column]:
        """List of columns in the table"""
    def __init__(
        self,
        *,
        columns: collections.abc.Iterable[global___TableTypeProto.Column] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["columns", b"columns"]) -> None: ...

global___TableTypeProto = TableTypeProto

@typing_extensions.final
class MPTypeProto(google.protobuf.message.Message):
    """Multi-party type definition"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class AttrsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___AttrProto: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___AttrProto | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    TENSOR_TYPE_FIELD_NUMBER: builtins.int
    TABLE_TYPE_FIELD_NUMBER: builtins.int
    PMASK_FIELD_NUMBER: builtins.int
    ATTRS_FIELD_NUMBER: builtins.int
    @property
    def tensor_type(self) -> global___TensorTypeProto:
        """Tensor type specification"""
    @property
    def table_type(self) -> global___TableTypeProto:
        """Table type specification"""
    pmask: builtins.int
    """Party mask (-1 for dynamic mask, >=0 for static mask)"""
    @property
    def attrs(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___AttrProto]:
        """Additional attributes"""
    def __init__(
        self,
        *,
        tensor_type: global___TensorTypeProto | None = ...,
        table_type: global___TableTypeProto | None = ...,
        pmask: builtins.int = ...,
        attrs: collections.abc.Mapping[builtins.str, global___AttrProto] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["table_type", b"table_type", "tensor_type", b"tensor_type", "type_spec", b"type_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["attrs", b"attrs", "pmask", b"pmask", "table_type", b"table_type", "tensor_type", b"tensor_type", "type_spec", b"type_spec"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["type_spec", b"type_spec"]) -> typing_extensions.Literal["tensor_type", "table_type"] | None: ...

global___MPTypeProto = MPTypeProto

@typing_extensions.final
class NodeProto(google.protobuf.message.Message):
    """Node prototype definition"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class AttrsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___AttrProto: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___AttrProto | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    OP_TYPE_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    OUTS_INFO_FIELD_NUMBER: builtins.int
    ATTRS_FIELD_NUMBER: builtins.int
    DOC_STRING_FIELD_NUMBER: builtins.int
    op_type: builtins.str
    """Operation type of the node"""
    name: builtins.str
    """Name of the node"""
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Input specifications in format {name:index}"""
    @property
    def outs_info(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MPTypeProto]:
        """Output type information"""
    @property
    def attrs(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___AttrProto]:
        """Node attributes"""
    doc_string: builtins.str
    """Documentation string"""
    def __init__(
        self,
        *,
        op_type: builtins.str = ...,
        name: builtins.str = ...,
        inputs: collections.abc.Iterable[builtins.str] | None = ...,
        outs_info: collections.abc.Iterable[global___MPTypeProto] | None = ...,
        attrs: collections.abc.Mapping[builtins.str, global___AttrProto] | None = ...,
        doc_string: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["attrs", b"attrs", "doc_string", b"doc_string", "inputs", b"inputs", "name", b"name", "op_type", b"op_type", "outs_info", b"outs_info"]) -> None: ...

global___NodeProto = NodeProto

@typing_extensions.final
class VersionInfo(google.protobuf.message.Message):
    """Version information definition"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MAJOR_FIELD_NUMBER: builtins.int
    MINOR_FIELD_NUMBER: builtins.int
    PATCH_FIELD_NUMBER: builtins.int
    EXTRA_FIELD_NUMBER: builtins.int
    major: builtins.int
    """Major version, incompatible changes"""
    minor: builtins.int
    """Minor version, backward compatible changes"""
    patch: builtins.int
    """Patch version, bug fixes"""
    extra: builtins.str
    """Extra information, like "beta", "rc1", etc."""
    def __init__(
        self,
        *,
        major: builtins.int = ...,
        minor: builtins.int = ...,
        patch: builtins.int = ...,
        extra: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["extra", b"extra", "major", b"major", "minor", b"minor", "patch", b"patch"]) -> None: ...

global___VersionInfo = VersionInfo

@typing_extensions.final
class GraphProto(google.protobuf.message.Message):
    """Graph prototype definition"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class AttrsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___AttrProto: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___AttrProto | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    VERSION_FIELD_NUMBER: builtins.int
    NODES_FIELD_NUMBER: builtins.int
    OUTPUTS_FIELD_NUMBER: builtins.int
    ATTRS_FIELD_NUMBER: builtins.int
    @property
    def version(self) -> global___VersionInfo:
        """Version information"""
    @property
    def nodes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___NodeProto]:
        """List of nodes in the graph"""
    @property
    def outputs(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Output specifications in format {name:index}"""
    @property
    def attrs(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___AttrProto]:
        """Graph attributes"""
    def __init__(
        self,
        *,
        version: global___VersionInfo | None = ...,
        nodes: collections.abc.Iterable[global___NodeProto] | None = ...,
        outputs: collections.abc.Iterable[builtins.str] | None = ...,
        attrs: collections.abc.Mapping[builtins.str, global___AttrProto] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["version", b"version"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["attrs", b"attrs", "nodes", b"nodes", "outputs", b"outputs", "version", b"version"]) -> None: ...

global___GraphProto = GraphProto
