# MPLang HTTP Runtime API v1

This document specifies the RESTful API for the MPLang HTTP runtime server.

## Design Rationale

The API follows a resource-oriented design to manage sessions, computations, and symbols for distributed multi-party computation.

### Client-Generated IDs and Idempotent Creation

A key design choice is the use of `PUT` for resource creation (e.g., `PUT /api/v1/sessions/{session_id}`). This is because identifiers for resources like `sessions` and `computations` are generated by the client (the `Driver`), not the server.

This approach ensures that a resource ID is consistent across all participating parties in a distributed computation. Since the client defines the resource's unique URI, the creation operation is naturally **idempotent**. A `PUT` request will create the resource if it doesn't exist or do nothing if it already exists, which simplifies error recovery and retry logic for the client.

### Update Strategy: PUT vs. PATCH

The use of `PUT` for creation also implies its role in updates. According to HTTP semantics, `PUT` performs a **full replacement** of a resource. This is suitable for our current needs, as resources like `Session` and `Computation` configurations are largely immutable once created.

If a future requirement arises for **partial updates** (e.g., modifying a single attribute of a resource without sending the entire object), the standard approach is to introduce the `PATCH` method. For example:

`PATCH /api/v1/sessions/{session_id}`

This `PATCH` endpoint could accept a body with only the fields to be changed. It can coexist with the `PUT` endpoint without conflict. This design is therefore robust and extensible, allowing for partial updates to be added later without altering the existing API contract.

### Actions

Non-CRUD operations, such as triggering the execution of a computation, are modeled as "actions." These are invoked using `POST` on a resource, with a special action suffix (e.g., `POST /.../{resource_id}:action`). This clearly separates state changes from triggering processes.

However, for simplicity in the current implementation, some operations like computation creation and execution are combined into a single `PUT` request.

## API Endpoints (Control Plane)

The base path for all endpoints is `/api/v1`.

| Method | Path                                                       | Description                                                  |
| :----- | :--------------------------------------------------------- | :----------------------------------------------------------- |
| `GET`  | `/health`                                                  | Checks if the server is running and healthy.                 |
| `PUT`  | `/sessions/{session_id}`                                   | Creates or updates a session with a client-provided ID.      |
| `GET`  | `/sessions`                                                | Lists all sessions on the node.                              |
| `GET`  | `/sessions/{session_id}`                                   | Retrieves details for a specific session.                    |
| `DELETE` | /sessions/{session_id}                                   | Deletes a session and all its associated resources.          |
| `PUT`  | `/sessions/{session_id}/computations/{computation_id}`     | Creates and executes a computation with a client-provided ID. |
| `GET`  | `/sessions/{session_id}/computations`                      | Lists all computations within a session.                     |
| `DELETE`| `/sessions/{session_id}/computations/{computation_id}`     | Deletes a specific computation.                              |
| `PUT`  | `/sessions/{session_id}/symbols/{symbol_name}`             | Uploads or updates data for a symbol (e.g., an input).       |
| `GET`  | `/sessions/{session_id}/symbols/{symbol_name}`             | Retrieves the value of a symbol (e.g., an output).           |
| `GET`  | `/sessions/{session_id}/symbols`                           | Lists all symbols within a session.                          |
| `DELETE`| `/sessions/{session_id}/symbols/{symbol_name}`             | Deletes a specific symbol.                                   |

## Low-Level Communication API (Data Plane)

This API operates at a different abstraction level from the control plane and is used for direct, point-to-point data exchange during computation execution. It is not versioned under `/api/v1` and is consumed internally by the `Communicator`.

| Method | Path                                           | Description                                                  |
| :----- | :--------------------------------------------- | :----------------------------------------------------------- |
| `PUT`  | `/sessions/{session_name}/comm/{key}/from/{from_rank}` | Receives a data payload from a peer and passes it to the communicator. |
