from dataclasses import dataclass


@dataclass(frozen=True)
class Error:
    """A class representing an error contained in a Result type."""

    msg: str = ""

    def get_message(self) -> str:
        return self.msg

    def __str__(self) -> str:
        return self.msg

    def __repr__(self) -> str:
        return self.msg


class UnwrapError(Exception):
    """Exception raised when trying to unwrap an enum variant with no value."""

    def __init__(self, message: str = ""):
        super().__init__(message)


UNWRAP_OPTION_MSG = "Called Option.unwrap() on None."
UNWRAP_RESULT_MSG = "Called Result.unwrap() on Error."
UNWRAP_ERR_RESULT_MSG = "Called Result.unwrap_err() on Ok."
