# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['FederatedSettingsIdentityProviderArgs', 'FederatedSettingsIdentityProvider']

@pulumi.input_type
class FederatedSettingsIdentityProviderArgs:
    def __init__(__self__, *,
                 federation_settings_id: pulumi.Input[builtins.str],
                 issuer_uri: pulumi.Input[builtins.str],
                 associated_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 audience: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_type: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 groups_claim: Optional[pulumi.Input[builtins.str]] = None,
                 idp_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 request_binding: Optional[pulumi.Input[builtins.str]] = None,
                 requested_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 response_signature_algorithm: Optional[pulumi.Input[builtins.str]] = None,
                 sso_debug_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 sso_url: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 user_claim: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a FederatedSettingsIdentityProvider resource.
        :param pulumi.Input[builtins.str] federation_settings_id: Unique 24-hexadecimal digit string that identifies the federated authentication configuration.
        :param pulumi.Input[builtins.str] issuer_uri: Unique string that identifies the issuer of the IdP.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] associated_domains: List that contains the domains associated with the identity provider.
        :param pulumi.Input[builtins.str] audience: Identifier of the intended recipient of the token used in OIDC IdP.
        :param pulumi.Input[builtins.str] authorization_type: Indicates whether authorization is granted based on group membership or user ID. Valid values are `GROUP` or `USER`.
        :param pulumi.Input[builtins.str] client_id: Client identifier that is assigned to an application by the OIDC Identity Provider.
        :param pulumi.Input[builtins.str] description: The description of the identity provider.
        :param pulumi.Input[builtins.str] groups_claim: Identifier of the claim which contains OIDC IdP Group IDs in the token.
        :param pulumi.Input[builtins.str] name: Human-readable label that identifies the identity provider.
        :param pulumi.Input[builtins.str] protocol: The protocol of the identity provider. Either `SAML` or `OIDC`.
        :param pulumi.Input[builtins.str] request_binding: SAML Authentication Request Protocol HTTP method binding (`POST` or `REDIRECT`) that Federated Authentication uses to send the authentication request. Atlas supports the following binding values:
               - HTTP POST
               - HTTP REDIRECT
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] requested_scopes: Scopes that MongoDB applications will request from the authorization endpoint used for OIDC IdPs.
        :param pulumi.Input[builtins.str] response_signature_algorithm: Signature algorithm that Federated Authentication uses to encrypt the identity provider signature.  Valid values include `SHA-1 `and `SHA-256`.
        :param pulumi.Input[builtins.bool] sso_debug_enabled: Flag that indicates whether the identity provider has SSO debug enabled.
        :param pulumi.Input[builtins.str] sso_url: Unique string that identifies the intended audience of the SAML assertion.
        :param pulumi.Input[builtins.str] status: String enum that indicates whether the identity provider is active or not. Accepted values are ACTIVE or INACTIVE.
        :param pulumi.Input[builtins.str] user_claim: Identifier of the claim which contains the user ID in the token used for OIDC IdPs.
               userClaim is required for OIDC IdP with authorizationType GROUP and USER.
        """
        pulumi.set(__self__, "federation_settings_id", federation_settings_id)
        pulumi.set(__self__, "issuer_uri", issuer_uri)
        if associated_domains is not None:
            pulumi.set(__self__, "associated_domains", associated_domains)
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if authorization_type is not None:
            pulumi.set(__self__, "authorization_type", authorization_type)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if groups_claim is not None:
            pulumi.set(__self__, "groups_claim", groups_claim)
        if idp_type is not None:
            pulumi.set(__self__, "idp_type", idp_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if request_binding is not None:
            pulumi.set(__self__, "request_binding", request_binding)
        if requested_scopes is not None:
            pulumi.set(__self__, "requested_scopes", requested_scopes)
        if response_signature_algorithm is not None:
            pulumi.set(__self__, "response_signature_algorithm", response_signature_algorithm)
        if sso_debug_enabled is not None:
            pulumi.set(__self__, "sso_debug_enabled", sso_debug_enabled)
        if sso_url is not None:
            pulumi.set(__self__, "sso_url", sso_url)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if user_claim is not None:
            pulumi.set(__self__, "user_claim", user_claim)

    @property
    @pulumi.getter(name="federationSettingsId")
    def federation_settings_id(self) -> pulumi.Input[builtins.str]:
        """
        Unique 24-hexadecimal digit string that identifies the federated authentication configuration.
        """
        return pulumi.get(self, "federation_settings_id")

    @federation_settings_id.setter
    def federation_settings_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "federation_settings_id", value)

    @property
    @pulumi.getter(name="issuerUri")
    def issuer_uri(self) -> pulumi.Input[builtins.str]:
        """
        Unique string that identifies the issuer of the IdP.
        """
        return pulumi.get(self, "issuer_uri")

    @issuer_uri.setter
    def issuer_uri(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "issuer_uri", value)

    @property
    @pulumi.getter(name="associatedDomains")
    def associated_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List that contains the domains associated with the identity provider.
        """
        return pulumi.get(self, "associated_domains")

    @associated_domains.setter
    def associated_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "associated_domains", value)

    @property
    @pulumi.getter
    def audience(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the intended recipient of the token used in OIDC IdP.
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "audience", value)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether authorization is granted based on group membership or user ID. Valid values are `GROUP` or `USER`.
        """
        return pulumi.get(self, "authorization_type")

    @authorization_type.setter
    def authorization_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization_type", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Client identifier that is assigned to an application by the OIDC Identity Provider.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the identity provider.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="groupsClaim")
    def groups_claim(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the claim which contains OIDC IdP Group IDs in the token.
        """
        return pulumi.get(self, "groups_claim")

    @groups_claim.setter
    def groups_claim(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "groups_claim", value)

    @property
    @pulumi.getter(name="idpType")
    def idp_type(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "idp_type")

    @idp_type.setter
    def idp_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idp_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Human-readable label that identifies the identity provider.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The protocol of the identity provider. Either `SAML` or `OIDC`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="requestBinding")
    def request_binding(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SAML Authentication Request Protocol HTTP method binding (`POST` or `REDIRECT`) that Federated Authentication uses to send the authentication request. Atlas supports the following binding values:
        - HTTP POST
        - HTTP REDIRECT
        """
        return pulumi.get(self, "request_binding")

    @request_binding.setter
    def request_binding(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "request_binding", value)

    @property
    @pulumi.getter(name="requestedScopes")
    def requested_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Scopes that MongoDB applications will request from the authorization endpoint used for OIDC IdPs.
        """
        return pulumi.get(self, "requested_scopes")

    @requested_scopes.setter
    def requested_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "requested_scopes", value)

    @property
    @pulumi.getter(name="responseSignatureAlgorithm")
    def response_signature_algorithm(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Signature algorithm that Federated Authentication uses to encrypt the identity provider signature.  Valid values include `SHA-1 `and `SHA-256`.
        """
        return pulumi.get(self, "response_signature_algorithm")

    @response_signature_algorithm.setter
    def response_signature_algorithm(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "response_signature_algorithm", value)

    @property
    @pulumi.getter(name="ssoDebugEnabled")
    def sso_debug_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Flag that indicates whether the identity provider has SSO debug enabled.
        """
        return pulumi.get(self, "sso_debug_enabled")

    @sso_debug_enabled.setter
    def sso_debug_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "sso_debug_enabled", value)

    @property
    @pulumi.getter(name="ssoUrl")
    def sso_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique string that identifies the intended audience of the SAML assertion.
        """
        return pulumi.get(self, "sso_url")

    @sso_url.setter
    def sso_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sso_url", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        String enum that indicates whether the identity provider is active or not. Accepted values are ACTIVE or INACTIVE.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="userClaim")
    def user_claim(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the claim which contains the user ID in the token used for OIDC IdPs.
        userClaim is required for OIDC IdP with authorizationType GROUP and USER.
        """
        return pulumi.get(self, "user_claim")

    @user_claim.setter
    def user_claim(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_claim", value)


@pulumi.input_type
class _FederatedSettingsIdentityProviderState:
    def __init__(__self__, *,
                 associated_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 audience: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_type: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 federation_settings_id: Optional[pulumi.Input[builtins.str]] = None,
                 groups_claim: Optional[pulumi.Input[builtins.str]] = None,
                 idp_id: Optional[pulumi.Input[builtins.str]] = None,
                 idp_type: Optional[pulumi.Input[builtins.str]] = None,
                 issuer_uri: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 okta_idp_id: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 request_binding: Optional[pulumi.Input[builtins.str]] = None,
                 requested_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 response_signature_algorithm: Optional[pulumi.Input[builtins.str]] = None,
                 sso_debug_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 sso_url: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 user_claim: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering FederatedSettingsIdentityProvider resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] associated_domains: List that contains the domains associated with the identity provider.
        :param pulumi.Input[builtins.str] audience: Identifier of the intended recipient of the token used in OIDC IdP.
        :param pulumi.Input[builtins.str] authorization_type: Indicates whether authorization is granted based on group membership or user ID. Valid values are `GROUP` or `USER`.
        :param pulumi.Input[builtins.str] client_id: Client identifier that is assigned to an application by the OIDC Identity Provider.
        :param pulumi.Input[builtins.str] description: The description of the identity provider.
        :param pulumi.Input[builtins.str] federation_settings_id: Unique 24-hexadecimal digit string that identifies the federated authentication configuration.
        :param pulumi.Input[builtins.str] groups_claim: Identifier of the claim which contains OIDC IdP Group IDs in the token.
        :param pulumi.Input[builtins.str] idp_id: Unique 24-hexadecimal digit string that identifies the IdP.
        :param pulumi.Input[builtins.str] issuer_uri: Unique string that identifies the issuer of the IdP.
        :param pulumi.Input[builtins.str] name: Human-readable label that identifies the identity provider.
        :param pulumi.Input[builtins.str] okta_idp_id: Unique 20-hexadecimal digit string that identifies the IdP.
        :param pulumi.Input[builtins.str] protocol: The protocol of the identity provider. Either `SAML` or `OIDC`.
        :param pulumi.Input[builtins.str] request_binding: SAML Authentication Request Protocol HTTP method binding (`POST` or `REDIRECT`) that Federated Authentication uses to send the authentication request. Atlas supports the following binding values:
               - HTTP POST
               - HTTP REDIRECT
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] requested_scopes: Scopes that MongoDB applications will request from the authorization endpoint used for OIDC IdPs.
        :param pulumi.Input[builtins.str] response_signature_algorithm: Signature algorithm that Federated Authentication uses to encrypt the identity provider signature.  Valid values include `SHA-1 `and `SHA-256`.
        :param pulumi.Input[builtins.bool] sso_debug_enabled: Flag that indicates whether the identity provider has SSO debug enabled.
        :param pulumi.Input[builtins.str] sso_url: Unique string that identifies the intended audience of the SAML assertion.
        :param pulumi.Input[builtins.str] status: String enum that indicates whether the identity provider is active or not. Accepted values are ACTIVE or INACTIVE.
        :param pulumi.Input[builtins.str] user_claim: Identifier of the claim which contains the user ID in the token used for OIDC IdPs.
               userClaim is required for OIDC IdP with authorizationType GROUP and USER.
        """
        if associated_domains is not None:
            pulumi.set(__self__, "associated_domains", associated_domains)
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if authorization_type is not None:
            pulumi.set(__self__, "authorization_type", authorization_type)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if federation_settings_id is not None:
            pulumi.set(__self__, "federation_settings_id", federation_settings_id)
        if groups_claim is not None:
            pulumi.set(__self__, "groups_claim", groups_claim)
        if idp_id is not None:
            pulumi.set(__self__, "idp_id", idp_id)
        if idp_type is not None:
            pulumi.set(__self__, "idp_type", idp_type)
        if issuer_uri is not None:
            pulumi.set(__self__, "issuer_uri", issuer_uri)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if okta_idp_id is not None:
            pulumi.set(__self__, "okta_idp_id", okta_idp_id)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if request_binding is not None:
            pulumi.set(__self__, "request_binding", request_binding)
        if requested_scopes is not None:
            pulumi.set(__self__, "requested_scopes", requested_scopes)
        if response_signature_algorithm is not None:
            pulumi.set(__self__, "response_signature_algorithm", response_signature_algorithm)
        if sso_debug_enabled is not None:
            pulumi.set(__self__, "sso_debug_enabled", sso_debug_enabled)
        if sso_url is not None:
            pulumi.set(__self__, "sso_url", sso_url)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if user_claim is not None:
            pulumi.set(__self__, "user_claim", user_claim)

    @property
    @pulumi.getter(name="associatedDomains")
    def associated_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List that contains the domains associated with the identity provider.
        """
        return pulumi.get(self, "associated_domains")

    @associated_domains.setter
    def associated_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "associated_domains", value)

    @property
    @pulumi.getter
    def audience(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the intended recipient of the token used in OIDC IdP.
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "audience", value)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether authorization is granted based on group membership or user ID. Valid values are `GROUP` or `USER`.
        """
        return pulumi.get(self, "authorization_type")

    @authorization_type.setter
    def authorization_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization_type", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Client identifier that is assigned to an application by the OIDC Identity Provider.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the identity provider.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="federationSettingsId")
    def federation_settings_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique 24-hexadecimal digit string that identifies the federated authentication configuration.
        """
        return pulumi.get(self, "federation_settings_id")

    @federation_settings_id.setter
    def federation_settings_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "federation_settings_id", value)

    @property
    @pulumi.getter(name="groupsClaim")
    def groups_claim(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the claim which contains OIDC IdP Group IDs in the token.
        """
        return pulumi.get(self, "groups_claim")

    @groups_claim.setter
    def groups_claim(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "groups_claim", value)

    @property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique 24-hexadecimal digit string that identifies the IdP.
        """
        return pulumi.get(self, "idp_id")

    @idp_id.setter
    def idp_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idp_id", value)

    @property
    @pulumi.getter(name="idpType")
    def idp_type(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "idp_type")

    @idp_type.setter
    def idp_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idp_type", value)

    @property
    @pulumi.getter(name="issuerUri")
    def issuer_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique string that identifies the issuer of the IdP.
        """
        return pulumi.get(self, "issuer_uri")

    @issuer_uri.setter
    def issuer_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "issuer_uri", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Human-readable label that identifies the identity provider.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oktaIdpId")
    def okta_idp_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique 20-hexadecimal digit string that identifies the IdP.
        """
        return pulumi.get(self, "okta_idp_id")

    @okta_idp_id.setter
    def okta_idp_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "okta_idp_id", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The protocol of the identity provider. Either `SAML` or `OIDC`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="requestBinding")
    def request_binding(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SAML Authentication Request Protocol HTTP method binding (`POST` or `REDIRECT`) that Federated Authentication uses to send the authentication request. Atlas supports the following binding values:
        - HTTP POST
        - HTTP REDIRECT
        """
        return pulumi.get(self, "request_binding")

    @request_binding.setter
    def request_binding(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "request_binding", value)

    @property
    @pulumi.getter(name="requestedScopes")
    def requested_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Scopes that MongoDB applications will request from the authorization endpoint used for OIDC IdPs.
        """
        return pulumi.get(self, "requested_scopes")

    @requested_scopes.setter
    def requested_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "requested_scopes", value)

    @property
    @pulumi.getter(name="responseSignatureAlgorithm")
    def response_signature_algorithm(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Signature algorithm that Federated Authentication uses to encrypt the identity provider signature.  Valid values include `SHA-1 `and `SHA-256`.
        """
        return pulumi.get(self, "response_signature_algorithm")

    @response_signature_algorithm.setter
    def response_signature_algorithm(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "response_signature_algorithm", value)

    @property
    @pulumi.getter(name="ssoDebugEnabled")
    def sso_debug_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Flag that indicates whether the identity provider has SSO debug enabled.
        """
        return pulumi.get(self, "sso_debug_enabled")

    @sso_debug_enabled.setter
    def sso_debug_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "sso_debug_enabled", value)

    @property
    @pulumi.getter(name="ssoUrl")
    def sso_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique string that identifies the intended audience of the SAML assertion.
        """
        return pulumi.get(self, "sso_url")

    @sso_url.setter
    def sso_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sso_url", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        String enum that indicates whether the identity provider is active or not. Accepted values are ACTIVE or INACTIVE.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="userClaim")
    def user_claim(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the claim which contains the user ID in the token used for OIDC IdPs.
        userClaim is required for OIDC IdP with authorizationType GROUP and USER.
        """
        return pulumi.get(self, "user_claim")

    @user_claim.setter
    def user_claim(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_claim", value)


@pulumi.type_token("mongodbatlas:index/federatedSettingsIdentityProvider:FederatedSettingsIdentityProvider")
class FederatedSettingsIdentityProvider(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associated_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 audience: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_type: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 federation_settings_id: Optional[pulumi.Input[builtins.str]] = None,
                 groups_claim: Optional[pulumi.Input[builtins.str]] = None,
                 idp_type: Optional[pulumi.Input[builtins.str]] = None,
                 issuer_uri: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 request_binding: Optional[pulumi.Input[builtins.str]] = None,
                 requested_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 response_signature_algorithm: Optional[pulumi.Input[builtins.str]] = None,
                 sso_debug_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 sso_url: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 user_claim: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## # Resource: FederatedSettingsIdentityProvider

        `FederatedSettingsIdentityProvider` provides an Atlas federated settings identity provider resource provides a subset of settings to be maintained post import of the existing resource.

        ## Example Usage

        > **IMPORTANT** If you want to use a SAML Identity Provider, you **MUST** import this resource before you can manage it with this provider.

        SAML IdP:

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        identity_provider = mongodbatlas.FederatedSettingsIdentityProvider("identity_provider",
            federation_settings_id="627a9687f7f7f7f774de306f14",
            name="mongodb_federation_test",
            associated_domains=["yourdomain.com"],
            sso_debug_enabled=True,
            status="ACTIVE",
            sso_url="https://mysso.oktapreview.com/app/mysso_terraformtestsso/exk17q7f7f7f7f50h8/sso/saml",
            issuer_uri="http://www.okta.com/exk17q7f7f7f7fp50h8",
            request_binding="HTTP-POST",
            response_signature_algorithm="SHA-256")
        ```

        OIDC IdP:

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        oidc = mongodbatlas.FederatedSettingsIdentityProvider("oidc",
            federation_settings_id=this["id"],
            audience=token_audience,
            authorization_type="USER",
            description="oidc",
            issuer_uri=f"https://sts.windows.net/{this_azurerm_user_assigned_identity['tenantId']}/",
            idp_type="WORKLOAD",
            name="OIDC-for-azure",
            protocol="OIDC",
            user_claim="sub")
        ```

        ## Import

        Identity Provider __must__ be imported before using federation_settings_id-idp_id, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/federatedSettingsIdentityProvider:FederatedSettingsIdentityProvider identity_provider 6287a663c660f52b1c441c6c-0oad4fas87jL5Xnk12971234
        ```
        For more information see: [MongoDB Atlas API Reference.](https://www.mongodb.com/docs/atlas/reference/api/federation-configuration/)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] associated_domains: List that contains the domains associated with the identity provider.
        :param pulumi.Input[builtins.str] audience: Identifier of the intended recipient of the token used in OIDC IdP.
        :param pulumi.Input[builtins.str] authorization_type: Indicates whether authorization is granted based on group membership or user ID. Valid values are `GROUP` or `USER`.
        :param pulumi.Input[builtins.str] client_id: Client identifier that is assigned to an application by the OIDC Identity Provider.
        :param pulumi.Input[builtins.str] description: The description of the identity provider.
        :param pulumi.Input[builtins.str] federation_settings_id: Unique 24-hexadecimal digit string that identifies the federated authentication configuration.
        :param pulumi.Input[builtins.str] groups_claim: Identifier of the claim which contains OIDC IdP Group IDs in the token.
        :param pulumi.Input[builtins.str] issuer_uri: Unique string that identifies the issuer of the IdP.
        :param pulumi.Input[builtins.str] name: Human-readable label that identifies the identity provider.
        :param pulumi.Input[builtins.str] protocol: The protocol of the identity provider. Either `SAML` or `OIDC`.
        :param pulumi.Input[builtins.str] request_binding: SAML Authentication Request Protocol HTTP method binding (`POST` or `REDIRECT`) that Federated Authentication uses to send the authentication request. Atlas supports the following binding values:
               - HTTP POST
               - HTTP REDIRECT
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] requested_scopes: Scopes that MongoDB applications will request from the authorization endpoint used for OIDC IdPs.
        :param pulumi.Input[builtins.str] response_signature_algorithm: Signature algorithm that Federated Authentication uses to encrypt the identity provider signature.  Valid values include `SHA-1 `and `SHA-256`.
        :param pulumi.Input[builtins.bool] sso_debug_enabled: Flag that indicates whether the identity provider has SSO debug enabled.
        :param pulumi.Input[builtins.str] sso_url: Unique string that identifies the intended audience of the SAML assertion.
        :param pulumi.Input[builtins.str] status: String enum that indicates whether the identity provider is active or not. Accepted values are ACTIVE or INACTIVE.
        :param pulumi.Input[builtins.str] user_claim: Identifier of the claim which contains the user ID in the token used for OIDC IdPs.
               userClaim is required for OIDC IdP with authorizationType GROUP and USER.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FederatedSettingsIdentityProviderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: FederatedSettingsIdentityProvider

        `FederatedSettingsIdentityProvider` provides an Atlas federated settings identity provider resource provides a subset of settings to be maintained post import of the existing resource.

        ## Example Usage

        > **IMPORTANT** If you want to use a SAML Identity Provider, you **MUST** import this resource before you can manage it with this provider.

        SAML IdP:

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        identity_provider = mongodbatlas.FederatedSettingsIdentityProvider("identity_provider",
            federation_settings_id="627a9687f7f7f7f774de306f14",
            name="mongodb_federation_test",
            associated_domains=["yourdomain.com"],
            sso_debug_enabled=True,
            status="ACTIVE",
            sso_url="https://mysso.oktapreview.com/app/mysso_terraformtestsso/exk17q7f7f7f7f50h8/sso/saml",
            issuer_uri="http://www.okta.com/exk17q7f7f7f7fp50h8",
            request_binding="HTTP-POST",
            response_signature_algorithm="SHA-256")
        ```

        OIDC IdP:

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        oidc = mongodbatlas.FederatedSettingsIdentityProvider("oidc",
            federation_settings_id=this["id"],
            audience=token_audience,
            authorization_type="USER",
            description="oidc",
            issuer_uri=f"https://sts.windows.net/{this_azurerm_user_assigned_identity['tenantId']}/",
            idp_type="WORKLOAD",
            name="OIDC-for-azure",
            protocol="OIDC",
            user_claim="sub")
        ```

        ## Import

        Identity Provider __must__ be imported before using federation_settings_id-idp_id, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/federatedSettingsIdentityProvider:FederatedSettingsIdentityProvider identity_provider 6287a663c660f52b1c441c6c-0oad4fas87jL5Xnk12971234
        ```
        For more information see: [MongoDB Atlas API Reference.](https://www.mongodb.com/docs/atlas/reference/api/federation-configuration/)

        :param str resource_name: The name of the resource.
        :param FederatedSettingsIdentityProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FederatedSettingsIdentityProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associated_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 audience: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_type: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 federation_settings_id: Optional[pulumi.Input[builtins.str]] = None,
                 groups_claim: Optional[pulumi.Input[builtins.str]] = None,
                 idp_type: Optional[pulumi.Input[builtins.str]] = None,
                 issuer_uri: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 request_binding: Optional[pulumi.Input[builtins.str]] = None,
                 requested_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 response_signature_algorithm: Optional[pulumi.Input[builtins.str]] = None,
                 sso_debug_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 sso_url: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 user_claim: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FederatedSettingsIdentityProviderArgs.__new__(FederatedSettingsIdentityProviderArgs)

            __props__.__dict__["associated_domains"] = associated_domains
            __props__.__dict__["audience"] = audience
            __props__.__dict__["authorization_type"] = authorization_type
            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["description"] = description
            if federation_settings_id is None and not opts.urn:
                raise TypeError("Missing required property 'federation_settings_id'")
            __props__.__dict__["federation_settings_id"] = federation_settings_id
            __props__.__dict__["groups_claim"] = groups_claim
            __props__.__dict__["idp_type"] = idp_type
            if issuer_uri is None and not opts.urn:
                raise TypeError("Missing required property 'issuer_uri'")
            __props__.__dict__["issuer_uri"] = issuer_uri
            __props__.__dict__["name"] = name
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["request_binding"] = request_binding
            __props__.__dict__["requested_scopes"] = requested_scopes
            __props__.__dict__["response_signature_algorithm"] = response_signature_algorithm
            __props__.__dict__["sso_debug_enabled"] = sso_debug_enabled
            __props__.__dict__["sso_url"] = sso_url
            __props__.__dict__["status"] = status
            __props__.__dict__["user_claim"] = user_claim
            __props__.__dict__["idp_id"] = None
            __props__.__dict__["okta_idp_id"] = None
        super(FederatedSettingsIdentityProvider, __self__).__init__(
            'mongodbatlas:index/federatedSettingsIdentityProvider:FederatedSettingsIdentityProvider',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            associated_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            audience: Optional[pulumi.Input[builtins.str]] = None,
            authorization_type: Optional[pulumi.Input[builtins.str]] = None,
            client_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            federation_settings_id: Optional[pulumi.Input[builtins.str]] = None,
            groups_claim: Optional[pulumi.Input[builtins.str]] = None,
            idp_id: Optional[pulumi.Input[builtins.str]] = None,
            idp_type: Optional[pulumi.Input[builtins.str]] = None,
            issuer_uri: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            okta_idp_id: Optional[pulumi.Input[builtins.str]] = None,
            protocol: Optional[pulumi.Input[builtins.str]] = None,
            request_binding: Optional[pulumi.Input[builtins.str]] = None,
            requested_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            response_signature_algorithm: Optional[pulumi.Input[builtins.str]] = None,
            sso_debug_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            sso_url: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            user_claim: Optional[pulumi.Input[builtins.str]] = None) -> 'FederatedSettingsIdentityProvider':
        """
        Get an existing FederatedSettingsIdentityProvider resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] associated_domains: List that contains the domains associated with the identity provider.
        :param pulumi.Input[builtins.str] audience: Identifier of the intended recipient of the token used in OIDC IdP.
        :param pulumi.Input[builtins.str] authorization_type: Indicates whether authorization is granted based on group membership or user ID. Valid values are `GROUP` or `USER`.
        :param pulumi.Input[builtins.str] client_id: Client identifier that is assigned to an application by the OIDC Identity Provider.
        :param pulumi.Input[builtins.str] description: The description of the identity provider.
        :param pulumi.Input[builtins.str] federation_settings_id: Unique 24-hexadecimal digit string that identifies the federated authentication configuration.
        :param pulumi.Input[builtins.str] groups_claim: Identifier of the claim which contains OIDC IdP Group IDs in the token.
        :param pulumi.Input[builtins.str] idp_id: Unique 24-hexadecimal digit string that identifies the IdP.
        :param pulumi.Input[builtins.str] issuer_uri: Unique string that identifies the issuer of the IdP.
        :param pulumi.Input[builtins.str] name: Human-readable label that identifies the identity provider.
        :param pulumi.Input[builtins.str] okta_idp_id: Unique 20-hexadecimal digit string that identifies the IdP.
        :param pulumi.Input[builtins.str] protocol: The protocol of the identity provider. Either `SAML` or `OIDC`.
        :param pulumi.Input[builtins.str] request_binding: SAML Authentication Request Protocol HTTP method binding (`POST` or `REDIRECT`) that Federated Authentication uses to send the authentication request. Atlas supports the following binding values:
               - HTTP POST
               - HTTP REDIRECT
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] requested_scopes: Scopes that MongoDB applications will request from the authorization endpoint used for OIDC IdPs.
        :param pulumi.Input[builtins.str] response_signature_algorithm: Signature algorithm that Federated Authentication uses to encrypt the identity provider signature.  Valid values include `SHA-1 `and `SHA-256`.
        :param pulumi.Input[builtins.bool] sso_debug_enabled: Flag that indicates whether the identity provider has SSO debug enabled.
        :param pulumi.Input[builtins.str] sso_url: Unique string that identifies the intended audience of the SAML assertion.
        :param pulumi.Input[builtins.str] status: String enum that indicates whether the identity provider is active or not. Accepted values are ACTIVE or INACTIVE.
        :param pulumi.Input[builtins.str] user_claim: Identifier of the claim which contains the user ID in the token used for OIDC IdPs.
               userClaim is required for OIDC IdP with authorizationType GROUP and USER.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FederatedSettingsIdentityProviderState.__new__(_FederatedSettingsIdentityProviderState)

        __props__.__dict__["associated_domains"] = associated_domains
        __props__.__dict__["audience"] = audience
        __props__.__dict__["authorization_type"] = authorization_type
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["description"] = description
        __props__.__dict__["federation_settings_id"] = federation_settings_id
        __props__.__dict__["groups_claim"] = groups_claim
        __props__.__dict__["idp_id"] = idp_id
        __props__.__dict__["idp_type"] = idp_type
        __props__.__dict__["issuer_uri"] = issuer_uri
        __props__.__dict__["name"] = name
        __props__.__dict__["okta_idp_id"] = okta_idp_id
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["request_binding"] = request_binding
        __props__.__dict__["requested_scopes"] = requested_scopes
        __props__.__dict__["response_signature_algorithm"] = response_signature_algorithm
        __props__.__dict__["sso_debug_enabled"] = sso_debug_enabled
        __props__.__dict__["sso_url"] = sso_url
        __props__.__dict__["status"] = status
        __props__.__dict__["user_claim"] = user_claim
        return FederatedSettingsIdentityProvider(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="associatedDomains")
    def associated_domains(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List that contains the domains associated with the identity provider.
        """
        return pulumi.get(self, "associated_domains")

    @property
    @pulumi.getter
    def audience(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Identifier of the intended recipient of the token used in OIDC IdP.
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Indicates whether authorization is granted based on group membership or user ID. Valid values are `GROUP` or `USER`.
        """
        return pulumi.get(self, "authorization_type")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Client identifier that is assigned to an application by the OIDC Identity Provider.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the identity provider.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="federationSettingsId")
    def federation_settings_id(self) -> pulumi.Output[builtins.str]:
        """
        Unique 24-hexadecimal digit string that identifies the federated authentication configuration.
        """
        return pulumi.get(self, "federation_settings_id")

    @property
    @pulumi.getter(name="groupsClaim")
    def groups_claim(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Identifier of the claim which contains OIDC IdP Group IDs in the token.
        """
        return pulumi.get(self, "groups_claim")

    @property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> pulumi.Output[builtins.str]:
        """
        Unique 24-hexadecimal digit string that identifies the IdP.
        """
        return pulumi.get(self, "idp_id")

    @property
    @pulumi.getter(name="idpType")
    def idp_type(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "idp_type")

    @property
    @pulumi.getter(name="issuerUri")
    def issuer_uri(self) -> pulumi.Output[builtins.str]:
        """
        Unique string that identifies the issuer of the IdP.
        """
        return pulumi.get(self, "issuer_uri")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Human-readable label that identifies the identity provider.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="oktaIdpId")
    def okta_idp_id(self) -> pulumi.Output[builtins.str]:
        """
        Unique 20-hexadecimal digit string that identifies the IdP.
        """
        return pulumi.get(self, "okta_idp_id")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[builtins.str]:
        """
        The protocol of the identity provider. Either `SAML` or `OIDC`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="requestBinding")
    def request_binding(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        SAML Authentication Request Protocol HTTP method binding (`POST` or `REDIRECT`) that Federated Authentication uses to send the authentication request. Atlas supports the following binding values:
        - HTTP POST
        - HTTP REDIRECT
        """
        return pulumi.get(self, "request_binding")

    @property
    @pulumi.getter(name="requestedScopes")
    def requested_scopes(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Scopes that MongoDB applications will request from the authorization endpoint used for OIDC IdPs.
        """
        return pulumi.get(self, "requested_scopes")

    @property
    @pulumi.getter(name="responseSignatureAlgorithm")
    def response_signature_algorithm(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Signature algorithm that Federated Authentication uses to encrypt the identity provider signature.  Valid values include `SHA-1 `and `SHA-256`.
        """
        return pulumi.get(self, "response_signature_algorithm")

    @property
    @pulumi.getter(name="ssoDebugEnabled")
    def sso_debug_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Flag that indicates whether the identity provider has SSO debug enabled.
        """
        return pulumi.get(self, "sso_debug_enabled")

    @property
    @pulumi.getter(name="ssoUrl")
    def sso_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Unique string that identifies the intended audience of the SAML assertion.
        """
        return pulumi.get(self, "sso_url")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        String enum that indicates whether the identity provider is active or not. Accepted values are ACTIVE or INACTIVE.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="userClaim")
    def user_claim(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Identifier of the claim which contains the user ID in the token used for OIDC IdPs.
        userClaim is required for OIDC IdP with authorizationType GROUP and USER.
        """
        return pulumi.get(self, "user_claim")

