# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetAdvancedClusterResult',
    'AwaitableGetAdvancedClusterResult',
    'get_advanced_cluster',
    'get_advanced_cluster_output',
]

@pulumi.output_type
class GetAdvancedClusterResult:
    """
    A collection of values returned by getAdvancedCluster.
    """
    def __init__(__self__, advanced_configurations=None, backup_enabled=None, bi_connector_configs=None, cluster_type=None, config_server_management_mode=None, config_server_type=None, connection_strings=None, create_date=None, disk_size_gb=None, encryption_at_rest_provider=None, global_cluster_self_managed_sharding=None, id=None, labels=None, mongo_db_major_version=None, mongo_db_version=None, name=None, paused=None, pinned_fcvs=None, pit_enabled=None, project_id=None, redact_client_log_data=None, replica_set_scaling_strategy=None, replication_specs=None, root_cert_type=None, state_name=None, tags=None, termination_protection_enabled=None, use_replication_spec_per_shard=None, version_release_system=None):
        if advanced_configurations and not isinstance(advanced_configurations, list):
            raise TypeError("Expected argument 'advanced_configurations' to be a list")
        pulumi.set(__self__, "advanced_configurations", advanced_configurations)
        if backup_enabled and not isinstance(backup_enabled, bool):
            raise TypeError("Expected argument 'backup_enabled' to be a bool")
        pulumi.set(__self__, "backup_enabled", backup_enabled)
        if bi_connector_configs and not isinstance(bi_connector_configs, list):
            raise TypeError("Expected argument 'bi_connector_configs' to be a list")
        pulumi.set(__self__, "bi_connector_configs", bi_connector_configs)
        if cluster_type and not isinstance(cluster_type, str):
            raise TypeError("Expected argument 'cluster_type' to be a str")
        pulumi.set(__self__, "cluster_type", cluster_type)
        if config_server_management_mode and not isinstance(config_server_management_mode, str):
            raise TypeError("Expected argument 'config_server_management_mode' to be a str")
        pulumi.set(__self__, "config_server_management_mode", config_server_management_mode)
        if config_server_type and not isinstance(config_server_type, str):
            raise TypeError("Expected argument 'config_server_type' to be a str")
        pulumi.set(__self__, "config_server_type", config_server_type)
        if connection_strings and not isinstance(connection_strings, list):
            raise TypeError("Expected argument 'connection_strings' to be a list")
        pulumi.set(__self__, "connection_strings", connection_strings)
        if create_date and not isinstance(create_date, str):
            raise TypeError("Expected argument 'create_date' to be a str")
        pulumi.set(__self__, "create_date", create_date)
        if disk_size_gb and not isinstance(disk_size_gb, float):
            raise TypeError("Expected argument 'disk_size_gb' to be a float")
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if encryption_at_rest_provider and not isinstance(encryption_at_rest_provider, str):
            raise TypeError("Expected argument 'encryption_at_rest_provider' to be a str")
        pulumi.set(__self__, "encryption_at_rest_provider", encryption_at_rest_provider)
        if global_cluster_self_managed_sharding and not isinstance(global_cluster_self_managed_sharding, bool):
            raise TypeError("Expected argument 'global_cluster_self_managed_sharding' to be a bool")
        pulumi.set(__self__, "global_cluster_self_managed_sharding", global_cluster_self_managed_sharding)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, list):
            raise TypeError("Expected argument 'labels' to be a list")
        pulumi.set(__self__, "labels", labels)
        if mongo_db_major_version and not isinstance(mongo_db_major_version, str):
            raise TypeError("Expected argument 'mongo_db_major_version' to be a str")
        pulumi.set(__self__, "mongo_db_major_version", mongo_db_major_version)
        if mongo_db_version and not isinstance(mongo_db_version, str):
            raise TypeError("Expected argument 'mongo_db_version' to be a str")
        pulumi.set(__self__, "mongo_db_version", mongo_db_version)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if paused and not isinstance(paused, bool):
            raise TypeError("Expected argument 'paused' to be a bool")
        pulumi.set(__self__, "paused", paused)
        if pinned_fcvs and not isinstance(pinned_fcvs, list):
            raise TypeError("Expected argument 'pinned_fcvs' to be a list")
        pulumi.set(__self__, "pinned_fcvs", pinned_fcvs)
        if pit_enabled and not isinstance(pit_enabled, bool):
            raise TypeError("Expected argument 'pit_enabled' to be a bool")
        pulumi.set(__self__, "pit_enabled", pit_enabled)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if redact_client_log_data and not isinstance(redact_client_log_data, bool):
            raise TypeError("Expected argument 'redact_client_log_data' to be a bool")
        pulumi.set(__self__, "redact_client_log_data", redact_client_log_data)
        if replica_set_scaling_strategy and not isinstance(replica_set_scaling_strategy, str):
            raise TypeError("Expected argument 'replica_set_scaling_strategy' to be a str")
        pulumi.set(__self__, "replica_set_scaling_strategy", replica_set_scaling_strategy)
        if replication_specs and not isinstance(replication_specs, list):
            raise TypeError("Expected argument 'replication_specs' to be a list")
        pulumi.set(__self__, "replication_specs", replication_specs)
        if root_cert_type and not isinstance(root_cert_type, str):
            raise TypeError("Expected argument 'root_cert_type' to be a str")
        pulumi.set(__self__, "root_cert_type", root_cert_type)
        if state_name and not isinstance(state_name, str):
            raise TypeError("Expected argument 'state_name' to be a str")
        pulumi.set(__self__, "state_name", state_name)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if termination_protection_enabled and not isinstance(termination_protection_enabled, bool):
            raise TypeError("Expected argument 'termination_protection_enabled' to be a bool")
        pulumi.set(__self__, "termination_protection_enabled", termination_protection_enabled)
        if use_replication_spec_per_shard and not isinstance(use_replication_spec_per_shard, bool):
            raise TypeError("Expected argument 'use_replication_spec_per_shard' to be a bool")
        pulumi.set(__self__, "use_replication_spec_per_shard", use_replication_spec_per_shard)
        if version_release_system and not isinstance(version_release_system, str):
            raise TypeError("Expected argument 'version_release_system' to be a str")
        pulumi.set(__self__, "version_release_system", version_release_system)

    @property
    @pulumi.getter(name="advancedConfigurations")
    def advanced_configurations(self) -> Sequence['outputs.GetAdvancedClusterAdvancedConfigurationResult']:
        """
        Get the advanced configuration options. See Advanced Configuration below for more details.
        """
        return pulumi.get(self, "advanced_configurations")

    @property
    @pulumi.getter(name="backupEnabled")
    def backup_enabled(self) -> builtins.bool:
        return pulumi.get(self, "backup_enabled")

    @property
    @pulumi.getter(name="biConnectorConfigs")
    def bi_connector_configs(self) -> Sequence['outputs.GetAdvancedClusterBiConnectorConfigResult']:
        return pulumi.get(self, "bi_connector_configs")

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> builtins.str:
        """
        Type of the cluster that you want to create.
        """
        return pulumi.get(self, "cluster_type")

    @property
    @pulumi.getter(name="configServerManagementMode")
    def config_server_management_mode(self) -> builtins.str:
        """
        Config Server Management Mode for creating or updating a sharded cluster. Valid values are `ATLAS_MANAGED` (default) and `FIXED_TO_DEDICATED`. When configured as `ATLAS_MANAGED`, Atlas may automatically switch the cluster's config server type for optimal performance and savings. When configured as `FIXED_TO_DEDICATED`, the cluster will always use a dedicated config server. To learn more, see the [Sharded Cluster Config Servers documentation](https://dochub.mongodb.org/docs/manual/core/sharded-cluster-config-servers/).
        """
        return pulumi.get(self, "config_server_management_mode")

    @property
    @pulumi.getter(name="configServerType")
    def config_server_type(self) -> builtins.str:
        """
        Describes a sharded cluster's config server type. Valid values are `DEDICATED` and `EMBEDDED`. To learn more, see the [Sharded Cluster Config Servers documentation](https://dochub.mongodb.org/docs/manual/core/sharded-cluster-config-servers/).
        """
        return pulumi.get(self, "config_server_type")

    @property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Sequence['outputs.GetAdvancedClusterConnectionStringResult']:
        """
        Set of connection strings that your applications use to connect to this cluster. More information in [Connection-strings](https://docs.mongodb.com/manual/reference/connection-string/). Use the parameters in this object to connect your applications to this cluster. To learn more about the formats of connection strings, see [Connection String Options](https://docs.atlas.mongodb.com/reference/faq/connection-changes/). NOTE: Atlas returns the contents of this object after the cluster is operational, not while it builds the cluster.
        """
        return pulumi.get(self, "connection_strings")

    @property
    @pulumi.getter(name="createDate")
    def create_date(self) -> builtins.str:
        return pulumi.get(self, "create_date")

    @property
    @pulumi.getter(name="diskSizeGb")
    @_utilities.deprecated("""This parameter is deprecated. Please refer to our examples, documentation, and 1.18.0 migration guide for more details at https://registry.terraform.io/providers/mongodb/mongodbatlas/latest/docs/guides/1.18.0-upgrade-guide""")
    def disk_size_gb(self) -> builtins.float:
        """
        Storage capacity that the host's root volume possesses expressed in gigabytes. If disk size specified is below the minimum (10 GB), this parameter defaults to the minimum disk size value. Storage charge calculations depend on whether you choose the default value or a custom value.  The maximum value for disk storage cannot exceed 50 times the maximum RAM for the selected cluster. If you require more storage space, consider upgrading your cluster to a higher tier.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="encryptionAtRestProvider")
    def encryption_at_rest_provider(self) -> builtins.str:
        """
        Possible values are AWS, GCP, AZURE or NONE.
        """
        return pulumi.get(self, "encryption_at_rest_provider")

    @property
    @pulumi.getter(name="globalClusterSelfManagedSharding")
    def global_cluster_self_managed_sharding(self) -> builtins.bool:
        """
        Flag that indicates if cluster uses Atlas-Managed Sharding (false) or Self-Managed Sharding (true).
        """
        return pulumi.get(self, "global_cluster_self_managed_sharding")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Sequence['outputs.GetAdvancedClusterLabelResult']:
        """
        Set that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the cluster. See below. **(DEPRECATED)** Use `tags` instead.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="mongoDbMajorVersion")
    def mongo_db_major_version(self) -> builtins.str:
        """
        Version of the cluster to deploy.
        """
        return pulumi.get(self, "mongo_db_major_version")

    @property
    @pulumi.getter(name="mongoDbVersion")
    def mongo_db_version(self) -> builtins.str:
        """
        Version of MongoDB the cluster runs, in `major-version`.`minor-version` format.
        """
        return pulumi.get(self, "mongo_db_version")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def paused(self) -> builtins.bool:
        """
        Flag that indicates whether the cluster is paused or not.
        """
        return pulumi.get(self, "paused")

    @property
    @pulumi.getter(name="pinnedFcvs")
    def pinned_fcvs(self) -> Sequence['outputs.GetAdvancedClusterPinnedFcvResult']:
        """
        The pinned Feature Compatibility Version (FCV) with its associated expiration date. See below.
        """
        return pulumi.get(self, "pinned_fcvs")

    @property
    @pulumi.getter(name="pitEnabled")
    def pit_enabled(self) -> builtins.bool:
        """
        Flag that indicates if the cluster uses Continuous Cloud Backup.
        """
        return pulumi.get(self, "pit_enabled")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="redactClientLogData")
    def redact_client_log_data(self) -> builtins.bool:
        """
        (Optional) Flag that enables or disables log redaction, see the [manual](https://www.mongodb.com/docs/manual/administration/monitoring/#log-redaction) for more information.
        """
        return pulumi.get(self, "redact_client_log_data")

    @property
    @pulumi.getter(name="replicaSetScalingStrategy")
    def replica_set_scaling_strategy(self) -> builtins.str:
        """
        (Optional) Replica set scaling mode for your cluster.
        """
        return pulumi.get(self, "replica_set_scaling_strategy")

    @property
    @pulumi.getter(name="replicationSpecs")
    def replication_specs(self) -> Sequence['outputs.GetAdvancedClusterReplicationSpecResult']:
        """
        List of settings that configure your cluster regions. If `use_replication_spec_per_shard = true`, this array has one object per shard representing node configurations in each shard. For replica sets there is only one object representing node configurations. See below.
        """
        return pulumi.get(self, "replication_specs")

    @property
    @pulumi.getter(name="rootCertType")
    def root_cert_type(self) -> builtins.str:
        """
        Certificate Authority that MongoDB Atlas clusters use.
        """
        return pulumi.get(self, "root_cert_type")

    @property
    @pulumi.getter(name="stateName")
    def state_name(self) -> builtins.str:
        """
        Current state of the cluster. The possible states are:
        """
        return pulumi.get(self, "state_name")

    @property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetAdvancedClusterTagResult']:
        """
        Set that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the cluster. See below.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="terminationProtectionEnabled")
    def termination_protection_enabled(self) -> builtins.bool:
        """
        Flag that indicates whether termination protection is enabled on the cluster. If set to true, MongoDB Cloud won't delete the cluster. If set to false, MongoDB Cloud will delete the cluster.
        """
        return pulumi.get(self, "termination_protection_enabled")

    @property
    @pulumi.getter(name="useReplicationSpecPerShard")
    def use_replication_spec_per_shard(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "use_replication_spec_per_shard")

    @property
    @pulumi.getter(name="versionReleaseSystem")
    def version_release_system(self) -> builtins.str:
        """
        Release cadence that Atlas uses for this cluster.
        """
        return pulumi.get(self, "version_release_system")


class AwaitableGetAdvancedClusterResult(GetAdvancedClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAdvancedClusterResult(
            advanced_configurations=self.advanced_configurations,
            backup_enabled=self.backup_enabled,
            bi_connector_configs=self.bi_connector_configs,
            cluster_type=self.cluster_type,
            config_server_management_mode=self.config_server_management_mode,
            config_server_type=self.config_server_type,
            connection_strings=self.connection_strings,
            create_date=self.create_date,
            disk_size_gb=self.disk_size_gb,
            encryption_at_rest_provider=self.encryption_at_rest_provider,
            global_cluster_self_managed_sharding=self.global_cluster_self_managed_sharding,
            id=self.id,
            labels=self.labels,
            mongo_db_major_version=self.mongo_db_major_version,
            mongo_db_version=self.mongo_db_version,
            name=self.name,
            paused=self.paused,
            pinned_fcvs=self.pinned_fcvs,
            pit_enabled=self.pit_enabled,
            project_id=self.project_id,
            redact_client_log_data=self.redact_client_log_data,
            replica_set_scaling_strategy=self.replica_set_scaling_strategy,
            replication_specs=self.replication_specs,
            root_cert_type=self.root_cert_type,
            state_name=self.state_name,
            tags=self.tags,
            termination_protection_enabled=self.termination_protection_enabled,
            use_replication_spec_per_shard=self.use_replication_spec_per_shard,
            version_release_system=self.version_release_system)


def get_advanced_cluster(name: Optional[builtins.str] = None,
                         pit_enabled: Optional[builtins.bool] = None,
                         project_id: Optional[builtins.str] = None,
                         use_replication_spec_per_shard: Optional[builtins.bool] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAdvancedClusterResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    example_advanced_cluster = mongodbatlas.AdvancedCluster("example",
        project_id="<YOUR-PROJECT-ID>",
        name="cluster-test",
        cluster_type="REPLICASET",
        replication_specs=[{
            "region_configs": [{
                "electable_specs": {
                    "instance_size": "M0",
                },
                "provider_name": "TENANT",
                "backing_provider_name": "AWS",
                "region_name": "US_EAST_1",
                "priority": 7,
            }],
        }])
    example = mongodbatlas.get_advanced_cluster_output(project_id=example_advanced_cluster.project_id,
        name=example_advanced_cluster.name)
    ```

    ## Example using latest sharding configurations with independent shard scaling in the cluster

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    example_advanced_cluster = mongodbatlas.AdvancedCluster("example",
        project_id="<YOUR-PROJECT-ID>",
        name="cluster-test",
        backup_enabled=False,
        cluster_type="SHARDED",
        replication_specs=[
            {
                "region_configs": [{
                    "electable_specs": {
                        "instance_size": "M30",
                        "disk_iops": 3000,
                        "node_count": 3,
                    },
                    "provider_name": "AWS",
                    "priority": 7,
                    "region_name": "EU_WEST_1",
                }],
            },
            {
                "region_configs": [{
                    "electable_specs": {
                        "instance_size": "M40",
                        "disk_iops": 3000,
                        "node_count": 3,
                    },
                    "provider_name": "AWS",
                    "priority": 7,
                    "region_name": "EU_WEST_1",
                }],
            },
        ])
    example = mongodbatlas.get_advanced_cluster_output(project_id=example_advanced_cluster.project_id,
        name=example_advanced_cluster.name,
        use_replication_spec_per_shard=True)
    ```

    ## Example using Flex cluster

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    example_flex = mongodbatlas.AdvancedCluster("example-flex",
        project_id="<YOUR-PROJECT-ID>",
        name="flex-cluster",
        cluster_type="REPLICASET",
        replication_specs=[{
            "region_configs": [{
                "provider_name": "FLEX",
                "backing_provider_name": "AWS",
                "region_name": "US_EAST_1",
                "priority": 7,
            }],
        }])
    example = mongodbatlas.get_advanced_cluster_output(project_id=example_flex.project_id,
        name=example_flex.name)
    ```


    :param builtins.str name: Name of the cluster as it appears in Atlas. Once the cluster is created, its name cannot be changed.
    :param builtins.bool pit_enabled: Flag that indicates if the cluster uses Continuous Cloud Backup.
    :param builtins.str project_id: The unique ID for the project to create the cluster.
    :param builtins.bool use_replication_spec_per_shard: Set this field to true to allow the data source to use the latest schema representing each shard with an individual `replication_specs` object. This enables representing clusters with independent shard scaling.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['pitEnabled'] = pit_enabled
    __args__['projectId'] = project_id
    __args__['useReplicationSpecPerShard'] = use_replication_spec_per_shard
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getAdvancedCluster:getAdvancedCluster', __args__, opts=opts, typ=GetAdvancedClusterResult).value

    return AwaitableGetAdvancedClusterResult(
        advanced_configurations=pulumi.get(__ret__, 'advanced_configurations'),
        backup_enabled=pulumi.get(__ret__, 'backup_enabled'),
        bi_connector_configs=pulumi.get(__ret__, 'bi_connector_configs'),
        cluster_type=pulumi.get(__ret__, 'cluster_type'),
        config_server_management_mode=pulumi.get(__ret__, 'config_server_management_mode'),
        config_server_type=pulumi.get(__ret__, 'config_server_type'),
        connection_strings=pulumi.get(__ret__, 'connection_strings'),
        create_date=pulumi.get(__ret__, 'create_date'),
        disk_size_gb=pulumi.get(__ret__, 'disk_size_gb'),
        encryption_at_rest_provider=pulumi.get(__ret__, 'encryption_at_rest_provider'),
        global_cluster_self_managed_sharding=pulumi.get(__ret__, 'global_cluster_self_managed_sharding'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        mongo_db_major_version=pulumi.get(__ret__, 'mongo_db_major_version'),
        mongo_db_version=pulumi.get(__ret__, 'mongo_db_version'),
        name=pulumi.get(__ret__, 'name'),
        paused=pulumi.get(__ret__, 'paused'),
        pinned_fcvs=pulumi.get(__ret__, 'pinned_fcvs'),
        pit_enabled=pulumi.get(__ret__, 'pit_enabled'),
        project_id=pulumi.get(__ret__, 'project_id'),
        redact_client_log_data=pulumi.get(__ret__, 'redact_client_log_data'),
        replica_set_scaling_strategy=pulumi.get(__ret__, 'replica_set_scaling_strategy'),
        replication_specs=pulumi.get(__ret__, 'replication_specs'),
        root_cert_type=pulumi.get(__ret__, 'root_cert_type'),
        state_name=pulumi.get(__ret__, 'state_name'),
        tags=pulumi.get(__ret__, 'tags'),
        termination_protection_enabled=pulumi.get(__ret__, 'termination_protection_enabled'),
        use_replication_spec_per_shard=pulumi.get(__ret__, 'use_replication_spec_per_shard'),
        version_release_system=pulumi.get(__ret__, 'version_release_system'))
def get_advanced_cluster_output(name: Optional[pulumi.Input[builtins.str]] = None,
                                pit_enabled: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                project_id: Optional[pulumi.Input[builtins.str]] = None,
                                use_replication_spec_per_shard: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAdvancedClusterResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    example_advanced_cluster = mongodbatlas.AdvancedCluster("example",
        project_id="<YOUR-PROJECT-ID>",
        name="cluster-test",
        cluster_type="REPLICASET",
        replication_specs=[{
            "region_configs": [{
                "electable_specs": {
                    "instance_size": "M0",
                },
                "provider_name": "TENANT",
                "backing_provider_name": "AWS",
                "region_name": "US_EAST_1",
                "priority": 7,
            }],
        }])
    example = mongodbatlas.get_advanced_cluster_output(project_id=example_advanced_cluster.project_id,
        name=example_advanced_cluster.name)
    ```

    ## Example using latest sharding configurations with independent shard scaling in the cluster

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    example_advanced_cluster = mongodbatlas.AdvancedCluster("example",
        project_id="<YOUR-PROJECT-ID>",
        name="cluster-test",
        backup_enabled=False,
        cluster_type="SHARDED",
        replication_specs=[
            {
                "region_configs": [{
                    "electable_specs": {
                        "instance_size": "M30",
                        "disk_iops": 3000,
                        "node_count": 3,
                    },
                    "provider_name": "AWS",
                    "priority": 7,
                    "region_name": "EU_WEST_1",
                }],
            },
            {
                "region_configs": [{
                    "electable_specs": {
                        "instance_size": "M40",
                        "disk_iops": 3000,
                        "node_count": 3,
                    },
                    "provider_name": "AWS",
                    "priority": 7,
                    "region_name": "EU_WEST_1",
                }],
            },
        ])
    example = mongodbatlas.get_advanced_cluster_output(project_id=example_advanced_cluster.project_id,
        name=example_advanced_cluster.name,
        use_replication_spec_per_shard=True)
    ```

    ## Example using Flex cluster

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    example_flex = mongodbatlas.AdvancedCluster("example-flex",
        project_id="<YOUR-PROJECT-ID>",
        name="flex-cluster",
        cluster_type="REPLICASET",
        replication_specs=[{
            "region_configs": [{
                "provider_name": "FLEX",
                "backing_provider_name": "AWS",
                "region_name": "US_EAST_1",
                "priority": 7,
            }],
        }])
    example = mongodbatlas.get_advanced_cluster_output(project_id=example_flex.project_id,
        name=example_flex.name)
    ```


    :param builtins.str name: Name of the cluster as it appears in Atlas. Once the cluster is created, its name cannot be changed.
    :param builtins.bool pit_enabled: Flag that indicates if the cluster uses Continuous Cloud Backup.
    :param builtins.str project_id: The unique ID for the project to create the cluster.
    :param builtins.bool use_replication_spec_per_shard: Set this field to true to allow the data source to use the latest schema representing each shard with an individual `replication_specs` object. This enables representing clusters with independent shard scaling.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['pitEnabled'] = pit_enabled
    __args__['projectId'] = project_id
    __args__['useReplicationSpecPerShard'] = use_replication_spec_per_shard
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('mongodbatlas:index/getAdvancedCluster:getAdvancedCluster', __args__, opts=opts, typ=GetAdvancedClusterResult)
    return __ret__.apply(lambda __response__: GetAdvancedClusterResult(
        advanced_configurations=pulumi.get(__response__, 'advanced_configurations'),
        backup_enabled=pulumi.get(__response__, 'backup_enabled'),
        bi_connector_configs=pulumi.get(__response__, 'bi_connector_configs'),
        cluster_type=pulumi.get(__response__, 'cluster_type'),
        config_server_management_mode=pulumi.get(__response__, 'config_server_management_mode'),
        config_server_type=pulumi.get(__response__, 'config_server_type'),
        connection_strings=pulumi.get(__response__, 'connection_strings'),
        create_date=pulumi.get(__response__, 'create_date'),
        disk_size_gb=pulumi.get(__response__, 'disk_size_gb'),
        encryption_at_rest_provider=pulumi.get(__response__, 'encryption_at_rest_provider'),
        global_cluster_self_managed_sharding=pulumi.get(__response__, 'global_cluster_self_managed_sharding'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        mongo_db_major_version=pulumi.get(__response__, 'mongo_db_major_version'),
        mongo_db_version=pulumi.get(__response__, 'mongo_db_version'),
        name=pulumi.get(__response__, 'name'),
        paused=pulumi.get(__response__, 'paused'),
        pinned_fcvs=pulumi.get(__response__, 'pinned_fcvs'),
        pit_enabled=pulumi.get(__response__, 'pit_enabled'),
        project_id=pulumi.get(__response__, 'project_id'),
        redact_client_log_data=pulumi.get(__response__, 'redact_client_log_data'),
        replica_set_scaling_strategy=pulumi.get(__response__, 'replica_set_scaling_strategy'),
        replication_specs=pulumi.get(__response__, 'replication_specs'),
        root_cert_type=pulumi.get(__response__, 'root_cert_type'),
        state_name=pulumi.get(__response__, 'state_name'),
        tags=pulumi.get(__response__, 'tags'),
        termination_protection_enabled=pulumi.get(__response__, 'termination_protection_enabled'),
        use_replication_spec_per_shard=pulumi.get(__response__, 'use_replication_spec_per_shard'),
        version_release_system=pulumi.get(__response__, 'version_release_system')))
