# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAlertConfigurationsResult',
    'AwaitableGetAlertConfigurationsResult',
    'get_alert_configurations',
    'get_alert_configurations_output',
]

@pulumi.output_type
class GetAlertConfigurationsResult:
    """
    A collection of values returned by getAlertConfigurations.
    """
    def __init__(__self__, id=None, list_options=None, output_types=None, project_id=None, results=None, total_count=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if list_options and not isinstance(list_options, list):
            raise TypeError("Expected argument 'list_options' to be a list")
        pulumi.set(__self__, "list_options", list_options)
        if output_types and not isinstance(output_types, list):
            raise TypeError("Expected argument 'output_types' to be a list")
        pulumi.set(__self__, "output_types", output_types)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="listOptions")
    def list_options(self) -> Optional[Sequence['outputs.GetAlertConfigurationsListOptionResult']]:
        return pulumi.get(self, "list_options")

    @property
    @pulumi.getter(name="outputTypes")
    def output_types(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "output_types")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        The ID of the project where the alert configuration exists
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetAlertConfigurationsResultResult']:
        """
        A list of alert configurations for the project_id, constrained by the `list_options`.
        """
        return pulumi.get(self, "results")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> builtins.int:
        """
        Total count of results
        """
        return pulumi.get(self, "total_count")


class AwaitableGetAlertConfigurationsResult(GetAlertConfigurationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlertConfigurationsResult(
            id=self.id,
            list_options=self.list_options,
            output_types=self.output_types,
            project_id=self.project_id,
            results=self.results,
            total_count=self.total_count)


def get_alert_configurations(list_options: Optional[Sequence[Union['GetAlertConfigurationsListOptionArgs', 'GetAlertConfigurationsListOptionArgsDict']]] = None,
                             output_types: Optional[Sequence[builtins.str]] = None,
                             project_id: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlertConfigurationsResult:
    """
    ## # Data Source: get_alert_configurations

    `get_alert_configurations` describes all Alert Configurations by the provided project_id. The data source requires your Project ID.

    > **NOTE:** Groups and projects are synonymous terms. You may find group_id in the official documentation.


    :param Sequence[Union['GetAlertConfigurationsListOptionArgs', 'GetAlertConfigurationsListOptionArgsDict']] list_options: Arguments that dictate how many and which results are returned by the data source
           * `list_options.page_num` - Which page of results to retrieve (default to first page)
           * `list_options.items_per_page` - How many alerts to retrieve per page (default 100)
           * `list_options.include_count` - Whether to include total count of results in the response (default false)
    :param Sequence[builtins.str] output_types: List of requested string formatted output to be included on each individual result. Options are `resource_hcl` and `resource_import`. Available to make it easy to gather resource statements for existing alert configurations, and corresponding import statements to import said resource state into the statefile.
    :param builtins.str project_id: The unique ID for the project to get the alert configurations.
    """
    __args__ = dict()
    __args__['listOptions'] = list_options
    __args__['outputTypes'] = output_types
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getAlertConfigurations:getAlertConfigurations', __args__, opts=opts, typ=GetAlertConfigurationsResult).value

    return AwaitableGetAlertConfigurationsResult(
        id=pulumi.get(__ret__, 'id'),
        list_options=pulumi.get(__ret__, 'list_options'),
        output_types=pulumi.get(__ret__, 'output_types'),
        project_id=pulumi.get(__ret__, 'project_id'),
        results=pulumi.get(__ret__, 'results'),
        total_count=pulumi.get(__ret__, 'total_count'))
def get_alert_configurations_output(list_options: Optional[pulumi.Input[Optional[Sequence[Union['GetAlertConfigurationsListOptionArgs', 'GetAlertConfigurationsListOptionArgsDict']]]]] = None,
                                    output_types: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                    project_id: Optional[pulumi.Input[builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAlertConfigurationsResult]:
    """
    ## # Data Source: get_alert_configurations

    `get_alert_configurations` describes all Alert Configurations by the provided project_id. The data source requires your Project ID.

    > **NOTE:** Groups and projects are synonymous terms. You may find group_id in the official documentation.


    :param Sequence[Union['GetAlertConfigurationsListOptionArgs', 'GetAlertConfigurationsListOptionArgsDict']] list_options: Arguments that dictate how many and which results are returned by the data source
           * `list_options.page_num` - Which page of results to retrieve (default to first page)
           * `list_options.items_per_page` - How many alerts to retrieve per page (default 100)
           * `list_options.include_count` - Whether to include total count of results in the response (default false)
    :param Sequence[builtins.str] output_types: List of requested string formatted output to be included on each individual result. Options are `resource_hcl` and `resource_import`. Available to make it easy to gather resource statements for existing alert configurations, and corresponding import statements to import said resource state into the statefile.
    :param builtins.str project_id: The unique ID for the project to get the alert configurations.
    """
    __args__ = dict()
    __args__['listOptions'] = list_options
    __args__['outputTypes'] = output_types
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('mongodbatlas:index/getAlertConfigurations:getAlertConfigurations', __args__, opts=opts, typ=GetAlertConfigurationsResult)
    return __ret__.apply(lambda __response__: GetAlertConfigurationsResult(
        id=pulumi.get(__response__, 'id'),
        list_options=pulumi.get(__response__, 'list_options'),
        output_types=pulumi.get(__response__, 'output_types'),
        project_id=pulumi.get(__response__, 'project_id'),
        results=pulumi.get(__response__, 'results'),
        total_count=pulumi.get(__response__, 'total_count')))
