# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetFlexClusterResult',
    'AwaitableGetFlexClusterResult',
    'get_flex_cluster',
    'get_flex_cluster_output',
]

@pulumi.output_type
class GetFlexClusterResult:
    """
    A collection of values returned by getFlexCluster.
    """
    def __init__(__self__, backup_settings=None, cluster_type=None, connection_strings=None, create_date=None, id=None, mongo_db_version=None, name=None, project_id=None, provider_settings=None, state_name=None, tags=None, termination_protection_enabled=None, version_release_system=None):
        if backup_settings and not isinstance(backup_settings, dict):
            raise TypeError("Expected argument 'backup_settings' to be a dict")
        pulumi.set(__self__, "backup_settings", backup_settings)
        if cluster_type and not isinstance(cluster_type, str):
            raise TypeError("Expected argument 'cluster_type' to be a str")
        pulumi.set(__self__, "cluster_type", cluster_type)
        if connection_strings and not isinstance(connection_strings, dict):
            raise TypeError("Expected argument 'connection_strings' to be a dict")
        pulumi.set(__self__, "connection_strings", connection_strings)
        if create_date and not isinstance(create_date, str):
            raise TypeError("Expected argument 'create_date' to be a str")
        pulumi.set(__self__, "create_date", create_date)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if mongo_db_version and not isinstance(mongo_db_version, str):
            raise TypeError("Expected argument 'mongo_db_version' to be a str")
        pulumi.set(__self__, "mongo_db_version", mongo_db_version)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if provider_settings and not isinstance(provider_settings, dict):
            raise TypeError("Expected argument 'provider_settings' to be a dict")
        pulumi.set(__self__, "provider_settings", provider_settings)
        if state_name and not isinstance(state_name, str):
            raise TypeError("Expected argument 'state_name' to be a str")
        pulumi.set(__self__, "state_name", state_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if termination_protection_enabled and not isinstance(termination_protection_enabled, bool):
            raise TypeError("Expected argument 'termination_protection_enabled' to be a bool")
        pulumi.set(__self__, "termination_protection_enabled", termination_protection_enabled)
        if version_release_system and not isinstance(version_release_system, str):
            raise TypeError("Expected argument 'version_release_system' to be a str")
        pulumi.set(__self__, "version_release_system", version_release_system)

    @property
    @pulumi.getter(name="backupSettings")
    def backup_settings(self) -> 'outputs.GetFlexClusterBackupSettingsResult':
        """
        Flex backup configuration
        """
        return pulumi.get(self, "backup_settings")

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> builtins.str:
        """
        Flex cluster topology.
        """
        return pulumi.get(self, "cluster_type")

    @property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> 'outputs.GetFlexClusterConnectionStringsResult':
        """
        Collection of Uniform Resource Locators that point to the MongoDB database.
        """
        return pulumi.get(self, "connection_strings")

    @property
    @pulumi.getter(name="createDate")
    def create_date(self) -> builtins.str:
        """
        Date and time when MongoDB Cloud created this instance. This parameter expresses its value in ISO 8601 format in UTC.
        """
        return pulumi.get(self, "create_date")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Unique 24-hexadecimal digit string that identifies the instance.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="mongoDbVersion")
    def mongo_db_version(self) -> builtins.str:
        """
        Version of MongoDB that the instance runs.
        """
        return pulumi.get(self, "mongo_db_version")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Human-readable label that identifies the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        Unique 24-hexadecimal character string that identifies the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="providerSettings")
    def provider_settings(self) -> 'outputs.GetFlexClusterProviderSettingsResult':
        """
        Group of cloud provider settings that configure the provisioned MongoDB flex cluster.
        """
        return pulumi.get(self, "provider_settings")

    @property
    @pulumi.getter(name="stateName")
    def state_name(self) -> builtins.str:
        """
        Human-readable label that indicates the current operating condition of this instance.
        """
        return pulumi.get(self, "state_name")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Map that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the instance.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="terminationProtectionEnabled")
    def termination_protection_enabled(self) -> builtins.bool:
        """
        Flag that indicates whether termination protection is enabled on the cluster. If set to `true`, MongoDB Cloud won't delete the cluster. If set to `false`, MongoDB Cloud will delete the cluster.
        """
        return pulumi.get(self, "termination_protection_enabled")

    @property
    @pulumi.getter(name="versionReleaseSystem")
    def version_release_system(self) -> builtins.str:
        """
        Method by which the cluster maintains the MongoDB versions.
        """
        return pulumi.get(self, "version_release_system")


class AwaitableGetFlexClusterResult(GetFlexClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlexClusterResult(
            backup_settings=self.backup_settings,
            cluster_type=self.cluster_type,
            connection_strings=self.connection_strings,
            create_date=self.create_date,
            id=self.id,
            mongo_db_version=self.mongo_db_version,
            name=self.name,
            project_id=self.project_id,
            provider_settings=self.provider_settings,
            state_name=self.state_name,
            tags=self.tags,
            termination_protection_enabled=self.termination_protection_enabled,
            version_release_system=self.version_release_system)


def get_flex_cluster(name: Optional[builtins.str] = None,
                     project_id: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlexClusterResult:
    """
    ## # Data Source: FlexCluster

    `FlexCluster` describes a flex cluster.

    **RECOMMENDATION:** We recommend using the `AdvancedCluster` data source instead of `FlexCluster` data source to retrieve Flex clusters. The `AdvancedCluster` data source not only supports Flex clusters, but also supports free and dedicated clusters, providing easier migration between different cluster types. For more information, see the Advanced Cluster data source.

    ## Example Usage


    :param builtins.str name: Human-readable label that identifies the instance.
    :param builtins.str project_id: Unique 24-hexadecimal character string that identifies the project.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getFlexCluster:getFlexCluster', __args__, opts=opts, typ=GetFlexClusterResult).value

    return AwaitableGetFlexClusterResult(
        backup_settings=pulumi.get(__ret__, 'backup_settings'),
        cluster_type=pulumi.get(__ret__, 'cluster_type'),
        connection_strings=pulumi.get(__ret__, 'connection_strings'),
        create_date=pulumi.get(__ret__, 'create_date'),
        id=pulumi.get(__ret__, 'id'),
        mongo_db_version=pulumi.get(__ret__, 'mongo_db_version'),
        name=pulumi.get(__ret__, 'name'),
        project_id=pulumi.get(__ret__, 'project_id'),
        provider_settings=pulumi.get(__ret__, 'provider_settings'),
        state_name=pulumi.get(__ret__, 'state_name'),
        tags=pulumi.get(__ret__, 'tags'),
        termination_protection_enabled=pulumi.get(__ret__, 'termination_protection_enabled'),
        version_release_system=pulumi.get(__ret__, 'version_release_system'))
def get_flex_cluster_output(name: Optional[pulumi.Input[builtins.str]] = None,
                            project_id: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFlexClusterResult]:
    """
    ## # Data Source: FlexCluster

    `FlexCluster` describes a flex cluster.

    **RECOMMENDATION:** We recommend using the `AdvancedCluster` data source instead of `FlexCluster` data source to retrieve Flex clusters. The `AdvancedCluster` data source not only supports Flex clusters, but also supports free and dedicated clusters, providing easier migration between different cluster types. For more information, see the Advanced Cluster data source.

    ## Example Usage


    :param builtins.str name: Human-readable label that identifies the instance.
    :param builtins.str project_id: Unique 24-hexadecimal character string that identifies the project.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('mongodbatlas:index/getFlexCluster:getFlexCluster', __args__, opts=opts, typ=GetFlexClusterResult)
    return __ret__.apply(lambda __response__: GetFlexClusterResult(
        backup_settings=pulumi.get(__response__, 'backup_settings'),
        cluster_type=pulumi.get(__response__, 'cluster_type'),
        connection_strings=pulumi.get(__response__, 'connection_strings'),
        create_date=pulumi.get(__response__, 'create_date'),
        id=pulumi.get(__response__, 'id'),
        mongo_db_version=pulumi.get(__response__, 'mongo_db_version'),
        name=pulumi.get(__response__, 'name'),
        project_id=pulumi.get(__response__, 'project_id'),
        provider_settings=pulumi.get(__response__, 'provider_settings'),
        state_name=pulumi.get(__response__, 'state_name'),
        tags=pulumi.get(__response__, 'tags'),
        termination_protection_enabled=pulumi.get(__response__, 'termination_protection_enabled'),
        version_release_system=pulumi.get(__response__, 'version_release_system')))
