# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetMongodbEmployeeAccessGrantResult',
    'AwaitableGetMongodbEmployeeAccessGrantResult',
    'get_mongodb_employee_access_grant',
    'get_mongodb_employee_access_grant_output',
]

@pulumi.output_type
class GetMongodbEmployeeAccessGrantResult:
    """
    A collection of values returned by getMongodbEmployeeAccessGrant.
    """
    def __init__(__self__, cluster_name=None, expiration_time=None, grant_type=None, id=None, project_id=None):
        if cluster_name and not isinstance(cluster_name, str):
            raise TypeError("Expected argument 'cluster_name' to be a str")
        pulumi.set(__self__, "cluster_name", cluster_name)
        if expiration_time and not isinstance(expiration_time, str):
            raise TypeError("Expected argument 'expiration_time' to be a str")
        pulumi.set(__self__, "expiration_time", expiration_time)
        if grant_type and not isinstance(grant_type, str):
            raise TypeError("Expected argument 'grant_type' to be a str")
        pulumi.set(__self__, "grant_type", grant_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> builtins.str:
        """
        Human-readable label that identifies this cluster.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> builtins.str:
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="grantType")
    def grant_type(self) -> builtins.str:
        return pulumi.get(self, "grant_type")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        """
        return pulumi.get(self, "project_id")


class AwaitableGetMongodbEmployeeAccessGrantResult(GetMongodbEmployeeAccessGrantResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMongodbEmployeeAccessGrantResult(
            cluster_name=self.cluster_name,
            expiration_time=self.expiration_time,
            grant_type=self.grant_type,
            id=self.id,
            project_id=self.project_id)


def get_mongodb_employee_access_grant(cluster_name: Optional[builtins.str] = None,
                                      project_id: Optional[builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMongodbEmployeeAccessGrantResult:
    """
    ## # Data Source: MongodbEmployeeAccessGrant

    `MongodbEmployeeAccessGrant` describes a MongoDB employee access grant.

    ## Example Usage

    ### S
    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    example = mongodbatlas.MongodbEmployeeAccessGrant("example",
        project_id=project_id,
        cluster_name=cluster_name,
        grant_type="CLUSTER_INFRASTRUCTURE_AND_APP_SERVICES_SYNC_DATA",
        expiration_time="2025-01-01T12:00:00Z")
    ds_example = mongodbatlas.get_mongodb_employee_access_grant(project_id=project_id,
        cluster_name=cluster_name)
    pulumi.export("grantType", ds_example.grant_type)
    pulumi.export("expirationTime", ds_example.expiration_time)
    ```


    :param builtins.str cluster_name: Human-readable label that identifies this cluster.
    :param builtins.str project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
    """
    __args__ = dict()
    __args__['clusterName'] = cluster_name
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getMongodbEmployeeAccessGrant:getMongodbEmployeeAccessGrant', __args__, opts=opts, typ=GetMongodbEmployeeAccessGrantResult).value

    return AwaitableGetMongodbEmployeeAccessGrantResult(
        cluster_name=pulumi.get(__ret__, 'cluster_name'),
        expiration_time=pulumi.get(__ret__, 'expiration_time'),
        grant_type=pulumi.get(__ret__, 'grant_type'),
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'))
def get_mongodb_employee_access_grant_output(cluster_name: Optional[pulumi.Input[builtins.str]] = None,
                                             project_id: Optional[pulumi.Input[builtins.str]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMongodbEmployeeAccessGrantResult]:
    """
    ## # Data Source: MongodbEmployeeAccessGrant

    `MongodbEmployeeAccessGrant` describes a MongoDB employee access grant.

    ## Example Usage

    ### S
    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    example = mongodbatlas.MongodbEmployeeAccessGrant("example",
        project_id=project_id,
        cluster_name=cluster_name,
        grant_type="CLUSTER_INFRASTRUCTURE_AND_APP_SERVICES_SYNC_DATA",
        expiration_time="2025-01-01T12:00:00Z")
    ds_example = mongodbatlas.get_mongodb_employee_access_grant(project_id=project_id,
        cluster_name=cluster_name)
    pulumi.export("grantType", ds_example.grant_type)
    pulumi.export("expirationTime", ds_example.expiration_time)
    ```


    :param builtins.str cluster_name: Human-readable label that identifies this cluster.
    :param builtins.str project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
    """
    __args__ = dict()
    __args__['clusterName'] = cluster_name
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('mongodbatlas:index/getMongodbEmployeeAccessGrant:getMongodbEmployeeAccessGrant', __args__, opts=opts, typ=GetMongodbEmployeeAccessGrantResult)
    return __ret__.apply(lambda __response__: GetMongodbEmployeeAccessGrantResult(
        cluster_name=pulumi.get(__response__, 'cluster_name'),
        expiration_time=pulumi.get(__response__, 'expiration_time'),
        grant_type=pulumi.get(__response__, 'grant_type'),
        id=pulumi.get(__response__, 'id'),
        project_id=pulumi.get(__response__, 'project_id')))
