# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetStreamAccountDetailsResult',
    'AwaitableGetStreamAccountDetailsResult',
    'get_stream_account_details',
    'get_stream_account_details_output',
]

@pulumi.output_type
class GetStreamAccountDetailsResult:
    """
    A collection of values returned by getStreamAccountDetails.
    """
    def __init__(__self__, aws_account_id=None, azure_subscription_id=None, cidr_block=None, cloud_provider=None, id=None, project_id=None, region_name=None, virtual_network_name=None, vpc_id=None):
        if aws_account_id and not isinstance(aws_account_id, str):
            raise TypeError("Expected argument 'aws_account_id' to be a str")
        pulumi.set(__self__, "aws_account_id", aws_account_id)
        if azure_subscription_id and not isinstance(azure_subscription_id, str):
            raise TypeError("Expected argument 'azure_subscription_id' to be a str")
        pulumi.set(__self__, "azure_subscription_id", azure_subscription_id)
        if cidr_block and not isinstance(cidr_block, str):
            raise TypeError("Expected argument 'cidr_block' to be a str")
        pulumi.set(__self__, "cidr_block", cidr_block)
        if cloud_provider and not isinstance(cloud_provider, str):
            raise TypeError("Expected argument 'cloud_provider' to be a str")
        pulumi.set(__self__, "cloud_provider", cloud_provider)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if region_name and not isinstance(region_name, str):
            raise TypeError("Expected argument 'region_name' to be a str")
        pulumi.set(__self__, "region_name", region_name)
        if virtual_network_name and not isinstance(virtual_network_name, str):
            raise TypeError("Expected argument 'virtual_network_name' to be a str")
        pulumi.set(__self__, "virtual_network_name", virtual_network_name)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> builtins.str:
        return pulumi.get(self, "aws_account_id")

    @property
    @pulumi.getter(name="azureSubscriptionId")
    def azure_subscription_id(self) -> builtins.str:
        return pulumi.get(self, "azure_subscription_id")

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> builtins.str:
        return pulumi.get(self, "cidr_block")

    @property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> builtins.str:
        """
        One of `aws` or `azure`.
        """
        return pulumi.get(self, "cloud_provider")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        Unique 24-hexadecimal digit string that identifies your project. Use the [/groups](https://www.mongodb.com/docs/atlas/reference/api-resources-spec/v2/#tag/Projects/operation/listProjects) endpoint to retrieve all projects to which the authenticated user has access.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> builtins.str:
        return pulumi.get(self, "region_name")

    @property
    @pulumi.getter(name="virtualNetworkName")
    def virtual_network_name(self) -> builtins.str:
        return pulumi.get(self, "virtual_network_name")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> builtins.str:
        return pulumi.get(self, "vpc_id")


class AwaitableGetStreamAccountDetailsResult(GetStreamAccountDetailsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStreamAccountDetailsResult(
            aws_account_id=self.aws_account_id,
            azure_subscription_id=self.azure_subscription_id,
            cidr_block=self.cidr_block,
            cloud_provider=self.cloud_provider,
            id=self.id,
            project_id=self.project_id,
            region_name=self.region_name,
            virtual_network_name=self.virtual_network_name,
            vpc_id=self.vpc_id)


def get_stream_account_details(cloud_provider: Optional[builtins.str] = None,
                               project_id: Optional[builtins.str] = None,
                               region_name: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStreamAccountDetailsResult:
    """
    ## # Data Source: get_stream_account_details

    `get_stream_account_details` returns the AWS Account ID/Azure Subscription ID, and the AWS VPC ID/Azure Virtual Network Name for the group, cloud provider, and region that you specify.

    ## Example Usage

    ### S
    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    account_details = mongodbatlas.get_stream_account_details(project_id=project_id,
        cloud_provider="aws",
        region_name="US_EAST_1")
    pulumi.export("awsAccountId", account_details.aws_account_id)
    pulumi.export("cidrBlock", account_details.cidr_block)
    pulumi.export("cloudProvider", account_details.cloud_provider)
    pulumi.export("vpcId", account_details.vpc_id)
    ```


    :param builtins.str cloud_provider: One of `aws` or `azure`.
    :param builtins.str project_id: Unique 24-hexadecimal digit string that identifies your project. Use the [/groups](https://www.mongodb.com/docs/atlas/reference/api-resources-spec/v2/#tag/Projects/operation/listProjects) endpoint to retrieve all projects to which the authenticated user has access.
    """
    __args__ = dict()
    __args__['cloudProvider'] = cloud_provider
    __args__['projectId'] = project_id
    __args__['regionName'] = region_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getStreamAccountDetails:getStreamAccountDetails', __args__, opts=opts, typ=GetStreamAccountDetailsResult).value

    return AwaitableGetStreamAccountDetailsResult(
        aws_account_id=pulumi.get(__ret__, 'aws_account_id'),
        azure_subscription_id=pulumi.get(__ret__, 'azure_subscription_id'),
        cidr_block=pulumi.get(__ret__, 'cidr_block'),
        cloud_provider=pulumi.get(__ret__, 'cloud_provider'),
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        region_name=pulumi.get(__ret__, 'region_name'),
        virtual_network_name=pulumi.get(__ret__, 'virtual_network_name'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_stream_account_details_output(cloud_provider: Optional[pulumi.Input[builtins.str]] = None,
                                      project_id: Optional[pulumi.Input[builtins.str]] = None,
                                      region_name: Optional[pulumi.Input[builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStreamAccountDetailsResult]:
    """
    ## # Data Source: get_stream_account_details

    `get_stream_account_details` returns the AWS Account ID/Azure Subscription ID, and the AWS VPC ID/Azure Virtual Network Name for the group, cloud provider, and region that you specify.

    ## Example Usage

    ### S
    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    account_details = mongodbatlas.get_stream_account_details(project_id=project_id,
        cloud_provider="aws",
        region_name="US_EAST_1")
    pulumi.export("awsAccountId", account_details.aws_account_id)
    pulumi.export("cidrBlock", account_details.cidr_block)
    pulumi.export("cloudProvider", account_details.cloud_provider)
    pulumi.export("vpcId", account_details.vpc_id)
    ```


    :param builtins.str cloud_provider: One of `aws` or `azure`.
    :param builtins.str project_id: Unique 24-hexadecimal digit string that identifies your project. Use the [/groups](https://www.mongodb.com/docs/atlas/reference/api-resources-spec/v2/#tag/Projects/operation/listProjects) endpoint to retrieve all projects to which the authenticated user has access.
    """
    __args__ = dict()
    __args__['cloudProvider'] = cloud_provider
    __args__['projectId'] = project_id
    __args__['regionName'] = region_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('mongodbatlas:index/getStreamAccountDetails:getStreamAccountDetails', __args__, opts=opts, typ=GetStreamAccountDetailsResult)
    return __ret__.apply(lambda __response__: GetStreamAccountDetailsResult(
        aws_account_id=pulumi.get(__response__, 'aws_account_id'),
        azure_subscription_id=pulumi.get(__response__, 'azure_subscription_id'),
        cidr_block=pulumi.get(__response__, 'cidr_block'),
        cloud_provider=pulumi.get(__response__, 'cloud_provider'),
        id=pulumi.get(__response__, 'id'),
        project_id=pulumi.get(__response__, 'project_id'),
        region_name=pulumi.get(__response__, 'region_name'),
        virtual_network_name=pulumi.get(__response__, 'virtual_network_name'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
