# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetStreamInstanceResult',
    'AwaitableGetStreamInstanceResult',
    'get_stream_instance',
    'get_stream_instance_output',
]

@pulumi.output_type
class GetStreamInstanceResult:
    """
    A collection of values returned by getStreamInstance.
    """
    def __init__(__self__, data_process_region=None, hostnames=None, id=None, instance_name=None, project_id=None, stream_config=None):
        if data_process_region and not isinstance(data_process_region, dict):
            raise TypeError("Expected argument 'data_process_region' to be a dict")
        pulumi.set(__self__, "data_process_region", data_process_region)
        if hostnames and not isinstance(hostnames, list):
            raise TypeError("Expected argument 'hostnames' to be a list")
        pulumi.set(__self__, "hostnames", hostnames)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_name and not isinstance(instance_name, str):
            raise TypeError("Expected argument 'instance_name' to be a str")
        pulumi.set(__self__, "instance_name", instance_name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if stream_config and not isinstance(stream_config, dict):
            raise TypeError("Expected argument 'stream_config' to be a dict")
        pulumi.set(__self__, "stream_config", stream_config)

    @property
    @pulumi.getter(name="dataProcessRegion")
    def data_process_region(self) -> 'outputs.GetStreamInstanceDataProcessRegionResult':
        """
        Defines the cloud service provider and region where MongoDB Cloud performs stream processing. See data process region.
        """
        return pulumi.get(self, "data_process_region")

    @property
    @pulumi.getter
    def hostnames(self) -> Sequence[builtins.str]:
        """
        List that contains the hostnames assigned to the stream instance.
        """
        return pulumi.get(self, "hostnames")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> builtins.str:
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="streamConfig")
    def stream_config(self) -> 'outputs.GetStreamInstanceStreamConfigResult':
        """
        Defines the configuration options for an Atlas Stream Processing Instance. See stream config
        """
        return pulumi.get(self, "stream_config")


class AwaitableGetStreamInstanceResult(GetStreamInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStreamInstanceResult(
            data_process_region=self.data_process_region,
            hostnames=self.hostnames,
            id=self.id,
            instance_name=self.instance_name,
            project_id=self.project_id,
            stream_config=self.stream_config)


def get_stream_instance(instance_name: Optional[builtins.str] = None,
                        project_id: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStreamInstanceResult:
    """
    ## # Data Source: StreamInstance

    `StreamInstance` describes a stream instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    example = mongodbatlas.get_stream_instance(project_id="<PROJECT_ID>",
        instance_name="<INSTANCE_NAME>")
    ```


    :param builtins.str instance_name: Human-readable label that identifies the stream instance.
    :param builtins.str project_id: Unique 24-hexadecimal digit string that identifies your project.
    """
    __args__ = dict()
    __args__['instanceName'] = instance_name
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getStreamInstance:getStreamInstance', __args__, opts=opts, typ=GetStreamInstanceResult).value

    return AwaitableGetStreamInstanceResult(
        data_process_region=pulumi.get(__ret__, 'data_process_region'),
        hostnames=pulumi.get(__ret__, 'hostnames'),
        id=pulumi.get(__ret__, 'id'),
        instance_name=pulumi.get(__ret__, 'instance_name'),
        project_id=pulumi.get(__ret__, 'project_id'),
        stream_config=pulumi.get(__ret__, 'stream_config'))
def get_stream_instance_output(instance_name: Optional[pulumi.Input[builtins.str]] = None,
                               project_id: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStreamInstanceResult]:
    """
    ## # Data Source: StreamInstance

    `StreamInstance` describes a stream instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    example = mongodbatlas.get_stream_instance(project_id="<PROJECT_ID>",
        instance_name="<INSTANCE_NAME>")
    ```


    :param builtins.str instance_name: Human-readable label that identifies the stream instance.
    :param builtins.str project_id: Unique 24-hexadecimal digit string that identifies your project.
    """
    __args__ = dict()
    __args__['instanceName'] = instance_name
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('mongodbatlas:index/getStreamInstance:getStreamInstance', __args__, opts=opts, typ=GetStreamInstanceResult)
    return __ret__.apply(lambda __response__: GetStreamInstanceResult(
        data_process_region=pulumi.get(__response__, 'data_process_region'),
        hostnames=pulumi.get(__response__, 'hostnames'),
        id=pulumi.get(__response__, 'id'),
        instance_name=pulumi.get(__response__, 'instance_name'),
        project_id=pulumi.get(__response__, 'project_id'),
        stream_config=pulumi.get(__response__, 'stream_config')))
