# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LdapConfigurationArgs', 'LdapConfiguration']

@pulumi.input_type
class LdapConfigurationArgs:
    def __init__(__self__, *,
                 authentication_enabled: pulumi.Input[builtins.bool],
                 bind_password: pulumi.Input[builtins.str],
                 bind_username: pulumi.Input[builtins.str],
                 hostname: pulumi.Input[builtins.str],
                 project_id: pulumi.Input[builtins.str],
                 authorization_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 authz_query_template: Optional[pulumi.Input[builtins.str]] = None,
                 ca_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 user_to_dn_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['LdapConfigurationUserToDnMappingArgs']]]] = None):
        """
        The set of arguments for constructing a LdapConfiguration resource.
        :param pulumi.Input[builtins.bool] authentication_enabled: Specifies whether user authentication with LDAP is enabled.
        :param pulumi.Input[builtins.str] bind_password: The password used to authenticate the `bind_username`.
        :param pulumi.Input[builtins.str] bind_username: The user DN that Atlas uses to connect to the LDAP server. Must be the full DN, such as `CN=BindUser,CN=Users,DC=myldapserver,DC=mycompany,DC=com`.
        :param pulumi.Input[builtins.str] hostname: The hostname or IP address of the LDAP server. The server must be visible to the internet or connected to your Atlas cluster with VPC Peering.
        :param pulumi.Input[builtins.str] project_id: The unique ID for the project to configure LDAP.
        :param pulumi.Input[builtins.bool] authorization_enabled: Specifies whether user authorization with LDAP is enabled. You cannot enable user authorization with LDAP without first enabling user authentication with LDAP.
        :param pulumi.Input[builtins.str] authz_query_template: An LDAP query template that Atlas executes to obtain the LDAP groups to which the authenticated user belongs. Used only for user authorization. Use the {USER} placeholder in the URL to substitute the authenticated username. The query is relative to the host specified with hostname. The formatting for the query must conform to RFC4515 and RFC 4516. If you do not provide a query template, Atlas attempts to use the default value: `{USER}?memberOf?base`.
        :param pulumi.Input[builtins.str] ca_certificate: CA certificate used to verify the identify of the LDAP server. Self-signed certificates are allowed.
        :param pulumi.Input[builtins.int] port: The port to which the LDAP server listens for client connections. Default: `636`
        :param pulumi.Input[Sequence[pulumi.Input['LdapConfigurationUserToDnMappingArgs']]] user_to_dn_mappings: Maps an LDAP username for authentication to an LDAP Distinguished Name (DN). Each document contains a `match` regular expression and either a `substitution` or `ldap_query` template used to transform the LDAP username extracted from the regular expression. Atlas steps through the each document in the array in the given order, checking the authentication username against the `match` filter. If a match is found, Atlas applies the transformation and uses the output to authenticate the user. Atlas does not check the remaining documents in the array. For more details and examples see the [MongoDB Atlas API Reference](https://docs.atlas.mongodb.com/reference/api/ldaps-configuration-save/).
               * `user_to_dn_mapping.0.match` - (Optional) A regular expression to match against a provided LDAP username. Each parenthesis-enclosed section represents a regular expression capture group used by the `substitution` or `ldap_query` template.
               * `user_to_dn_mapping.0.substitution` - (Optional) An LDAP Distinguished Name (DN) formatting template that converts the LDAP name matched by the `match` regular expression into an LDAP Distinguished Name. Each bracket-enclosed numeric value is replaced by the corresponding regular expression capture group extracted from the LDAP username that matched the `match` regular expression.
               * `user_to_dn_mapping.0.ldap_query` - (Optional) An LDAP query formatting template that inserts the LDAP name matched by the `match` regular expression into an LDAP query URI as specified by RFC 4515 and RFC 4516. Each numeric value is replaced by the corresponding regular expression capture group extracted from the LDAP username that matched the `match` regular expression.
        """
        pulumi.set(__self__, "authentication_enabled", authentication_enabled)
        pulumi.set(__self__, "bind_password", bind_password)
        pulumi.set(__self__, "bind_username", bind_username)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "project_id", project_id)
        if authorization_enabled is not None:
            pulumi.set(__self__, "authorization_enabled", authorization_enabled)
        if authz_query_template is not None:
            pulumi.set(__self__, "authz_query_template", authz_query_template)
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if user_to_dn_mappings is not None:
            pulumi.set(__self__, "user_to_dn_mappings", user_to_dn_mappings)

    @property
    @pulumi.getter(name="authenticationEnabled")
    def authentication_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Specifies whether user authentication with LDAP is enabled.
        """
        return pulumi.get(self, "authentication_enabled")

    @authentication_enabled.setter
    def authentication_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "authentication_enabled", value)

    @property
    @pulumi.getter(name="bindPassword")
    def bind_password(self) -> pulumi.Input[builtins.str]:
        """
        The password used to authenticate the `bind_username`.
        """
        return pulumi.get(self, "bind_password")

    @bind_password.setter
    def bind_password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bind_password", value)

    @property
    @pulumi.getter(name="bindUsername")
    def bind_username(self) -> pulumi.Input[builtins.str]:
        """
        The user DN that Atlas uses to connect to the LDAP server. Must be the full DN, such as `CN=BindUser,CN=Users,DC=myldapserver,DC=mycompany,DC=com`.
        """
        return pulumi.get(self, "bind_username")

    @bind_username.setter
    def bind_username(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bind_username", value)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[builtins.str]:
        """
        The hostname or IP address of the LDAP server. The server must be visible to the internet or connected to your Atlas cluster with VPC Peering.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.str]:
        """
        The unique ID for the project to configure LDAP.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="authorizationEnabled")
    def authorization_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether user authorization with LDAP is enabled. You cannot enable user authorization with LDAP without first enabling user authentication with LDAP.
        """
        return pulumi.get(self, "authorization_enabled")

    @authorization_enabled.setter
    def authorization_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "authorization_enabled", value)

    @property
    @pulumi.getter(name="authzQueryTemplate")
    def authz_query_template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An LDAP query template that Atlas executes to obtain the LDAP groups to which the authenticated user belongs. Used only for user authorization. Use the {USER} placeholder in the URL to substitute the authenticated username. The query is relative to the host specified with hostname. The formatting for the query must conform to RFC4515 and RFC 4516. If you do not provide a query template, Atlas attempts to use the default value: `{USER}?memberOf?base`.
        """
        return pulumi.get(self, "authz_query_template")

    @authz_query_template.setter
    def authz_query_template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authz_query_template", value)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        CA certificate used to verify the identify of the LDAP server. Self-signed certificates are allowed.
        """
        return pulumi.get(self, "ca_certificate")

    @ca_certificate.setter
    def ca_certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ca_certificate", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port to which the LDAP server listens for client connections. Default: `636`
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="userToDnMappings")
    def user_to_dn_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LdapConfigurationUserToDnMappingArgs']]]]:
        """
        Maps an LDAP username for authentication to an LDAP Distinguished Name (DN). Each document contains a `match` regular expression and either a `substitution` or `ldap_query` template used to transform the LDAP username extracted from the regular expression. Atlas steps through the each document in the array in the given order, checking the authentication username against the `match` filter. If a match is found, Atlas applies the transformation and uses the output to authenticate the user. Atlas does not check the remaining documents in the array. For more details and examples see the [MongoDB Atlas API Reference](https://docs.atlas.mongodb.com/reference/api/ldaps-configuration-save/).
        * `user_to_dn_mapping.0.match` - (Optional) A regular expression to match against a provided LDAP username. Each parenthesis-enclosed section represents a regular expression capture group used by the `substitution` or `ldap_query` template.
        * `user_to_dn_mapping.0.substitution` - (Optional) An LDAP Distinguished Name (DN) formatting template that converts the LDAP name matched by the `match` regular expression into an LDAP Distinguished Name. Each bracket-enclosed numeric value is replaced by the corresponding regular expression capture group extracted from the LDAP username that matched the `match` regular expression.
        * `user_to_dn_mapping.0.ldap_query` - (Optional) An LDAP query formatting template that inserts the LDAP name matched by the `match` regular expression into an LDAP query URI as specified by RFC 4515 and RFC 4516. Each numeric value is replaced by the corresponding regular expression capture group extracted from the LDAP username that matched the `match` regular expression.
        """
        return pulumi.get(self, "user_to_dn_mappings")

    @user_to_dn_mappings.setter
    def user_to_dn_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LdapConfigurationUserToDnMappingArgs']]]]):
        pulumi.set(self, "user_to_dn_mappings", value)


@pulumi.input_type
class _LdapConfigurationState:
    def __init__(__self__, *,
                 authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 authorization_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 authz_query_template: Optional[pulumi.Input[builtins.str]] = None,
                 bind_password: Optional[pulumi.Input[builtins.str]] = None,
                 bind_username: Optional[pulumi.Input[builtins.str]] = None,
                 ca_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 user_to_dn_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['LdapConfigurationUserToDnMappingArgs']]]] = None):
        """
        Input properties used for looking up and filtering LdapConfiguration resources.
        :param pulumi.Input[builtins.bool] authentication_enabled: Specifies whether user authentication with LDAP is enabled.
        :param pulumi.Input[builtins.bool] authorization_enabled: Specifies whether user authorization with LDAP is enabled. You cannot enable user authorization with LDAP without first enabling user authentication with LDAP.
        :param pulumi.Input[builtins.str] authz_query_template: An LDAP query template that Atlas executes to obtain the LDAP groups to which the authenticated user belongs. Used only for user authorization. Use the {USER} placeholder in the URL to substitute the authenticated username. The query is relative to the host specified with hostname. The formatting for the query must conform to RFC4515 and RFC 4516. If you do not provide a query template, Atlas attempts to use the default value: `{USER}?memberOf?base`.
        :param pulumi.Input[builtins.str] bind_password: The password used to authenticate the `bind_username`.
        :param pulumi.Input[builtins.str] bind_username: The user DN that Atlas uses to connect to the LDAP server. Must be the full DN, such as `CN=BindUser,CN=Users,DC=myldapserver,DC=mycompany,DC=com`.
        :param pulumi.Input[builtins.str] ca_certificate: CA certificate used to verify the identify of the LDAP server. Self-signed certificates are allowed.
        :param pulumi.Input[builtins.str] hostname: The hostname or IP address of the LDAP server. The server must be visible to the internet or connected to your Atlas cluster with VPC Peering.
        :param pulumi.Input[builtins.int] port: The port to which the LDAP server listens for client connections. Default: `636`
        :param pulumi.Input[builtins.str] project_id: The unique ID for the project to configure LDAP.
        :param pulumi.Input[Sequence[pulumi.Input['LdapConfigurationUserToDnMappingArgs']]] user_to_dn_mappings: Maps an LDAP username for authentication to an LDAP Distinguished Name (DN). Each document contains a `match` regular expression and either a `substitution` or `ldap_query` template used to transform the LDAP username extracted from the regular expression. Atlas steps through the each document in the array in the given order, checking the authentication username against the `match` filter. If a match is found, Atlas applies the transformation and uses the output to authenticate the user. Atlas does not check the remaining documents in the array. For more details and examples see the [MongoDB Atlas API Reference](https://docs.atlas.mongodb.com/reference/api/ldaps-configuration-save/).
               * `user_to_dn_mapping.0.match` - (Optional) A regular expression to match against a provided LDAP username. Each parenthesis-enclosed section represents a regular expression capture group used by the `substitution` or `ldap_query` template.
               * `user_to_dn_mapping.0.substitution` - (Optional) An LDAP Distinguished Name (DN) formatting template that converts the LDAP name matched by the `match` regular expression into an LDAP Distinguished Name. Each bracket-enclosed numeric value is replaced by the corresponding regular expression capture group extracted from the LDAP username that matched the `match` regular expression.
               * `user_to_dn_mapping.0.ldap_query` - (Optional) An LDAP query formatting template that inserts the LDAP name matched by the `match` regular expression into an LDAP query URI as specified by RFC 4515 and RFC 4516. Each numeric value is replaced by the corresponding regular expression capture group extracted from the LDAP username that matched the `match` regular expression.
        """
        if authentication_enabled is not None:
            pulumi.set(__self__, "authentication_enabled", authentication_enabled)
        if authorization_enabled is not None:
            pulumi.set(__self__, "authorization_enabled", authorization_enabled)
        if authz_query_template is not None:
            pulumi.set(__self__, "authz_query_template", authz_query_template)
        if bind_password is not None:
            pulumi.set(__self__, "bind_password", bind_password)
        if bind_username is not None:
            pulumi.set(__self__, "bind_username", bind_username)
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if user_to_dn_mappings is not None:
            pulumi.set(__self__, "user_to_dn_mappings", user_to_dn_mappings)

    @property
    @pulumi.getter(name="authenticationEnabled")
    def authentication_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether user authentication with LDAP is enabled.
        """
        return pulumi.get(self, "authentication_enabled")

    @authentication_enabled.setter
    def authentication_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "authentication_enabled", value)

    @property
    @pulumi.getter(name="authorizationEnabled")
    def authorization_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether user authorization with LDAP is enabled. You cannot enable user authorization with LDAP without first enabling user authentication with LDAP.
        """
        return pulumi.get(self, "authorization_enabled")

    @authorization_enabled.setter
    def authorization_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "authorization_enabled", value)

    @property
    @pulumi.getter(name="authzQueryTemplate")
    def authz_query_template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An LDAP query template that Atlas executes to obtain the LDAP groups to which the authenticated user belongs. Used only for user authorization. Use the {USER} placeholder in the URL to substitute the authenticated username. The query is relative to the host specified with hostname. The formatting for the query must conform to RFC4515 and RFC 4516. If you do not provide a query template, Atlas attempts to use the default value: `{USER}?memberOf?base`.
        """
        return pulumi.get(self, "authz_query_template")

    @authz_query_template.setter
    def authz_query_template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authz_query_template", value)

    @property
    @pulumi.getter(name="bindPassword")
    def bind_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password used to authenticate the `bind_username`.
        """
        return pulumi.get(self, "bind_password")

    @bind_password.setter
    def bind_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bind_password", value)

    @property
    @pulumi.getter(name="bindUsername")
    def bind_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user DN that Atlas uses to connect to the LDAP server. Must be the full DN, such as `CN=BindUser,CN=Users,DC=myldapserver,DC=mycompany,DC=com`.
        """
        return pulumi.get(self, "bind_username")

    @bind_username.setter
    def bind_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bind_username", value)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        CA certificate used to verify the identify of the LDAP server. Self-signed certificates are allowed.
        """
        return pulumi.get(self, "ca_certificate")

    @ca_certificate.setter
    def ca_certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ca_certificate", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname or IP address of the LDAP server. The server must be visible to the internet or connected to your Atlas cluster with VPC Peering.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port to which the LDAP server listens for client connections. Default: `636`
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique ID for the project to configure LDAP.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="userToDnMappings")
    def user_to_dn_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LdapConfigurationUserToDnMappingArgs']]]]:
        """
        Maps an LDAP username for authentication to an LDAP Distinguished Name (DN). Each document contains a `match` regular expression and either a `substitution` or `ldap_query` template used to transform the LDAP username extracted from the regular expression. Atlas steps through the each document in the array in the given order, checking the authentication username against the `match` filter. If a match is found, Atlas applies the transformation and uses the output to authenticate the user. Atlas does not check the remaining documents in the array. For more details and examples see the [MongoDB Atlas API Reference](https://docs.atlas.mongodb.com/reference/api/ldaps-configuration-save/).
        * `user_to_dn_mapping.0.match` - (Optional) A regular expression to match against a provided LDAP username. Each parenthesis-enclosed section represents a regular expression capture group used by the `substitution` or `ldap_query` template.
        * `user_to_dn_mapping.0.substitution` - (Optional) An LDAP Distinguished Name (DN) formatting template that converts the LDAP name matched by the `match` regular expression into an LDAP Distinguished Name. Each bracket-enclosed numeric value is replaced by the corresponding regular expression capture group extracted from the LDAP username that matched the `match` regular expression.
        * `user_to_dn_mapping.0.ldap_query` - (Optional) An LDAP query formatting template that inserts the LDAP name matched by the `match` regular expression into an LDAP query URI as specified by RFC 4515 and RFC 4516. Each numeric value is replaced by the corresponding regular expression capture group extracted from the LDAP username that matched the `match` regular expression.
        """
        return pulumi.get(self, "user_to_dn_mappings")

    @user_to_dn_mappings.setter
    def user_to_dn_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LdapConfigurationUserToDnMappingArgs']]]]):
        pulumi.set(self, "user_to_dn_mappings", value)


@pulumi.type_token("mongodbatlas:index/ldapConfiguration:LdapConfiguration")
class LdapConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 authorization_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 authz_query_template: Optional[pulumi.Input[builtins.str]] = None,
                 bind_password: Optional[pulumi.Input[builtins.str]] = None,
                 bind_username: Optional[pulumi.Input[builtins.str]] = None,
                 ca_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 user_to_dn_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LdapConfigurationUserToDnMappingArgs', 'LdapConfigurationUserToDnMappingArgsDict']]]]] = None,
                 __props__=None):
        """
        ## # Resource: LdapConfiguration

        `LdapConfiguration` provides an LDAP Configuration resource. This allows an LDAP configuration for an Atlas project to be created and managed. This endpoint doesn’t verify connectivity using the provided LDAP over TLS configuration details. To verify a configuration before saving it, use the resource to verify the LDAP configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.Project("test",
            name="NAME OF THE PROJECT",
            org_id="ORG ID")
        test_ldap_configuration = mongodbatlas.LdapConfiguration("test",
            project_id=test.id,
            authentication_enabled=True,
            hostname="HOSTNAME",
            port=636,
            bind_username="USERNAME",
            bind_password="PASSWORD")
        ```

        ### LDAP With User To DN Mapping

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.Project("test",
            name="NAME OF THE PROJECT",
            org_id="ORG ID")
        test_ldap_configuration = mongodbatlas.LdapConfiguration("test",
            project_id=test.id,
            authentication_enabled=True,
            hostname="HOSTNAME",
            port=636,
            bind_username="USERNAME",
            bind_password="PASSWORD",
            ca_certificate="CA CERTIFICATE",
            authz_query_template="{USER}?memberOf?base",
            user_to_dn_mappings=[{
                "match": "(.+)",
                "ldap_query": "DC=example,DC=com??sub?(userPrincipalName={0})",
            }])
        ```

        ## Import

        LDAP Configuration must be imported using project ID, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/ldapConfiguration:LdapConfiguration test 5d09d6a59ccf6445652a444a
        ```
        For more information see: [MongoDB Atlas API Reference.](https://docs.atlas.mongodb.com/reference/api/ldaps-configuration-save)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] authentication_enabled: Specifies whether user authentication with LDAP is enabled.
        :param pulumi.Input[builtins.bool] authorization_enabled: Specifies whether user authorization with LDAP is enabled. You cannot enable user authorization with LDAP without first enabling user authentication with LDAP.
        :param pulumi.Input[builtins.str] authz_query_template: An LDAP query template that Atlas executes to obtain the LDAP groups to which the authenticated user belongs. Used only for user authorization. Use the {USER} placeholder in the URL to substitute the authenticated username. The query is relative to the host specified with hostname. The formatting for the query must conform to RFC4515 and RFC 4516. If you do not provide a query template, Atlas attempts to use the default value: `{USER}?memberOf?base`.
        :param pulumi.Input[builtins.str] bind_password: The password used to authenticate the `bind_username`.
        :param pulumi.Input[builtins.str] bind_username: The user DN that Atlas uses to connect to the LDAP server. Must be the full DN, such as `CN=BindUser,CN=Users,DC=myldapserver,DC=mycompany,DC=com`.
        :param pulumi.Input[builtins.str] ca_certificate: CA certificate used to verify the identify of the LDAP server. Self-signed certificates are allowed.
        :param pulumi.Input[builtins.str] hostname: The hostname or IP address of the LDAP server. The server must be visible to the internet or connected to your Atlas cluster with VPC Peering.
        :param pulumi.Input[builtins.int] port: The port to which the LDAP server listens for client connections. Default: `636`
        :param pulumi.Input[builtins.str] project_id: The unique ID for the project to configure LDAP.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LdapConfigurationUserToDnMappingArgs', 'LdapConfigurationUserToDnMappingArgsDict']]]] user_to_dn_mappings: Maps an LDAP username for authentication to an LDAP Distinguished Name (DN). Each document contains a `match` regular expression and either a `substitution` or `ldap_query` template used to transform the LDAP username extracted from the regular expression. Atlas steps through the each document in the array in the given order, checking the authentication username against the `match` filter. If a match is found, Atlas applies the transformation and uses the output to authenticate the user. Atlas does not check the remaining documents in the array. For more details and examples see the [MongoDB Atlas API Reference](https://docs.atlas.mongodb.com/reference/api/ldaps-configuration-save/).
               * `user_to_dn_mapping.0.match` - (Optional) A regular expression to match against a provided LDAP username. Each parenthesis-enclosed section represents a regular expression capture group used by the `substitution` or `ldap_query` template.
               * `user_to_dn_mapping.0.substitution` - (Optional) An LDAP Distinguished Name (DN) formatting template that converts the LDAP name matched by the `match` regular expression into an LDAP Distinguished Name. Each bracket-enclosed numeric value is replaced by the corresponding regular expression capture group extracted from the LDAP username that matched the `match` regular expression.
               * `user_to_dn_mapping.0.ldap_query` - (Optional) An LDAP query formatting template that inserts the LDAP name matched by the `match` regular expression into an LDAP query URI as specified by RFC 4515 and RFC 4516. Each numeric value is replaced by the corresponding regular expression capture group extracted from the LDAP username that matched the `match` regular expression.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LdapConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: LdapConfiguration

        `LdapConfiguration` provides an LDAP Configuration resource. This allows an LDAP configuration for an Atlas project to be created and managed. This endpoint doesn’t verify connectivity using the provided LDAP over TLS configuration details. To verify a configuration before saving it, use the resource to verify the LDAP configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.Project("test",
            name="NAME OF THE PROJECT",
            org_id="ORG ID")
        test_ldap_configuration = mongodbatlas.LdapConfiguration("test",
            project_id=test.id,
            authentication_enabled=True,
            hostname="HOSTNAME",
            port=636,
            bind_username="USERNAME",
            bind_password="PASSWORD")
        ```

        ### LDAP With User To DN Mapping

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.Project("test",
            name="NAME OF THE PROJECT",
            org_id="ORG ID")
        test_ldap_configuration = mongodbatlas.LdapConfiguration("test",
            project_id=test.id,
            authentication_enabled=True,
            hostname="HOSTNAME",
            port=636,
            bind_username="USERNAME",
            bind_password="PASSWORD",
            ca_certificate="CA CERTIFICATE",
            authz_query_template="{USER}?memberOf?base",
            user_to_dn_mappings=[{
                "match": "(.+)",
                "ldap_query": "DC=example,DC=com??sub?(userPrincipalName={0})",
            }])
        ```

        ## Import

        LDAP Configuration must be imported using project ID, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/ldapConfiguration:LdapConfiguration test 5d09d6a59ccf6445652a444a
        ```
        For more information see: [MongoDB Atlas API Reference.](https://docs.atlas.mongodb.com/reference/api/ldaps-configuration-save)

        :param str resource_name: The name of the resource.
        :param LdapConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LdapConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 authorization_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 authz_query_template: Optional[pulumi.Input[builtins.str]] = None,
                 bind_password: Optional[pulumi.Input[builtins.str]] = None,
                 bind_username: Optional[pulumi.Input[builtins.str]] = None,
                 ca_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 user_to_dn_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LdapConfigurationUserToDnMappingArgs', 'LdapConfigurationUserToDnMappingArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LdapConfigurationArgs.__new__(LdapConfigurationArgs)

            if authentication_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'authentication_enabled'")
            __props__.__dict__["authentication_enabled"] = authentication_enabled
            __props__.__dict__["authorization_enabled"] = authorization_enabled
            __props__.__dict__["authz_query_template"] = authz_query_template
            if bind_password is None and not opts.urn:
                raise TypeError("Missing required property 'bind_password'")
            __props__.__dict__["bind_password"] = None if bind_password is None else pulumi.Output.secret(bind_password)
            if bind_username is None and not opts.urn:
                raise TypeError("Missing required property 'bind_username'")
            __props__.__dict__["bind_username"] = bind_username
            __props__.__dict__["ca_certificate"] = ca_certificate
            if hostname is None and not opts.urn:
                raise TypeError("Missing required property 'hostname'")
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["port"] = port
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["user_to_dn_mappings"] = user_to_dn_mappings
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["bindPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(LdapConfiguration, __self__).__init__(
            'mongodbatlas:index/ldapConfiguration:LdapConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            authorization_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            authz_query_template: Optional[pulumi.Input[builtins.str]] = None,
            bind_password: Optional[pulumi.Input[builtins.str]] = None,
            bind_username: Optional[pulumi.Input[builtins.str]] = None,
            ca_certificate: Optional[pulumi.Input[builtins.str]] = None,
            hostname: Optional[pulumi.Input[builtins.str]] = None,
            port: Optional[pulumi.Input[builtins.int]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            user_to_dn_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LdapConfigurationUserToDnMappingArgs', 'LdapConfigurationUserToDnMappingArgsDict']]]]] = None) -> 'LdapConfiguration':
        """
        Get an existing LdapConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] authentication_enabled: Specifies whether user authentication with LDAP is enabled.
        :param pulumi.Input[builtins.bool] authorization_enabled: Specifies whether user authorization with LDAP is enabled. You cannot enable user authorization with LDAP without first enabling user authentication with LDAP.
        :param pulumi.Input[builtins.str] authz_query_template: An LDAP query template that Atlas executes to obtain the LDAP groups to which the authenticated user belongs. Used only for user authorization. Use the {USER} placeholder in the URL to substitute the authenticated username. The query is relative to the host specified with hostname. The formatting for the query must conform to RFC4515 and RFC 4516. If you do not provide a query template, Atlas attempts to use the default value: `{USER}?memberOf?base`.
        :param pulumi.Input[builtins.str] bind_password: The password used to authenticate the `bind_username`.
        :param pulumi.Input[builtins.str] bind_username: The user DN that Atlas uses to connect to the LDAP server. Must be the full DN, such as `CN=BindUser,CN=Users,DC=myldapserver,DC=mycompany,DC=com`.
        :param pulumi.Input[builtins.str] ca_certificate: CA certificate used to verify the identify of the LDAP server. Self-signed certificates are allowed.
        :param pulumi.Input[builtins.str] hostname: The hostname or IP address of the LDAP server. The server must be visible to the internet or connected to your Atlas cluster with VPC Peering.
        :param pulumi.Input[builtins.int] port: The port to which the LDAP server listens for client connections. Default: `636`
        :param pulumi.Input[builtins.str] project_id: The unique ID for the project to configure LDAP.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LdapConfigurationUserToDnMappingArgs', 'LdapConfigurationUserToDnMappingArgsDict']]]] user_to_dn_mappings: Maps an LDAP username for authentication to an LDAP Distinguished Name (DN). Each document contains a `match` regular expression and either a `substitution` or `ldap_query` template used to transform the LDAP username extracted from the regular expression. Atlas steps through the each document in the array in the given order, checking the authentication username against the `match` filter. If a match is found, Atlas applies the transformation and uses the output to authenticate the user. Atlas does not check the remaining documents in the array. For more details and examples see the [MongoDB Atlas API Reference](https://docs.atlas.mongodb.com/reference/api/ldaps-configuration-save/).
               * `user_to_dn_mapping.0.match` - (Optional) A regular expression to match against a provided LDAP username. Each parenthesis-enclosed section represents a regular expression capture group used by the `substitution` or `ldap_query` template.
               * `user_to_dn_mapping.0.substitution` - (Optional) An LDAP Distinguished Name (DN) formatting template that converts the LDAP name matched by the `match` regular expression into an LDAP Distinguished Name. Each bracket-enclosed numeric value is replaced by the corresponding regular expression capture group extracted from the LDAP username that matched the `match` regular expression.
               * `user_to_dn_mapping.0.ldap_query` - (Optional) An LDAP query formatting template that inserts the LDAP name matched by the `match` regular expression into an LDAP query URI as specified by RFC 4515 and RFC 4516. Each numeric value is replaced by the corresponding regular expression capture group extracted from the LDAP username that matched the `match` regular expression.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LdapConfigurationState.__new__(_LdapConfigurationState)

        __props__.__dict__["authentication_enabled"] = authentication_enabled
        __props__.__dict__["authorization_enabled"] = authorization_enabled
        __props__.__dict__["authz_query_template"] = authz_query_template
        __props__.__dict__["bind_password"] = bind_password
        __props__.__dict__["bind_username"] = bind_username
        __props__.__dict__["ca_certificate"] = ca_certificate
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["port"] = port
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["user_to_dn_mappings"] = user_to_dn_mappings
        return LdapConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authenticationEnabled")
    def authentication_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Specifies whether user authentication with LDAP is enabled.
        """
        return pulumi.get(self, "authentication_enabled")

    @property
    @pulumi.getter(name="authorizationEnabled")
    def authorization_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Specifies whether user authorization with LDAP is enabled. You cannot enable user authorization with LDAP without first enabling user authentication with LDAP.
        """
        return pulumi.get(self, "authorization_enabled")

    @property
    @pulumi.getter(name="authzQueryTemplate")
    def authz_query_template(self) -> pulumi.Output[builtins.str]:
        """
        An LDAP query template that Atlas executes to obtain the LDAP groups to which the authenticated user belongs. Used only for user authorization. Use the {USER} placeholder in the URL to substitute the authenticated username. The query is relative to the host specified with hostname. The formatting for the query must conform to RFC4515 and RFC 4516. If you do not provide a query template, Atlas attempts to use the default value: `{USER}?memberOf?base`.
        """
        return pulumi.get(self, "authz_query_template")

    @property
    @pulumi.getter(name="bindPassword")
    def bind_password(self) -> pulumi.Output[builtins.str]:
        """
        The password used to authenticate the `bind_username`.
        """
        return pulumi.get(self, "bind_password")

    @property
    @pulumi.getter(name="bindUsername")
    def bind_username(self) -> pulumi.Output[builtins.str]:
        """
        The user DN that Atlas uses to connect to the LDAP server. Must be the full DN, such as `CN=BindUser,CN=Users,DC=myldapserver,DC=mycompany,DC=com`.
        """
        return pulumi.get(self, "bind_username")

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> pulumi.Output[builtins.str]:
        """
        CA certificate used to verify the identify of the LDAP server. Self-signed certificates are allowed.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[builtins.str]:
        """
        The hostname or IP address of the LDAP server. The server must be visible to the internet or connected to your Atlas cluster with VPC Peering.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The port to which the LDAP server listens for client connections. Default: `636`
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique ID for the project to configure LDAP.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="userToDnMappings")
    def user_to_dn_mappings(self) -> pulumi.Output[Sequence['outputs.LdapConfigurationUserToDnMapping']]:
        """
        Maps an LDAP username for authentication to an LDAP Distinguished Name (DN). Each document contains a `match` regular expression and either a `substitution` or `ldap_query` template used to transform the LDAP username extracted from the regular expression. Atlas steps through the each document in the array in the given order, checking the authentication username against the `match` filter. If a match is found, Atlas applies the transformation and uses the output to authenticate the user. Atlas does not check the remaining documents in the array. For more details and examples see the [MongoDB Atlas API Reference](https://docs.atlas.mongodb.com/reference/api/ldaps-configuration-save/).
        * `user_to_dn_mapping.0.match` - (Optional) A regular expression to match against a provided LDAP username. Each parenthesis-enclosed section represents a regular expression capture group used by the `substitution` or `ldap_query` template.
        * `user_to_dn_mapping.0.substitution` - (Optional) An LDAP Distinguished Name (DN) formatting template that converts the LDAP name matched by the `match` regular expression into an LDAP Distinguished Name. Each bracket-enclosed numeric value is replaced by the corresponding regular expression capture group extracted from the LDAP username that matched the `match` regular expression.
        * `user_to_dn_mapping.0.ldap_query` - (Optional) An LDAP query formatting template that inserts the LDAP name matched by the `match` regular expression into an LDAP query URI as specified by RFC 4515 and RFC 4516. Each numeric value is replaced by the corresponding regular expression capture group extracted from the LDAP username that matched the `match` regular expression.
        """
        return pulumi.get(self, "user_to_dn_mappings")

