# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectArgs', 'Project']

@pulumi.input_type
class ProjectArgs:
    def __init__(__self__, *,
                 org_id: pulumi.Input[builtins.str],
                 is_collect_database_specifics_statistics_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_data_explorer_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_extended_storage_sizes_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_performance_advisor_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_realtime_performance_panel_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_schema_advisor_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_slow_operation_thresholding_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 limits: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectLimitArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_owner_id: Optional[pulumi.Input[builtins.str]] = None,
                 region_usage_restrictions: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectTeamArgs']]]] = None,
                 with_default_alerts_settings: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a Project resource.
        :param pulumi.Input[builtins.str] org_id: The ID of the organization you want to create the project within.
        :param pulumi.Input[builtins.bool] is_collect_database_specifics_statistics_enabled: Flag that indicates whether to enable statistics in [cluster metrics](https://www.mongodb.com/docs/atlas/monitor-cluster-metrics/) collection for the project. By default, this flag is set to true.
        :param pulumi.Input[builtins.bool] is_data_explorer_enabled: Flag that indicates whether to enable Data Explorer for the project. If enabled, you can query your database with an easy to use interface.  When Data Explorer is disabled, you cannot terminate slow operations from the [Real-Time Performance Panel](https://www.mongodb.com/docs/atlas/real-time-performance-panel/#std-label-real-time-metrics-status-tab) or create indexes from the [Performance Advisor](https://www.mongodb.com/docs/atlas/performance-advisor/#std-label-performance-advisor). You can still view Performance Advisor recommendations, but you must create those indexes from [mongosh](https://www.mongodb.com/docs/mongodb-shell/#mongodb-binary-bin.mongosh). By default, this flag is set to true.
        :param pulumi.Input[builtins.bool] is_extended_storage_sizes_enabled: Flag that indicates whether to enable extended storage sizes for the specified project. Clusters with extended storage sizes must be on AWS or GCP, and cannot span multiple regions. When extending storage size, initial syncs and cross-project snapshot restores will be slow. This setting should only be used as a measure of temporary relief; consider sharding if more storage is required.
        :param pulumi.Input[builtins.bool] is_performance_advisor_enabled: Flag that indicates whether to enable Performance Advisor and Profiler for the project. If enabled, you can analyze database logs to recommend performance improvements. By default, this flag is set to true.
        :param pulumi.Input[builtins.bool] is_realtime_performance_panel_enabled: Flag that indicates whether to enable Real Time Performance Panel for the project. If enabled, you can see real time metrics from your MongoDB database. By default, this flag is set to true.
        :param pulumi.Input[builtins.bool] is_schema_advisor_enabled: Flag that indicates whether to enable Schema Advisor for the project. If enabled, you receive customized recommendations to optimize your data model and enhance performance. Disable this setting to disable schema suggestions in the [Performance Advisor](https://www.mongodb.com/docs/atlas/performance-advisor/#std-label-performance-advisor) and the [Data Explorer](https://www.mongodb.com/docs/atlas/atlas-ui/#std-label-atlas-ui). By default, this flag is set to true.
        :param pulumi.Input[builtins.bool] is_slow_operation_thresholding_enabled: (Optional) Flag that enables MongoDB Cloud to use its slow operation threshold for the specified project. The threshold determines which operations the Performance Advisor and Query Profiler considers slow. When enabled, MongoDB Cloud uses the average execution time for operations on your cluster to determine slow-running queries. As a result, the threshold is more pertinent to your cluster workload. The slow operation threshold is enabled by default for dedicated clusters (M10+). When disabled, MongoDB Cloud considers any operation that takes longer than 100 milliseconds to be slow. **Note**: To use this attribute, the requesting API Key must have the Project Owner role, if not it will show a warning and will return `false`. If you are not using this field, you don't need to take any action.
        :param pulumi.Input[builtins.str] name: The name of the project you want to create.
        :param pulumi.Input[builtins.str] project_owner_id: Unique 24-hexadecimal digit string that identifies the Atlas user account to be granted the [Project Owner](https://docs.atlas.mongodb.com/reference/user-roles/#mongodb-authrole-Project-Owner) role on the specified project. If you set this parameter, it overrides the default value of the oldest [Organization Owner](https://docs.atlas.mongodb.com/reference/user-roles/#mongodb-authrole-Organization-Owner).
        :param pulumi.Input[builtins.str] region_usage_restrictions: Designates that this project can be used for government regions only.  If not set the project will default to standard regions.   You cannot deploy clusters across government and standard regions in the same project. AWS is the only cloud provider for AtlasGov.  For more information see [MongoDB Atlas for Government](https://www.mongodb.com/docs/atlas/government/api/#creating-a-project).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the project. See below.
        :param pulumi.Input[builtins.bool] with_default_alerts_settings: It allows users to disable the creation of the default alert settings. By default, this flag is set to true.
        """
        pulumi.set(__self__, "org_id", org_id)
        if is_collect_database_specifics_statistics_enabled is not None:
            pulumi.set(__self__, "is_collect_database_specifics_statistics_enabled", is_collect_database_specifics_statistics_enabled)
        if is_data_explorer_enabled is not None:
            pulumi.set(__self__, "is_data_explorer_enabled", is_data_explorer_enabled)
        if is_extended_storage_sizes_enabled is not None:
            pulumi.set(__self__, "is_extended_storage_sizes_enabled", is_extended_storage_sizes_enabled)
        if is_performance_advisor_enabled is not None:
            pulumi.set(__self__, "is_performance_advisor_enabled", is_performance_advisor_enabled)
        if is_realtime_performance_panel_enabled is not None:
            pulumi.set(__self__, "is_realtime_performance_panel_enabled", is_realtime_performance_panel_enabled)
        if is_schema_advisor_enabled is not None:
            pulumi.set(__self__, "is_schema_advisor_enabled", is_schema_advisor_enabled)
        if is_slow_operation_thresholding_enabled is not None:
            warnings.warn("""This parameter is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""is_slow_operation_thresholding_enabled is deprecated: This parameter is deprecated.""")
        if is_slow_operation_thresholding_enabled is not None:
            pulumi.set(__self__, "is_slow_operation_thresholding_enabled", is_slow_operation_thresholding_enabled)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_owner_id is not None:
            pulumi.set(__self__, "project_owner_id", project_owner_id)
        if region_usage_restrictions is not None:
            pulumi.set(__self__, "region_usage_restrictions", region_usage_restrictions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if teams is not None:
            pulumi.set(__self__, "teams", teams)
        if with_default_alerts_settings is not None:
            pulumi.set(__self__, "with_default_alerts_settings", with_default_alerts_settings)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the organization you want to create the project within.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="isCollectDatabaseSpecificsStatisticsEnabled")
    def is_collect_database_specifics_statistics_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Flag that indicates whether to enable statistics in [cluster metrics](https://www.mongodb.com/docs/atlas/monitor-cluster-metrics/) collection for the project. By default, this flag is set to true.
        """
        return pulumi.get(self, "is_collect_database_specifics_statistics_enabled")

    @is_collect_database_specifics_statistics_enabled.setter
    def is_collect_database_specifics_statistics_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_collect_database_specifics_statistics_enabled", value)

    @property
    @pulumi.getter(name="isDataExplorerEnabled")
    def is_data_explorer_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Flag that indicates whether to enable Data Explorer for the project. If enabled, you can query your database with an easy to use interface.  When Data Explorer is disabled, you cannot terminate slow operations from the [Real-Time Performance Panel](https://www.mongodb.com/docs/atlas/real-time-performance-panel/#std-label-real-time-metrics-status-tab) or create indexes from the [Performance Advisor](https://www.mongodb.com/docs/atlas/performance-advisor/#std-label-performance-advisor). You can still view Performance Advisor recommendations, but you must create those indexes from [mongosh](https://www.mongodb.com/docs/mongodb-shell/#mongodb-binary-bin.mongosh). By default, this flag is set to true.
        """
        return pulumi.get(self, "is_data_explorer_enabled")

    @is_data_explorer_enabled.setter
    def is_data_explorer_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_data_explorer_enabled", value)

    @property
    @pulumi.getter(name="isExtendedStorageSizesEnabled")
    def is_extended_storage_sizes_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Flag that indicates whether to enable extended storage sizes for the specified project. Clusters with extended storage sizes must be on AWS or GCP, and cannot span multiple regions. When extending storage size, initial syncs and cross-project snapshot restores will be slow. This setting should only be used as a measure of temporary relief; consider sharding if more storage is required.
        """
        return pulumi.get(self, "is_extended_storage_sizes_enabled")

    @is_extended_storage_sizes_enabled.setter
    def is_extended_storage_sizes_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_extended_storage_sizes_enabled", value)

    @property
    @pulumi.getter(name="isPerformanceAdvisorEnabled")
    def is_performance_advisor_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Flag that indicates whether to enable Performance Advisor and Profiler for the project. If enabled, you can analyze database logs to recommend performance improvements. By default, this flag is set to true.
        """
        return pulumi.get(self, "is_performance_advisor_enabled")

    @is_performance_advisor_enabled.setter
    def is_performance_advisor_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_performance_advisor_enabled", value)

    @property
    @pulumi.getter(name="isRealtimePerformancePanelEnabled")
    def is_realtime_performance_panel_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Flag that indicates whether to enable Real Time Performance Panel for the project. If enabled, you can see real time metrics from your MongoDB database. By default, this flag is set to true.
        """
        return pulumi.get(self, "is_realtime_performance_panel_enabled")

    @is_realtime_performance_panel_enabled.setter
    def is_realtime_performance_panel_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_realtime_performance_panel_enabled", value)

    @property
    @pulumi.getter(name="isSchemaAdvisorEnabled")
    def is_schema_advisor_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Flag that indicates whether to enable Schema Advisor for the project. If enabled, you receive customized recommendations to optimize your data model and enhance performance. Disable this setting to disable schema suggestions in the [Performance Advisor](https://www.mongodb.com/docs/atlas/performance-advisor/#std-label-performance-advisor) and the [Data Explorer](https://www.mongodb.com/docs/atlas/atlas-ui/#std-label-atlas-ui). By default, this flag is set to true.
        """
        return pulumi.get(self, "is_schema_advisor_enabled")

    @is_schema_advisor_enabled.setter
    def is_schema_advisor_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_schema_advisor_enabled", value)

    @property
    @pulumi.getter(name="isSlowOperationThresholdingEnabled")
    @_utilities.deprecated("""This parameter is deprecated.""")
    def is_slow_operation_thresholding_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Optional) Flag that enables MongoDB Cloud to use its slow operation threshold for the specified project. The threshold determines which operations the Performance Advisor and Query Profiler considers slow. When enabled, MongoDB Cloud uses the average execution time for operations on your cluster to determine slow-running queries. As a result, the threshold is more pertinent to your cluster workload. The slow operation threshold is enabled by default for dedicated clusters (M10+). When disabled, MongoDB Cloud considers any operation that takes longer than 100 milliseconds to be slow. **Note**: To use this attribute, the requesting API Key must have the Project Owner role, if not it will show a warning and will return `false`. If you are not using this field, you don't need to take any action.
        """
        return pulumi.get(self, "is_slow_operation_thresholding_enabled")

    @is_slow_operation_thresholding_enabled.setter
    def is_slow_operation_thresholding_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_slow_operation_thresholding_enabled", value)

    @property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectLimitArgs']]]]:
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectLimitArgs']]]]):
        pulumi.set(self, "limits", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the project you want to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectOwnerId")
    def project_owner_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique 24-hexadecimal digit string that identifies the Atlas user account to be granted the [Project Owner](https://docs.atlas.mongodb.com/reference/user-roles/#mongodb-authrole-Project-Owner) role on the specified project. If you set this parameter, it overrides the default value of the oldest [Organization Owner](https://docs.atlas.mongodb.com/reference/user-roles/#mongodb-authrole-Organization-Owner).
        """
        return pulumi.get(self, "project_owner_id")

    @project_owner_id.setter
    def project_owner_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_owner_id", value)

    @property
    @pulumi.getter(name="regionUsageRestrictions")
    def region_usage_restrictions(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Designates that this project can be used for government regions only.  If not set the project will default to standard regions.   You cannot deploy clusters across government and standard regions in the same project. AWS is the only cloud provider for AtlasGov.  For more information see [MongoDB Atlas for Government](https://www.mongodb.com/docs/atlas/government/api/#creating-a-project).
        """
        return pulumi.get(self, "region_usage_restrictions")

    @region_usage_restrictions.setter
    def region_usage_restrictions(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region_usage_restrictions", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the project. See below.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def teams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectTeamArgs']]]]:
        return pulumi.get(self, "teams")

    @teams.setter
    def teams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectTeamArgs']]]]):
        pulumi.set(self, "teams", value)

    @property
    @pulumi.getter(name="withDefaultAlertsSettings")
    def with_default_alerts_settings(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        It allows users to disable the creation of the default alert settings. By default, this flag is set to true.
        """
        return pulumi.get(self, "with_default_alerts_settings")

    @with_default_alerts_settings.setter
    def with_default_alerts_settings(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "with_default_alerts_settings", value)


@pulumi.input_type
class _ProjectState:
    def __init__(__self__, *,
                 cluster_count: Optional[pulumi.Input[builtins.int]] = None,
                 created: Optional[pulumi.Input[builtins.str]] = None,
                 ip_addresses: Optional[pulumi.Input['ProjectIpAddressesArgs']] = None,
                 is_collect_database_specifics_statistics_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_data_explorer_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_extended_storage_sizes_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_performance_advisor_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_realtime_performance_panel_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_schema_advisor_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_slow_operation_thresholding_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 limits: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectLimitArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_owner_id: Optional[pulumi.Input[builtins.str]] = None,
                 region_usage_restrictions: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectTeamArgs']]]] = None,
                 with_default_alerts_settings: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Project resources.
        :param pulumi.Input[builtins.int] cluster_count: The number of Atlas clusters deployed in the project.
        :param pulumi.Input[builtins.str] created: The ISO-8601-formatted timestamp of when Atlas created the project.
        :param pulumi.Input['ProjectIpAddressesArgs'] ip_addresses: IP addresses in a project categorized by services. See IP Addresses. **WARNING:** This attribute is deprecated, use the `get_project_ip_addresses` data source instead.
        :param pulumi.Input[builtins.bool] is_collect_database_specifics_statistics_enabled: Flag that indicates whether to enable statistics in [cluster metrics](https://www.mongodb.com/docs/atlas/monitor-cluster-metrics/) collection for the project. By default, this flag is set to true.
        :param pulumi.Input[builtins.bool] is_data_explorer_enabled: Flag that indicates whether to enable Data Explorer for the project. If enabled, you can query your database with an easy to use interface.  When Data Explorer is disabled, you cannot terminate slow operations from the [Real-Time Performance Panel](https://www.mongodb.com/docs/atlas/real-time-performance-panel/#std-label-real-time-metrics-status-tab) or create indexes from the [Performance Advisor](https://www.mongodb.com/docs/atlas/performance-advisor/#std-label-performance-advisor). You can still view Performance Advisor recommendations, but you must create those indexes from [mongosh](https://www.mongodb.com/docs/mongodb-shell/#mongodb-binary-bin.mongosh). By default, this flag is set to true.
        :param pulumi.Input[builtins.bool] is_extended_storage_sizes_enabled: Flag that indicates whether to enable extended storage sizes for the specified project. Clusters with extended storage sizes must be on AWS or GCP, and cannot span multiple regions. When extending storage size, initial syncs and cross-project snapshot restores will be slow. This setting should only be used as a measure of temporary relief; consider sharding if more storage is required.
        :param pulumi.Input[builtins.bool] is_performance_advisor_enabled: Flag that indicates whether to enable Performance Advisor and Profiler for the project. If enabled, you can analyze database logs to recommend performance improvements. By default, this flag is set to true.
        :param pulumi.Input[builtins.bool] is_realtime_performance_panel_enabled: Flag that indicates whether to enable Real Time Performance Panel for the project. If enabled, you can see real time metrics from your MongoDB database. By default, this flag is set to true.
        :param pulumi.Input[builtins.bool] is_schema_advisor_enabled: Flag that indicates whether to enable Schema Advisor for the project. If enabled, you receive customized recommendations to optimize your data model and enhance performance. Disable this setting to disable schema suggestions in the [Performance Advisor](https://www.mongodb.com/docs/atlas/performance-advisor/#std-label-performance-advisor) and the [Data Explorer](https://www.mongodb.com/docs/atlas/atlas-ui/#std-label-atlas-ui). By default, this flag is set to true.
        :param pulumi.Input[builtins.bool] is_slow_operation_thresholding_enabled: (Optional) Flag that enables MongoDB Cloud to use its slow operation threshold for the specified project. The threshold determines which operations the Performance Advisor and Query Profiler considers slow. When enabled, MongoDB Cloud uses the average execution time for operations on your cluster to determine slow-running queries. As a result, the threshold is more pertinent to your cluster workload. The slow operation threshold is enabled by default for dedicated clusters (M10+). When disabled, MongoDB Cloud considers any operation that takes longer than 100 milliseconds to be slow. **Note**: To use this attribute, the requesting API Key must have the Project Owner role, if not it will show a warning and will return `false`. If you are not using this field, you don't need to take any action.
        :param pulumi.Input[builtins.str] name: The name of the project you want to create.
        :param pulumi.Input[builtins.str] org_id: The ID of the organization you want to create the project within.
        :param pulumi.Input[builtins.str] project_owner_id: Unique 24-hexadecimal digit string that identifies the Atlas user account to be granted the [Project Owner](https://docs.atlas.mongodb.com/reference/user-roles/#mongodb-authrole-Project-Owner) role on the specified project. If you set this parameter, it overrides the default value of the oldest [Organization Owner](https://docs.atlas.mongodb.com/reference/user-roles/#mongodb-authrole-Organization-Owner).
        :param pulumi.Input[builtins.str] region_usage_restrictions: Designates that this project can be used for government regions only.  If not set the project will default to standard regions.   You cannot deploy clusters across government and standard regions in the same project. AWS is the only cloud provider for AtlasGov.  For more information see [MongoDB Atlas for Government](https://www.mongodb.com/docs/atlas/government/api/#creating-a-project).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the project. See below.
        :param pulumi.Input[builtins.bool] with_default_alerts_settings: It allows users to disable the creation of the default alert settings. By default, this flag is set to true.
        """
        if cluster_count is not None:
            pulumi.set(__self__, "cluster_count", cluster_count)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if ip_addresses is not None:
            warnings.warn("""This parameter is deprecated. Please transition to get_project_ip_addresses data source.""", DeprecationWarning)
            pulumi.log.warn("""ip_addresses is deprecated: This parameter is deprecated. Please transition to get_project_ip_addresses data source.""")
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if is_collect_database_specifics_statistics_enabled is not None:
            pulumi.set(__self__, "is_collect_database_specifics_statistics_enabled", is_collect_database_specifics_statistics_enabled)
        if is_data_explorer_enabled is not None:
            pulumi.set(__self__, "is_data_explorer_enabled", is_data_explorer_enabled)
        if is_extended_storage_sizes_enabled is not None:
            pulumi.set(__self__, "is_extended_storage_sizes_enabled", is_extended_storage_sizes_enabled)
        if is_performance_advisor_enabled is not None:
            pulumi.set(__self__, "is_performance_advisor_enabled", is_performance_advisor_enabled)
        if is_realtime_performance_panel_enabled is not None:
            pulumi.set(__self__, "is_realtime_performance_panel_enabled", is_realtime_performance_panel_enabled)
        if is_schema_advisor_enabled is not None:
            pulumi.set(__self__, "is_schema_advisor_enabled", is_schema_advisor_enabled)
        if is_slow_operation_thresholding_enabled is not None:
            warnings.warn("""This parameter is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""is_slow_operation_thresholding_enabled is deprecated: This parameter is deprecated.""")
        if is_slow_operation_thresholding_enabled is not None:
            pulumi.set(__self__, "is_slow_operation_thresholding_enabled", is_slow_operation_thresholding_enabled)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_owner_id is not None:
            pulumi.set(__self__, "project_owner_id", project_owner_id)
        if region_usage_restrictions is not None:
            pulumi.set(__self__, "region_usage_restrictions", region_usage_restrictions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if teams is not None:
            pulumi.set(__self__, "teams", teams)
        if with_default_alerts_settings is not None:
            pulumi.set(__self__, "with_default_alerts_settings", with_default_alerts_settings)

    @property
    @pulumi.getter(name="clusterCount")
    def cluster_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of Atlas clusters deployed in the project.
        """
        return pulumi.get(self, "cluster_count")

    @cluster_count.setter
    def cluster_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cluster_count", value)

    @property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ISO-8601-formatted timestamp of when Atlas created the project.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created", value)

    @property
    @pulumi.getter(name="ipAddresses")
    @_utilities.deprecated("""This parameter is deprecated. Please transition to get_project_ip_addresses data source.""")
    def ip_addresses(self) -> Optional[pulumi.Input['ProjectIpAddressesArgs']]:
        """
        IP addresses in a project categorized by services. See IP Addresses. **WARNING:** This attribute is deprecated, use the `get_project_ip_addresses` data source instead.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input['ProjectIpAddressesArgs']]):
        pulumi.set(self, "ip_addresses", value)

    @property
    @pulumi.getter(name="isCollectDatabaseSpecificsStatisticsEnabled")
    def is_collect_database_specifics_statistics_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Flag that indicates whether to enable statistics in [cluster metrics](https://www.mongodb.com/docs/atlas/monitor-cluster-metrics/) collection for the project. By default, this flag is set to true.
        """
        return pulumi.get(self, "is_collect_database_specifics_statistics_enabled")

    @is_collect_database_specifics_statistics_enabled.setter
    def is_collect_database_specifics_statistics_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_collect_database_specifics_statistics_enabled", value)

    @property
    @pulumi.getter(name="isDataExplorerEnabled")
    def is_data_explorer_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Flag that indicates whether to enable Data Explorer for the project. If enabled, you can query your database with an easy to use interface.  When Data Explorer is disabled, you cannot terminate slow operations from the [Real-Time Performance Panel](https://www.mongodb.com/docs/atlas/real-time-performance-panel/#std-label-real-time-metrics-status-tab) or create indexes from the [Performance Advisor](https://www.mongodb.com/docs/atlas/performance-advisor/#std-label-performance-advisor). You can still view Performance Advisor recommendations, but you must create those indexes from [mongosh](https://www.mongodb.com/docs/mongodb-shell/#mongodb-binary-bin.mongosh). By default, this flag is set to true.
        """
        return pulumi.get(self, "is_data_explorer_enabled")

    @is_data_explorer_enabled.setter
    def is_data_explorer_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_data_explorer_enabled", value)

    @property
    @pulumi.getter(name="isExtendedStorageSizesEnabled")
    def is_extended_storage_sizes_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Flag that indicates whether to enable extended storage sizes for the specified project. Clusters with extended storage sizes must be on AWS or GCP, and cannot span multiple regions. When extending storage size, initial syncs and cross-project snapshot restores will be slow. This setting should only be used as a measure of temporary relief; consider sharding if more storage is required.
        """
        return pulumi.get(self, "is_extended_storage_sizes_enabled")

    @is_extended_storage_sizes_enabled.setter
    def is_extended_storage_sizes_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_extended_storage_sizes_enabled", value)

    @property
    @pulumi.getter(name="isPerformanceAdvisorEnabled")
    def is_performance_advisor_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Flag that indicates whether to enable Performance Advisor and Profiler for the project. If enabled, you can analyze database logs to recommend performance improvements. By default, this flag is set to true.
        """
        return pulumi.get(self, "is_performance_advisor_enabled")

    @is_performance_advisor_enabled.setter
    def is_performance_advisor_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_performance_advisor_enabled", value)

    @property
    @pulumi.getter(name="isRealtimePerformancePanelEnabled")
    def is_realtime_performance_panel_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Flag that indicates whether to enable Real Time Performance Panel for the project. If enabled, you can see real time metrics from your MongoDB database. By default, this flag is set to true.
        """
        return pulumi.get(self, "is_realtime_performance_panel_enabled")

    @is_realtime_performance_panel_enabled.setter
    def is_realtime_performance_panel_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_realtime_performance_panel_enabled", value)

    @property
    @pulumi.getter(name="isSchemaAdvisorEnabled")
    def is_schema_advisor_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Flag that indicates whether to enable Schema Advisor for the project. If enabled, you receive customized recommendations to optimize your data model and enhance performance. Disable this setting to disable schema suggestions in the [Performance Advisor](https://www.mongodb.com/docs/atlas/performance-advisor/#std-label-performance-advisor) and the [Data Explorer](https://www.mongodb.com/docs/atlas/atlas-ui/#std-label-atlas-ui). By default, this flag is set to true.
        """
        return pulumi.get(self, "is_schema_advisor_enabled")

    @is_schema_advisor_enabled.setter
    def is_schema_advisor_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_schema_advisor_enabled", value)

    @property
    @pulumi.getter(name="isSlowOperationThresholdingEnabled")
    @_utilities.deprecated("""This parameter is deprecated.""")
    def is_slow_operation_thresholding_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Optional) Flag that enables MongoDB Cloud to use its slow operation threshold for the specified project. The threshold determines which operations the Performance Advisor and Query Profiler considers slow. When enabled, MongoDB Cloud uses the average execution time for operations on your cluster to determine slow-running queries. As a result, the threshold is more pertinent to your cluster workload. The slow operation threshold is enabled by default for dedicated clusters (M10+). When disabled, MongoDB Cloud considers any operation that takes longer than 100 milliseconds to be slow. **Note**: To use this attribute, the requesting API Key must have the Project Owner role, if not it will show a warning and will return `false`. If you are not using this field, you don't need to take any action.
        """
        return pulumi.get(self, "is_slow_operation_thresholding_enabled")

    @is_slow_operation_thresholding_enabled.setter
    def is_slow_operation_thresholding_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_slow_operation_thresholding_enabled", value)

    @property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectLimitArgs']]]]:
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectLimitArgs']]]]):
        pulumi.set(self, "limits", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the project you want to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the organization you want to create the project within.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectOwnerId")
    def project_owner_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique 24-hexadecimal digit string that identifies the Atlas user account to be granted the [Project Owner](https://docs.atlas.mongodb.com/reference/user-roles/#mongodb-authrole-Project-Owner) role on the specified project. If you set this parameter, it overrides the default value of the oldest [Organization Owner](https://docs.atlas.mongodb.com/reference/user-roles/#mongodb-authrole-Organization-Owner).
        """
        return pulumi.get(self, "project_owner_id")

    @project_owner_id.setter
    def project_owner_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_owner_id", value)

    @property
    @pulumi.getter(name="regionUsageRestrictions")
    def region_usage_restrictions(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Designates that this project can be used for government regions only.  If not set the project will default to standard regions.   You cannot deploy clusters across government and standard regions in the same project. AWS is the only cloud provider for AtlasGov.  For more information see [MongoDB Atlas for Government](https://www.mongodb.com/docs/atlas/government/api/#creating-a-project).
        """
        return pulumi.get(self, "region_usage_restrictions")

    @region_usage_restrictions.setter
    def region_usage_restrictions(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region_usage_restrictions", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the project. See below.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def teams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectTeamArgs']]]]:
        return pulumi.get(self, "teams")

    @teams.setter
    def teams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectTeamArgs']]]]):
        pulumi.set(self, "teams", value)

    @property
    @pulumi.getter(name="withDefaultAlertsSettings")
    def with_default_alerts_settings(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        It allows users to disable the creation of the default alert settings. By default, this flag is set to true.
        """
        return pulumi.get(self, "with_default_alerts_settings")

    @with_default_alerts_settings.setter
    def with_default_alerts_settings(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "with_default_alerts_settings", value)


@pulumi.type_token("mongodbatlas:index/project:Project")
class Project(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_collect_database_specifics_statistics_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_data_explorer_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_extended_storage_sizes_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_performance_advisor_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_realtime_performance_panel_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_schema_advisor_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_slow_operation_thresholding_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 limits: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectLimitArgs', 'ProjectLimitArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_owner_id: Optional[pulumi.Input[builtins.str]] = None,
                 region_usage_restrictions: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectTeamArgs', 'ProjectTeamArgsDict']]]]] = None,
                 with_default_alerts_settings: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        ## # Resource: Project

        `Project` provides a Project resource. This allows project to be created.

        > **NOTE:** If Backup Compliance Policy is enabled for the project for which this backup schedule is defined, you cannot delete the Atlas project if any snapshots exist.  See [Backup Compliance Policy Prohibited Actions and Considerations](https://www.mongodb.com/docs/atlas/backup/cloud-backup/backup-compliance-policy/#configure-a-backup-compliance-policy).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.get_roles_org_id()
        test_project = mongodbatlas.Project("test",
            name="project-name",
            org_id=test.org_id,
            project_owner_id="<OWNER_ACCOUNT_ID>",
            teams=[
                {
                    "team_id": "5e0fa8c99ccf641c722fe645",
                    "role_names": ["GROUP_OWNER"],
                },
                {
                    "team_id": "5e1dd7b4f2a30ba80a70cd4rw",
                    "role_names": [
                        "GROUP_READ_ONLY",
                        "GROUP_DATA_ACCESS_READ_WRITE",
                    ],
                },
            ],
            limits=[
                {
                    "name": "atlas.project.deployment.clusters",
                    "value": 26,
                },
                {
                    "name": "atlas.project.deployment.nodesPerPrivateLinkRegion",
                    "value": 51,
                },
            ],
            is_collect_database_specifics_statistics_enabled=True,
            is_data_explorer_enabled=True,
            is_extended_storage_sizes_enabled=True,
            is_performance_advisor_enabled=True,
            is_realtime_performance_panel_enabled=True,
            is_schema_advisor_enabled=True,
            is_slow_operation_thresholding_enabled=True)
        ```

        ## Import

        Project must be imported using project ID, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/project:Project my_project 5d09d6a59ccf6445652a444a
        ```
        For more information see: [MongoDB Atlas Admin API Projects](https://www.mongodb.com/docs/atlas/reference/api-resources-spec/#tag/Projects) and [MongoDB Atlas Admin API Teams](https://docs.atlas.mongodb.com/reference/api/teams/) Documentation for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] is_collect_database_specifics_statistics_enabled: Flag that indicates whether to enable statistics in [cluster metrics](https://www.mongodb.com/docs/atlas/monitor-cluster-metrics/) collection for the project. By default, this flag is set to true.
        :param pulumi.Input[builtins.bool] is_data_explorer_enabled: Flag that indicates whether to enable Data Explorer for the project. If enabled, you can query your database with an easy to use interface.  When Data Explorer is disabled, you cannot terminate slow operations from the [Real-Time Performance Panel](https://www.mongodb.com/docs/atlas/real-time-performance-panel/#std-label-real-time-metrics-status-tab) or create indexes from the [Performance Advisor](https://www.mongodb.com/docs/atlas/performance-advisor/#std-label-performance-advisor). You can still view Performance Advisor recommendations, but you must create those indexes from [mongosh](https://www.mongodb.com/docs/mongodb-shell/#mongodb-binary-bin.mongosh). By default, this flag is set to true.
        :param pulumi.Input[builtins.bool] is_extended_storage_sizes_enabled: Flag that indicates whether to enable extended storage sizes for the specified project. Clusters with extended storage sizes must be on AWS or GCP, and cannot span multiple regions. When extending storage size, initial syncs and cross-project snapshot restores will be slow. This setting should only be used as a measure of temporary relief; consider sharding if more storage is required.
        :param pulumi.Input[builtins.bool] is_performance_advisor_enabled: Flag that indicates whether to enable Performance Advisor and Profiler for the project. If enabled, you can analyze database logs to recommend performance improvements. By default, this flag is set to true.
        :param pulumi.Input[builtins.bool] is_realtime_performance_panel_enabled: Flag that indicates whether to enable Real Time Performance Panel for the project. If enabled, you can see real time metrics from your MongoDB database. By default, this flag is set to true.
        :param pulumi.Input[builtins.bool] is_schema_advisor_enabled: Flag that indicates whether to enable Schema Advisor for the project. If enabled, you receive customized recommendations to optimize your data model and enhance performance. Disable this setting to disable schema suggestions in the [Performance Advisor](https://www.mongodb.com/docs/atlas/performance-advisor/#std-label-performance-advisor) and the [Data Explorer](https://www.mongodb.com/docs/atlas/atlas-ui/#std-label-atlas-ui). By default, this flag is set to true.
        :param pulumi.Input[builtins.bool] is_slow_operation_thresholding_enabled: (Optional) Flag that enables MongoDB Cloud to use its slow operation threshold for the specified project. The threshold determines which operations the Performance Advisor and Query Profiler considers slow. When enabled, MongoDB Cloud uses the average execution time for operations on your cluster to determine slow-running queries. As a result, the threshold is more pertinent to your cluster workload. The slow operation threshold is enabled by default for dedicated clusters (M10+). When disabled, MongoDB Cloud considers any operation that takes longer than 100 milliseconds to be slow. **Note**: To use this attribute, the requesting API Key must have the Project Owner role, if not it will show a warning and will return `false`. If you are not using this field, you don't need to take any action.
        :param pulumi.Input[builtins.str] name: The name of the project you want to create.
        :param pulumi.Input[builtins.str] org_id: The ID of the organization you want to create the project within.
        :param pulumi.Input[builtins.str] project_owner_id: Unique 24-hexadecimal digit string that identifies the Atlas user account to be granted the [Project Owner](https://docs.atlas.mongodb.com/reference/user-roles/#mongodb-authrole-Project-Owner) role on the specified project. If you set this parameter, it overrides the default value of the oldest [Organization Owner](https://docs.atlas.mongodb.com/reference/user-roles/#mongodb-authrole-Organization-Owner).
        :param pulumi.Input[builtins.str] region_usage_restrictions: Designates that this project can be used for government regions only.  If not set the project will default to standard regions.   You cannot deploy clusters across government and standard regions in the same project. AWS is the only cloud provider for AtlasGov.  For more information see [MongoDB Atlas for Government](https://www.mongodb.com/docs/atlas/government/api/#creating-a-project).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the project. See below.
        :param pulumi.Input[builtins.bool] with_default_alerts_settings: It allows users to disable the creation of the default alert settings. By default, this flag is set to true.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: Project

        `Project` provides a Project resource. This allows project to be created.

        > **NOTE:** If Backup Compliance Policy is enabled for the project for which this backup schedule is defined, you cannot delete the Atlas project if any snapshots exist.  See [Backup Compliance Policy Prohibited Actions and Considerations](https://www.mongodb.com/docs/atlas/backup/cloud-backup/backup-compliance-policy/#configure-a-backup-compliance-policy).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.get_roles_org_id()
        test_project = mongodbatlas.Project("test",
            name="project-name",
            org_id=test.org_id,
            project_owner_id="<OWNER_ACCOUNT_ID>",
            teams=[
                {
                    "team_id": "5e0fa8c99ccf641c722fe645",
                    "role_names": ["GROUP_OWNER"],
                },
                {
                    "team_id": "5e1dd7b4f2a30ba80a70cd4rw",
                    "role_names": [
                        "GROUP_READ_ONLY",
                        "GROUP_DATA_ACCESS_READ_WRITE",
                    ],
                },
            ],
            limits=[
                {
                    "name": "atlas.project.deployment.clusters",
                    "value": 26,
                },
                {
                    "name": "atlas.project.deployment.nodesPerPrivateLinkRegion",
                    "value": 51,
                },
            ],
            is_collect_database_specifics_statistics_enabled=True,
            is_data_explorer_enabled=True,
            is_extended_storage_sizes_enabled=True,
            is_performance_advisor_enabled=True,
            is_realtime_performance_panel_enabled=True,
            is_schema_advisor_enabled=True,
            is_slow_operation_thresholding_enabled=True)
        ```

        ## Import

        Project must be imported using project ID, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/project:Project my_project 5d09d6a59ccf6445652a444a
        ```
        For more information see: [MongoDB Atlas Admin API Projects](https://www.mongodb.com/docs/atlas/reference/api-resources-spec/#tag/Projects) and [MongoDB Atlas Admin API Teams](https://docs.atlas.mongodb.com/reference/api/teams/) Documentation for more information.

        :param str resource_name: The name of the resource.
        :param ProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_collect_database_specifics_statistics_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_data_explorer_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_extended_storage_sizes_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_performance_advisor_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_realtime_performance_panel_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_schema_advisor_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_slow_operation_thresholding_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 limits: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectLimitArgs', 'ProjectLimitArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_owner_id: Optional[pulumi.Input[builtins.str]] = None,
                 region_usage_restrictions: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectTeamArgs', 'ProjectTeamArgsDict']]]]] = None,
                 with_default_alerts_settings: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectArgs.__new__(ProjectArgs)

            __props__.__dict__["is_collect_database_specifics_statistics_enabled"] = is_collect_database_specifics_statistics_enabled
            __props__.__dict__["is_data_explorer_enabled"] = is_data_explorer_enabled
            __props__.__dict__["is_extended_storage_sizes_enabled"] = is_extended_storage_sizes_enabled
            __props__.__dict__["is_performance_advisor_enabled"] = is_performance_advisor_enabled
            __props__.__dict__["is_realtime_performance_panel_enabled"] = is_realtime_performance_panel_enabled
            __props__.__dict__["is_schema_advisor_enabled"] = is_schema_advisor_enabled
            __props__.__dict__["is_slow_operation_thresholding_enabled"] = is_slow_operation_thresholding_enabled
            __props__.__dict__["limits"] = limits
            __props__.__dict__["name"] = name
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_owner_id"] = project_owner_id
            __props__.__dict__["region_usage_restrictions"] = region_usage_restrictions
            __props__.__dict__["tags"] = tags
            __props__.__dict__["teams"] = teams
            __props__.__dict__["with_default_alerts_settings"] = with_default_alerts_settings
            __props__.__dict__["cluster_count"] = None
            __props__.__dict__["created"] = None
            __props__.__dict__["ip_addresses"] = None
        super(Project, __self__).__init__(
            'mongodbatlas:index/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_count: Optional[pulumi.Input[builtins.int]] = None,
            created: Optional[pulumi.Input[builtins.str]] = None,
            ip_addresses: Optional[pulumi.Input[Union['ProjectIpAddressesArgs', 'ProjectIpAddressesArgsDict']]] = None,
            is_collect_database_specifics_statistics_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            is_data_explorer_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            is_extended_storage_sizes_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            is_performance_advisor_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            is_realtime_performance_panel_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            is_schema_advisor_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            is_slow_operation_thresholding_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            limits: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectLimitArgs', 'ProjectLimitArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            org_id: Optional[pulumi.Input[builtins.str]] = None,
            project_owner_id: Optional[pulumi.Input[builtins.str]] = None,
            region_usage_restrictions: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            teams: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectTeamArgs', 'ProjectTeamArgsDict']]]]] = None,
            with_default_alerts_settings: Optional[pulumi.Input[builtins.bool]] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] cluster_count: The number of Atlas clusters deployed in the project.
        :param pulumi.Input[builtins.str] created: The ISO-8601-formatted timestamp of when Atlas created the project.
        :param pulumi.Input[Union['ProjectIpAddressesArgs', 'ProjectIpAddressesArgsDict']] ip_addresses: IP addresses in a project categorized by services. See IP Addresses. **WARNING:** This attribute is deprecated, use the `get_project_ip_addresses` data source instead.
        :param pulumi.Input[builtins.bool] is_collect_database_specifics_statistics_enabled: Flag that indicates whether to enable statistics in [cluster metrics](https://www.mongodb.com/docs/atlas/monitor-cluster-metrics/) collection for the project. By default, this flag is set to true.
        :param pulumi.Input[builtins.bool] is_data_explorer_enabled: Flag that indicates whether to enable Data Explorer for the project. If enabled, you can query your database with an easy to use interface.  When Data Explorer is disabled, you cannot terminate slow operations from the [Real-Time Performance Panel](https://www.mongodb.com/docs/atlas/real-time-performance-panel/#std-label-real-time-metrics-status-tab) or create indexes from the [Performance Advisor](https://www.mongodb.com/docs/atlas/performance-advisor/#std-label-performance-advisor). You can still view Performance Advisor recommendations, but you must create those indexes from [mongosh](https://www.mongodb.com/docs/mongodb-shell/#mongodb-binary-bin.mongosh). By default, this flag is set to true.
        :param pulumi.Input[builtins.bool] is_extended_storage_sizes_enabled: Flag that indicates whether to enable extended storage sizes for the specified project. Clusters with extended storage sizes must be on AWS or GCP, and cannot span multiple regions. When extending storage size, initial syncs and cross-project snapshot restores will be slow. This setting should only be used as a measure of temporary relief; consider sharding if more storage is required.
        :param pulumi.Input[builtins.bool] is_performance_advisor_enabled: Flag that indicates whether to enable Performance Advisor and Profiler for the project. If enabled, you can analyze database logs to recommend performance improvements. By default, this flag is set to true.
        :param pulumi.Input[builtins.bool] is_realtime_performance_panel_enabled: Flag that indicates whether to enable Real Time Performance Panel for the project. If enabled, you can see real time metrics from your MongoDB database. By default, this flag is set to true.
        :param pulumi.Input[builtins.bool] is_schema_advisor_enabled: Flag that indicates whether to enable Schema Advisor for the project. If enabled, you receive customized recommendations to optimize your data model and enhance performance. Disable this setting to disable schema suggestions in the [Performance Advisor](https://www.mongodb.com/docs/atlas/performance-advisor/#std-label-performance-advisor) and the [Data Explorer](https://www.mongodb.com/docs/atlas/atlas-ui/#std-label-atlas-ui). By default, this flag is set to true.
        :param pulumi.Input[builtins.bool] is_slow_operation_thresholding_enabled: (Optional) Flag that enables MongoDB Cloud to use its slow operation threshold for the specified project. The threshold determines which operations the Performance Advisor and Query Profiler considers slow. When enabled, MongoDB Cloud uses the average execution time for operations on your cluster to determine slow-running queries. As a result, the threshold is more pertinent to your cluster workload. The slow operation threshold is enabled by default for dedicated clusters (M10+). When disabled, MongoDB Cloud considers any operation that takes longer than 100 milliseconds to be slow. **Note**: To use this attribute, the requesting API Key must have the Project Owner role, if not it will show a warning and will return `false`. If you are not using this field, you don't need to take any action.
        :param pulumi.Input[builtins.str] name: The name of the project you want to create.
        :param pulumi.Input[builtins.str] org_id: The ID of the organization you want to create the project within.
        :param pulumi.Input[builtins.str] project_owner_id: Unique 24-hexadecimal digit string that identifies the Atlas user account to be granted the [Project Owner](https://docs.atlas.mongodb.com/reference/user-roles/#mongodb-authrole-Project-Owner) role on the specified project. If you set this parameter, it overrides the default value of the oldest [Organization Owner](https://docs.atlas.mongodb.com/reference/user-roles/#mongodb-authrole-Organization-Owner).
        :param pulumi.Input[builtins.str] region_usage_restrictions: Designates that this project can be used for government regions only.  If not set the project will default to standard regions.   You cannot deploy clusters across government and standard regions in the same project. AWS is the only cloud provider for AtlasGov.  For more information see [MongoDB Atlas for Government](https://www.mongodb.com/docs/atlas/government/api/#creating-a-project).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the project. See below.
        :param pulumi.Input[builtins.bool] with_default_alerts_settings: It allows users to disable the creation of the default alert settings. By default, this flag is set to true.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectState.__new__(_ProjectState)

        __props__.__dict__["cluster_count"] = cluster_count
        __props__.__dict__["created"] = created
        __props__.__dict__["ip_addresses"] = ip_addresses
        __props__.__dict__["is_collect_database_specifics_statistics_enabled"] = is_collect_database_specifics_statistics_enabled
        __props__.__dict__["is_data_explorer_enabled"] = is_data_explorer_enabled
        __props__.__dict__["is_extended_storage_sizes_enabled"] = is_extended_storage_sizes_enabled
        __props__.__dict__["is_performance_advisor_enabled"] = is_performance_advisor_enabled
        __props__.__dict__["is_realtime_performance_panel_enabled"] = is_realtime_performance_panel_enabled
        __props__.__dict__["is_schema_advisor_enabled"] = is_schema_advisor_enabled
        __props__.__dict__["is_slow_operation_thresholding_enabled"] = is_slow_operation_thresholding_enabled
        __props__.__dict__["limits"] = limits
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_owner_id"] = project_owner_id
        __props__.__dict__["region_usage_restrictions"] = region_usage_restrictions
        __props__.__dict__["tags"] = tags
        __props__.__dict__["teams"] = teams
        __props__.__dict__["with_default_alerts_settings"] = with_default_alerts_settings
        return Project(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterCount")
    def cluster_count(self) -> pulumi.Output[builtins.int]:
        """
        The number of Atlas clusters deployed in the project.
        """
        return pulumi.get(self, "cluster_count")

    @property
    @pulumi.getter
    def created(self) -> pulumi.Output[builtins.str]:
        """
        The ISO-8601-formatted timestamp of when Atlas created the project.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter(name="ipAddresses")
    @_utilities.deprecated("""This parameter is deprecated. Please transition to get_project_ip_addresses data source.""")
    def ip_addresses(self) -> pulumi.Output['outputs.ProjectIpAddresses']:
        """
        IP addresses in a project categorized by services. See IP Addresses. **WARNING:** This attribute is deprecated, use the `get_project_ip_addresses` data source instead.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter(name="isCollectDatabaseSpecificsStatisticsEnabled")
    def is_collect_database_specifics_statistics_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Flag that indicates whether to enable statistics in [cluster metrics](https://www.mongodb.com/docs/atlas/monitor-cluster-metrics/) collection for the project. By default, this flag is set to true.
        """
        return pulumi.get(self, "is_collect_database_specifics_statistics_enabled")

    @property
    @pulumi.getter(name="isDataExplorerEnabled")
    def is_data_explorer_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Flag that indicates whether to enable Data Explorer for the project. If enabled, you can query your database with an easy to use interface.  When Data Explorer is disabled, you cannot terminate slow operations from the [Real-Time Performance Panel](https://www.mongodb.com/docs/atlas/real-time-performance-panel/#std-label-real-time-metrics-status-tab) or create indexes from the [Performance Advisor](https://www.mongodb.com/docs/atlas/performance-advisor/#std-label-performance-advisor). You can still view Performance Advisor recommendations, but you must create those indexes from [mongosh](https://www.mongodb.com/docs/mongodb-shell/#mongodb-binary-bin.mongosh). By default, this flag is set to true.
        """
        return pulumi.get(self, "is_data_explorer_enabled")

    @property
    @pulumi.getter(name="isExtendedStorageSizesEnabled")
    def is_extended_storage_sizes_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Flag that indicates whether to enable extended storage sizes for the specified project. Clusters with extended storage sizes must be on AWS or GCP, and cannot span multiple regions. When extending storage size, initial syncs and cross-project snapshot restores will be slow. This setting should only be used as a measure of temporary relief; consider sharding if more storage is required.
        """
        return pulumi.get(self, "is_extended_storage_sizes_enabled")

    @property
    @pulumi.getter(name="isPerformanceAdvisorEnabled")
    def is_performance_advisor_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Flag that indicates whether to enable Performance Advisor and Profiler for the project. If enabled, you can analyze database logs to recommend performance improvements. By default, this flag is set to true.
        """
        return pulumi.get(self, "is_performance_advisor_enabled")

    @property
    @pulumi.getter(name="isRealtimePerformancePanelEnabled")
    def is_realtime_performance_panel_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Flag that indicates whether to enable Real Time Performance Panel for the project. If enabled, you can see real time metrics from your MongoDB database. By default, this flag is set to true.
        """
        return pulumi.get(self, "is_realtime_performance_panel_enabled")

    @property
    @pulumi.getter(name="isSchemaAdvisorEnabled")
    def is_schema_advisor_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Flag that indicates whether to enable Schema Advisor for the project. If enabled, you receive customized recommendations to optimize your data model and enhance performance. Disable this setting to disable schema suggestions in the [Performance Advisor](https://www.mongodb.com/docs/atlas/performance-advisor/#std-label-performance-advisor) and the [Data Explorer](https://www.mongodb.com/docs/atlas/atlas-ui/#std-label-atlas-ui). By default, this flag is set to true.
        """
        return pulumi.get(self, "is_schema_advisor_enabled")

    @property
    @pulumi.getter(name="isSlowOperationThresholdingEnabled")
    @_utilities.deprecated("""This parameter is deprecated.""")
    def is_slow_operation_thresholding_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        (Optional) Flag that enables MongoDB Cloud to use its slow operation threshold for the specified project. The threshold determines which operations the Performance Advisor and Query Profiler considers slow. When enabled, MongoDB Cloud uses the average execution time for operations on your cluster to determine slow-running queries. As a result, the threshold is more pertinent to your cluster workload. The slow operation threshold is enabled by default for dedicated clusters (M10+). When disabled, MongoDB Cloud considers any operation that takes longer than 100 milliseconds to be slow. **Note**: To use this attribute, the requesting API Key must have the Project Owner role, if not it will show a warning and will return `false`. If you are not using this field, you don't need to take any action.
        """
        return pulumi.get(self, "is_slow_operation_thresholding_enabled")

    @property
    @pulumi.getter
    def limits(self) -> pulumi.Output[Optional[Sequence['outputs.ProjectLimit']]]:
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the project you want to create.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the organization you want to create the project within.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectOwnerId")
    def project_owner_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Unique 24-hexadecimal digit string that identifies the Atlas user account to be granted the [Project Owner](https://docs.atlas.mongodb.com/reference/user-roles/#mongodb-authrole-Project-Owner) role on the specified project. If you set this parameter, it overrides the default value of the oldest [Organization Owner](https://docs.atlas.mongodb.com/reference/user-roles/#mongodb-authrole-Organization-Owner).
        """
        return pulumi.get(self, "project_owner_id")

    @property
    @pulumi.getter(name="regionUsageRestrictions")
    def region_usage_restrictions(self) -> pulumi.Output[builtins.str]:
        """
        Designates that this project can be used for government regions only.  If not set the project will default to standard regions.   You cannot deploy clusters across government and standard regions in the same project. AWS is the only cloud provider for AtlasGov.  For more information see [MongoDB Atlas for Government](https://www.mongodb.com/docs/atlas/government/api/#creating-a-project).
        """
        return pulumi.get(self, "region_usage_restrictions")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map that contains key-value pairs between 1 to 255 characters in length for tagging and categorizing the project. See below.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def teams(self) -> pulumi.Output[Optional[Sequence['outputs.ProjectTeam']]]:
        return pulumi.get(self, "teams")

    @property
    @pulumi.getter(name="withDefaultAlertsSettings")
    def with_default_alerts_settings(self) -> pulumi.Output[builtins.bool]:
        """
        It allows users to disable the creation of the default alert settings. By default, this flag is set to true.
        """
        return pulumi.get(self, "with_default_alerts_settings")

