# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from ._inputs import *

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 assume_role: Optional[pulumi.Input['ProviderAssumeRoleArgs']] = None,
                 aws_access_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 aws_secret_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 aws_session_token: Optional[pulumi.Input[builtins.str]] = None,
                 base_url: Optional[pulumi.Input[builtins.str]] = None,
                 is_mongodbgov_cloud: Optional[pulumi.Input[builtins.bool]] = None,
                 private_key: Optional[pulumi.Input[builtins.str]] = None,
                 public_key: Optional[pulumi.Input[builtins.str]] = None,
                 realm_base_url: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 secret_name: Optional[pulumi.Input[builtins.str]] = None,
                 sts_endpoint: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[builtins.str] aws_access_key_id: AWS API Access Key.
        :param pulumi.Input[builtins.str] aws_secret_access_key: AWS API Access Secret Key.
        :param pulumi.Input[builtins.str] aws_session_token: AWS Security Token Service provided session token.
        :param pulumi.Input[builtins.str] base_url: MongoDB Atlas Base URL
        :param pulumi.Input[builtins.bool] is_mongodbgov_cloud: MongoDB Atlas Base URL default to gov
        :param pulumi.Input[builtins.str] private_key: MongoDB Atlas Programmatic Private Key
        :param pulumi.Input[builtins.str] public_key: MongoDB Atlas Programmatic Public Key
        :param pulumi.Input[builtins.str] realm_base_url: MongoDB Realm Base URL
        :param pulumi.Input[builtins.str] region: Region where secret is stored as part of AWS Secret Manager.
        :param pulumi.Input[builtins.str] secret_name: Name of secret stored in AWS Secret Manager.
        :param pulumi.Input[builtins.str] sts_endpoint: AWS Security Token Service endpoint. Required for cross-AWS region or cross-AWS account secrets.
        """
        if assume_role is not None:
            pulumi.set(__self__, "assume_role", assume_role)
        if aws_access_key_id is not None:
            pulumi.set(__self__, "aws_access_key_id", aws_access_key_id)
        if aws_secret_access_key is not None:
            pulumi.set(__self__, "aws_secret_access_key", aws_secret_access_key)
        if aws_session_token is not None:
            pulumi.set(__self__, "aws_session_token", aws_session_token)
        if base_url is not None:
            pulumi.set(__self__, "base_url", base_url)
        if is_mongodbgov_cloud is not None:
            pulumi.set(__self__, "is_mongodbgov_cloud", is_mongodbgov_cloud)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if realm_base_url is not None:
            pulumi.set(__self__, "realm_base_url", realm_base_url)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if sts_endpoint is not None:
            pulumi.set(__self__, "sts_endpoint", sts_endpoint)

    @property
    @pulumi.getter(name="assumeRole")
    def assume_role(self) -> Optional[pulumi.Input['ProviderAssumeRoleArgs']]:
        return pulumi.get(self, "assume_role")

    @assume_role.setter
    def assume_role(self, value: Optional[pulumi.Input['ProviderAssumeRoleArgs']]):
        pulumi.set(self, "assume_role", value)

    @property
    @pulumi.getter(name="awsAccessKeyId")
    def aws_access_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AWS API Access Key.
        """
        return pulumi.get(self, "aws_access_key_id")

    @aws_access_key_id.setter
    def aws_access_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "aws_access_key_id", value)

    @property
    @pulumi.getter(name="awsSecretAccessKey")
    def aws_secret_access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AWS API Access Secret Key.
        """
        return pulumi.get(self, "aws_secret_access_key")

    @aws_secret_access_key.setter
    def aws_secret_access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "aws_secret_access_key", value)

    @property
    @pulumi.getter(name="awsSessionToken")
    def aws_session_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AWS Security Token Service provided session token.
        """
        return pulumi.get(self, "aws_session_token")

    @aws_session_token.setter
    def aws_session_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "aws_session_token", value)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        MongoDB Atlas Base URL
        """
        return pulumi.get(self, "base_url")

    @base_url.setter
    def base_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "base_url", value)

    @property
    @pulumi.getter(name="isMongodbgovCloud")
    def is_mongodbgov_cloud(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        MongoDB Atlas Base URL default to gov
        """
        return pulumi.get(self, "is_mongodbgov_cloud")

    @is_mongodbgov_cloud.setter
    def is_mongodbgov_cloud(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_mongodbgov_cloud", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        MongoDB Atlas Programmatic Private Key
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        MongoDB Atlas Programmatic Public Key
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter(name="realmBaseUrl")
    def realm_base_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        MongoDB Realm Base URL
        """
        return pulumi.get(self, "realm_base_url")

    @realm_base_url.setter
    def realm_base_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "realm_base_url", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where secret is stored as part of AWS Secret Manager.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of secret stored in AWS Secret Manager.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_name", value)

    @property
    @pulumi.getter(name="stsEndpoint")
    def sts_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AWS Security Token Service endpoint. Required for cross-AWS region or cross-AWS account secrets.
        """
        return pulumi.get(self, "sts_endpoint")

    @sts_endpoint.setter
    def sts_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sts_endpoint", value)


@pulumi.type_token("pulumi:providers:mongodbatlas")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assume_role: Optional[pulumi.Input[Union['ProviderAssumeRoleArgs', 'ProviderAssumeRoleArgsDict']]] = None,
                 aws_access_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 aws_secret_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 aws_session_token: Optional[pulumi.Input[builtins.str]] = None,
                 base_url: Optional[pulumi.Input[builtins.str]] = None,
                 is_mongodbgov_cloud: Optional[pulumi.Input[builtins.bool]] = None,
                 private_key: Optional[pulumi.Input[builtins.str]] = None,
                 public_key: Optional[pulumi.Input[builtins.str]] = None,
                 realm_base_url: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 secret_name: Optional[pulumi.Input[builtins.str]] = None,
                 sts_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The provider type for the mongodbatlas package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] aws_access_key_id: AWS API Access Key.
        :param pulumi.Input[builtins.str] aws_secret_access_key: AWS API Access Secret Key.
        :param pulumi.Input[builtins.str] aws_session_token: AWS Security Token Service provided session token.
        :param pulumi.Input[builtins.str] base_url: MongoDB Atlas Base URL
        :param pulumi.Input[builtins.bool] is_mongodbgov_cloud: MongoDB Atlas Base URL default to gov
        :param pulumi.Input[builtins.str] private_key: MongoDB Atlas Programmatic Private Key
        :param pulumi.Input[builtins.str] public_key: MongoDB Atlas Programmatic Public Key
        :param pulumi.Input[builtins.str] realm_base_url: MongoDB Realm Base URL
        :param pulumi.Input[builtins.str] region: Region where secret is stored as part of AWS Secret Manager.
        :param pulumi.Input[builtins.str] secret_name: Name of secret stored in AWS Secret Manager.
        :param pulumi.Input[builtins.str] sts_endpoint: AWS Security Token Service endpoint. Required for cross-AWS region or cross-AWS account secrets.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the mongodbatlas package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assume_role: Optional[pulumi.Input[Union['ProviderAssumeRoleArgs', 'ProviderAssumeRoleArgsDict']]] = None,
                 aws_access_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 aws_secret_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 aws_session_token: Optional[pulumi.Input[builtins.str]] = None,
                 base_url: Optional[pulumi.Input[builtins.str]] = None,
                 is_mongodbgov_cloud: Optional[pulumi.Input[builtins.bool]] = None,
                 private_key: Optional[pulumi.Input[builtins.str]] = None,
                 public_key: Optional[pulumi.Input[builtins.str]] = None,
                 realm_base_url: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 secret_name: Optional[pulumi.Input[builtins.str]] = None,
                 sts_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["assume_role"] = pulumi.Output.from_input(assume_role).apply(pulumi.runtime.to_json) if assume_role is not None else None
            __props__.__dict__["aws_access_key_id"] = aws_access_key_id
            __props__.__dict__["aws_secret_access_key"] = aws_secret_access_key
            __props__.__dict__["aws_session_token"] = aws_session_token
            __props__.__dict__["base_url"] = base_url
            __props__.__dict__["is_mongodbgov_cloud"] = pulumi.Output.from_input(is_mongodbgov_cloud).apply(pulumi.runtime.to_json) if is_mongodbgov_cloud is not None else None
            __props__.__dict__["private_key"] = None if private_key is None else pulumi.Output.secret(private_key)
            __props__.__dict__["public_key"] = public_key
            __props__.__dict__["realm_base_url"] = realm_base_url
            __props__.__dict__["region"] = region
            __props__.__dict__["secret_name"] = secret_name
            __props__.__dict__["sts_endpoint"] = sts_endpoint
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["privateKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'mongodbatlas',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter(name="awsAccessKeyId")
    def aws_access_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        AWS API Access Key.
        """
        return pulumi.get(self, "aws_access_key_id")

    @property
    @pulumi.getter(name="awsSecretAccessKey")
    def aws_secret_access_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        AWS API Access Secret Key.
        """
        return pulumi.get(self, "aws_secret_access_key")

    @property
    @pulumi.getter(name="awsSessionToken")
    def aws_session_token(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        AWS Security Token Service provided session token.
        """
        return pulumi.get(self, "aws_session_token")

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        MongoDB Atlas Base URL
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        MongoDB Atlas Programmatic Private Key
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        MongoDB Atlas Programmatic Public Key
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="realmBaseUrl")
    def realm_base_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        MongoDB Realm Base URL
        """
        return pulumi.get(self, "realm_base_url")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Region where secret is stored as part of AWS Secret Manager.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name of secret stored in AWS Secret Manager.
        """
        return pulumi.get(self, "secret_name")

    @property
    @pulumi.getter(name="stsEndpoint")
    def sts_endpoint(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        AWS Security Token Service endpoint. Required for cross-AWS region or cross-AWS account secrets.
        """
        return pulumi.get(self, "sts_endpoint")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:mongodbatlas/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

